<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * DisruptionEvent is a notification sent to customers about the disruption
 * event of a resource.
 *
 * Generated from protobuf message <code>google.container.v1.DisruptionEvent</code>
 */
class DisruptionEvent extends \Google\Protobuf\Internal\Message
{
    /**
     * The type of the disruption event.
     *
     * Generated from protobuf field <code>.google.container.v1.DisruptionEvent.DisruptionType disruption_type = 1;</code>
     */
    protected $disruption_type = 0;
    /**
     * The node whose drain is blocked by PDB. This field is set for both
     * POD_PDB_VIOLATION and POD_NOT_ENOUGH_PDB event.
     *
     * Generated from protobuf field <code>string pdb_blocked_node = 2;</code>
     */
    protected $pdb_blocked_node = '';
    /**
     * The pods whose evictions are blocked by PDB. This field is set for
     * both POD_PDB_VIOLATION and POD_NOT_ENOUGH_PDB event.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.DisruptionEvent.PdbBlockedPod pdb_blocked_pod = 3;</code>
     */
    private $pdb_blocked_pod;
    /**
     * The timeout in seconds for which the node drain is blocked by PDB.
     * After this timeout, pods are forcefully evicted.
     * This field is only populated when event_type is
     * POD_PDB_VIOLATION.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Duration pdb_violation_timeout = 4;</code>
     */
    protected $pdb_violation_timeout = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $disruption_type
     *           The type of the disruption event.
     *     @type string $pdb_blocked_node
     *           The node whose drain is blocked by PDB. This field is set for both
     *           POD_PDB_VIOLATION and POD_NOT_ENOUGH_PDB event.
     *     @type array<\Google\Cloud\Container\V1\DisruptionEvent\PdbBlockedPod>|\Google\Protobuf\Internal\RepeatedField $pdb_blocked_pod
     *           The pods whose evictions are blocked by PDB. This field is set for
     *           both POD_PDB_VIOLATION and POD_NOT_ENOUGH_PDB event.
     *     @type \Google\Protobuf\Duration $pdb_violation_timeout
     *           The timeout in seconds for which the node drain is blocked by PDB.
     *           After this timeout, pods are forcefully evicted.
     *           This field is only populated when event_type is
     *           POD_PDB_VIOLATION.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * The type of the disruption event.
     *
     * Generated from protobuf field <code>.google.container.v1.DisruptionEvent.DisruptionType disruption_type = 1;</code>
     * @return int
     */
    public function getDisruptionType()
    {
        return $this->disruption_type;
    }

    /**
     * The type of the disruption event.
     *
     * Generated from protobuf field <code>.google.container.v1.DisruptionEvent.DisruptionType disruption_type = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setDisruptionType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Container\V1\DisruptionEvent\DisruptionType::class);
        $this->disruption_type = $var;

        return $this;
    }

    /**
     * The node whose drain is blocked by PDB. This field is set for both
     * POD_PDB_VIOLATION and POD_NOT_ENOUGH_PDB event.
     *
     * Generated from protobuf field <code>string pdb_blocked_node = 2;</code>
     * @return string
     */
    public function getPdbBlockedNode()
    {
        return $this->pdb_blocked_node;
    }

    /**
     * The node whose drain is blocked by PDB. This field is set for both
     * POD_PDB_VIOLATION and POD_NOT_ENOUGH_PDB event.
     *
     * Generated from protobuf field <code>string pdb_blocked_node = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setPdbBlockedNode($var)
    {
        GPBUtil::checkString($var, True);
        $this->pdb_blocked_node = $var;

        return $this;
    }

    /**
     * The pods whose evictions are blocked by PDB. This field is set for
     * both POD_PDB_VIOLATION and POD_NOT_ENOUGH_PDB event.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.DisruptionEvent.PdbBlockedPod pdb_blocked_pod = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPdbBlockedPod()
    {
        return $this->pdb_blocked_pod;
    }

    /**
     * The pods whose evictions are blocked by PDB. This field is set for
     * both POD_PDB_VIOLATION and POD_NOT_ENOUGH_PDB event.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.DisruptionEvent.PdbBlockedPod pdb_blocked_pod = 3;</code>
     * @param array<\Google\Cloud\Container\V1\DisruptionEvent\PdbBlockedPod>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPdbBlockedPod($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Container\V1\DisruptionEvent\PdbBlockedPod::class);
        $this->pdb_blocked_pod = $arr;

        return $this;
    }

    /**
     * The timeout in seconds for which the node drain is blocked by PDB.
     * After this timeout, pods are forcefully evicted.
     * This field is only populated when event_type is
     * POD_PDB_VIOLATION.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Duration pdb_violation_timeout = 4;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getPdbViolationTimeout()
    {
        return $this->pdb_violation_timeout;
    }

    public function hasPdbViolationTimeout()
    {
        return isset($this->pdb_violation_timeout);
    }

    public function clearPdbViolationTimeout()
    {
        unset($this->pdb_violation_timeout);
    }

    /**
     * The timeout in seconds for which the node drain is blocked by PDB.
     * After this timeout, pods are forcefully evicted.
     * This field is only populated when event_type is
     * POD_PDB_VIOLATION.
     *
     * Generated from protobuf field <code>optional .google.protobuf.Duration pdb_violation_timeout = 4;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setPdbViolationTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->pdb_violation_timeout = $var;

        return $this;
    }

}

