<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1\ContainerdConfig\RegistryHostConfig;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * HostConfig configures the registry host under a given Server.
 *
 * Generated from protobuf message <code>google.container.v1.ContainerdConfig.RegistryHostConfig.HostConfig</code>
 */
class HostConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Host configures the registry host/mirror.
     * It supports fully qualified domain names (FQDN) and IP addresses:
     * Specifying port is supported.
     * Wildcards are NOT supported.
     * Examples:
     * - my.customdomain.com
     * - 10.0.1.2:5000
     *
     * Generated from protobuf field <code>string host = 1;</code>
     */
    protected $host = '';
    /**
     * Capabilities represent the capabilities of the registry host,
     * specifying what operations a host is capable of performing.
     * If not set, containerd enables all capabilities by default.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.ContainerdConfig.RegistryHostConfig.HostCapability capabilities = 2;</code>
     */
    private $capabilities;
    /**
     * OverridePath is used to indicate the host's API root endpoint is
     * defined in the URL path rather than by the API specification. This may
     * be used with non-compliant OCI registries which are missing the /v2
     * prefix.
     * If not set, containerd sets default false.
     *
     * Generated from protobuf field <code>bool override_path = 3;</code>
     */
    protected $override_path = false;
    /**
     * Header configures the registry host headers.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.ContainerdConfig.RegistryHostConfig.RegistryHeader header = 4;</code>
     */
    private $header;
    /**
     * CA configures the registry host certificate.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.ContainerdConfig.RegistryHostConfig.CertificateConfig ca = 5;</code>
     */
    private $ca;
    /**
     * Client configures the registry host client certificate and key.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.ContainerdConfig.RegistryHostConfig.CertificateConfigPair client = 6;</code>
     */
    private $client;
    /**
     * Specifies the maximum duration allowed for a connection attempt to
     * complete. A shorter timeout helps reduce delays when falling back to
     * the original registry if the mirror is unreachable.
     * Maximum allowed value is 180s. If not set, containerd sets default 30s.
     * The value should be a decimal number of seconds with an `s` suffix.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration dial_timeout = 7;</code>
     */
    protected $dial_timeout = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $host
     *           Host configures the registry host/mirror.
     *           It supports fully qualified domain names (FQDN) and IP addresses:
     *           Specifying port is supported.
     *           Wildcards are NOT supported.
     *           Examples:
     *           - my.customdomain.com
     *           - 10.0.1.2:5000
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $capabilities
     *           Capabilities represent the capabilities of the registry host,
     *           specifying what operations a host is capable of performing.
     *           If not set, containerd enables all capabilities by default.
     *     @type bool $override_path
     *           OverridePath is used to indicate the host's API root endpoint is
     *           defined in the URL path rather than by the API specification. This may
     *           be used with non-compliant OCI registries which are missing the /v2
     *           prefix.
     *           If not set, containerd sets default false.
     *     @type array<\Google\Cloud\Container\V1\ContainerdConfig\RegistryHostConfig\RegistryHeader>|\Google\Protobuf\Internal\RepeatedField $header
     *           Header configures the registry host headers.
     *     @type array<\Google\Cloud\Container\V1\ContainerdConfig\RegistryHostConfig\CertificateConfig>|\Google\Protobuf\Internal\RepeatedField $ca
     *           CA configures the registry host certificate.
     *     @type array<\Google\Cloud\Container\V1\ContainerdConfig\RegistryHostConfig\CertificateConfigPair>|\Google\Protobuf\Internal\RepeatedField $client
     *           Client configures the registry host client certificate and key.
     *     @type \Google\Protobuf\Duration $dial_timeout
     *           Specifies the maximum duration allowed for a connection attempt to
     *           complete. A shorter timeout helps reduce delays when falling back to
     *           the original registry if the mirror is unreachable.
     *           Maximum allowed value is 180s. If not set, containerd sets default 30s.
     *           The value should be a decimal number of seconds with an `s` suffix.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * Host configures the registry host/mirror.
     * It supports fully qualified domain names (FQDN) and IP addresses:
     * Specifying port is supported.
     * Wildcards are NOT supported.
     * Examples:
     * - my.customdomain.com
     * - 10.0.1.2:5000
     *
     * Generated from protobuf field <code>string host = 1;</code>
     * @return string
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * Host configures the registry host/mirror.
     * It supports fully qualified domain names (FQDN) and IP addresses:
     * Specifying port is supported.
     * Wildcards are NOT supported.
     * Examples:
     * - my.customdomain.com
     * - 10.0.1.2:5000
     *
     * Generated from protobuf field <code>string host = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setHost($var)
    {
        GPBUtil::checkString($var, True);
        $this->host = $var;

        return $this;
    }

    /**
     * Capabilities represent the capabilities of the registry host,
     * specifying what operations a host is capable of performing.
     * If not set, containerd enables all capabilities by default.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.ContainerdConfig.RegistryHostConfig.HostCapability capabilities = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCapabilities()
    {
        return $this->capabilities;
    }

    /**
     * Capabilities represent the capabilities of the registry host,
     * specifying what operations a host is capable of performing.
     * If not set, containerd enables all capabilities by default.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.ContainerdConfig.RegistryHostConfig.HostCapability capabilities = 2;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCapabilities($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\Container\V1\ContainerdConfig\RegistryHostConfig\HostCapability::class);
        $this->capabilities = $arr;

        return $this;
    }

    /**
     * OverridePath is used to indicate the host's API root endpoint is
     * defined in the URL path rather than by the API specification. This may
     * be used with non-compliant OCI registries which are missing the /v2
     * prefix.
     * If not set, containerd sets default false.
     *
     * Generated from protobuf field <code>bool override_path = 3;</code>
     * @return bool
     */
    public function getOverridePath()
    {
        return $this->override_path;
    }

    /**
     * OverridePath is used to indicate the host's API root endpoint is
     * defined in the URL path rather than by the API specification. This may
     * be used with non-compliant OCI registries which are missing the /v2
     * prefix.
     * If not set, containerd sets default false.
     *
     * Generated from protobuf field <code>bool override_path = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setOverridePath($var)
    {
        GPBUtil::checkBool($var);
        $this->override_path = $var;

        return $this;
    }

    /**
     * Header configures the registry host headers.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.ContainerdConfig.RegistryHostConfig.RegistryHeader header = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getHeader()
    {
        return $this->header;
    }

    /**
     * Header configures the registry host headers.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.ContainerdConfig.RegistryHostConfig.RegistryHeader header = 4;</code>
     * @param array<\Google\Cloud\Container\V1\ContainerdConfig\RegistryHostConfig\RegistryHeader>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setHeader($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Container\V1\ContainerdConfig\RegistryHostConfig\RegistryHeader::class);
        $this->header = $arr;

        return $this;
    }

    /**
     * CA configures the registry host certificate.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.ContainerdConfig.RegistryHostConfig.CertificateConfig ca = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCa()
    {
        return $this->ca;
    }

    /**
     * CA configures the registry host certificate.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.ContainerdConfig.RegistryHostConfig.CertificateConfig ca = 5;</code>
     * @param array<\Google\Cloud\Container\V1\ContainerdConfig\RegistryHostConfig\CertificateConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCa($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Container\V1\ContainerdConfig\RegistryHostConfig\CertificateConfig::class);
        $this->ca = $arr;

        return $this;
    }

    /**
     * Client configures the registry host client certificate and key.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.ContainerdConfig.RegistryHostConfig.CertificateConfigPair client = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * Client configures the registry host client certificate and key.
     *
     * Generated from protobuf field <code>repeated .google.container.v1.ContainerdConfig.RegistryHostConfig.CertificateConfigPair client = 6;</code>
     * @param array<\Google\Cloud\Container\V1\ContainerdConfig\RegistryHostConfig\CertificateConfigPair>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setClient($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Container\V1\ContainerdConfig\RegistryHostConfig\CertificateConfigPair::class);
        $this->client = $arr;

        return $this;
    }

    /**
     * Specifies the maximum duration allowed for a connection attempt to
     * complete. A shorter timeout helps reduce delays when falling back to
     * the original registry if the mirror is unreachable.
     * Maximum allowed value is 180s. If not set, containerd sets default 30s.
     * The value should be a decimal number of seconds with an `s` suffix.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration dial_timeout = 7;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getDialTimeout()
    {
        return $this->dial_timeout;
    }

    public function hasDialTimeout()
    {
        return isset($this->dial_timeout);
    }

    public function clearDialTimeout()
    {
        unset($this->dial_timeout);
    }

    /**
     * Specifies the maximum duration allowed for a connection attempt to
     * complete. A shorter timeout helps reduce delays when falling back to
     * the original registry if the mirror is unreachable.
     * Maximum allowed value is 180s. If not set, containerd sets default 30s.
     * The value should be a decimal number of seconds with an `s` suffix.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration dial_timeout = 7;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setDialTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->dial_timeout = $var;

        return $this;
    }

}


