<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents an Image resource.
 * You can use images to create boot disks for your VM instances.
 * For more information, read Images.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.Image</code>
 */
class Image extends \Google\Protobuf\Internal\Message
{
    /**
     * The architecture of the image. Valid values are
     * ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string architecture = 302803283;</code>
     */
    protected $architecture = null;
    /**
     * Size of the image tar.gz archive stored in Google Cloud
     * Storage (in bytes).
     *
     * Generated from protobuf field <code>optional int64 archive_size_bytes = 381093450;</code>
     */
    protected $archive_size_bytes = null;
    /**
     * Output only. [Output Only] Creation timestamp inRFC3339
     * text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     */
    protected $creation_timestamp = null;
    /**
     * Output only. The deprecation status associated with this image.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     */
    protected $deprecated = null;
    /**
     * An optional description of this resource. Provide this property when you
     * create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     */
    protected $description = null;
    /**
     * Size of the image when restored onto a persistent disk (in GB).
     *
     * Generated from protobuf field <code>optional int64 disk_size_gb = 316263735;</code>
     */
    protected $disk_size_gb = null;
    /**
     * Output only. Whether this image is created from a confidential compute mode disk.
     * [Output Only]: This field is not set by user, but from source disk.
     *
     * Generated from protobuf field <code>optional bool enable_confidential_compute = 102135228;</code>
     */
    protected $enable_confidential_compute = null;
    /**
     * The name of the image family to which this image belongs. The image
     * family name can be from a publicly managed image family provided by
     * Compute Engine, or from a custom image family you create. For example,centos-stream-9 is a publicly available image family.
     * For more information, see Image
     * family best practices.
     * When creating disks, you can specify an image family instead of a specific
     * image name. The image family always returns its latest image that is not
     * deprecated. The name of the image family must comply with RFC1035.
     *
     * Generated from protobuf field <code>optional string family = 328751972;</code>
     */
    protected $family = null;
    /**
     * A list of features to enable on the guest operating system. Applicable
     * only for bootable images. To see a list of available options, see theguestOSfeatures[].type parameter.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    private $guest_os_features;
    /**
     * Output only. [Output Only] The unique identifier for the resource. This identifier is
     * defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     */
    protected $id = null;
    /**
     * Encrypts the image using acustomer-supplied
     * encryption key.
     * After you encrypt an image with a customer-supplied key, you must provide
     * the same key if you use the image later (e.g. to create a disk from
     * the image).
     * Customer-supplied encryption keys do not protect access to metadata
     * of the disk.
     * If you do not provide an encryption key when creating the image, then the
     * disk will be encrypted using an automatically generated key and you do not
     * need to provide a key to use the image later.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey image_encryption_key = 379512583;</code>
     */
    protected $image_encryption_key = null;
    /**
     * Output only. [Output Only] Type of the resource. Always compute#image for
     * images.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     */
    protected $kind = null;
    /**
     * A fingerprint for the labels being applied to this image, which is
     * essentially a hash of the labels used for optimistic locking. The
     * fingerprint is initially generated by Compute Engine and changes after
     * every request to modify or update labels. You must always provide an
     * up-to-date fingerprint hash in order to update or change labels,
     * otherwise the request will fail with error412 conditionNotMet.
     * To see the latest fingerprint, make a get() request to
     * retrieve an image.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     */
    protected $label_fingerprint = null;
    /**
     * Labels to apply to this image. These can be later modified by
     * the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     */
    private $labels;
    /**
     * Integer license codes indicating which licenses are attached to this image.
     *
     * Generated from protobuf field <code>repeated int64 license_codes = 45482664;</code>
     */
    private $license_codes;
    /**
     * Any applicable license URI.
     *
     * Generated from protobuf field <code>repeated string licenses = 337642578;</code>
     */
    private $licenses;
    /**
     * Name of the resource; provided by the client when the resource is created.
     * The name must be 1-63 characters long, and comply withRFC1035.
     * Specifically, the name must be 1-63 characters long and match the regular
     * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must be
     * a dash, lowercase letter, or digit, except the last character, which cannot
     * be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     */
    protected $name = null;
    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted
     * as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ImageParams params = 78313862;</code>
     */
    protected $params = null;
    /**
     * The parameters of the raw disk image.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.RawDisk raw_disk = 503113556;</code>
     */
    protected $raw_disk = null;
    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 480964257;</code>
     */
    protected $satisfies_pzi = null;
    /**
     * Output only. [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     */
    protected $satisfies_pzs = null;
    /**
     * Output only. [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     */
    protected $self_link = null;
    /**
     * Set the secure boot keys of shielded instance.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;</code>
     */
    protected $shielded_instance_initial_state = null;
    /**
     * URL of the source disk used to create this image.
     * For example, the following are valid values:
     *    - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
     *    - projects/project/zones/zone/disks/disk
     *    - zones/zone/disks/disk
     * In order to create an image, you must provide the full or partial URL of
     * one of the following:
     *    - The rawDisk.source URL
     *    - The sourceDisk URL
     *    - The sourceImage URL
     *    - The sourceSnapshot URL
     *
     * Generated from protobuf field <code>optional string source_disk = 451753793;</code>
     */
    protected $source_disk = null;
    /**
     * Thecustomer-supplied
     * encryption key of the source disk. Required if the source disk is
     * protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;</code>
     */
    protected $source_disk_encryption_key = null;
    /**
     * Output only. [Output Only]
     * The ID value of the disk used to create this image. This value may be used
     * to determine whether the image was taken from the current or a previous
     * instance of a given disk name.
     *
     * Generated from protobuf field <code>optional string source_disk_id = 454190809;</code>
     */
    protected $source_disk_id = null;
    /**
     * URL of the source image used to create this image.
     * The following are valid formats for the URL:
     *    - https://www.googleapis.com/compute/v1/projects/project_id/global/
     *    images/image_name
     *    - projects/project_id/global/images/image_name
     * In order to create an image, you must provide the full or partial URL of
     * one of the following:
     *    - The rawDisk.source URL
     *    - The sourceDisk URL
     *    - The sourceImage URL
     *    - The sourceSnapshot URL
     *
     * Generated from protobuf field <code>optional string source_image = 50443319;</code>
     */
    protected $source_image = null;
    /**
     * The customer-supplied encryption key of the source image. Required if the
     * source image is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;</code>
     */
    protected $source_image_encryption_key = null;
    /**
     * Output only. [Output Only]
     * The ID value of the image used to create this image. This value may be used
     * to determine whether the image was taken from the current or a previous
     * instance of a given image name.
     *
     * Generated from protobuf field <code>optional string source_image_id = 55328291;</code>
     */
    protected $source_image_id = null;
    /**
     * URL of the source snapshot used to create this image.
     * The following are valid formats for the URL:
     *    - https://www.googleapis.com/compute/v1/projects/project_id/global/
     *    snapshots/snapshot_name
     *    - projects/project_id/global/snapshots/snapshot_name
     * In order to create an image, you must provide the full or partial URL of
     * one of the following:
     *    - The rawDisk.source URL
     *    - The sourceDisk URL
     *    - The sourceImage URL
     *    - The sourceSnapshot URL
     *
     * Generated from protobuf field <code>optional string source_snapshot = 126061928;</code>
     */
    protected $source_snapshot = null;
    /**
     * The customer-supplied encryption key of the source snapshot. Required if
     * the source snapshot is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;</code>
     */
    protected $source_snapshot_encryption_key = null;
    /**
     * Output only. [Output Only]
     * The ID value of the snapshot used to create this image. This value may be
     * used to determine whether the snapshot was taken from the current or a
     * previous instance of a given snapshot name.
     *
     * Generated from protobuf field <code>optional string source_snapshot_id = 98962258;</code>
     */
    protected $source_snapshot_id = null;
    /**
     * The type of the image used to create this disk. The
     * default and only valid value is RAW.
     * Check the SourceType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string source_type = 452245726;</code>
     */
    protected $source_type = null;
    /**
     * Output only. [Output Only] The status of the image. An image can be used to create other
     * resources, such as instances, only after the image has been successfully
     * created and the status is set to READY. Possible
     * values are FAILED, PENDING, orREADY.
     * Check the Status enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string status = 181260274;</code>
     */
    protected $status = null;
    /**
     * Cloud Storage bucket storage location of the image (regional or
     * multi-regional).
     *
     * Generated from protobuf field <code>repeated string storage_locations = 328005274;</code>
     */
    private $storage_locations;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $architecture
     *           The architecture of the image. Valid values are
     *           ARM64 or X86_64.
     *           Check the Architecture enum for the list of possible values.
     *     @type int|string $archive_size_bytes
     *           Size of the image tar.gz archive stored in Google Cloud
     *           Storage (in bytes).
     *     @type string $creation_timestamp
     *           Output only. [Output Only] Creation timestamp inRFC3339
     *           text format.
     *     @type \Google\Cloud\Compute\V1\DeprecationStatus $deprecated
     *           Output only. The deprecation status associated with this image.
     *     @type string $description
     *           An optional description of this resource. Provide this property when you
     *           create the resource.
     *     @type int|string $disk_size_gb
     *           Size of the image when restored onto a persistent disk (in GB).
     *     @type bool $enable_confidential_compute
     *           Output only. Whether this image is created from a confidential compute mode disk.
     *           [Output Only]: This field is not set by user, but from source disk.
     *     @type string $family
     *           The name of the image family to which this image belongs. The image
     *           family name can be from a publicly managed image family provided by
     *           Compute Engine, or from a custom image family you create. For example,centos-stream-9 is a publicly available image family.
     *           For more information, see Image
     *           family best practices.
     *           When creating disks, you can specify an image family instead of a specific
     *           image name. The image family always returns its latest image that is not
     *           deprecated. The name of the image family must comply with RFC1035.
     *     @type array<\Google\Cloud\Compute\V1\GuestOsFeature>|\Google\Protobuf\Internal\RepeatedField $guest_os_features
     *           A list of features to enable on the guest operating system. Applicable
     *           only for bootable images. To see a list of available options, see theguestOSfeatures[].type parameter.
     *     @type int|string $id
     *           Output only. [Output Only] The unique identifier for the resource. This identifier is
     *           defined by the server.
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $image_encryption_key
     *           Encrypts the image using acustomer-supplied
     *           encryption key.
     *           After you encrypt an image with a customer-supplied key, you must provide
     *           the same key if you use the image later (e.g. to create a disk from
     *           the image).
     *           Customer-supplied encryption keys do not protect access to metadata
     *           of the disk.
     *           If you do not provide an encryption key when creating the image, then the
     *           disk will be encrypted using an automatically generated key and you do not
     *           need to provide a key to use the image later.
     *     @type string $kind
     *           Output only. [Output Only] Type of the resource. Always compute#image for
     *           images.
     *     @type string $label_fingerprint
     *           A fingerprint for the labels being applied to this image, which is
     *           essentially a hash of the labels used for optimistic locking. The
     *           fingerprint is initially generated by Compute Engine and changes after
     *           every request to modify or update labels. You must always provide an
     *           up-to-date fingerprint hash in order to update or change labels,
     *           otherwise the request will fail with error412 conditionNotMet.
     *           To see the latest fingerprint, make a get() request to
     *           retrieve an image.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels to apply to this image. These can be later modified by
     *           the setLabels method.
     *     @type array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField $license_codes
     *           Integer license codes indicating which licenses are attached to this image.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $licenses
     *           Any applicable license URI.
     *     @type string $name
     *           Name of the resource; provided by the client when the resource is created.
     *           The name must be 1-63 characters long, and comply withRFC1035.
     *           Specifically, the name must be 1-63 characters long and match the regular
     *           expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     *           character must be a lowercase letter, and all following characters must be
     *           a dash, lowercase letter, or digit, except the last character, which cannot
     *           be a dash.
     *     @type \Google\Cloud\Compute\V1\ImageParams $params
     *           Input only. [Input Only] Additional params passed with the request, but not persisted
     *           as part of resource payload.
     *     @type \Google\Cloud\Compute\V1\RawDisk $raw_disk
     *           The parameters of the raw disk image.
     *     @type bool $satisfies_pzi
     *           Output only. Reserved for future use.
     *     @type bool $satisfies_pzs
     *           Output only. [Output Only] Reserved for future use.
     *     @type string $self_link
     *           Output only. [Output Only] Server-defined URL for the resource.
     *     @type \Google\Cloud\Compute\V1\InitialStateConfig $shielded_instance_initial_state
     *           Set the secure boot keys of shielded instance.
     *     @type string $source_disk
     *           URL of the source disk used to create this image.
     *           For example, the following are valid values:
     *              - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
     *              - projects/project/zones/zone/disks/disk
     *              - zones/zone/disks/disk
     *           In order to create an image, you must provide the full or partial URL of
     *           one of the following:
     *              - The rawDisk.source URL
     *              - The sourceDisk URL
     *              - The sourceImage URL
     *              - The sourceSnapshot URL
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $source_disk_encryption_key
     *           Thecustomer-supplied
     *           encryption key of the source disk. Required if the source disk is
     *           protected by a customer-supplied encryption key.
     *     @type string $source_disk_id
     *           Output only. [Output Only]
     *           The ID value of the disk used to create this image. This value may be used
     *           to determine whether the image was taken from the current or a previous
     *           instance of a given disk name.
     *     @type string $source_image
     *           URL of the source image used to create this image.
     *           The following are valid formats for the URL:
     *              - https://www.googleapis.com/compute/v1/projects/project_id/global/
     *              images/image_name
     *              - projects/project_id/global/images/image_name
     *           In order to create an image, you must provide the full or partial URL of
     *           one of the following:
     *              - The rawDisk.source URL
     *              - The sourceDisk URL
     *              - The sourceImage URL
     *              - The sourceSnapshot URL
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $source_image_encryption_key
     *           The customer-supplied encryption key of the source image. Required if the
     *           source image is protected by a customer-supplied encryption key.
     *     @type string $source_image_id
     *           Output only. [Output Only]
     *           The ID value of the image used to create this image. This value may be used
     *           to determine whether the image was taken from the current or a previous
     *           instance of a given image name.
     *     @type string $source_snapshot
     *           URL of the source snapshot used to create this image.
     *           The following are valid formats for the URL:
     *              - https://www.googleapis.com/compute/v1/projects/project_id/global/
     *              snapshots/snapshot_name
     *              - projects/project_id/global/snapshots/snapshot_name
     *           In order to create an image, you must provide the full or partial URL of
     *           one of the following:
     *              - The rawDisk.source URL
     *              - The sourceDisk URL
     *              - The sourceImage URL
     *              - The sourceSnapshot URL
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $source_snapshot_encryption_key
     *           The customer-supplied encryption key of the source snapshot. Required if
     *           the source snapshot is protected by a customer-supplied encryption key.
     *     @type string $source_snapshot_id
     *           Output only. [Output Only]
     *           The ID value of the snapshot used to create this image. This value may be
     *           used to determine whether the snapshot was taken from the current or a
     *           previous instance of a given snapshot name.
     *     @type string $source_type
     *           The type of the image used to create this disk. The
     *           default and only valid value is RAW.
     *           Check the SourceType enum for the list of possible values.
     *     @type string $status
     *           Output only. [Output Only] The status of the image. An image can be used to create other
     *           resources, such as instances, only after the image has been successfully
     *           created and the status is set to READY. Possible
     *           values are FAILED, PENDING, orREADY.
     *           Check the Status enum for the list of possible values.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $storage_locations
     *           Cloud Storage bucket storage location of the image (regional or
     *           multi-regional).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * The architecture of the image. Valid values are
     * ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string architecture = 302803283;</code>
     * @return string
     */
    public function getArchitecture()
    {
        return isset($this->architecture) ? $this->architecture : '';
    }

    public function hasArchitecture()
    {
        return isset($this->architecture);
    }

    public function clearArchitecture()
    {
        unset($this->architecture);
    }

    /**
     * The architecture of the image. Valid values are
     * ARM64 or X86_64.
     * Check the Architecture enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string architecture = 302803283;</code>
     * @param string $var
     * @return $this
     */
    public function setArchitecture($var)
    {
        GPBUtil::checkString($var, True);
        $this->architecture = $var;

        return $this;
    }

    /**
     * Size of the image tar.gz archive stored in Google Cloud
     * Storage (in bytes).
     *
     * Generated from protobuf field <code>optional int64 archive_size_bytes = 381093450;</code>
     * @return int|string
     */
    public function getArchiveSizeBytes()
    {
        return isset($this->archive_size_bytes) ? $this->archive_size_bytes : 0;
    }

    public function hasArchiveSizeBytes()
    {
        return isset($this->archive_size_bytes);
    }

    public function clearArchiveSizeBytes()
    {
        unset($this->archive_size_bytes);
    }

    /**
     * Size of the image tar.gz archive stored in Google Cloud
     * Storage (in bytes).
     *
     * Generated from protobuf field <code>optional int64 archive_size_bytes = 381093450;</code>
     * @param int|string $var
     * @return $this
     */
    public function setArchiveSizeBytes($var)
    {
        GPBUtil::checkInt64($var);
        $this->archive_size_bytes = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Creation timestamp inRFC3339
     * text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return isset($this->creation_timestamp) ? $this->creation_timestamp : '';
    }

    public function hasCreationTimestamp()
    {
        return isset($this->creation_timestamp);
    }

    public function clearCreationTimestamp()
    {
        unset($this->creation_timestamp);
    }

    /**
     * Output only. [Output Only] Creation timestamp inRFC3339
     * text format.
     *
     * Generated from protobuf field <code>optional string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * Output only. The deprecation status associated with this image.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     * @return \Google\Cloud\Compute\V1\DeprecationStatus|null
     */
    public function getDeprecated()
    {
        return $this->deprecated;
    }

    public function hasDeprecated()
    {
        return isset($this->deprecated);
    }

    public function clearDeprecated()
    {
        unset($this->deprecated);
    }

    /**
     * Output only. The deprecation status associated with this image.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.DeprecationStatus deprecated = 515138995;</code>
     * @param \Google\Cloud\Compute\V1\DeprecationStatus $var
     * @return $this
     */
    public function setDeprecated($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\DeprecationStatus::class);
        $this->deprecated = $var;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you
     * create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * An optional description of this resource. Provide this property when you
     * create the resource.
     *
     * Generated from protobuf field <code>optional string description = 422937596;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Size of the image when restored onto a persistent disk (in GB).
     *
     * Generated from protobuf field <code>optional int64 disk_size_gb = 316263735;</code>
     * @return int|string
     */
    public function getDiskSizeGb()
    {
        return isset($this->disk_size_gb) ? $this->disk_size_gb : 0;
    }

    public function hasDiskSizeGb()
    {
        return isset($this->disk_size_gb);
    }

    public function clearDiskSizeGb()
    {
        unset($this->disk_size_gb);
    }

    /**
     * Size of the image when restored onto a persistent disk (in GB).
     *
     * Generated from protobuf field <code>optional int64 disk_size_gb = 316263735;</code>
     * @param int|string $var
     * @return $this
     */
    public function setDiskSizeGb($var)
    {
        GPBUtil::checkInt64($var);
        $this->disk_size_gb = $var;

        return $this;
    }

    /**
     * Output only. Whether this image is created from a confidential compute mode disk.
     * [Output Only]: This field is not set by user, but from source disk.
     *
     * Generated from protobuf field <code>optional bool enable_confidential_compute = 102135228;</code>
     * @return bool
     */
    public function getEnableConfidentialCompute()
    {
        return isset($this->enable_confidential_compute) ? $this->enable_confidential_compute : false;
    }

    public function hasEnableConfidentialCompute()
    {
        return isset($this->enable_confidential_compute);
    }

    public function clearEnableConfidentialCompute()
    {
        unset($this->enable_confidential_compute);
    }

    /**
     * Output only. Whether this image is created from a confidential compute mode disk.
     * [Output Only]: This field is not set by user, but from source disk.
     *
     * Generated from protobuf field <code>optional bool enable_confidential_compute = 102135228;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableConfidentialCompute($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_confidential_compute = $var;

        return $this;
    }

    /**
     * The name of the image family to which this image belongs. The image
     * family name can be from a publicly managed image family provided by
     * Compute Engine, or from a custom image family you create. For example,centos-stream-9 is a publicly available image family.
     * For more information, see Image
     * family best practices.
     * When creating disks, you can specify an image family instead of a specific
     * image name. The image family always returns its latest image that is not
     * deprecated. The name of the image family must comply with RFC1035.
     *
     * Generated from protobuf field <code>optional string family = 328751972;</code>
     * @return string
     */
    public function getFamily()
    {
        return isset($this->family) ? $this->family : '';
    }

    public function hasFamily()
    {
        return isset($this->family);
    }

    public function clearFamily()
    {
        unset($this->family);
    }

    /**
     * The name of the image family to which this image belongs. The image
     * family name can be from a publicly managed image family provided by
     * Compute Engine, or from a custom image family you create. For example,centos-stream-9 is a publicly available image family.
     * For more information, see Image
     * family best practices.
     * When creating disks, you can specify an image family instead of a specific
     * image name. The image family always returns its latest image that is not
     * deprecated. The name of the image family must comply with RFC1035.
     *
     * Generated from protobuf field <code>optional string family = 328751972;</code>
     * @param string $var
     * @return $this
     */
    public function setFamily($var)
    {
        GPBUtil::checkString($var, True);
        $this->family = $var;

        return $this;
    }

    /**
     * A list of features to enable on the guest operating system. Applicable
     * only for bootable images. To see a list of available options, see theguestOSfeatures[].type parameter.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGuestOsFeatures()
    {
        return $this->guest_os_features;
    }

    /**
     * A list of features to enable on the guest operating system. Applicable
     * only for bootable images. To see a list of available options, see theguestOSfeatures[].type parameter.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     * @param array<\Google\Cloud\Compute\V1\GuestOsFeature>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGuestOsFeatures($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\GuestOsFeature::class);
        $this->guest_os_features = $arr;

        return $this;
    }

    /**
     * Output only. [Output Only] The unique identifier for the resource. This identifier is
     * defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @return int|string
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : 0;
    }

    public function hasId()
    {
        return isset($this->id);
    }

    public function clearId()
    {
        unset($this->id);
    }

    /**
     * Output only. [Output Only] The unique identifier for the resource. This identifier is
     * defined by the server.
     *
     * Generated from protobuf field <code>optional uint64 id = 3355;</code>
     * @param int|string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkUint64($var);
        $this->id = $var;

        return $this;
    }

    /**
     * Encrypts the image using acustomer-supplied
     * encryption key.
     * After you encrypt an image with a customer-supplied key, you must provide
     * the same key if you use the image later (e.g. to create a disk from
     * the image).
     * Customer-supplied encryption keys do not protect access to metadata
     * of the disk.
     * If you do not provide an encryption key when creating the image, then the
     * disk will be encrypted using an automatically generated key and you do not
     * need to provide a key to use the image later.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey image_encryption_key = 379512583;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey|null
     */
    public function getImageEncryptionKey()
    {
        return $this->image_encryption_key;
    }

    public function hasImageEncryptionKey()
    {
        return isset($this->image_encryption_key);
    }

    public function clearImageEncryptionKey()
    {
        unset($this->image_encryption_key);
    }

    /**
     * Encrypts the image using acustomer-supplied
     * encryption key.
     * After you encrypt an image with a customer-supplied key, you must provide
     * the same key if you use the image later (e.g. to create a disk from
     * the image).
     * Customer-supplied encryption keys do not protect access to metadata
     * of the disk.
     * If you do not provide an encryption key when creating the image, then the
     * disk will be encrypted using an automatically generated key and you do not
     * need to provide a key to use the image later.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey image_encryption_key = 379512583;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setImageEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->image_encryption_key = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Type of the resource. Always compute#image for
     * images.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return isset($this->kind) ? $this->kind : '';
    }

    public function hasKind()
    {
        return isset($this->kind);
    }

    public function clearKind()
    {
        unset($this->kind);
    }

    /**
     * Output only. [Output Only] Type of the resource. Always compute#image for
     * images.
     *
     * Generated from protobuf field <code>optional string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * A fingerprint for the labels being applied to this image, which is
     * essentially a hash of the labels used for optimistic locking. The
     * fingerprint is initially generated by Compute Engine and changes after
     * every request to modify or update labels. You must always provide an
     * up-to-date fingerprint hash in order to update or change labels,
     * otherwise the request will fail with error412 conditionNotMet.
     * To see the latest fingerprint, make a get() request to
     * retrieve an image.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     * @return string
     */
    public function getLabelFingerprint()
    {
        return isset($this->label_fingerprint) ? $this->label_fingerprint : '';
    }

    public function hasLabelFingerprint()
    {
        return isset($this->label_fingerprint);
    }

    public function clearLabelFingerprint()
    {
        unset($this->label_fingerprint);
    }

    /**
     * A fingerprint for the labels being applied to this image, which is
     * essentially a hash of the labels used for optimistic locking. The
     * fingerprint is initially generated by Compute Engine and changes after
     * every request to modify or update labels. You must always provide an
     * up-to-date fingerprint hash in order to update or change labels,
     * otherwise the request will fail with error412 conditionNotMet.
     * To see the latest fingerprint, make a get() request to
     * retrieve an image.
     *
     * Generated from protobuf field <code>optional string label_fingerprint = 178124825;</code>
     * @param string $var
     * @return $this
     */
    public function setLabelFingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->label_fingerprint = $var;

        return $this;
    }

    /**
     * Labels to apply to this image. These can be later modified by
     * the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels to apply to this image. These can be later modified by
     * the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 500195327;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Integer license codes indicating which licenses are attached to this image.
     *
     * Generated from protobuf field <code>repeated int64 license_codes = 45482664;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLicenseCodes()
    {
        return $this->license_codes;
    }

    /**
     * Integer license codes indicating which licenses are attached to this image.
     *
     * Generated from protobuf field <code>repeated int64 license_codes = 45482664;</code>
     * @param array<int>|array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLicenseCodes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::INT64);
        $this->license_codes = $arr;

        return $this;
    }

    /**
     * Any applicable license URI.
     *
     * Generated from protobuf field <code>repeated string licenses = 337642578;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLicenses()
    {
        return $this->licenses;
    }

    /**
     * Any applicable license URI.
     *
     * Generated from protobuf field <code>repeated string licenses = 337642578;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLicenses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->licenses = $arr;

        return $this;
    }

    /**
     * Name of the resource; provided by the client when the resource is created.
     * The name must be 1-63 characters long, and comply withRFC1035.
     * Specifically, the name must be 1-63 characters long and match the regular
     * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must be
     * a dash, lowercase letter, or digit, except the last character, which cannot
     * be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : '';
    }

    public function hasName()
    {
        return isset($this->name);
    }

    public function clearName()
    {
        unset($this->name);
    }

    /**
     * Name of the resource; provided by the client when the resource is created.
     * The name must be 1-63 characters long, and comply withRFC1035.
     * Specifically, the name must be 1-63 characters long and match the regular
     * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
     * character must be a lowercase letter, and all following characters must be
     * a dash, lowercase letter, or digit, except the last character, which cannot
     * be a dash.
     *
     * Generated from protobuf field <code>optional string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted
     * as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ImageParams params = 78313862;</code>
     * @return \Google\Cloud\Compute\V1\ImageParams|null
     */
    public function getParams()
    {
        return $this->params;
    }

    public function hasParams()
    {
        return isset($this->params);
    }

    public function clearParams()
    {
        unset($this->params);
    }

    /**
     * Input only. [Input Only] Additional params passed with the request, but not persisted
     * as part of resource payload.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.ImageParams params = 78313862;</code>
     * @param \Google\Cloud\Compute\V1\ImageParams $var
     * @return $this
     */
    public function setParams($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\ImageParams::class);
        $this->params = $var;

        return $this;
    }

    /**
     * The parameters of the raw disk image.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.RawDisk raw_disk = 503113556;</code>
     * @return \Google\Cloud\Compute\V1\RawDisk|null
     */
    public function getRawDisk()
    {
        return $this->raw_disk;
    }

    public function hasRawDisk()
    {
        return isset($this->raw_disk);
    }

    public function clearRawDisk()
    {
        unset($this->raw_disk);
    }

    /**
     * The parameters of the raw disk image.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.RawDisk raw_disk = 503113556;</code>
     * @param \Google\Cloud\Compute\V1\RawDisk $var
     * @return $this
     */
    public function setRawDisk($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\RawDisk::class);
        $this->raw_disk = $var;

        return $this;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 480964257;</code>
     * @return bool
     */
    public function getSatisfiesPzi()
    {
        return isset($this->satisfies_pzi) ? $this->satisfies_pzi : false;
    }

    public function hasSatisfiesPzi()
    {
        return isset($this->satisfies_pzi);
    }

    public function clearSatisfiesPzi()
    {
        unset($this->satisfies_pzi);
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzi = 480964257;</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzi($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzi = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return isset($this->satisfies_pzs) ? $this->satisfies_pzs : false;
    }

    public function hasSatisfiesPzs()
    {
        return isset($this->satisfies_pzs);
    }

    public function clearSatisfiesPzs()
    {
        unset($this->satisfies_pzs);
    }

    /**
     * Output only. [Output Only] Reserved for future use.
     *
     * Generated from protobuf field <code>optional bool satisfies_pzs = 480964267;</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return isset($this->self_link) ? $this->self_link : '';
    }

    public function hasSelfLink()
    {
        return isset($this->self_link);
    }

    public function clearSelfLink()
    {
        unset($this->self_link);
    }

    /**
     * Output only. [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>optional string self_link = 456214797;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * Set the secure boot keys of shielded instance.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;</code>
     * @return \Google\Cloud\Compute\V1\InitialStateConfig|null
     */
    public function getShieldedInstanceInitialState()
    {
        return $this->shielded_instance_initial_state;
    }

    public function hasShieldedInstanceInitialState()
    {
        return isset($this->shielded_instance_initial_state);
    }

    public function clearShieldedInstanceInitialState()
    {
        unset($this->shielded_instance_initial_state);
    }

    /**
     * Set the secure boot keys of shielded instance.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;</code>
     * @param \Google\Cloud\Compute\V1\InitialStateConfig $var
     * @return $this
     */
    public function setShieldedInstanceInitialState($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\InitialStateConfig::class);
        $this->shielded_instance_initial_state = $var;

        return $this;
    }

    /**
     * URL of the source disk used to create this image.
     * For example, the following are valid values:
     *    - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
     *    - projects/project/zones/zone/disks/disk
     *    - zones/zone/disks/disk
     * In order to create an image, you must provide the full or partial URL of
     * one of the following:
     *    - The rawDisk.source URL
     *    - The sourceDisk URL
     *    - The sourceImage URL
     *    - The sourceSnapshot URL
     *
     * Generated from protobuf field <code>optional string source_disk = 451753793;</code>
     * @return string
     */
    public function getSourceDisk()
    {
        return isset($this->source_disk) ? $this->source_disk : '';
    }

    public function hasSourceDisk()
    {
        return isset($this->source_disk);
    }

    public function clearSourceDisk()
    {
        unset($this->source_disk);
    }

    /**
     * URL of the source disk used to create this image.
     * For example, the following are valid values:
     *    - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
     *    - projects/project/zones/zone/disks/disk
     *    - zones/zone/disks/disk
     * In order to create an image, you must provide the full or partial URL of
     * one of the following:
     *    - The rawDisk.source URL
     *    - The sourceDisk URL
     *    - The sourceImage URL
     *    - The sourceSnapshot URL
     *
     * Generated from protobuf field <code>optional string source_disk = 451753793;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceDisk($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_disk = $var;

        return $this;
    }

    /**
     * Thecustomer-supplied
     * encryption key of the source disk. Required if the source disk is
     * protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey|null
     */
    public function getSourceDiskEncryptionKey()
    {
        return $this->source_disk_encryption_key;
    }

    public function hasSourceDiskEncryptionKey()
    {
        return isset($this->source_disk_encryption_key);
    }

    public function clearSourceDiskEncryptionKey()
    {
        unset($this->source_disk_encryption_key);
    }

    /**
     * Thecustomer-supplied
     * encryption key of the source disk. Required if the source disk is
     * protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 531501153;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setSourceDiskEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->source_disk_encryption_key = $var;

        return $this;
    }

    /**
     * Output only. [Output Only]
     * The ID value of the disk used to create this image. This value may be used
     * to determine whether the image was taken from the current or a previous
     * instance of a given disk name.
     *
     * Generated from protobuf field <code>optional string source_disk_id = 454190809;</code>
     * @return string
     */
    public function getSourceDiskId()
    {
        return isset($this->source_disk_id) ? $this->source_disk_id : '';
    }

    public function hasSourceDiskId()
    {
        return isset($this->source_disk_id);
    }

    public function clearSourceDiskId()
    {
        unset($this->source_disk_id);
    }

    /**
     * Output only. [Output Only]
     * The ID value of the disk used to create this image. This value may be used
     * to determine whether the image was taken from the current or a previous
     * instance of a given disk name.
     *
     * Generated from protobuf field <code>optional string source_disk_id = 454190809;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceDiskId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_disk_id = $var;

        return $this;
    }

    /**
     * URL of the source image used to create this image.
     * The following are valid formats for the URL:
     *    - https://www.googleapis.com/compute/v1/projects/project_id/global/
     *    images/image_name
     *    - projects/project_id/global/images/image_name
     * In order to create an image, you must provide the full or partial URL of
     * one of the following:
     *    - The rawDisk.source URL
     *    - The sourceDisk URL
     *    - The sourceImage URL
     *    - The sourceSnapshot URL
     *
     * Generated from protobuf field <code>optional string source_image = 50443319;</code>
     * @return string
     */
    public function getSourceImage()
    {
        return isset($this->source_image) ? $this->source_image : '';
    }

    public function hasSourceImage()
    {
        return isset($this->source_image);
    }

    public function clearSourceImage()
    {
        unset($this->source_image);
    }

    /**
     * URL of the source image used to create this image.
     * The following are valid formats for the URL:
     *    - https://www.googleapis.com/compute/v1/projects/project_id/global/
     *    images/image_name
     *    - projects/project_id/global/images/image_name
     * In order to create an image, you must provide the full or partial URL of
     * one of the following:
     *    - The rawDisk.source URL
     *    - The sourceDisk URL
     *    - The sourceImage URL
     *    - The sourceSnapshot URL
     *
     * Generated from protobuf field <code>optional string source_image = 50443319;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceImage($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_image = $var;

        return $this;
    }

    /**
     * The customer-supplied encryption key of the source image. Required if the
     * source image is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey|null
     */
    public function getSourceImageEncryptionKey()
    {
        return $this->source_image_encryption_key;
    }

    public function hasSourceImageEncryptionKey()
    {
        return isset($this->source_image_encryption_key);
    }

    public function clearSourceImageEncryptionKey()
    {
        unset($this->source_image_encryption_key);
    }

    /**
     * The customer-supplied encryption key of the source image. Required if the
     * source image is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setSourceImageEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->source_image_encryption_key = $var;

        return $this;
    }

    /**
     * Output only. [Output Only]
     * The ID value of the image used to create this image. This value may be used
     * to determine whether the image was taken from the current or a previous
     * instance of a given image name.
     *
     * Generated from protobuf field <code>optional string source_image_id = 55328291;</code>
     * @return string
     */
    public function getSourceImageId()
    {
        return isset($this->source_image_id) ? $this->source_image_id : '';
    }

    public function hasSourceImageId()
    {
        return isset($this->source_image_id);
    }

    public function clearSourceImageId()
    {
        unset($this->source_image_id);
    }

    /**
     * Output only. [Output Only]
     * The ID value of the image used to create this image. This value may be used
     * to determine whether the image was taken from the current or a previous
     * instance of a given image name.
     *
     * Generated from protobuf field <code>optional string source_image_id = 55328291;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceImageId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_image_id = $var;

        return $this;
    }

    /**
     * URL of the source snapshot used to create this image.
     * The following are valid formats for the URL:
     *    - https://www.googleapis.com/compute/v1/projects/project_id/global/
     *    snapshots/snapshot_name
     *    - projects/project_id/global/snapshots/snapshot_name
     * In order to create an image, you must provide the full or partial URL of
     * one of the following:
     *    - The rawDisk.source URL
     *    - The sourceDisk URL
     *    - The sourceImage URL
     *    - The sourceSnapshot URL
     *
     * Generated from protobuf field <code>optional string source_snapshot = 126061928;</code>
     * @return string
     */
    public function getSourceSnapshot()
    {
        return isset($this->source_snapshot) ? $this->source_snapshot : '';
    }

    public function hasSourceSnapshot()
    {
        return isset($this->source_snapshot);
    }

    public function clearSourceSnapshot()
    {
        unset($this->source_snapshot);
    }

    /**
     * URL of the source snapshot used to create this image.
     * The following are valid formats for the URL:
     *    - https://www.googleapis.com/compute/v1/projects/project_id/global/
     *    snapshots/snapshot_name
     *    - projects/project_id/global/snapshots/snapshot_name
     * In order to create an image, you must provide the full or partial URL of
     * one of the following:
     *    - The rawDisk.source URL
     *    - The sourceDisk URL
     *    - The sourceImage URL
     *    - The sourceSnapshot URL
     *
     * Generated from protobuf field <code>optional string source_snapshot = 126061928;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceSnapshot($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_snapshot = $var;

        return $this;
    }

    /**
     * The customer-supplied encryption key of the source snapshot. Required if
     * the source snapshot is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey|null
     */
    public function getSourceSnapshotEncryptionKey()
    {
        return $this->source_snapshot_encryption_key;
    }

    public function hasSourceSnapshotEncryptionKey()
    {
        return isset($this->source_snapshot_encryption_key);
    }

    public function clearSourceSnapshotEncryptionKey()
    {
        unset($this->source_snapshot_encryption_key);
    }

    /**
     * The customer-supplied encryption key of the source snapshot. Required if
     * the source snapshot is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setSourceSnapshotEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->source_snapshot_encryption_key = $var;

        return $this;
    }

    /**
     * Output only. [Output Only]
     * The ID value of the snapshot used to create this image. This value may be
     * used to determine whether the snapshot was taken from the current or a
     * previous instance of a given snapshot name.
     *
     * Generated from protobuf field <code>optional string source_snapshot_id = 98962258;</code>
     * @return string
     */
    public function getSourceSnapshotId()
    {
        return isset($this->source_snapshot_id) ? $this->source_snapshot_id : '';
    }

    public function hasSourceSnapshotId()
    {
        return isset($this->source_snapshot_id);
    }

    public function clearSourceSnapshotId()
    {
        unset($this->source_snapshot_id);
    }

    /**
     * Output only. [Output Only]
     * The ID value of the snapshot used to create this image. This value may be
     * used to determine whether the snapshot was taken from the current or a
     * previous instance of a given snapshot name.
     *
     * Generated from protobuf field <code>optional string source_snapshot_id = 98962258;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceSnapshotId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_snapshot_id = $var;

        return $this;
    }

    /**
     * The type of the image used to create this disk. The
     * default and only valid value is RAW.
     * Check the SourceType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string source_type = 452245726;</code>
     * @return string
     */
    public function getSourceType()
    {
        return isset($this->source_type) ? $this->source_type : '';
    }

    public function hasSourceType()
    {
        return isset($this->source_type);
    }

    public function clearSourceType()
    {
        unset($this->source_type);
    }

    /**
     * The type of the image used to create this disk. The
     * default and only valid value is RAW.
     * Check the SourceType enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string source_type = 452245726;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceType($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_type = $var;

        return $this;
    }

    /**
     * Output only. [Output Only] The status of the image. An image can be used to create other
     * resources, such as instances, only after the image has been successfully
     * created and the status is set to READY. Possible
     * values are FAILED, PENDING, orREADY.
     * Check the Status enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string status = 181260274;</code>
     * @return string
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : '';
    }

    public function hasStatus()
    {
        return isset($this->status);
    }

    public function clearStatus()
    {
        unset($this->status);
    }

    /**
     * Output only. [Output Only] The status of the image. An image can be used to create other
     * resources, such as instances, only after the image has been successfully
     * created and the status is set to READY. Possible
     * values are FAILED, PENDING, orREADY.
     * Check the Status enum for the list of possible values.
     *
     * Generated from protobuf field <code>optional string status = 181260274;</code>
     * @param string $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkString($var, True);
        $this->status = $var;

        return $this;
    }

    /**
     * Cloud Storage bucket storage location of the image (regional or
     * multi-regional).
     *
     * Generated from protobuf field <code>repeated string storage_locations = 328005274;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStorageLocations()
    {
        return $this->storage_locations;
    }

    /**
     * Cloud Storage bucket storage location of the image (regional or
     * multi-regional).
     *
     * Generated from protobuf field <code>repeated string storage_locations = 328005274;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStorageLocations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->storage_locations = $arr;

        return $this;
    }

}

