<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/reservation/v1/reservation.proto

namespace Google\Cloud\BigQuery\Reservation\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An assignment allows a project to submit jobs
 * of a certain type using slots from the specified reservation.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.reservation.v1.Assignment</code>
 */
class Assignment extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Name of the resource. E.g.:
     * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
     * The assignment_id must only contain lower case alphanumeric characters or
     * dashes and the max length is 64 characters.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Optional. The resource which will use the reservation. E.g.
     * `projects/myproject`, `folders/123`, or `organizations/456`.
     *
     * Generated from protobuf field <code>string assignee = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $assignee = '';
    /**
     * Optional. Which type of jobs will use the reservation.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.Assignment.JobType job_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $job_type = 0;
    /**
     * Output only. State of the assignment.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.Assignment.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Optional. Deprecated: "Gemini in BigQuery" is now available by
     * default for all BigQuery editions and should not be explicitly set.
     * Controls if "Gemini in BigQuery"
     * (https://cloud.google.com/gemini/docs/bigquery/overview) features should be
     * enabled for this reservation assignment.
     *
     * Generated from protobuf field <code>bool enable_gemini_in_bigquery = 10 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @deprecated
     */
    protected $enable_gemini_in_bigquery = false;
    /**
     * Optional. The scheduling policy to use for jobs and queries of this
     * assignee when running under the associated reservation. The scheduling
     * policy controls how the reservation's resources are distributed. This
     * overrides the default scheduling policy specified on the reservation.
     * This feature is not yet generally available.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.SchedulingPolicy scheduling_policy = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $scheduling_policy = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Name of the resource. E.g.:
     *           `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
     *           The assignment_id must only contain lower case alphanumeric characters or
     *           dashes and the max length is 64 characters.
     *     @type string $assignee
     *           Optional. The resource which will use the reservation. E.g.
     *           `projects/myproject`, `folders/123`, or `organizations/456`.
     *     @type int $job_type
     *           Optional. Which type of jobs will use the reservation.
     *     @type int $state
     *           Output only. State of the assignment.
     *     @type bool $enable_gemini_in_bigquery
     *           Optional. Deprecated: "Gemini in BigQuery" is now available by
     *           default for all BigQuery editions and should not be explicitly set.
     *           Controls if "Gemini in BigQuery"
     *           (https://cloud.google.com/gemini/docs/bigquery/overview) features should be
     *           enabled for this reservation assignment.
     *     @type \Google\Cloud\BigQuery\Reservation\V1\SchedulingPolicy $scheduling_policy
     *           Optional. The scheduling policy to use for jobs and queries of this
     *           assignee when running under the associated reservation. The scheduling
     *           policy controls how the reservation's resources are distributed. This
     *           overrides the default scheduling policy specified on the reservation.
     *           This feature is not yet generally available.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Reservation\V1\Reservation::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Name of the resource. E.g.:
     * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
     * The assignment_id must only contain lower case alphanumeric characters or
     * dashes and the max length is 64 characters.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Name of the resource. E.g.:
     * `projects/myproject/locations/US/reservations/team1-prod/assignments/123`.
     * The assignment_id must only contain lower case alphanumeric characters or
     * dashes and the max length is 64 characters.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. The resource which will use the reservation. E.g.
     * `projects/myproject`, `folders/123`, or `organizations/456`.
     *
     * Generated from protobuf field <code>string assignee = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getAssignee()
    {
        return $this->assignee;
    }

    /**
     * Optional. The resource which will use the reservation. E.g.
     * `projects/myproject`, `folders/123`, or `organizations/456`.
     *
     * Generated from protobuf field <code>string assignee = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setAssignee($var)
    {
        GPBUtil::checkString($var, True);
        $this->assignee = $var;

        return $this;
    }

    /**
     * Optional. Which type of jobs will use the reservation.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.Assignment.JobType job_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getJobType()
    {
        return $this->job_type;
    }

    /**
     * Optional. Which type of jobs will use the reservation.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.Assignment.JobType job_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setJobType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BigQuery\Reservation\V1\Assignment\JobType::class);
        $this->job_type = $var;

        return $this;
    }

    /**
     * Output only. State of the assignment.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.Assignment.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. State of the assignment.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.Assignment.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BigQuery\Reservation\V1\Assignment\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Optional. Deprecated: "Gemini in BigQuery" is now available by
     * default for all BigQuery editions and should not be explicitly set.
     * Controls if "Gemini in BigQuery"
     * (https://cloud.google.com/gemini/docs/bigquery/overview) features should be
     * enabled for this reservation assignment.
     *
     * Generated from protobuf field <code>bool enable_gemini_in_bigquery = 10 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     * @deprecated
     */
    public function getEnableGeminiInBigquery()
    {
        if ($this->enable_gemini_in_bigquery !== false) {
            @trigger_error('enable_gemini_in_bigquery is deprecated.', E_USER_DEPRECATED);
        }
        return $this->enable_gemini_in_bigquery;
    }

    /**
     * Optional. Deprecated: "Gemini in BigQuery" is now available by
     * default for all BigQuery editions and should not be explicitly set.
     * Controls if "Gemini in BigQuery"
     * (https://cloud.google.com/gemini/docs/bigquery/overview) features should be
     * enabled for this reservation assignment.
     *
     * Generated from protobuf field <code>bool enable_gemini_in_bigquery = 10 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     * @deprecated
     */
    public function setEnableGeminiInBigquery($var)
    {
        @trigger_error('enable_gemini_in_bigquery is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkBool($var);
        $this->enable_gemini_in_bigquery = $var;

        return $this;
    }

    /**
     * Optional. The scheduling policy to use for jobs and queries of this
     * assignee when running under the associated reservation. The scheduling
     * policy controls how the reservation's resources are distributed. This
     * overrides the default scheduling policy specified on the reservation.
     * This feature is not yet generally available.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.SchedulingPolicy scheduling_policy = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\BigQuery\Reservation\V1\SchedulingPolicy|null
     */
    public function getSchedulingPolicy()
    {
        return $this->scheduling_policy;
    }

    public function hasSchedulingPolicy()
    {
        return isset($this->scheduling_policy);
    }

    public function clearSchedulingPolicy()
    {
        unset($this->scheduling_policy);
    }

    /**
     * Optional. The scheduling policy to use for jobs and queries of this
     * assignee when running under the associated reservation. The scheduling
     * policy controls how the reservation's resources are distributed. This
     * overrides the default scheduling policy specified on the reservation.
     * This feature is not yet generally available.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.SchedulingPolicy scheduling_policy = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\BigQuery\Reservation\V1\SchedulingPolicy $var
     * @return $this
     */
    public function setSchedulingPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\Reservation\V1\SchedulingPolicy::class);
        $this->scheduling_policy = $var;

        return $this;
    }

}

