<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/artifactregistry/v1/tag.proto

namespace Google\Cloud\ArtifactRegistry\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The request to list tags.
 *
 * Generated from protobuf message <code>google.devtools.artifactregistry.v1.ListTagsRequest</code>
 */
class ListTagsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the parent package whose tags will be listed.
     * For example:
     * `projects/p1/locations/us-central1/repositories/repo1/packages/pkg1`.
     *
     * Generated from protobuf field <code>string parent = 1;</code>
     */
    protected $parent = '';
    /**
     * An expression for filtering the results of the request. Filter rules are
     * case insensitive. The fields eligible for filtering are:
     *   * `name`
     *   * `version`
     *  Examples of using a filter:
     *  To filter the results of your request to tags with the name `my-tag` in
     *  package `my-package` in repository `my-repo` in project "`y-project` in
     *  the us-central region, append the following filter expression to your
     *  request:
     *   * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/my-tag"`
     *  You can also use wildcards to match any number of characters before or
     *  after the value:
     *   * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/my*"`
     *   * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/&#42;tag"`
     *   * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/&#42;tag*"`
     *  To filter the results of your request to tags applied to the version
     *  `1.0` in package `my-package`, append the following filter expression to
     *  your request:
     *   * `version="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/versions/1.0"`
     *
     * Generated from protobuf field <code>string filter = 4;</code>
     */
    protected $filter = '';
    /**
     * The maximum number of tags to return. Maximum page size is 1,000.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     */
    protected $page_size = 0;
    /**
     * The next_page_token value returned from a previous list request, if any.
     *
     * Generated from protobuf field <code>string page_token = 3;</code>
     */
    protected $page_token = '';

    /**
     * @param string $parent The name of the parent package whose tags will be listed.
     *                       For example:
     *                       `projects/p1/locations/us-central1/repositories/repo1/packages/pkg1`.
     *
     * @return \Google\Cloud\ArtifactRegistry\V1\ListTagsRequest
     *
     * @experimental
     */
    public static function build(string $parent): self
    {
        return (new self())
            ->setParent($parent);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           The name of the parent package whose tags will be listed.
     *           For example:
     *           `projects/p1/locations/us-central1/repositories/repo1/packages/pkg1`.
     *     @type string $filter
     *           An expression for filtering the results of the request. Filter rules are
     *           case insensitive. The fields eligible for filtering are:
     *             * `name`
     *             * `version`
     *            Examples of using a filter:
     *            To filter the results of your request to tags with the name `my-tag` in
     *            package `my-package` in repository `my-repo` in project "`y-project` in
     *            the us-central region, append the following filter expression to your
     *            request:
     *             * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/my-tag"`
     *            You can also use wildcards to match any number of characters before or
     *            after the value:
     *             * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/my*"`
     *             * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/&#42;tag"`
     *             * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/&#42;tag*"`
     *            To filter the results of your request to tags applied to the version
     *            `1.0` in package `my-package`, append the following filter expression to
     *            your request:
     *             * `version="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/versions/1.0"`
     *     @type int $page_size
     *           The maximum number of tags to return. Maximum page size is 1,000.
     *     @type string $page_token
     *           The next_page_token value returned from a previous list request, if any.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Devtools\Artifactregistry\V1\Tag::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of the parent package whose tags will be listed.
     * For example:
     * `projects/p1/locations/us-central1/repositories/repo1/packages/pkg1`.
     *
     * Generated from protobuf field <code>string parent = 1;</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * The name of the parent package whose tags will be listed.
     * For example:
     * `projects/p1/locations/us-central1/repositories/repo1/packages/pkg1`.
     *
     * Generated from protobuf field <code>string parent = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * An expression for filtering the results of the request. Filter rules are
     * case insensitive. The fields eligible for filtering are:
     *   * `name`
     *   * `version`
     *  Examples of using a filter:
     *  To filter the results of your request to tags with the name `my-tag` in
     *  package `my-package` in repository `my-repo` in project "`y-project` in
     *  the us-central region, append the following filter expression to your
     *  request:
     *   * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/my-tag"`
     *  You can also use wildcards to match any number of characters before or
     *  after the value:
     *   * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/my*"`
     *   * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/&#42;tag"`
     *   * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/&#42;tag*"`
     *  To filter the results of your request to tags applied to the version
     *  `1.0` in package `my-package`, append the following filter expression to
     *  your request:
     *   * `version="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/versions/1.0"`
     *
     * Generated from protobuf field <code>string filter = 4;</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * An expression for filtering the results of the request. Filter rules are
     * case insensitive. The fields eligible for filtering are:
     *   * `name`
     *   * `version`
     *  Examples of using a filter:
     *  To filter the results of your request to tags with the name `my-tag` in
     *  package `my-package` in repository `my-repo` in project "`y-project` in
     *  the us-central region, append the following filter expression to your
     *  request:
     *   * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/my-tag"`
     *  You can also use wildcards to match any number of characters before or
     *  after the value:
     *   * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/my*"`
     *   * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/&#42;tag"`
     *   * `name="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/tags/&#42;tag*"`
     *  To filter the results of your request to tags applied to the version
     *  `1.0` in package `my-package`, append the following filter expression to
     *  your request:
     *   * `version="projects/my-project/locations/us-central1/repositories/my-repo/packages/my-package/versions/1.0"`
     *
     * Generated from protobuf field <code>string filter = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * The maximum number of tags to return. Maximum page size is 1,000.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * The maximum number of tags to return. Maximum page size is 1,000.
     *
     * Generated from protobuf field <code>int32 page_size = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * The next_page_token value returned from a previous list request, if any.
     *
     * Generated from protobuf field <code>string page_token = 3;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * The next_page_token value returned from a previous list request, if any.
     *
     * Generated from protobuf field <code>string page_token = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

}

