<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/artifactregistry/v1/attachment.proto

namespace Google\Cloud\ArtifactRegistry\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An Attachment refers to additional metadata that can be attached to
 * artifacts in Artifact Registry. An attachment consists of one or more files.
 *
 * Generated from protobuf message <code>google.devtools.artifactregistry.v1.Attachment</code>
 */
class Attachment extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the attachment. E.g.
     * `projects/p1/locations/us/repositories/repo/attachments/sbom`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Required. The target the attachment is for, can be a Version, Package or
     * Repository. E.g.
     * `projects/p1/locations/us-central1/repositories/repo1/packages/p1/versions/v1`.
     *
     * Generated from protobuf field <code>string target = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $target = '';
    /**
     * Type of attachment.
     * E.g. `application/vnd.spdx+json`
     *
     * Generated from protobuf field <code>string type = 3;</code>
     */
    protected $type = '';
    /**
     * The namespace this attachment belongs to.
     * E.g. If an attachment is created by artifact analysis, namespace is set
     * to `artifactanalysis.googleapis.com`.
     *
     * Generated from protobuf field <code>string attachment_namespace = 4;</code>
     */
    protected $attachment_namespace = '';
    /**
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Artifact Registry. See
     * https://google.aip.dev/128#annotations for more details such as format and
     * size limitations.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $annotations;
    /**
     * Output only. The time when the attachment was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time when the attachment was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Required. The files that belong to this attachment.
     * If the file ID part contains slashes, they are escaped. E.g.
     * `projects/p1/locations/us-central1/repositories/repo1/files/sha:<sha-of-file>`.
     *
     * Generated from protobuf field <code>repeated string files = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $files;
    /**
     * Output only. The name of the OCI version that this attachment created. Only
     * populated for Docker attachments. E.g.
     * `projects/p1/locations/us-central1/repositories/repo1/packages/p1/versions/v1`.
     *
     * Generated from protobuf field <code>string oci_version_name = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $oci_version_name = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The name of the attachment. E.g.
     *           `projects/p1/locations/us/repositories/repo/attachments/sbom`.
     *     @type string $target
     *           Required. The target the attachment is for, can be a Version, Package or
     *           Repository. E.g.
     *           `projects/p1/locations/us-central1/repositories/repo1/packages/p1/versions/v1`.
     *     @type string $type
     *           Type of attachment.
     *           E.g. `application/vnd.spdx+json`
     *     @type string $attachment_namespace
     *           The namespace this attachment belongs to.
     *           E.g. If an attachment is created by artifact analysis, namespace is set
     *           to `artifactanalysis.googleapis.com`.
     *     @type array|\Google\Protobuf\Internal\MapField $annotations
     *           Optional. User annotations. These attributes can only be set and used by
     *           the user, and not by Artifact Registry. See
     *           https://google.aip.dev/128#annotations for more details such as format and
     *           size limitations.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time when the attachment was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time when the attachment was last updated.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $files
     *           Required. The files that belong to this attachment.
     *           If the file ID part contains slashes, they are escaped. E.g.
     *           `projects/p1/locations/us-central1/repositories/repo1/files/sha:<sha-of-file>`.
     *     @type string $oci_version_name
     *           Output only. The name of the OCI version that this attachment created. Only
     *           populated for Docker attachments. E.g.
     *           `projects/p1/locations/us-central1/repositories/repo1/packages/p1/versions/v1`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Devtools\Artifactregistry\V1\Attachment::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of the attachment. E.g.
     * `projects/p1/locations/us/repositories/repo/attachments/sbom`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name of the attachment. E.g.
     * `projects/p1/locations/us/repositories/repo/attachments/sbom`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The target the attachment is for, can be a Version, Package or
     * Repository. E.g.
     * `projects/p1/locations/us-central1/repositories/repo1/packages/p1/versions/v1`.
     *
     * Generated from protobuf field <code>string target = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTarget()
    {
        return $this->target;
    }

    /**
     * Required. The target the attachment is for, can be a Version, Package or
     * Repository. E.g.
     * `projects/p1/locations/us-central1/repositories/repo1/packages/p1/versions/v1`.
     *
     * Generated from protobuf field <code>string target = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTarget($var)
    {
        GPBUtil::checkString($var, True);
        $this->target = $var;

        return $this;
    }

    /**
     * Type of attachment.
     * E.g. `application/vnd.spdx+json`
     *
     * Generated from protobuf field <code>string type = 3;</code>
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Type of attachment.
     * E.g. `application/vnd.spdx+json`
     *
     * Generated from protobuf field <code>string type = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkString($var, True);
        $this->type = $var;

        return $this;
    }

    /**
     * The namespace this attachment belongs to.
     * E.g. If an attachment is created by artifact analysis, namespace is set
     * to `artifactanalysis.googleapis.com`.
     *
     * Generated from protobuf field <code>string attachment_namespace = 4;</code>
     * @return string
     */
    public function getAttachmentNamespace()
    {
        return $this->attachment_namespace;
    }

    /**
     * The namespace this attachment belongs to.
     * E.g. If an attachment is created by artifact analysis, namespace is set
     * to `artifactanalysis.googleapis.com`.
     *
     * Generated from protobuf field <code>string attachment_namespace = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setAttachmentNamespace($var)
    {
        GPBUtil::checkString($var, True);
        $this->attachment_namespace = $var;

        return $this;
    }

    /**
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Artifact Registry. See
     * https://google.aip.dev/128#annotations for more details such as format and
     * size limitations.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAnnotations()
    {
        return $this->annotations;
    }

    /**
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Artifact Registry. See
     * https://google.aip.dev/128#annotations for more details such as format and
     * size limitations.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAnnotations($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->annotations = $arr;

        return $this;
    }

    /**
     * Output only. The time when the attachment was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time when the attachment was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time when the attachment was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time when the attachment was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Required. The files that belong to this attachment.
     * If the file ID part contains slashes, they are escaped. E.g.
     * `projects/p1/locations/us-central1/repositories/repo1/files/sha:<sha-of-file>`.
     *
     * Generated from protobuf field <code>repeated string files = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFiles()
    {
        return $this->files;
    }

    /**
     * Required. The files that belong to this attachment.
     * If the file ID part contains slashes, they are escaped. E.g.
     * `projects/p1/locations/us-central1/repositories/repo1/files/sha:<sha-of-file>`.
     *
     * Generated from protobuf field <code>repeated string files = 8 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFiles($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->files = $arr;

        return $this;
    }

    /**
     * Output only. The name of the OCI version that this attachment created. Only
     * populated for Docker attachments. E.g.
     * `projects/p1/locations/us-central1/repositories/repo1/packages/p1/versions/v1`.
     *
     * Generated from protobuf field <code>string oci_version_name = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getOciVersionName()
    {
        return $this->oci_version_name;
    }

    /**
     * Output only. The name of the OCI version that this attachment created. Only
     * populated for Docker attachments. E.g.
     * `projects/p1/locations/us-central1/repositories/repo1/packages/p1/versions/v1`.
     *
     * Generated from protobuf field <code>string oci_version_name = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setOciVersionName($var)
    {
        GPBUtil::checkString($var, True);
        $this->oci_version_name = $var;

        return $this;
    }

}

