<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/model_garden_service.proto

namespace Google\Cloud\AIPlatform\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [ModelGardenService.Deploy][google.cloud.aiplatform.v1.ModelGardenService.Deploy].
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.DeployRequest</code>
 */
class DeployRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the Location to deploy the model in.
     * Format: `projects/{project}/locations/{location}`
     *
     * Generated from protobuf field <code>string destination = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $destination = '';
    /**
     * Optional. The model config to use for the deployment.
     * If not specified, the default model config will be used.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $model_config = null;
    /**
     * Optional. The endpoint config to use for the deployment.
     * If not specified, the default endpoint config will be used.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $endpoint_config = null;
    /**
     * Optional. The deploy config to use for the deployment.
     * If not specified, the default deploy config will be used.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $deploy_config = null;
    protected $artifacts;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $publisher_model_name
     *           The Model Garden model to deploy.
     *           Format:
     *           `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
     *           `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
     *     @type string $hugging_face_model_id
     *           The Hugging Face model to deploy.
     *           Format: Hugging Face model ID like `google/gemma-2-2b-it`.
     *     @type string $destination
     *           Required. The resource name of the Location to deploy the model in.
     *           Format: `projects/{project}/locations/{location}`
     *     @type \Google\Cloud\AIPlatform\V1\DeployRequest\ModelConfig $model_config
     *           Optional. The model config to use for the deployment.
     *           If not specified, the default model config will be used.
     *     @type \Google\Cloud\AIPlatform\V1\DeployRequest\EndpointConfig $endpoint_config
     *           Optional. The endpoint config to use for the deployment.
     *           If not specified, the default endpoint config will be used.
     *     @type \Google\Cloud\AIPlatform\V1\DeployRequest\DeployConfig $deploy_config
     *           Optional. The deploy config to use for the deployment.
     *           If not specified, the default deploy config will be used.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\ModelGardenService::initOnce();
        parent::__construct($data);
    }

    /**
     * The Model Garden model to deploy.
     * Format:
     * `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
     * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
     *
     * Generated from protobuf field <code>string publisher_model_name = 1 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getPublisherModelName()
    {
        return $this->readOneof(1);
    }

    public function hasPublisherModelName()
    {
        return $this->hasOneof(1);
    }

    /**
     * The Model Garden model to deploy.
     * Format:
     * `publishers/{publisher}/models/{publisher_model}&#64;{version_id}`, or
     * `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}&#64;001`.
     *
     * Generated from protobuf field <code>string publisher_model_name = 1 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setPublisherModelName($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * The Hugging Face model to deploy.
     * Format: Hugging Face model ID like `google/gemma-2-2b-it`.
     *
     * Generated from protobuf field <code>string hugging_face_model_id = 2;</code>
     * @return string
     */
    public function getHuggingFaceModelId()
    {
        return $this->readOneof(2);
    }

    public function hasHuggingFaceModelId()
    {
        return $this->hasOneof(2);
    }

    /**
     * The Hugging Face model to deploy.
     * Format: Hugging Face model ID like `google/gemma-2-2b-it`.
     *
     * Generated from protobuf field <code>string hugging_face_model_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setHuggingFaceModelId($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Required. The resource name of the Location to deploy the model in.
     * Format: `projects/{project}/locations/{location}`
     *
     * Generated from protobuf field <code>string destination = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getDestination()
    {
        return $this->destination;
    }

    /**
     * Required. The resource name of the Location to deploy the model in.
     * Format: `projects/{project}/locations/{location}`
     *
     * Generated from protobuf field <code>string destination = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setDestination($var)
    {
        GPBUtil::checkString($var, True);
        $this->destination = $var;

        return $this;
    }

    /**
     * Optional. The model config to use for the deployment.
     * If not specified, the default model config will be used.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AIPlatform\V1\DeployRequest\ModelConfig|null
     */
    public function getModelConfig()
    {
        return $this->model_config;
    }

    public function hasModelConfig()
    {
        return isset($this->model_config);
    }

    public function clearModelConfig()
    {
        unset($this->model_config);
    }

    /**
     * Optional. The model config to use for the deployment.
     * If not specified, the default model config will be used.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.DeployRequest.ModelConfig model_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AIPlatform\V1\DeployRequest\ModelConfig $var
     * @return $this
     */
    public function setModelConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\DeployRequest\ModelConfig::class);
        $this->model_config = $var;

        return $this;
    }

    /**
     * Optional. The endpoint config to use for the deployment.
     * If not specified, the default endpoint config will be used.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AIPlatform\V1\DeployRequest\EndpointConfig|null
     */
    public function getEndpointConfig()
    {
        return $this->endpoint_config;
    }

    public function hasEndpointConfig()
    {
        return isset($this->endpoint_config);
    }

    public function clearEndpointConfig()
    {
        unset($this->endpoint_config);
    }

    /**
     * Optional. The endpoint config to use for the deployment.
     * If not specified, the default endpoint config will be used.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.DeployRequest.EndpointConfig endpoint_config = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AIPlatform\V1\DeployRequest\EndpointConfig $var
     * @return $this
     */
    public function setEndpointConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\DeployRequest\EndpointConfig::class);
        $this->endpoint_config = $var;

        return $this;
    }

    /**
     * Optional. The deploy config to use for the deployment.
     * If not specified, the default deploy config will be used.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AIPlatform\V1\DeployRequest\DeployConfig|null
     */
    public function getDeployConfig()
    {
        return $this->deploy_config;
    }

    public function hasDeployConfig()
    {
        return isset($this->deploy_config);
    }

    public function clearDeployConfig()
    {
        unset($this->deploy_config);
    }

    /**
     * Optional. The deploy config to use for the deployment.
     * If not specified, the default deploy config will be used.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.DeployRequest.DeployConfig deploy_config = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AIPlatform\V1\DeployRequest\DeployConfig $var
     * @return $this
     */
    public function setDeployConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\DeployRequest\DeployConfig::class);
        $this->deploy_config = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getArtifacts()
    {
        return $this->whichOneof("artifacts");
    }

}

