<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/iam/v2/policy.proto

namespace Google\Cloud\Iam\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Data for an IAM policy.
 *
 * Generated from protobuf message <code>google.iam.v2.Policy</code>
 */
class Policy extends \Google\Protobuf\Internal\Message
{
    /**
     * Immutable. The resource name of the `Policy`, which must be unique. Format:
     * `policies/{attachment_point}/denypolicies/{policy_id}`
     * The attachment point is identified by its URL-encoded full resource name,
     * which means that the forward-slash character, `/`, must be written as
     * `%2F`. For example,
     * `policies/cloudresourcemanager.googleapis.com%2Fprojects%2Fmy-project/denypolicies/my-deny-policy`.
     * For organizations and folders, use the numeric ID in the full resource
     * name. For projects, requests can use the alphanumeric or the numeric ID.
     * Responses always contain the numeric ID.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $name = '';
    /**
     * Immutable. The globally unique ID of the `Policy`. Assigned automatically when the
     * `Policy` is created.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $uid = '';
    /**
     * Output only. The kind of the `Policy`. Always contains the value `DenyPolicy`.
     *
     * Generated from protobuf field <code>string kind = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $kind = '';
    /**
     * A user-specified description of the `Policy`. This value can be up to 63
     * characters.
     *
     * Generated from protobuf field <code>string display_name = 4;</code>
     */
    protected $display_name = '';
    /**
     * A key-value map to store arbitrary metadata for the `Policy`. Keys
     * can be up to 63 characters. Values can be up to 255 characters.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 5;</code>
     */
    private $annotations;
    /**
     * An opaque tag that identifies the current version of the `Policy`. IAM uses
     * this value to help manage concurrent updates, so they do not cause one
     * update to be overwritten by another.
     * If this field is present in a [CreatePolicy][] request, the value is
     * ignored.
     *
     * Generated from protobuf field <code>string etag = 6;</code>
     */
    protected $etag = '';
    /**
     * Output only. The time when the `Policy` was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time when the `Policy` was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. The time when the `Policy` was deleted. Empty if the policy is not deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $delete_time = null;
    /**
     * A list of rules that specify the behavior of the `Policy`. All of the rules
     * should be of the `kind` specified in the `Policy`.
     *
     * Generated from protobuf field <code>repeated .google.iam.v2.PolicyRule rules = 10;</code>
     */
    private $rules;
    /**
     * Immutable. Specifies that this policy is managed by an authority and can only be
     * modified by that authority. Usage is restricted.
     *
     * Generated from protobuf field <code>string managing_authority = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $managing_authority = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Immutable. The resource name of the `Policy`, which must be unique. Format:
     *           `policies/{attachment_point}/denypolicies/{policy_id}`
     *           The attachment point is identified by its URL-encoded full resource name,
     *           which means that the forward-slash character, `/`, must be written as
     *           `%2F`. For example,
     *           `policies/cloudresourcemanager.googleapis.com%2Fprojects%2Fmy-project/denypolicies/my-deny-policy`.
     *           For organizations and folders, use the numeric ID in the full resource
     *           name. For projects, requests can use the alphanumeric or the numeric ID.
     *           Responses always contain the numeric ID.
     *     @type string $uid
     *           Immutable. The globally unique ID of the `Policy`. Assigned automatically when the
     *           `Policy` is created.
     *     @type string $kind
     *           Output only. The kind of the `Policy`. Always contains the value `DenyPolicy`.
     *     @type string $display_name
     *           A user-specified description of the `Policy`. This value can be up to 63
     *           characters.
     *     @type array|\Google\Protobuf\Internal\MapField $annotations
     *           A key-value map to store arbitrary metadata for the `Policy`. Keys
     *           can be up to 63 characters. Values can be up to 255 characters.
     *     @type string $etag
     *           An opaque tag that identifies the current version of the `Policy`. IAM uses
     *           this value to help manage concurrent updates, so they do not cause one
     *           update to be overwritten by another.
     *           If this field is present in a [CreatePolicy][] request, the value is
     *           ignored.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time when the `Policy` was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time when the `Policy` was last updated.
     *     @type \Google\Protobuf\Timestamp $delete_time
     *           Output only. The time when the `Policy` was deleted. Empty if the policy is not deleted.
     *     @type array<\Google\Cloud\Iam\V2\PolicyRule>|\Google\Protobuf\Internal\RepeatedField $rules
     *           A list of rules that specify the behavior of the `Policy`. All of the rules
     *           should be of the `kind` specified in the `Policy`.
     *     @type string $managing_authority
     *           Immutable. Specifies that this policy is managed by an authority and can only be
     *           modified by that authority. Usage is restricted.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Iam\V2\Policy::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. The resource name of the `Policy`, which must be unique. Format:
     * `policies/{attachment_point}/denypolicies/{policy_id}`
     * The attachment point is identified by its URL-encoded full resource name,
     * which means that the forward-slash character, `/`, must be written as
     * `%2F`. For example,
     * `policies/cloudresourcemanager.googleapis.com%2Fprojects%2Fmy-project/denypolicies/my-deny-policy`.
     * For organizations and folders, use the numeric ID in the full resource
     * name. For projects, requests can use the alphanumeric or the numeric ID.
     * Responses always contain the numeric ID.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Immutable. The resource name of the `Policy`, which must be unique. Format:
     * `policies/{attachment_point}/denypolicies/{policy_id}`
     * The attachment point is identified by its URL-encoded full resource name,
     * which means that the forward-slash character, `/`, must be written as
     * `%2F`. For example,
     * `policies/cloudresourcemanager.googleapis.com%2Fprojects%2Fmy-project/denypolicies/my-deny-policy`.
     * For organizations and folders, use the numeric ID in the full resource
     * name. For projects, requests can use the alphanumeric or the numeric ID.
     * Responses always contain the numeric ID.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Immutable. The globally unique ID of the `Policy`. Assigned automatically when the
     * `Policy` is created.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Immutable. The globally unique ID of the `Policy`. Assigned automatically when the
     * `Policy` is created.
     *
     * Generated from protobuf field <code>string uid = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Output only. The kind of the `Policy`. Always contains the value `DenyPolicy`.
     *
     * Generated from protobuf field <code>string kind = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * Output only. The kind of the `Policy`. Always contains the value `DenyPolicy`.
     *
     * Generated from protobuf field <code>string kind = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * A user-specified description of the `Policy`. This value can be up to 63
     * characters.
     *
     * Generated from protobuf field <code>string display_name = 4;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * A user-specified description of the `Policy`. This value can be up to 63
     * characters.
     *
     * Generated from protobuf field <code>string display_name = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * A key-value map to store arbitrary metadata for the `Policy`. Keys
     * can be up to 63 characters. Values can be up to 255 characters.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 5;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAnnotations()
    {
        return $this->annotations;
    }

    /**
     * A key-value map to store arbitrary metadata for the `Policy`. Keys
     * can be up to 63 characters. Values can be up to 255 characters.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 5;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAnnotations($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->annotations = $arr;

        return $this;
    }

    /**
     * An opaque tag that identifies the current version of the `Policy`. IAM uses
     * this value to help manage concurrent updates, so they do not cause one
     * update to be overwritten by another.
     * If this field is present in a [CreatePolicy][] request, the value is
     * ignored.
     *
     * Generated from protobuf field <code>string etag = 6;</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * An opaque tag that identifies the current version of the `Policy`. IAM uses
     * this value to help manage concurrent updates, so they do not cause one
     * update to be overwritten by another.
     * If this field is present in a [CreatePolicy][] request, the value is
     * ignored.
     *
     * Generated from protobuf field <code>string etag = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Output only. The time when the `Policy` was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time when the `Policy` was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time when the `Policy` was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time when the `Policy` was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. The time when the `Policy` was deleted. Empty if the policy is not deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDeleteTime()
    {
        return $this->delete_time;
    }

    public function hasDeleteTime()
    {
        return isset($this->delete_time);
    }

    public function clearDeleteTime()
    {
        unset($this->delete_time);
    }

    /**
     * Output only. The time when the `Policy` was deleted. Empty if the policy is not deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDeleteTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->delete_time = $var;

        return $this;
    }

    /**
     * A list of rules that specify the behavior of the `Policy`. All of the rules
     * should be of the `kind` specified in the `Policy`.
     *
     * Generated from protobuf field <code>repeated .google.iam.v2.PolicyRule rules = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRules()
    {
        return $this->rules;
    }

    /**
     * A list of rules that specify the behavior of the `Policy`. All of the rules
     * should be of the `kind` specified in the `Policy`.
     *
     * Generated from protobuf field <code>repeated .google.iam.v2.PolicyRule rules = 10;</code>
     * @param array<\Google\Cloud\Iam\V2\PolicyRule>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRules($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Iam\V2\PolicyRule::class);
        $this->rules = $arr;

        return $this;
    }

    /**
     * Immutable. Specifies that this policy is managed by an authority and can only be
     * modified by that authority. Usage is restricted.
     *
     * Generated from protobuf field <code>string managing_authority = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getManagingAuthority()
    {
        return $this->managing_authority;
    }

    /**
     * Immutable. Specifies that this policy is managed by an authority and can only be
     * modified by that authority. Usage is restricted.
     *
     * Generated from protobuf field <code>string managing_authority = 11 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setManagingAuthority($var)
    {
        GPBUtil::checkString($var, True);
        $this->managing_authority = $var;

        return $this;
    }

}

