<?php
/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/firestore/admin/v1/firestore_admin.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Firestore\Admin\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Firestore\Admin\V1\Backup;
use Google\Cloud\Firestore\Admin\V1\BackupSchedule;
use Google\Cloud\Firestore\Admin\V1\BulkDeleteDocumentsRequest;
use Google\Cloud\Firestore\Admin\V1\CreateBackupScheduleRequest;
use Google\Cloud\Firestore\Admin\V1\CreateDatabaseRequest;
use Google\Cloud\Firestore\Admin\V1\CreateIndexRequest;
use Google\Cloud\Firestore\Admin\V1\Database;
use Google\Cloud\Firestore\Admin\V1\Database\EncryptionConfig;
use Google\Cloud\Firestore\Admin\V1\DeleteBackupRequest;
use Google\Cloud\Firestore\Admin\V1\DeleteBackupScheduleRequest;
use Google\Cloud\Firestore\Admin\V1\DeleteDatabaseRequest;
use Google\Cloud\Firestore\Admin\V1\DeleteIndexRequest;
use Google\Cloud\Firestore\Admin\V1\ExportDocumentsRequest;
use Google\Cloud\Firestore\Admin\V1\ExportDocumentsResponse;
use Google\Cloud\Firestore\Admin\V1\Field;
use Google\Cloud\Firestore\Admin\V1\FieldOperationMetadata;
use Google\Cloud\Firestore\Admin\V1\GetBackupRequest;
use Google\Cloud\Firestore\Admin\V1\GetBackupScheduleRequest;
use Google\Cloud\Firestore\Admin\V1\GetDatabaseRequest;
use Google\Cloud\Firestore\Admin\V1\GetFieldRequest;
use Google\Cloud\Firestore\Admin\V1\GetIndexRequest;
use Google\Cloud\Firestore\Admin\V1\ImportDocumentsRequest;
use Google\Cloud\Firestore\Admin\V1\Index;
use Google\Cloud\Firestore\Admin\V1\IndexOperationMetadata;
use Google\Cloud\Firestore\Admin\V1\ListBackupSchedulesRequest;
use Google\Cloud\Firestore\Admin\V1\ListBackupSchedulesResponse;
use Google\Cloud\Firestore\Admin\V1\ListBackupsRequest;
use Google\Cloud\Firestore\Admin\V1\ListBackupsResponse;
use Google\Cloud\Firestore\Admin\V1\ListDatabasesRequest;
use Google\Cloud\Firestore\Admin\V1\ListDatabasesResponse;
use Google\Cloud\Firestore\Admin\V1\ListFieldsRequest;
use Google\Cloud\Firestore\Admin\V1\ListFieldsResponse;
use Google\Cloud\Firestore\Admin\V1\ListIndexesRequest;
use Google\Cloud\Firestore\Admin\V1\ListIndexesResponse;
use Google\Cloud\Firestore\Admin\V1\RestoreDatabaseMetadata;
use Google\Cloud\Firestore\Admin\V1\RestoreDatabaseRequest;
use Google\Cloud\Firestore\Admin\V1\UpdateBackupScheduleRequest;
use Google\Cloud\Firestore\Admin\V1\UpdateDatabaseRequest;
use Google\Cloud\Firestore\Admin\V1\UpdateFieldRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;
use Google\Protobuf\Timestamp;

/**
 * Service Description: The Cloud Firestore Admin API.
 *
 * This API provides several administrative services for Cloud Firestore.
 *
 * Project, Database, Namespace, Collection, Collection Group, and Document are
 * used as defined in the Google Cloud Firestore API.
 *
 * Operation: An Operation represents work being performed in the background.
 *
 * The index service manages Cloud Firestore indexes.
 *
 * Index creation is performed asynchronously.
 * An Operation resource is created for each such asynchronous operation.
 * The state of the operation (including any errors encountered)
 * may be queried via the Operation resource.
 *
 * The Operations collection provides a record of actions performed for the
 * specified Project (including any Operations in progress). Operations are not
 * created directly but through calls on other collections or resources.
 *
 * An Operation that is done may be deleted so that it is no longer listed as
 * part of the Operation collection. Operations are garbage collected after
 * 30 days. By default, ListOperations will only return in progress and failed
 * operations. To list completed operation, issue a ListOperations request with
 * the filter `done: true`.
 *
 * Operations are created by service `FirestoreAdmin`, but are accessed via
 * service `google.longrunning.Operations`.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $firestoreAdminClient = new FirestoreAdminClient();
 * try {
 *     $formattedName = $firestoreAdminClient->databaseName('[PROJECT]', '[DATABASE]');
 *     $operationResponse = $firestoreAdminClient->bulkDeleteDocuments($formattedName);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $firestoreAdminClient->bulkDeleteDocuments($formattedName);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $firestoreAdminClient->resumeOperation($operationName, 'bulkDeleteDocuments');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $firestoreAdminClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated Please use the new service client {@see \Google\Cloud\Firestore\Admin\V1\Client\FirestoreAdminClient}.
 */
class FirestoreAdminGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.firestore.admin.v1.FirestoreAdmin';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'firestore.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'firestore.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/datastore',
    ];

    private static $backupNameTemplate;

    private static $backupScheduleNameTemplate;

    private static $collectionGroupNameTemplate;

    private static $databaseNameTemplate;

    private static $fieldNameTemplate;

    private static $indexNameTemplate;

    private static $locationNameTemplate;

    private static $operationNameTemplate;

    private static $projectNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/firestore_admin_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/firestore_admin_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/firestore_admin_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/firestore_admin_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getBackupNameTemplate()
    {
        if (self::$backupNameTemplate == null) {
            self::$backupNameTemplate = new PathTemplate('projects/{project}/locations/{location}/backups/{backup}');
        }

        return self::$backupNameTemplate;
    }

    private static function getBackupScheduleNameTemplate()
    {
        if (self::$backupScheduleNameTemplate == null) {
            self::$backupScheduleNameTemplate = new PathTemplate('projects/{project}/databases/{database}/backupSchedules/{backup_schedule}');
        }

        return self::$backupScheduleNameTemplate;
    }

    private static function getCollectionGroupNameTemplate()
    {
        if (self::$collectionGroupNameTemplate == null) {
            self::$collectionGroupNameTemplate = new PathTemplate('projects/{project}/databases/{database}/collectionGroups/{collection}');
        }

        return self::$collectionGroupNameTemplate;
    }

    private static function getDatabaseNameTemplate()
    {
        if (self::$databaseNameTemplate == null) {
            self::$databaseNameTemplate = new PathTemplate('projects/{project}/databases/{database}');
        }

        return self::$databaseNameTemplate;
    }

    private static function getFieldNameTemplate()
    {
        if (self::$fieldNameTemplate == null) {
            self::$fieldNameTemplate = new PathTemplate('projects/{project}/databases/{database}/collectionGroups/{collection}/fields/{field}');
        }

        return self::$fieldNameTemplate;
    }

    private static function getIndexNameTemplate()
    {
        if (self::$indexNameTemplate == null) {
            self::$indexNameTemplate = new PathTemplate('projects/{project}/databases/{database}/collectionGroups/{collection}/indexes/{index}');
        }

        return self::$indexNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getOperationNameTemplate()
    {
        if (self::$operationNameTemplate == null) {
            self::$operationNameTemplate = new PathTemplate('projects/{project}/databases/{database}/operations/{operation}');
        }

        return self::$operationNameTemplate;
    }

    private static function getProjectNameTemplate()
    {
        if (self::$projectNameTemplate == null) {
            self::$projectNameTemplate = new PathTemplate('projects/{project}');
        }

        return self::$projectNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'backup' => self::getBackupNameTemplate(),
                'backupSchedule' => self::getBackupScheduleNameTemplate(),
                'collectionGroup' => self::getCollectionGroupNameTemplate(),
                'database' => self::getDatabaseNameTemplate(),
                'field' => self::getFieldNameTemplate(),
                'index' => self::getIndexNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'operation' => self::getOperationNameTemplate(),
                'project' => self::getProjectNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backup
     *
     * @return string The formatted backup resource.
     */
    public static function backupName($project, $location, $backup)
    {
        return self::getBackupNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'backup' => $backup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * backup_schedule resource.
     *
     * @param string $project
     * @param string $database
     * @param string $backupSchedule
     *
     * @return string The formatted backup_schedule resource.
     */
    public static function backupScheduleName($project, $database, $backupSchedule)
    {
        return self::getBackupScheduleNameTemplate()->render([
            'project' => $project,
            'database' => $database,
            'backup_schedule' => $backupSchedule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * collection_group resource.
     *
     * @param string $project
     * @param string $database
     * @param string $collection
     *
     * @return string The formatted collection_group resource.
     */
    public static function collectionGroupName($project, $database, $collection)
    {
        return self::getCollectionGroupNameTemplate()->render([
            'project' => $project,
            'database' => $database,
            'collection' => $collection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a database
     * resource.
     *
     * @param string $project
     * @param string $database
     *
     * @return string The formatted database resource.
     */
    public static function databaseName($project, $database)
    {
        return self::getDatabaseNameTemplate()->render([
            'project' => $project,
            'database' => $database,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a field
     * resource.
     *
     * @param string $project
     * @param string $database
     * @param string $collection
     * @param string $field
     *
     * @return string The formatted field resource.
     */
    public static function fieldName($project, $database, $collection, $field)
    {
        return self::getFieldNameTemplate()->render([
            'project' => $project,
            'database' => $database,
            'collection' => $collection,
            'field' => $field,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a index
     * resource.
     *
     * @param string $project
     * @param string $database
     * @param string $collection
     * @param string $index
     *
     * @return string The formatted index resource.
     */
    public static function indexName($project, $database, $collection, $index)
    {
        return self::getIndexNameTemplate()->render([
            'project' => $project,
            'database' => $database,
            'collection' => $collection,
            'index' => $index,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a operation
     * resource.
     *
     * @param string $project
     * @param string $database
     * @param string $operation
     *
     * @return string The formatted operation resource.
     */
    public static function operationName($project, $database, $operation)
    {
        return self::getOperationNameTemplate()->render([
            'project' => $project,
            'database' => $database,
            'operation' => $operation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName($project)
    {
        return self::getProjectNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - backup: projects/{project}/locations/{location}/backups/{backup}
     * - backupSchedule: projects/{project}/databases/{database}/backupSchedules/{backup_schedule}
     * - collectionGroup: projects/{project}/databases/{database}/collectionGroups/{collection}
     * - database: projects/{project}/databases/{database}
     * - field: projects/{project}/databases/{database}/collectionGroups/{collection}/fields/{field}
     * - index: projects/{project}/databases/{database}/collectionGroups/{collection}/indexes/{index}
     * - location: projects/{project}/locations/{location}
     * - operation: projects/{project}/databases/{database}/operations/{operation}
     * - project: projects/{project}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'firestore.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Bulk deletes a subset of documents from Google Cloud Firestore.
     * Documents created or updated after the underlying system starts to process
     * the request will not be deleted. The bulk delete occurs in the background
     * and its progress can be monitored and managed via the Operation resource
     * that is created.
     *
     * For more details on bulk delete behavior, refer to:
     * https://cloud.google.com/firestore/docs/manage-data/bulk-delete
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedName = $firestoreAdminClient->databaseName('[PROJECT]', '[DATABASE]');
     *     $operationResponse = $firestoreAdminClient->bulkDeleteDocuments($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $firestoreAdminClient->bulkDeleteDocuments($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $firestoreAdminClient->resumeOperation($operationName, 'bulkDeleteDocuments');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Database to operate. Should be of the form:
     *                             `projects/{project_id}/databases/{database_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string[] $collectionIds
     *           Optional. IDs of the collection groups to delete. Unspecified means all
     *           collection groups.
     *
     *           Each collection group in this list must be unique.
     *     @type string[] $namespaceIds
     *           Optional. Namespaces to delete.
     *
     *           An empty list means all namespaces. This is the recommended
     *           usage for databases that don't use namespaces.
     *
     *           An empty string element represents the default namespace. This should be
     *           used if the database has data in non-default namespaces, but doesn't want
     *           to delete from them.
     *
     *           Each namespace in this list must be unique.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function bulkDeleteDocuments($name, array $optionalArgs = [])
    {
        $request = new BulkDeleteDocumentsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['collectionIds'])) {
            $request->setCollectionIds($optionalArgs['collectionIds']);
        }

        if (isset($optionalArgs['namespaceIds'])) {
            $request->setNamespaceIds($optionalArgs['namespaceIds']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('BulkDeleteDocuments', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a backup schedule on a database.
     * At most two backup schedules can be configured on a database, one daily
     * backup schedule and one weekly backup schedule.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedParent = $firestoreAdminClient->databaseName('[PROJECT]', '[DATABASE]');
     *     $backupSchedule = new BackupSchedule();
     *     $response = $firestoreAdminClient->createBackupSchedule($formattedParent, $backupSchedule);
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string         $parent         Required. The parent database.
     *
     *                                       Format `projects/{project}/databases/{database}`
     * @param BackupSchedule $backupSchedule Required. The backup schedule to create.
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Firestore\Admin\V1\BackupSchedule
     *
     * @throws ApiException if the remote call fails
     */
    public function createBackupSchedule($parent, $backupSchedule, array $optionalArgs = [])
    {
        $request = new CreateBackupScheduleRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setBackupSchedule($backupSchedule);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateBackupSchedule', BackupSchedule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Create a database.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedParent = $firestoreAdminClient->projectName('[PROJECT]');
     *     $database = new Database();
     *     $databaseId = 'database_id';
     *     $operationResponse = $firestoreAdminClient->createDatabase($formattedParent, $database, $databaseId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $firestoreAdminClient->createDatabase($formattedParent, $database, $databaseId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $firestoreAdminClient->resumeOperation($operationName, 'createDatabase');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. A parent name of the form
     *                               `projects/{project_id}`
     * @param Database $database     Required. The Database to create.
     * @param string   $databaseId   Required. The ID to use for the database, which will become the final
     *                               component of the database's resource name.
     *
     *                               This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
     *                               with first character a letter and the last a letter or a number. Must not
     *                               be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
     *
     *                               "(default)" database ID is also valid.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createDatabase($parent, $database, $databaseId, array $optionalArgs = [])
    {
        $request = new CreateDatabaseRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDatabase($database);
        $request->setDatabaseId($databaseId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateDatabase', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a composite index. This returns a
     * [google.longrunning.Operation][google.longrunning.Operation] which may be
     * used to track the status of the creation. The metadata for the operation
     * will be the type
     * [IndexOperationMetadata][google.firestore.admin.v1.IndexOperationMetadata].
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedParent = $firestoreAdminClient->collectionGroupName('[PROJECT]', '[DATABASE]', '[COLLECTION]');
     *     $index = new Index();
     *     $operationResponse = $firestoreAdminClient->createIndexLRO($formattedParent, $index);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $firestoreAdminClient->createIndexLRO($formattedParent, $index);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $firestoreAdminClient->resumeOperation($operationName, 'createIndex');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. A parent name of the form
     *                             `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
     * @param Index  $index        Required. The composite index to create.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createIndexLRO($parent, $index, array $optionalArgs = [])
    {
        $request = new CreateIndexRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setIndex($index);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateIndex', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a backup.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedName = $firestoreAdminClient->backupName('[PROJECT]', '[LOCATION]', '[BACKUP]');
     *     $firestoreAdminClient->deleteBackup($formattedName);
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the backup to delete.
     *
     *                             format is `projects/{project}/locations/{location}/backups/{backup}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteBackup($name, array $optionalArgs = [])
    {
        $request = new DeleteBackupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteBackup', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a backup schedule.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedName = $firestoreAdminClient->backupScheduleName('[PROJECT]', '[DATABASE]', '[BACKUP_SCHEDULE]');
     *     $firestoreAdminClient->deleteBackupSchedule($formattedName);
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the backup schedule.
     *
     *                             Format
     *                             `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteBackupSchedule($name, array $optionalArgs = [])
    {
        $request = new DeleteBackupScheduleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteBackupSchedule', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a database.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedName = $firestoreAdminClient->databaseName('[PROJECT]', '[DATABASE]');
     *     $operationResponse = $firestoreAdminClient->deleteDatabase($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $firestoreAdminClient->deleteDatabase($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $firestoreAdminClient->resumeOperation($operationName, 'deleteDatabase');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the form
     *                             `projects/{project_id}/databases/{database_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           The current etag of the Database.
     *           If an etag is provided and does not match the current etag of the database,
     *           deletion will be blocked and a FAILED_PRECONDITION error will be returned.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteDatabase($name, array $optionalArgs = [])
    {
        $request = new DeleteDatabaseRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteDatabase', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a composite index.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedName = $firestoreAdminClient->indexName('[PROJECT]', '[DATABASE]', '[COLLECTION]', '[INDEX]');
     *     $firestoreAdminClient->deleteIndex($formattedName);
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the form
     *                             `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteIndex($name, array $optionalArgs = [])
    {
        $request = new DeleteIndexRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteIndex', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Exports a copy of all or a subset of documents from Google Cloud Firestore
     * to another storage system, such as Google Cloud Storage. Recent updates to
     * documents may not be reflected in the export. The export occurs in the
     * background and its progress can be monitored and managed via the
     * Operation resource that is created. The output of an export may only be
     * used once the associated operation is done. If an export operation is
     * cancelled before completion it may leave partial data behind in Google
     * Cloud Storage.
     *
     * For more details on export behavior and output format, refer to:
     * https://cloud.google.com/firestore/docs/manage-data/export-import
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedName = $firestoreAdminClient->databaseName('[PROJECT]', '[DATABASE]');
     *     $operationResponse = $firestoreAdminClient->exportDocumentsLRO($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $firestoreAdminClient->exportDocumentsLRO($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $firestoreAdminClient->resumeOperation($operationName, 'exportDocuments');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Database to export. Should be of the form:
     *                             `projects/{project_id}/databases/{database_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string[] $collectionIds
     *           Which collection IDs to export. Unspecified means all collections. Each
     *           collection ID in this list must be unique.
     *     @type string $outputUriPrefix
     *           The output URI. Currently only supports Google Cloud Storage URIs of the
     *           form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
     *           of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
     *           Google Cloud Storage namespace path. When
     *           choosing a name, be sure to consider Google Cloud Storage naming
     *           guidelines: https://cloud.google.com/storage/docs/naming.
     *           If the URI is a bucket (without a namespace path), a prefix will be
     *           generated based on the start time.
     *     @type string[] $namespaceIds
     *           An empty list represents all namespaces. This is the preferred
     *           usage for databases that don't use namespaces.
     *
     *           An empty string element represents the default namespace. This should be
     *           used if the database has data in non-default namespaces, but doesn't want
     *           to include them. Each namespace in this list must be unique.
     *     @type Timestamp $snapshotTime
     *           The timestamp that corresponds to the version of the database to be
     *           exported. The timestamp must be in the past, rounded to the minute and not
     *           older than
     *           [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
     *           If specified, then the exported documents will represent a consistent view
     *           of the database at the provided time. Otherwise, there are no guarantees
     *           about the consistency of the exported documents.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function exportDocumentsLRO($name, array $optionalArgs = [])
    {
        $request = new ExportDocumentsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['collectionIds'])) {
            $request->setCollectionIds($optionalArgs['collectionIds']);
        }

        if (isset($optionalArgs['outputUriPrefix'])) {
            $request->setOutputUriPrefix($optionalArgs['outputUriPrefix']);
        }

        if (isset($optionalArgs['namespaceIds'])) {
            $request->setNamespaceIds($optionalArgs['namespaceIds']);
        }

        if (isset($optionalArgs['snapshotTime'])) {
            $request->setSnapshotTime($optionalArgs['snapshotTime']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('ExportDocuments', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Gets information about a backup.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedName = $firestoreAdminClient->backupName('[PROJECT]', '[LOCATION]', '[BACKUP]');
     *     $response = $firestoreAdminClient->getBackup($formattedName);
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Name of the backup to fetch.
     *
     *                             Format is `projects/{project}/locations/{location}/backups/{backup}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Firestore\Admin\V1\Backup
     *
     * @throws ApiException if the remote call fails
     */
    public function getBackup($name, array $optionalArgs = [])
    {
        $request = new GetBackupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetBackup', Backup::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets information about a backup schedule.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedName = $firestoreAdminClient->backupScheduleName('[PROJECT]', '[DATABASE]', '[BACKUP_SCHEDULE]');
     *     $response = $firestoreAdminClient->getBackupSchedule($formattedName);
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the backup schedule.
     *
     *                             Format
     *                             `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Firestore\Admin\V1\BackupSchedule
     *
     * @throws ApiException if the remote call fails
     */
    public function getBackupSchedule($name, array $optionalArgs = [])
    {
        $request = new GetBackupScheduleRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetBackupSchedule', BackupSchedule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets information about a database.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedName = $firestoreAdminClient->databaseName('[PROJECT]', '[DATABASE]');
     *     $response = $firestoreAdminClient->getDatabase($formattedName);
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the form
     *                             `projects/{project_id}/databases/{database_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Firestore\Admin\V1\Database
     *
     * @throws ApiException if the remote call fails
     */
    public function getDatabase($name, array $optionalArgs = [])
    {
        $request = new GetDatabaseRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetDatabase', Database::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the metadata and configuration for a Field.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedName = $firestoreAdminClient->fieldName('[PROJECT]', '[DATABASE]', '[COLLECTION]', '[FIELD]');
     *     $response = $firestoreAdminClient->getField($formattedName);
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the form
     *                             `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/fields/{field_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Firestore\Admin\V1\Field
     *
     * @throws ApiException if the remote call fails
     */
    public function getField($name, array $optionalArgs = [])
    {
        $request = new GetFieldRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetField', Field::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets a composite index.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedName = $firestoreAdminClient->indexName('[PROJECT]', '[DATABASE]', '[COLLECTION]', '[INDEX]');
     *     $response = $firestoreAdminClient->getIndex($formattedName);
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the form
     *                             `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Firestore\Admin\V1\Index
     *
     * @throws ApiException if the remote call fails
     */
    public function getIndex($name, array $optionalArgs = [])
    {
        $request = new GetIndexRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetIndex', Index::class, $optionalArgs, $request)->wait();
    }

    /**
     * Imports documents into Google Cloud Firestore. Existing documents with the
     * same name are overwritten. The import occurs in the background and its
     * progress can be monitored and managed via the Operation resource that is
     * created. If an ImportDocuments operation is cancelled, it is possible
     * that a subset of the data has already been imported to Cloud Firestore.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedName = $firestoreAdminClient->databaseName('[PROJECT]', '[DATABASE]');
     *     $operationResponse = $firestoreAdminClient->importDocumentsLRO($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $firestoreAdminClient->importDocumentsLRO($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $firestoreAdminClient->resumeOperation($operationName, 'importDocuments');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Database to import into. Should be of the form:
     *                             `projects/{project_id}/databases/{database_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string[] $collectionIds
     *           Which collection IDs to import. Unspecified means all collections included
     *           in the import. Each collection ID in this list must be unique.
     *     @type string $inputUriPrefix
     *           Location of the exported files.
     *           This must match the output_uri_prefix of an ExportDocumentsResponse from
     *           an export that has completed successfully.
     *           See:
     *           [google.firestore.admin.v1.ExportDocumentsResponse.output_uri_prefix][google.firestore.admin.v1.ExportDocumentsResponse.output_uri_prefix].
     *     @type string[] $namespaceIds
     *           An empty list represents all namespaces. This is the preferred
     *           usage for databases that don't use namespaces.
     *
     *           An empty string element represents the default namespace. This should be
     *           used if the database has data in non-default namespaces, but doesn't want
     *           to include them. Each namespace in this list must be unique.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function importDocumentsLRO($name, array $optionalArgs = [])
    {
        $request = new ImportDocumentsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['collectionIds'])) {
            $request->setCollectionIds($optionalArgs['collectionIds']);
        }

        if (isset($optionalArgs['inputUriPrefix'])) {
            $request->setInputUriPrefix($optionalArgs['inputUriPrefix']);
        }

        if (isset($optionalArgs['namespaceIds'])) {
            $request->setNamespaceIds($optionalArgs['namespaceIds']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('ImportDocuments', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * List backup schedules.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedParent = $firestoreAdminClient->databaseName('[PROJECT]', '[DATABASE]');
     *     $response = $firestoreAdminClient->listBackupSchedules($formattedParent);
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent database.
     *
     *                             Format is `projects/{project}/databases/{database}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Firestore\Admin\V1\ListBackupSchedulesResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listBackupSchedules($parent, array $optionalArgs = [])
    {
        $request = new ListBackupSchedulesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ListBackupSchedules', ListBackupSchedulesResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists all the backups.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedParent = $firestoreAdminClient->locationName('[PROJECT]', '[LOCATION]');
     *     $response = $firestoreAdminClient->listBackups($formattedParent);
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The location to list backups from.
     *
     *                             Format is `projects/{project}/locations/{location}`.
     *                             Use `{location} = '-'` to list backups from all locations for the given
     *                             project. This allows listing backups from a single location or from all
     *                             locations.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           An expression that filters the list of returned backups.
     *
     *           A filter expression consists of a field name, a comparison operator, and a
     *           value for filtering.
     *           The value must be a string, a number, or a boolean. The comparison operator
     *           must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
     *           Colon `:` is the contains operator. Filter rules are not case sensitive.
     *
     *           The following fields in the [Backup][google.firestore.admin.v1.Backup] are
     *           eligible for filtering:
     *
     *           * `database_uid` (supports `=` only)
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Firestore\Admin\V1\ListBackupsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listBackups($parent, array $optionalArgs = [])
    {
        $request = new ListBackupsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ListBackups', ListBackupsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * List all the databases in the project.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedParent = $firestoreAdminClient->projectName('[PROJECT]');
     *     $response = $firestoreAdminClient->listDatabases($formattedParent);
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. A parent name of the form
     *                             `projects/{project_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $showDeleted
     *           If true, also returns deleted resources.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Firestore\Admin\V1\ListDatabasesResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDatabases($parent, array $optionalArgs = [])
    {
        $request = new ListDatabasesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['showDeleted'])) {
            $request->setShowDeleted($optionalArgs['showDeleted']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ListDatabases', ListDatabasesResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists the field configuration and metadata for this database.
     *
     * Currently,
     * [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields]
     * only supports listing fields that have been explicitly overridden. To issue
     * this query, call
     * [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields]
     * with the filter set to `indexConfig.usesAncestorConfig:false` or
     * `ttlConfig:*`.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedParent = $firestoreAdminClient->collectionGroupName('[PROJECT]', '[DATABASE]', '[COLLECTION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $firestoreAdminClient->listFields($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $firestoreAdminClient->listFields($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. A parent name of the form
     *                             `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           The filter to apply to list results. Currently,
     *           [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields]
     *           only supports listing fields that have been explicitly overridden. To issue
     *           this query, call
     *           [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields]
     *           with a filter that includes `indexConfig.usesAncestorConfig:false` or
     *           `ttlConfig:*`.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listFields($parent, array $optionalArgs = [])
    {
        $request = new ListFieldsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListFields', $optionalArgs, ListFieldsResponse::class, $request);
    }

    /**
     * Lists composite indexes.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedParent = $firestoreAdminClient->collectionGroupName('[PROJECT]', '[DATABASE]', '[COLLECTION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $firestoreAdminClient->listIndexes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $firestoreAdminClient->listIndexes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. A parent name of the form
     *                             `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           The filter to apply to list results.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listIndexes($parent, array $optionalArgs = [])
    {
        $request = new ListIndexesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListIndexes', $optionalArgs, ListIndexesResponse::class, $request);
    }

    /**
     * Creates a new database by restoring from an existing backup.
     *
     * The new database must be in the same cloud region or multi-region location
     * as the existing backup. This behaves similar to
     * [FirestoreAdmin.CreateDatabase][google.firestore.admin.v1.FirestoreAdmin.CreateDatabase]
     * except instead of creating a new empty database, a new database is created
     * with the database type, index configuration, and documents from an existing
     * backup.
     *
     * The [long-running operation][google.longrunning.Operation] can be used to
     * track the progress of the restore, with the Operation's
     * [metadata][google.longrunning.Operation.metadata] field type being the
     * [RestoreDatabaseMetadata][google.firestore.admin.v1.RestoreDatabaseMetadata].
     * The [response][google.longrunning.Operation.response] type is the
     * [Database][google.firestore.admin.v1.Database] if the restore was
     * successful. The new database is not readable or writeable until the LRO has
     * completed.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $formattedParent = $firestoreAdminClient->projectName('[PROJECT]');
     *     $databaseId = 'database_id';
     *     $formattedBackup = $firestoreAdminClient->backupName('[PROJECT]', '[LOCATION]', '[BACKUP]');
     *     $operationResponse = $firestoreAdminClient->restoreDatabase($formattedParent, $databaseId, $formattedBackup);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $firestoreAdminClient->restoreDatabase($formattedParent, $databaseId, $formattedBackup);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $firestoreAdminClient->resumeOperation($operationName, 'restoreDatabase');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project to restore the database in. Format is
     *                             `projects/{project_id}`.
     * @param string $databaseId   Required. The ID to use for the database, which will become the final
     *                             component of the database's resource name. This database ID must not be
     *                             associated with an existing database.
     *
     *                             This value should be 4-63 characters. Valid characters are /[a-z][0-9]-/
     *                             with first character a letter and the last a letter or a number. Must not
     *                             be UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
     *
     *                             "(default)" database ID is also valid.
     * @param string $backup       Required. Backup to restore from. Must be from the same project as the
     *                             parent.
     *
     *                             The restored database will be created in the same location as the source
     *                             backup.
     *
     *                             Format is: `projects/{project_id}/locations/{location}/backups/{backup}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type EncryptionConfig $encryptionConfig
     *           Optional. Encryption configuration for the restored database.
     *
     *           If this field is not specified, the restored database will use
     *           the same encryption configuration as the backup, namely
     *           [use_source_encryption][google.firestore.admin.v1.Database.EncryptionConfig.use_source_encryption].
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function restoreDatabase($parent, $databaseId, $backup, array $optionalArgs = [])
    {
        $request = new RestoreDatabaseRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDatabaseId($databaseId);
        $request->setBackup($backup);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['encryptionConfig'])) {
            $request->setEncryptionConfig($optionalArgs['encryptionConfig']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('RestoreDatabase', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates a backup schedule.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $backupSchedule = new BackupSchedule();
     *     $response = $firestoreAdminClient->updateBackupSchedule($backupSchedule);
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param BackupSchedule $backupSchedule Required. The backup schedule to update.
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Firestore\Admin\V1\BackupSchedule
     *
     * @throws ApiException if the remote call fails
     */
    public function updateBackupSchedule($backupSchedule, array $optionalArgs = [])
    {
        $request = new UpdateBackupScheduleRequest();
        $requestParamHeaders = [];
        $request->setBackupSchedule($backupSchedule);
        $requestParamHeaders['backup_schedule.name'] = $backupSchedule->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateBackupSchedule', BackupSchedule::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a database.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $database = new Database();
     *     $operationResponse = $firestoreAdminClient->updateDatabase($database);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $firestoreAdminClient->updateDatabase($database);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $firestoreAdminClient->resumeOperation($operationName, 'updateDatabase');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param Database $database     Required. The database to update.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateDatabase($database, array $optionalArgs = [])
    {
        $request = new UpdateDatabaseRequest();
        $requestParamHeaders = [];
        $request->setDatabase($database);
        $requestParamHeaders['database.name'] = $database->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateDatabase', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates a field configuration. Currently, field updates apply only to
     * single field index configuration. However, calls to
     * [FirestoreAdmin.UpdateField][google.firestore.admin.v1.FirestoreAdmin.UpdateField]
     * should provide a field mask to avoid changing any configuration that the
     * caller isn't aware of. The field mask should be specified as: `{ paths:
     * "index_config" }`.
     *
     * This call returns a
     * [google.longrunning.Operation][google.longrunning.Operation] which may be
     * used to track the status of the field update. The metadata for the
     * operation will be the type
     * [FieldOperationMetadata][google.firestore.admin.v1.FieldOperationMetadata].
     *
     * To configure the default field settings for the database, use
     * the special `Field` with resource name:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/__default__/fields/*`.
     *
     * Sample code:
     * ```
     * $firestoreAdminClient = new FirestoreAdminClient();
     * try {
     *     $field = new Field();
     *     $operationResponse = $firestoreAdminClient->updateFieldLRO($field);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $firestoreAdminClient->updateFieldLRO($field);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $firestoreAdminClient->resumeOperation($operationName, 'updateField');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $firestoreAdminClient->close();
     * }
     * ```
     *
     * @param Field $field        Required. The field to be updated.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           A mask, relative to the field. If specified, only configuration specified
     *           by this field_mask will be updated in the field.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateFieldLRO($field, array $optionalArgs = [])
    {
        $request = new UpdateFieldRequest();
        $requestParamHeaders = [];
        $request->setField($field);
        $requestParamHeaders['field.name'] = $field->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateField', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }
}
