<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/notebook_execution_job.proto

namespace Google\Cloud\AIPlatform\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * NotebookExecutionJob represents an instance of a notebook execution.
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.NotebookExecutionJob</code>
 */
class NotebookExecutionJob extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of this NotebookExecutionJob. Format:
     * `projects/{project_id}/locations/{location}/notebookExecutionJobs/{job_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * The display name of the NotebookExecutionJob. The name can be up to 128
     * characters long and can consist of any UTF-8 characters.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     */
    protected $display_name = '';
    /**
     * Max running time of the execution job in seconds (default 86400s / 24 hrs).
     *
     * Generated from protobuf field <code>.google.protobuf.Duration execution_timeout = 5;</code>
     */
    protected $execution_timeout = null;
    /**
     * Output only. The Schedule resource name if this job is triggered by one.
     * Format:
     * `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
     *
     * Generated from protobuf field <code>string schedule_resource_name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $schedule_resource_name = '';
    /**
     * Output only. The state of the NotebookExecutionJob.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.JobState job_state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $job_state = 0;
    /**
     * Output only. Populated when the NotebookExecutionJob is completed. When
     * there is an error during notebook execution, the error details are
     * populated.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $status = null;
    /**
     * Output only. Timestamp when this NotebookExecutionJob was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Timestamp when this NotebookExecutionJob was most recently
     * updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * The labels with user-defined metadata to organize NotebookExecutionJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     *
     * Generated from protobuf field <code>map<string, string> labels = 19;</code>
     */
    private $labels;
    /**
     * The name of the kernel to use during notebook execution. If unset, the
     * default kernel is used.
     *
     * Generated from protobuf field <code>string kernel_name = 20;</code>
     */
    protected $kernel_name = '';
    /**
     * Customer-managed encryption key spec for the notebook execution job.
     * This field is auto-populated if the
     * [NotebookRuntimeTemplate][google.cloud.aiplatform.v1.NotebookRuntimeTemplate]
     * has an encryption spec.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 22;</code>
     */
    protected $encryption_spec = null;
    protected $notebook_source;
    protected $environment_spec;
    protected $execution_sink;
    protected $execution_identity;
    protected $runtime_environment;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\DataformRepositorySource $dataform_repository_source
     *           The Dataform Repository pointing to a single file notebook repository.
     *     @type \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\GcsNotebookSource $gcs_notebook_source
     *           The Cloud Storage url pointing to the ipynb file. Format:
     *           `gs://bucket/notebook_file.ipynb`
     *     @type \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\DirectNotebookSource $direct_notebook_source
     *           The contents of an input notebook file.
     *     @type string $notebook_runtime_template_resource_name
     *           The NotebookRuntimeTemplate to source compute configuration from.
     *     @type \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\CustomEnvironmentSpec $custom_environment_spec
     *           The custom compute configuration for an execution job.
     *     @type string $gcs_output_uri
     *           The Cloud Storage location to upload the result to. Format:
     *           `gs://bucket-name`
     *     @type string $execution_user
     *           The user email to run the execution as. Only supported by Colab runtimes.
     *     @type string $service_account
     *           The service account to run the execution as.
     *     @type \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\WorkbenchRuntime $workbench_runtime
     *           The Workbench runtime configuration to use for the notebook execution.
     *     @type string $name
     *           Output only. The resource name of this NotebookExecutionJob. Format:
     *           `projects/{project_id}/locations/{location}/notebookExecutionJobs/{job_id}`
     *     @type string $display_name
     *           The display name of the NotebookExecutionJob. The name can be up to 128
     *           characters long and can consist of any UTF-8 characters.
     *     @type \Google\Protobuf\Duration $execution_timeout
     *           Max running time of the execution job in seconds (default 86400s / 24 hrs).
     *     @type string $schedule_resource_name
     *           Output only. The Schedule resource name if this job is triggered by one.
     *           Format:
     *           `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
     *     @type int $job_state
     *           Output only. The state of the NotebookExecutionJob.
     *     @type \Google\Rpc\Status $status
     *           Output only. Populated when the NotebookExecutionJob is completed. When
     *           there is an error during notebook execution, the error details are
     *           populated.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Timestamp when this NotebookExecutionJob was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Timestamp when this NotebookExecutionJob was most recently
     *           updated.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           The labels with user-defined metadata to organize NotebookExecutionJobs.
     *           Label keys and values can be no longer than 64 characters
     *           (Unicode codepoints), can only contain lowercase letters, numeric
     *           characters, underscores and dashes. International characters are allowed.
     *           See https://goo.gl/xmQnxf for more information and examples of labels.
     *           System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     *           and are immutable.
     *     @type string $kernel_name
     *           The name of the kernel to use during notebook execution. If unset, the
     *           default kernel is used.
     *     @type \Google\Cloud\AIPlatform\V1\EncryptionSpec $encryption_spec
     *           Customer-managed encryption key spec for the notebook execution job.
     *           This field is auto-populated if the
     *           [NotebookRuntimeTemplate][google.cloud.aiplatform.v1.NotebookRuntimeTemplate]
     *           has an encryption spec.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\NotebookExecutionJob::initOnce();
        parent::__construct($data);
    }

    /**
     * The Dataform Repository pointing to a single file notebook repository.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;</code>
     * @return \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\DataformRepositorySource|null
     */
    public function getDataformRepositorySource()
    {
        return $this->readOneof(3);
    }

    public function hasDataformRepositorySource()
    {
        return $this->hasOneof(3);
    }

    /**
     * The Dataform Repository pointing to a single file notebook repository.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.NotebookExecutionJob.DataformRepositorySource dataform_repository_source = 3;</code>
     * @param \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\DataformRepositorySource $var
     * @return $this
     */
    public function setDataformRepositorySource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\DataformRepositorySource::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * The Cloud Storage url pointing to the ipynb file. Format:
     * `gs://bucket/notebook_file.ipynb`
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;</code>
     * @return \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\GcsNotebookSource|null
     */
    public function getGcsNotebookSource()
    {
        return $this->readOneof(4);
    }

    public function hasGcsNotebookSource()
    {
        return $this->hasOneof(4);
    }

    /**
     * The Cloud Storage url pointing to the ipynb file. Format:
     * `gs://bucket/notebook_file.ipynb`
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.NotebookExecutionJob.GcsNotebookSource gcs_notebook_source = 4;</code>
     * @param \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\GcsNotebookSource $var
     * @return $this
     */
    public function setGcsNotebookSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\GcsNotebookSource::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * The contents of an input notebook file.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;</code>
     * @return \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\DirectNotebookSource|null
     */
    public function getDirectNotebookSource()
    {
        return $this->readOneof(17);
    }

    public function hasDirectNotebookSource()
    {
        return $this->hasOneof(17);
    }

    /**
     * The contents of an input notebook file.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.NotebookExecutionJob.DirectNotebookSource direct_notebook_source = 17;</code>
     * @param \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\DirectNotebookSource $var
     * @return $this
     */
    public function setDirectNotebookSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\DirectNotebookSource::class);
        $this->writeOneof(17, $var);

        return $this;
    }

    /**
     * The NotebookRuntimeTemplate to source compute configuration from.
     *
     * Generated from protobuf field <code>string notebook_runtime_template_resource_name = 14 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getNotebookRuntimeTemplateResourceName()
    {
        return $this->readOneof(14);
    }

    public function hasNotebookRuntimeTemplateResourceName()
    {
        return $this->hasOneof(14);
    }

    /**
     * The NotebookRuntimeTemplate to source compute configuration from.
     *
     * Generated from protobuf field <code>string notebook_runtime_template_resource_name = 14 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setNotebookRuntimeTemplateResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(14, $var);

        return $this;
    }

    /**
     * The custom compute configuration for an execution job.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.NotebookExecutionJob.CustomEnvironmentSpec custom_environment_spec = 16;</code>
     * @return \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\CustomEnvironmentSpec|null
     */
    public function getCustomEnvironmentSpec()
    {
        return $this->readOneof(16);
    }

    public function hasCustomEnvironmentSpec()
    {
        return $this->hasOneof(16);
    }

    /**
     * The custom compute configuration for an execution job.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.NotebookExecutionJob.CustomEnvironmentSpec custom_environment_spec = 16;</code>
     * @param \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\CustomEnvironmentSpec $var
     * @return $this
     */
    public function setCustomEnvironmentSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\CustomEnvironmentSpec::class);
        $this->writeOneof(16, $var);

        return $this;
    }

    /**
     * The Cloud Storage location to upload the result to. Format:
     * `gs://bucket-name`
     *
     * Generated from protobuf field <code>string gcs_output_uri = 8;</code>
     * @return string
     */
    public function getGcsOutputUri()
    {
        return $this->readOneof(8);
    }

    public function hasGcsOutputUri()
    {
        return $this->hasOneof(8);
    }

    /**
     * The Cloud Storage location to upload the result to. Format:
     * `gs://bucket-name`
     *
     * Generated from protobuf field <code>string gcs_output_uri = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setGcsOutputUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * The user email to run the execution as. Only supported by Colab runtimes.
     *
     * Generated from protobuf field <code>string execution_user = 9;</code>
     * @return string
     */
    public function getExecutionUser()
    {
        return $this->readOneof(9);
    }

    public function hasExecutionUser()
    {
        return $this->hasOneof(9);
    }

    /**
     * The user email to run the execution as. Only supported by Colab runtimes.
     *
     * Generated from protobuf field <code>string execution_user = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setExecutionUser($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(9, $var);

        return $this;
    }

    /**
     * The service account to run the execution as.
     *
     * Generated from protobuf field <code>string service_account = 18;</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->readOneof(18);
    }

    public function hasServiceAccount()
    {
        return $this->hasOneof(18);
    }

    /**
     * The service account to run the execution as.
     *
     * Generated from protobuf field <code>string service_account = 18;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(18, $var);

        return $this;
    }

    /**
     * The Workbench runtime configuration to use for the notebook execution.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.NotebookExecutionJob.WorkbenchRuntime workbench_runtime = 23;</code>
     * @return \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\WorkbenchRuntime|null
     */
    public function getWorkbenchRuntime()
    {
        return $this->readOneof(23);
    }

    public function hasWorkbenchRuntime()
    {
        return $this->hasOneof(23);
    }

    /**
     * The Workbench runtime configuration to use for the notebook execution.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.NotebookExecutionJob.WorkbenchRuntime workbench_runtime = 23;</code>
     * @param \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\WorkbenchRuntime $var
     * @return $this
     */
    public function setWorkbenchRuntime($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\NotebookExecutionJob\WorkbenchRuntime::class);
        $this->writeOneof(23, $var);

        return $this;
    }

    /**
     * Output only. The resource name of this NotebookExecutionJob. Format:
     * `projects/{project_id}/locations/{location}/notebookExecutionJobs/{job_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The resource name of this NotebookExecutionJob. Format:
     * `projects/{project_id}/locations/{location}/notebookExecutionJobs/{job_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The display name of the NotebookExecutionJob. The name can be up to 128
     * characters long and can consist of any UTF-8 characters.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * The display name of the NotebookExecutionJob. The name can be up to 128
     * characters long and can consist of any UTF-8 characters.
     *
     * Generated from protobuf field <code>string display_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Max running time of the execution job in seconds (default 86400s / 24 hrs).
     *
     * Generated from protobuf field <code>.google.protobuf.Duration execution_timeout = 5;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getExecutionTimeout()
    {
        return $this->execution_timeout;
    }

    public function hasExecutionTimeout()
    {
        return isset($this->execution_timeout);
    }

    public function clearExecutionTimeout()
    {
        unset($this->execution_timeout);
    }

    /**
     * Max running time of the execution job in seconds (default 86400s / 24 hrs).
     *
     * Generated from protobuf field <code>.google.protobuf.Duration execution_timeout = 5;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setExecutionTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->execution_timeout = $var;

        return $this;
    }

    /**
     * Output only. The Schedule resource name if this job is triggered by one.
     * Format:
     * `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
     *
     * Generated from protobuf field <code>string schedule_resource_name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getScheduleResourceName()
    {
        return $this->schedule_resource_name;
    }

    /**
     * Output only. The Schedule resource name if this job is triggered by one.
     * Format:
     * `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
     *
     * Generated from protobuf field <code>string schedule_resource_name = 6 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setScheduleResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->schedule_resource_name = $var;

        return $this;
    }

    /**
     * Output only. The state of the NotebookExecutionJob.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.JobState job_state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getJobState()
    {
        return $this->job_state;
    }

    /**
     * Output only. The state of the NotebookExecutionJob.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.JobState job_state = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setJobState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AIPlatform\V1\JobState::class);
        $this->job_state = $var;

        return $this;
    }

    /**
     * Output only. Populated when the NotebookExecutionJob is completed. When
     * there is an error during notebook execution, the error details are
     * populated.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Rpc\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }

    public function hasStatus()
    {
        return isset($this->status);
    }

    public function clearStatus()
    {
        unset($this->status);
    }

    /**
     * Output only. Populated when the NotebookExecutionJob is completed. When
     * there is an error during notebook execution, the error details are
     * populated.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->status = $var;

        return $this;
    }

    /**
     * Output only. Timestamp when this NotebookExecutionJob was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Timestamp when this NotebookExecutionJob was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Timestamp when this NotebookExecutionJob was most recently
     * updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Timestamp when this NotebookExecutionJob was most recently
     * updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * The labels with user-defined metadata to organize NotebookExecutionJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     *
     * Generated from protobuf field <code>map<string, string> labels = 19;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * The labels with user-defined metadata to organize NotebookExecutionJobs.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * System reserved label keys are prefixed with "aiplatform.googleapis.com/"
     * and are immutable.
     *
     * Generated from protobuf field <code>map<string, string> labels = 19;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * The name of the kernel to use during notebook execution. If unset, the
     * default kernel is used.
     *
     * Generated from protobuf field <code>string kernel_name = 20;</code>
     * @return string
     */
    public function getKernelName()
    {
        return $this->kernel_name;
    }

    /**
     * The name of the kernel to use during notebook execution. If unset, the
     * default kernel is used.
     *
     * Generated from protobuf field <code>string kernel_name = 20;</code>
     * @param string $var
     * @return $this
     */
    public function setKernelName($var)
    {
        GPBUtil::checkString($var, True);
        $this->kernel_name = $var;

        return $this;
    }

    /**
     * Customer-managed encryption key spec for the notebook execution job.
     * This field is auto-populated if the
     * [NotebookRuntimeTemplate][google.cloud.aiplatform.v1.NotebookRuntimeTemplate]
     * has an encryption spec.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 22;</code>
     * @return \Google\Cloud\AIPlatform\V1\EncryptionSpec|null
     */
    public function getEncryptionSpec()
    {
        return $this->encryption_spec;
    }

    public function hasEncryptionSpec()
    {
        return isset($this->encryption_spec);
    }

    public function clearEncryptionSpec()
    {
        unset($this->encryption_spec);
    }

    /**
     * Customer-managed encryption key spec for the notebook execution job.
     * This field is auto-populated if the
     * [NotebookRuntimeTemplate][google.cloud.aiplatform.v1.NotebookRuntimeTemplate]
     * has an encryption spec.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 22;</code>
     * @param \Google\Cloud\AIPlatform\V1\EncryptionSpec $var
     * @return $this
     */
    public function setEncryptionSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\EncryptionSpec::class);
        $this->encryption_spec = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getNotebookSource()
    {
        return $this->whichOneof("notebook_source");
    }

    /**
     * @return string
     */
    public function getEnvironmentSpec()
    {
        return $this->whichOneof("environment_spec");
    }

    /**
     * @return string
     */
    public function getExecutionSink()
    {
        return $this->whichOneof("execution_sink");
    }

    /**
     * @return string
     */
    public function getExecutionIdentity()
    {
        return $this->whichOneof("execution_identity");
    }

    /**
     * @return string
     */
    public function getRuntimeEnvironment()
    {
        return $this->whichOneof("runtime_environment");
    }

}

