<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dataplex/v1/catalog.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dataplex\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dataplex\V1\AspectType;
use Google\Cloud\Dataplex\V1\CreateAspectTypeRequest;
use Google\Cloud\Dataplex\V1\CreateEntryGroupRequest;
use Google\Cloud\Dataplex\V1\CreateEntryRequest;
use Google\Cloud\Dataplex\V1\CreateEntryTypeRequest;
use Google\Cloud\Dataplex\V1\DeleteAspectTypeRequest;
use Google\Cloud\Dataplex\V1\DeleteEntryGroupRequest;
use Google\Cloud\Dataplex\V1\DeleteEntryRequest;
use Google\Cloud\Dataplex\V1\DeleteEntryTypeRequest;
use Google\Cloud\Dataplex\V1\Entry;
use Google\Cloud\Dataplex\V1\EntryGroup;
use Google\Cloud\Dataplex\V1\EntryType;
use Google\Cloud\Dataplex\V1\GetAspectTypeRequest;
use Google\Cloud\Dataplex\V1\GetEntryGroupRequest;
use Google\Cloud\Dataplex\V1\GetEntryRequest;
use Google\Cloud\Dataplex\V1\GetEntryTypeRequest;
use Google\Cloud\Dataplex\V1\ListAspectTypesRequest;
use Google\Cloud\Dataplex\V1\ListAspectTypesResponse;
use Google\Cloud\Dataplex\V1\ListEntriesRequest;
use Google\Cloud\Dataplex\V1\ListEntriesResponse;
use Google\Cloud\Dataplex\V1\ListEntryGroupsRequest;
use Google\Cloud\Dataplex\V1\ListEntryGroupsResponse;
use Google\Cloud\Dataplex\V1\ListEntryTypesRequest;
use Google\Cloud\Dataplex\V1\ListEntryTypesResponse;
use Google\Cloud\Dataplex\V1\LookupEntryRequest;
use Google\Cloud\Dataplex\V1\SearchEntriesRequest;
use Google\Cloud\Dataplex\V1\SearchEntriesResponse;
use Google\Cloud\Dataplex\V1\UpdateAspectTypeRequest;
use Google\Cloud\Dataplex\V1\UpdateEntryGroupRequest;
use Google\Cloud\Dataplex\V1\UpdateEntryRequest;
use Google\Cloud\Dataplex\V1\UpdateEntryTypeRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: The primary resources offered by this service are EntryGroups, EntryTypes,
 * AspectTypes, Entry and Aspect which collectively allow a data administrator
 * to organize, manage, secure and catalog data across their organization
 * located across cloud projects in a variety of storage systems including Cloud
 * Storage and BigQuery.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $catalogServiceClient = new CatalogServiceClient();
 * try {
 *     $formattedParent = $catalogServiceClient->locationName('[PROJECT]', '[LOCATION]');
 *     $aspectTypeId = 'aspect_type_id';
 *     $aspectType = new AspectType();
 *     $operationResponse = $catalogServiceClient->createAspectType($formattedParent, $aspectTypeId, $aspectType);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $catalogServiceClient->createAspectType($formattedParent, $aspectTypeId, $aspectType);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $catalogServiceClient->resumeOperation($operationName, 'createAspectType');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $catalogServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated Please use the new service client {@see \Google\Cloud\Dataplex\V1\Client\CatalogServiceClient}.
 */
class CatalogServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.dataplex.v1.CatalogService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'dataplex.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'dataplex.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $aspectTypeNameTemplate;

    private static $entryNameTemplate;

    private static $entryGroupNameTemplate;

    private static $entryTypeNameTemplate;

    private static $locationNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/catalog_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/catalog_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/catalog_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/catalog_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAspectTypeNameTemplate()
    {
        if (self::$aspectTypeNameTemplate == null) {
            self::$aspectTypeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/aspectTypes/{aspect_type}'
            );
        }

        return self::$aspectTypeNameTemplate;
    }

    private static function getEntryNameTemplate()
    {
        if (self::$entryNameTemplate == null) {
            self::$entryNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}'
            );
        }

        return self::$entryNameTemplate;
    }

    private static function getEntryGroupNameTemplate()
    {
        if (self::$entryGroupNameTemplate == null) {
            self::$entryGroupNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/entryGroups/{entry_group}'
            );
        }

        return self::$entryGroupNameTemplate;
    }

    private static function getEntryTypeNameTemplate()
    {
        if (self::$entryTypeNameTemplate == null) {
            self::$entryTypeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/entryTypes/{entry_type}'
            );
        }

        return self::$entryTypeNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'aspectType' => self::getAspectTypeNameTemplate(),
                'entry' => self::getEntryNameTemplate(),
                'entryGroup' => self::getEntryGroupNameTemplate(),
                'entryType' => self::getEntryTypeNameTemplate(),
                'location' => self::getLocationNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a aspect_type
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $aspectType
     *
     * @return string The formatted aspect_type resource.
     */
    public static function aspectTypeName($project, $location, $aspectType)
    {
        return self::getAspectTypeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'aspect_type' => $aspectType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entry
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entryGroup
     * @param string $entry
     *
     * @return string The formatted entry resource.
     */
    public static function entryName($project, $location, $entryGroup, $entry)
    {
        return self::getEntryNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'entry_group' => $entryGroup,
            'entry' => $entry,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entry_group
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entryGroup
     *
     * @return string The formatted entry_group resource.
     */
    public static function entryGroupName($project, $location, $entryGroup)
    {
        return self::getEntryGroupNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'entry_group' => $entryGroup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entry_type
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entryType
     *
     * @return string The formatted entry_type resource.
     */
    public static function entryTypeName($project, $location, $entryType)
    {
        return self::getEntryTypeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'entry_type' => $entryType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - aspectType: projects/{project}/locations/{location}/aspectTypes/{aspect_type}
     * - entry: projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}
     * - entryGroup: projects/{project}/locations/{location}/entryGroups/{entry_group}
     * - entryType: projects/{project}/locations/{location}/entryTypes/{entry_type}
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dataplex.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates an AspectType
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedParent = $catalogServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $aspectTypeId = 'aspect_type_id';
     *     $aspectType = new AspectType();
     *     $operationResponse = $catalogServiceClient->createAspectType($formattedParent, $aspectTypeId, $aspectType);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $catalogServiceClient->createAspectType($formattedParent, $aspectTypeId, $aspectType);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $catalogServiceClient->resumeOperation($operationName, 'createAspectType');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The resource name of the AspectType, of the form:
     *                                 projects/{project_number}/locations/{location_id}
     *                                 where `location_id` refers to a GCP region.
     * @param string     $aspectTypeId Required. AspectType identifier.
     * @param AspectType $aspectType   Required. AspectType Resource
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createAspectType(
        $parent,
        $aspectTypeId,
        $aspectType,
        array $optionalArgs = []
    ) {
        $request = new CreateAspectTypeRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAspectTypeId($aspectTypeId);
        $request->setAspectType($aspectType);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateAspectType',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates an Entry.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedParent = $catalogServiceClient->entryGroupName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]');
     *     $entryId = 'entry_id';
     *     $entry = new Entry();
     *     $response = $catalogServiceClient->createEntry($formattedParent, $entryId, $entry);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent Entry Group:
     *                             `projects/{project}/locations/{location}/entryGroups/{entry_group}`.
     * @param string $entryId      Required. Entry identifier. It has to be unique within an Entry Group.
     *
     *                             Entries corresponding to Google Cloud resources use Entry ID format based
     *                             on Full Resource Names
     *                             (https://cloud.google.com/apis/design/resource_names#full_resource_name).
     *                             The format is a Full Resource Name of the resource without the
     *                             prefix double slashes in the API Service Name part of Full Resource Name.
     *                             This allows retrieval of entries using their associated resource name.
     *
     *                             For example if the Full Resource Name of a resource is
     *                             `//library.googleapis.com/shelves/shelf1/books/book2`,
     *                             then the suggested entry_id is
     *                             `library.googleapis.com/shelves/shelf1/books/book2`.
     *
     *                             It is also suggested to follow the same convention for entries
     *                             corresponding to resources from other providers or systems than Google
     *                             Cloud.
     *
     *                             The maximum size of the field is 4000 characters.
     * @param Entry  $entry        Required. Entry resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\Entry
     *
     * @throws ApiException if the remote call fails
     */
    public function createEntry(
        $parent,
        $entryId,
        $entry,
        array $optionalArgs = []
    ) {
        $request = new CreateEntryRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEntryId($entryId);
        $request->setEntry($entry);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateEntry',
            Entry::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates an EntryGroup
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedParent = $catalogServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $entryGroupId = 'entry_group_id';
     *     $entryGroup = new EntryGroup();
     *     $operationResponse = $catalogServiceClient->createEntryGroup($formattedParent, $entryGroupId, $entryGroup);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $catalogServiceClient->createEntryGroup($formattedParent, $entryGroupId, $entryGroup);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $catalogServiceClient->resumeOperation($operationName, 'createEntryGroup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The resource name of the entryGroup, of the form:
     *                                 projects/{project_number}/locations/{location_id}
     *                                 where `location_id` refers to a GCP region.
     * @param string     $entryGroupId Required. EntryGroup identifier.
     * @param EntryGroup $entryGroup   Required. EntryGroup Resource
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createEntryGroup(
        $parent,
        $entryGroupId,
        $entryGroup,
        array $optionalArgs = []
    ) {
        $request = new CreateEntryGroupRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEntryGroupId($entryGroupId);
        $request->setEntryGroup($entryGroup);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateEntryGroup',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates an EntryType
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedParent = $catalogServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $entryTypeId = 'entry_type_id';
     *     $entryType = new EntryType();
     *     $operationResponse = $catalogServiceClient->createEntryType($formattedParent, $entryTypeId, $entryType);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $catalogServiceClient->createEntryType($formattedParent, $entryTypeId, $entryType);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $catalogServiceClient->resumeOperation($operationName, 'createEntryType');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string    $parent       Required. The resource name of the EntryType, of the form:
     *                                projects/{project_number}/locations/{location_id}
     *                                where `location_id` refers to a GCP region.
     * @param string    $entryTypeId  Required. EntryType identifier.
     * @param EntryType $entryType    Required. EntryType Resource
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createEntryType(
        $parent,
        $entryTypeId,
        $entryType,
        array $optionalArgs = []
    ) {
        $request = new CreateEntryTypeRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEntryTypeId($entryTypeId);
        $request->setEntryType($entryType);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateEntryType',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a AspectType resource.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedName = $catalogServiceClient->aspectTypeName('[PROJECT]', '[LOCATION]', '[ASPECT_TYPE]');
     *     $operationResponse = $catalogServiceClient->deleteAspectType($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $catalogServiceClient->deleteAspectType($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $catalogServiceClient->resumeOperation($operationName, 'deleteAspectType');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the AspectType:
     *                             `projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           Optional. If the client provided etag value does not match the current etag
     *           value, the DeleteAspectTypeRequest method returns an ABORTED error response
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAspectType($name, array $optionalArgs = [])
    {
        $request = new DeleteAspectTypeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteAspectType',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes an Entry.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedName = $catalogServiceClient->entryName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]', '[ENTRY]');
     *     $response = $catalogServiceClient->deleteEntry($formattedName);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the Entry:
     *                             `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\Entry
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteEntry($name, array $optionalArgs = [])
    {
        $request = new DeleteEntryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteEntry',
            Entry::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a EntryGroup resource.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedName = $catalogServiceClient->entryGroupName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]');
     *     $operationResponse = $catalogServiceClient->deleteEntryGroup($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $catalogServiceClient->deleteEntryGroup($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $catalogServiceClient->resumeOperation($operationName, 'deleteEntryGroup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the EntryGroup:
     *                             `projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           Optional. If the client provided etag value does not match the current etag
     *           value, the DeleteEntryGroupRequest method returns an ABORTED error response
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteEntryGroup($name, array $optionalArgs = [])
    {
        $request = new DeleteEntryGroupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteEntryGroup',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a EntryType resource.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedName = $catalogServiceClient->entryTypeName('[PROJECT]', '[LOCATION]', '[ENTRY_TYPE]');
     *     $operationResponse = $catalogServiceClient->deleteEntryType($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $catalogServiceClient->deleteEntryType($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $catalogServiceClient->resumeOperation($operationName, 'deleteEntryType');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the EntryType:
     *                             `projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           Optional. If the client provided etag value does not match the current etag
     *           value, the DeleteEntryTypeRequest method returns an ABORTED error response
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteEntryType($name, array $optionalArgs = [])
    {
        $request = new DeleteEntryTypeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteEntryType',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Retrieves a AspectType resource.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedName = $catalogServiceClient->aspectTypeName('[PROJECT]', '[LOCATION]', '[ASPECT_TYPE]');
     *     $response = $catalogServiceClient->getAspectType($formattedName);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the AspectType:
     *                             `projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\AspectType
     *
     * @throws ApiException if the remote call fails
     */
    public function getAspectType($name, array $optionalArgs = [])
    {
        $request = new GetAspectTypeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetAspectType',
            AspectType::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a single entry.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedName = $catalogServiceClient->entryName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]', '[ENTRY]');
     *     $response = $catalogServiceClient->getEntry($formattedName);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the Entry:
     *                             `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $view
     *           Optional. View for controlling which parts of an entry are to be returned.
     *           For allowed values, use constants defined on {@see \Google\Cloud\Dataplex\V1\EntryView}
     *     @type string[] $aspectTypes
     *           Optional. Limits the aspects returned to the provided aspect types.
     *           Only works if the CUSTOM view is selected.
     *     @type string[] $paths
     *           Optional. Limits the aspects returned to those associated with the provided
     *           paths within the Entry. Only works if the CUSTOM view is selected.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\Entry
     *
     * @throws ApiException if the remote call fails
     */
    public function getEntry($name, array $optionalArgs = [])
    {
        $request = new GetEntryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['view'])) {
            $request->setView($optionalArgs['view']);
        }

        if (isset($optionalArgs['aspectTypes'])) {
            $request->setAspectTypes($optionalArgs['aspectTypes']);
        }

        if (isset($optionalArgs['paths'])) {
            $request->setPaths($optionalArgs['paths']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetEntry',
            Entry::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a EntryGroup resource.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedName = $catalogServiceClient->entryGroupName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]');
     *     $response = $catalogServiceClient->getEntryGroup($formattedName);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the EntryGroup:
     *                             `projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\EntryGroup
     *
     * @throws ApiException if the remote call fails
     */
    public function getEntryGroup($name, array $optionalArgs = [])
    {
        $request = new GetEntryGroupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetEntryGroup',
            EntryGroup::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a EntryType resource.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedName = $catalogServiceClient->entryTypeName('[PROJECT]', '[LOCATION]', '[ENTRY_TYPE]');
     *     $response = $catalogServiceClient->getEntryType($formattedName);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the EntryType:
     *                             `projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\EntryType
     *
     * @throws ApiException if the remote call fails
     */
    public function getEntryType($name, array $optionalArgs = [])
    {
        $request = new GetEntryTypeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetEntryType',
            EntryType::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists AspectType resources in a project and location.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedParent = $catalogServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $catalogServiceClient->listAspectTypes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $catalogServiceClient->listAspectTypes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the AspectType location, of the form:
     *                             `projects/{project_number}/locations/{location_id}`
     *                             where `location_id` refers to a GCP region.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filter request. Filters are case-sensitive.
     *           The following formats are supported:
     *
     *           labels.key1 = "value1"
     *           labels:key1
     *           name = "value"
     *           These restrictions can be coinjoined with AND, OR and NOT conjunctions.
     *     @type string $orderBy
     *           Optional. Order by fields (`name` or `create_time`) for the result.
     *           If not specified, the ordering is undefined.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAspectTypes($parent, array $optionalArgs = [])
    {
        $request = new ListAspectTypesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListAspectTypes',
            $optionalArgs,
            ListAspectTypesResponse::class,
            $request
        );
    }

    /**
     * Lists entries within an entry group.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedParent = $catalogServiceClient->entryGroupName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $catalogServiceClient->listEntries($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $catalogServiceClient->listEntries($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the parent Entry Group:
     *                             `projects/{project}/locations/{location}/entryGroups/{entry_group}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. A filter on the entries to return.
     *           Filters are case-sensitive.
     *           The request can be filtered by the following fields:
     *           entry_type, display_name.
     *           The comparison operators are =, !=, <, >, <=, >= (strings are compared
     *           according to lexical order)
     *           The logical operators AND, OR, NOT can be used
     *           in the filter. Example filter expressions:
     *           "display_name=AnExampleDisplayName"
     *           "entry_type=projects/example-project/locations/global/entryTypes/example-entry_type"
     *           "entry_type=projects/a* OR "entry_type=projects/k*"
     *           "NOT display_name=AnotherExampleDisplayName"
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEntries($parent, array $optionalArgs = [])
    {
        $request = new ListEntriesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListEntries',
            $optionalArgs,
            ListEntriesResponse::class,
            $request
        );
    }

    /**
     * Lists EntryGroup resources in a project and location.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedParent = $catalogServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $catalogServiceClient->listEntryGroups($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $catalogServiceClient->listEntryGroups($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the entryGroup location, of the form:
     *                             `projects/{project_number}/locations/{location_id}`
     *                             where `location_id` refers to a GCP region.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filter request.
     *     @type string $orderBy
     *           Optional. Order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEntryGroups($parent, array $optionalArgs = [])
    {
        $request = new ListEntryGroupsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListEntryGroups',
            $optionalArgs,
            ListEntryGroupsResponse::class,
            $request
        );
    }

    /**
     * Lists EntryType resources in a project and location.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $formattedParent = $catalogServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $catalogServiceClient->listEntryTypes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $catalogServiceClient->listEntryTypes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the EntryType location, of the form:
     *                             `projects/{project_number}/locations/{location_id}`
     *                             where `location_id` refers to a GCP region.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filter request. Filters are case-sensitive.
     *           The following formats are supported:
     *
     *           labels.key1 = "value1"
     *           labels:key1
     *           name = "value"
     *           These restrictions can be coinjoined with AND, OR and NOT conjunctions.
     *     @type string $orderBy
     *           Optional. Order by fields (`name` or `create_time`) for the result.
     *           If not specified, the ordering is undefined.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEntryTypes($parent, array $optionalArgs = [])
    {
        $request = new ListEntryTypesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListEntryTypes',
            $optionalArgs,
            ListEntryTypesResponse::class,
            $request
        );
    }

    /**
     * Looks up a single entry.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $name = 'name';
     *     $formattedEntry = $catalogServiceClient->entryName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]', '[ENTRY]');
     *     $response = $catalogServiceClient->lookupEntry($name, $formattedEntry);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The project to which the request should be attributed in the
     *                             following form: `projects/{project}/locations/{location}`.
     * @param string $entry        Required. The resource name of the Entry:
     *                             `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $view
     *           Optional. View for controlling which parts of an entry are to be returned.
     *           For allowed values, use constants defined on {@see \Google\Cloud\Dataplex\V1\EntryView}
     *     @type string[] $aspectTypes
     *           Optional. Limits the aspects returned to the provided aspect types.
     *           Only works if the CUSTOM view is selected.
     *     @type string[] $paths
     *           Optional. Limits the aspects returned to those associated with the provided
     *           paths within the Entry. Only works if the CUSTOM view is selected.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\Entry
     *
     * @throws ApiException if the remote call fails
     */
    public function lookupEntry($name, $entry, array $optionalArgs = [])
    {
        $request = new LookupEntryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setEntry($entry);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['view'])) {
            $request->setView($optionalArgs['view']);
        }

        if (isset($optionalArgs['aspectTypes'])) {
            $request->setAspectTypes($optionalArgs['aspectTypes']);
        }

        if (isset($optionalArgs['paths'])) {
            $request->setPaths($optionalArgs['paths']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'LookupEntry',
            Entry::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Searches for entries matching given query and scope.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $name = 'name';
     *     $query = 'query';
     *     // Iterate over pages of elements
     *     $pagedResponse = $catalogServiceClient->searchEntries($name, $query);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $catalogServiceClient->searchEntries($name, $query);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The project to which the request should be attributed in the
     *                             following form: `projects/{project}/locations/{location}`.
     * @param string $query        Required. The query against which entries in scope should be matched.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           Optional. Ordering of the results. Supported options to be added later.
     *     @type string $scope
     *           Optional. The scope under which the search should be operating. Should
     *           either be organizations/<org_id> or projects/<project_ref>. If left
     *           unspecified, it will default to the organization where the project provided
     *           in `name` is located.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function searchEntries($name, $query, array $optionalArgs = [])
    {
        $request = new SearchEntriesRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setQuery($query);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['scope'])) {
            $request->setScope($optionalArgs['scope']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'SearchEntries',
            $optionalArgs,
            SearchEntriesResponse::class,
            $request
        );
    }

    /**
     * Updates a AspectType resource.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $aspectType = new AspectType();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $catalogServiceClient->updateAspectType($aspectType, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $catalogServiceClient->updateAspectType($aspectType, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $catalogServiceClient->resumeOperation($operationName, 'updateAspectType');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param AspectType $aspectType   Required. AspectType Resource
     * @param FieldMask  $updateMask   Required. Mask of fields to update.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAspectType(
        $aspectType,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateAspectTypeRequest();
        $requestParamHeaders = [];
        $request->setAspectType($aspectType);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['aspect_type.name'] = $aspectType->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateAspectType',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates an Entry.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $entry = new Entry();
     *     $response = $catalogServiceClient->updateEntry($entry);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param Entry $entry        Required. Entry resource.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Mask of fields to update. To update Aspects, the update_mask must
     *           contain the value "aspects".
     *
     *           If the update_mask is empty, all modifiable fields present in the request
     *           will be updated.
     *     @type bool $allowMissing
     *           Optional. If set to true and the entry does not exist, it will be created.
     *     @type bool $deleteMissingAspects
     *           Optional. If set to true and the aspect_keys specify aspect ranges, any
     *           existing aspects from that range not provided in the request will be
     *           deleted.
     *     @type string[] $aspectKeys
     *           Optional. The map keys of the Aspects which should be modified. Supports
     *           the following syntaxes:
     *           * <aspect_type_reference> - matches aspect on given type and empty path
     *           * <aspect_type_reference>&#64;path - matches aspect on given type and specified
     *           path
     *           * <aspect_type_reference>* - matches aspects on given type for all paths
     *           * *&#64;path - matches aspects of all types on the given path
     *
     *           Existing aspects matching the syntax will not be removed unless
     *           `delete_missing_aspects` is set to true.
     *
     *           If this field is left empty, it will be treated as specifying exactly those
     *           Aspects present in the request.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\Entry
     *
     * @throws ApiException if the remote call fails
     */
    public function updateEntry($entry, array $optionalArgs = [])
    {
        $request = new UpdateEntryRequest();
        $requestParamHeaders = [];
        $request->setEntry($entry);
        $requestParamHeaders['entry.name'] = $entry->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        if (isset($optionalArgs['deleteMissingAspects'])) {
            $request->setDeleteMissingAspects(
                $optionalArgs['deleteMissingAspects']
            );
        }

        if (isset($optionalArgs['aspectKeys'])) {
            $request->setAspectKeys($optionalArgs['aspectKeys']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateEntry',
            Entry::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates a EntryGroup resource.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $entryGroup = new EntryGroup();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $catalogServiceClient->updateEntryGroup($entryGroup, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $catalogServiceClient->updateEntryGroup($entryGroup, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $catalogServiceClient->resumeOperation($operationName, 'updateEntryGroup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param EntryGroup $entryGroup   Required. EntryGroup Resource
     * @param FieldMask  $updateMask   Required. Mask of fields to update.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateEntryGroup(
        $entryGroup,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateEntryGroupRequest();
        $requestParamHeaders = [];
        $request->setEntryGroup($entryGroup);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['entry_group.name'] = $entryGroup->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateEntryGroup',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates a EntryType resource.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $entryType = new EntryType();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $catalogServiceClient->updateEntryType($entryType, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $catalogServiceClient->updateEntryType($entryType, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $catalogServiceClient->resumeOperation($operationName, 'updateEntryType');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param EntryType $entryType    Required. EntryType Resource
     * @param FieldMask $updateMask   Required. Mask of fields to update.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateEntryType(
        $entryType,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateEntryTypeRequest();
        $requestParamHeaders = [];
        $request->setEntryType($entryType);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['entry_type.name'] = $entryType->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateEntryType',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $catalogServiceClient->getIamPolicy($resource);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $catalogServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $catalogServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     $response = $catalogServiceClient->getLocation();
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $catalogServiceClient = new CatalogServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $catalogServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $catalogServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $catalogServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }
}
