<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/bigtable/admin/v2/table.proto

namespace Google\Cloud\Bigtable\Admin\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * AuthorizedViews represent subsets of a particular Cloud Bigtable table. Users
 * can configure access to each Authorized View independently from the table and
 * use the existing Data APIs to access the subset of data.
 *
 * Generated from protobuf message <code>google.bigtable.admin.v2.AuthorizedView</code>
 */
class AuthorizedView extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of this AuthorizedView.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    private $name = '';
    /**
     * The etag for this AuthorizedView.
     * If this is provided on update, it must match the server's etag. The server
     * returns ABORTED error on a mismatched etag.
     *
     * Generated from protobuf field <code>string etag = 3;</code>
     */
    private $etag = '';
    /**
     * Set to true to make the AuthorizedView protected against deletion.
     * The parent Table and containing Instance cannot be deleted if an
     * AuthorizedView has this bit set.
     *
     * Generated from protobuf field <code>bool deletion_protection = 4;</code>
     */
    private $deletion_protection = false;
    protected $authorized_view;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of this AuthorizedView.
     *           Values are of the form
     *           `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`
     *     @type \Google\Cloud\Bigtable\Admin\V2\AuthorizedView\SubsetView $subset_view
     *           An AuthorizedView permitting access to an explicit subset of a Table.
     *     @type string $etag
     *           The etag for this AuthorizedView.
     *           If this is provided on update, it must match the server's etag. The server
     *           returns ABORTED error on a mismatched etag.
     *     @type bool $deletion_protection
     *           Set to true to make the AuthorizedView protected against deletion.
     *           The parent Table and containing Instance cannot be deleted if an
     *           AuthorizedView has this bit set.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Bigtable\Admin\V2\Table::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of this AuthorizedView.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of this AuthorizedView.
     * Values are of the form
     * `projects/{project}/instances/{instance}/tables/{table}/authorizedViews/{authorized_view}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * An AuthorizedView permitting access to an explicit subset of a Table.
     *
     * Generated from protobuf field <code>.google.bigtable.admin.v2.AuthorizedView.SubsetView subset_view = 2;</code>
     * @return \Google\Cloud\Bigtable\Admin\V2\AuthorizedView\SubsetView|null
     */
    public function getSubsetView()
    {
        return $this->readOneof(2);
    }

    public function hasSubsetView()
    {
        return $this->hasOneof(2);
    }

    /**
     * An AuthorizedView permitting access to an explicit subset of a Table.
     *
     * Generated from protobuf field <code>.google.bigtable.admin.v2.AuthorizedView.SubsetView subset_view = 2;</code>
     * @param \Google\Cloud\Bigtable\Admin\V2\AuthorizedView\SubsetView $var
     * @return $this
     */
    public function setSubsetView($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Bigtable\Admin\V2\AuthorizedView\SubsetView::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * The etag for this AuthorizedView.
     * If this is provided on update, it must match the server's etag. The server
     * returns ABORTED error on a mismatched etag.
     *
     * Generated from protobuf field <code>string etag = 3;</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * The etag for this AuthorizedView.
     * If this is provided on update, it must match the server's etag. The server
     * returns ABORTED error on a mismatched etag.
     *
     * Generated from protobuf field <code>string etag = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Set to true to make the AuthorizedView protected against deletion.
     * The parent Table and containing Instance cannot be deleted if an
     * AuthorizedView has this bit set.
     *
     * Generated from protobuf field <code>bool deletion_protection = 4;</code>
     * @return bool
     */
    public function getDeletionProtection()
    {
        return $this->deletion_protection;
    }

    /**
     * Set to true to make the AuthorizedView protected against deletion.
     * The parent Table and containing Instance cannot be deleted if an
     * AuthorizedView has this bit set.
     *
     * Generated from protobuf field <code>bool deletion_protection = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setDeletionProtection($var)
    {
        GPBUtil::checkBool($var);
        $this->deletion_protection = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getAuthorizedView()
    {
        return $this->whichOneof("authorized_view");
    }

}

