<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/chat/v1/membership.proto

namespace Google\Apps\Chat\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for creating a membership.
 *
 * Generated from protobuf message <code>google.chat.v1.CreateMembershipRequest</code>
 */
class CreateMembershipRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the space for which to create the
     * membership.
     * Format: spaces/{space}
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The membership relation to create.
     * The `memberType` field must contain a user with the `user.name` and
     * `user.type` fields populated. The server will assign a resource name
     * and overwrite anything specified.
     * When a Chat app creates a membership relation for a human user, it must use
     * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
     * `user.name` with format `users/{user}`, where `{user}` can be the email
     * address for the user. For users in the same Workspace organization `{user}`
     * can also be the `id` of the
     * [person](https://developers.google.com/people/api/rest/v1/people) from the
     * People API, or the `id` for the user in the Directory API. For example, if
     * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
     * can add the user to the space by setting the `membership.member.name` to
     * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
     * membership relation for itself, it must use the `chat.memberships.app`
     * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $membership = null;

    /**
     * @param string                          $parent     Required. The resource name of the space for which to create the
     *                                                    membership.
     *
     *                                                    Format: spaces/{space}
     *                                                    Please see {@see ChatServiceClient::spaceName()} for help formatting this field.
     * @param \Google\Apps\Chat\V1\Membership $membership Required. The membership relation to create.
     *                                                    The `memberType` field must contain a user with the `user.name` and
     *                                                    `user.type` fields populated. The server will assign a resource name
     *                                                    and overwrite anything specified.
     *                                                    When a Chat app creates a membership relation for a human user, it must use
     *                                                    the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
     *                                                    `user.name` with format `users/{user}`, where `{user}` can be the email
     *                                                    address for the user. For users in the same Workspace organization `{user}`
     *                                                    can also be the `id` of the
     *                                                    [person](https://developers.google.com/people/api/rest/v1/people) from the
     *                                                    People API, or the `id` for the user in the Directory API. For example, if
     *                                                    the People API Person profile ID for `user&#64;example.com` is `123456789`, you
     *                                                    can add the user to the space by setting the `membership.member.name` to
     *                                                    `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
     *                                                    membership relation for itself, it must use the `chat.memberships.app`
     *                                                    scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
     *
     * @return \Google\Apps\Chat\V1\CreateMembershipRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Apps\Chat\V1\Membership $membership): self
    {
        return (new self())
            ->setParent($parent)
            ->setMembership($membership);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The resource name of the space for which to create the
     *           membership.
     *           Format: spaces/{space}
     *     @type \Google\Apps\Chat\V1\Membership $membership
     *           Required. The membership relation to create.
     *           The `memberType` field must contain a user with the `user.name` and
     *           `user.type` fields populated. The server will assign a resource name
     *           and overwrite anything specified.
     *           When a Chat app creates a membership relation for a human user, it must use
     *           the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
     *           `user.name` with format `users/{user}`, where `{user}` can be the email
     *           address for the user. For users in the same Workspace organization `{user}`
     *           can also be the `id` of the
     *           [person](https://developers.google.com/people/api/rest/v1/people) from the
     *           People API, or the `id` for the user in the Directory API. For example, if
     *           the People API Person profile ID for `user&#64;example.com` is `123456789`, you
     *           can add the user to the space by setting the `membership.member.name` to
     *           `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
     *           membership relation for itself, it must use the `chat.memberships.app`
     *           scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Chat\V1\Membership::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the space for which to create the
     * membership.
     * Format: spaces/{space}
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The resource name of the space for which to create the
     * membership.
     * Format: spaces/{space}
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The membership relation to create.
     * The `memberType` field must contain a user with the `user.name` and
     * `user.type` fields populated. The server will assign a resource name
     * and overwrite anything specified.
     * When a Chat app creates a membership relation for a human user, it must use
     * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
     * `user.name` with format `users/{user}`, where `{user}` can be the email
     * address for the user. For users in the same Workspace organization `{user}`
     * can also be the `id` of the
     * [person](https://developers.google.com/people/api/rest/v1/people) from the
     * People API, or the `id` for the user in the Directory API. For example, if
     * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
     * can add the user to the space by setting the `membership.member.name` to
     * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
     * membership relation for itself, it must use the `chat.memberships.app`
     * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Apps\Chat\V1\Membership|null
     */
    public function getMembership()
    {
        return $this->membership;
    }

    public function hasMembership()
    {
        return isset($this->membership);
    }

    public function clearMembership()
    {
        unset($this->membership);
    }

    /**
     * Required. The membership relation to create.
     * The `memberType` field must contain a user with the `user.name` and
     * `user.type` fields populated. The server will assign a resource name
     * and overwrite anything specified.
     * When a Chat app creates a membership relation for a human user, it must use
     * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
     * `user.name` with format `users/{user}`, where `{user}` can be the email
     * address for the user. For users in the same Workspace organization `{user}`
     * can also be the `id` of the
     * [person](https://developers.google.com/people/api/rest/v1/people) from the
     * People API, or the `id` for the user in the Directory API. For example, if
     * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
     * can add the user to the space by setting the `membership.member.name` to
     * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
     * membership relation for itself, it must use the `chat.memberships.app`
     * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
     *
     * Generated from protobuf field <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Apps\Chat\V1\Membership $var
     * @return $this
     */
    public function setMembership($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\Membership::class);
        $this->membership = $var;

        return $this;
    }

}

