<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/notebook_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\AssignNotebookRuntimeRequest;
use Google\Cloud\AIPlatform\V1\CreateNotebookRuntimeTemplateRequest;
use Google\Cloud\AIPlatform\V1\DeleteNotebookRuntimeRequest;
use Google\Cloud\AIPlatform\V1\DeleteNotebookRuntimeTemplateRequest;
use Google\Cloud\AIPlatform\V1\GetNotebookRuntimeRequest;
use Google\Cloud\AIPlatform\V1\GetNotebookRuntimeTemplateRequest;
use Google\Cloud\AIPlatform\V1\ListNotebookRuntimeTemplatesRequest;
use Google\Cloud\AIPlatform\V1\ListNotebookRuntimeTemplatesResponse;
use Google\Cloud\AIPlatform\V1\ListNotebookRuntimesRequest;
use Google\Cloud\AIPlatform\V1\ListNotebookRuntimesResponse;
use Google\Cloud\AIPlatform\V1\NotebookRuntime;
use Google\Cloud\AIPlatform\V1\NotebookRuntimeTemplate;
use Google\Cloud\AIPlatform\V1\StartNotebookRuntimeRequest;
use Google\Cloud\AIPlatform\V1\UpgradeNotebookRuntimeRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: The interface for Vertex Notebook service (a.k.a. Colab on Workbench).
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $notebookServiceClient = new NotebookServiceClient();
 * try {
 *     $formattedParent = $notebookServiceClient->locationName('[PROJECT]', '[LOCATION]');
 *     $formattedNotebookRuntimeTemplate = $notebookServiceClient->notebookRuntimeTemplateName('[PROJECT]', '[LOCATION]', '[NOTEBOOK_RUNTIME_TEMPLATE]');
 *     $notebookRuntime = new NotebookRuntime();
 *     $operationResponse = $notebookServiceClient->assignNotebookRuntime($formattedParent, $formattedNotebookRuntimeTemplate, $notebookRuntime);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $notebookServiceClient->assignNotebookRuntime($formattedParent, $formattedNotebookRuntimeTemplate, $notebookRuntime);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $notebookServiceClient->resumeOperation($operationName, 'assignNotebookRuntime');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *         // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $notebookServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated Please use the new service client {@see \Google\Cloud\AIPlatform\V1\Client\NotebookServiceClient}.
 */
class NotebookServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.aiplatform.v1.NotebookService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'aiplatform.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $locationNameTemplate;

    private static $networkNameTemplate;

    private static $notebookRuntimeNameTemplate;

    private static $notebookRuntimeTemplateNameTemplate;

    private static $subnetworkNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/notebook_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/notebook_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/notebook_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/notebook_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getNetworkNameTemplate()
    {
        if (self::$networkNameTemplate == null) {
            self::$networkNameTemplate = new PathTemplate(
                'projects/{project}/global/networks/{network}'
            );
        }

        return self::$networkNameTemplate;
    }

    private static function getNotebookRuntimeNameTemplate()
    {
        if (self::$notebookRuntimeNameTemplate == null) {
            self::$notebookRuntimeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/notebookRuntimes/{notebook_runtime}'
            );
        }

        return self::$notebookRuntimeNameTemplate;
    }

    private static function getNotebookRuntimeTemplateNameTemplate()
    {
        if (self::$notebookRuntimeTemplateNameTemplate == null) {
            self::$notebookRuntimeTemplateNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/notebookRuntimeTemplates/{notebook_runtime_template}'
            );
        }

        return self::$notebookRuntimeTemplateNameTemplate;
    }

    private static function getSubnetworkNameTemplate()
    {
        if (self::$subnetworkNameTemplate == null) {
            self::$subnetworkNameTemplate = new PathTemplate(
                'projects/{project}/regions/{region}/subnetworks/{subnetwork}'
            );
        }

        return self::$subnetworkNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'location' => self::getLocationNameTemplate(),
                'network' => self::getNetworkNameTemplate(),
                'notebookRuntime' => self::getNotebookRuntimeNameTemplate(),
                'notebookRuntimeTemplate' => self::getNotebookRuntimeTemplateNameTemplate(),
                'subnetwork' => self::getSubnetworkNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName($project, $network)
    {
        return self::getNetworkNameTemplate()->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * notebook_runtime resource.
     *
     * @param string $project
     * @param string $location
     * @param string $notebookRuntime
     *
     * @return string The formatted notebook_runtime resource.
     */
    public static function notebookRuntimeName(
        $project,
        $location,
        $notebookRuntime
    ) {
        return self::getNotebookRuntimeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'notebook_runtime' => $notebookRuntime,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * notebook_runtime_template resource.
     *
     * @param string $project
     * @param string $location
     * @param string $notebookRuntimeTemplate
     *
     * @return string The formatted notebook_runtime_template resource.
     */
    public static function notebookRuntimeTemplateName(
        $project,
        $location,
        $notebookRuntimeTemplate
    ) {
        return self::getNotebookRuntimeTemplateNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'notebook_runtime_template' => $notebookRuntimeTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a subnetwork
     * resource.
     *
     * @param string $project
     * @param string $region
     * @param string $subnetwork
     *
     * @return string The formatted subnetwork resource.
     */
    public static function subnetworkName($project, $region, $subnetwork)
    {
        return self::getSubnetworkNameTemplate()->render([
            'project' => $project,
            'region' => $region,
            'subnetwork' => $subnetwork,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - location: projects/{project}/locations/{location}
     * - network: projects/{project}/global/networks/{network}
     * - notebookRuntime: projects/{project}/locations/{location}/notebookRuntimes/{notebook_runtime}
     * - notebookRuntimeTemplate: projects/{project}/locations/{location}/notebookRuntimeTemplates/{notebook_runtime_template}
     * - subnetwork: projects/{project}/regions/{region}/subnetworks/{subnetwork}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Assigns a NotebookRuntime to a user for a particular Notebook file. This
     * method will either returns an existing assignment or generates a new one.
     *
     * Sample code:
     * ```
     * $notebookServiceClient = new NotebookServiceClient();
     * try {
     *     $formattedParent = $notebookServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $formattedNotebookRuntimeTemplate = $notebookServiceClient->notebookRuntimeTemplateName('[PROJECT]', '[LOCATION]', '[NOTEBOOK_RUNTIME_TEMPLATE]');
     *     $notebookRuntime = new NotebookRuntime();
     *     $operationResponse = $notebookServiceClient->assignNotebookRuntime($formattedParent, $formattedNotebookRuntimeTemplate, $notebookRuntime);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $notebookServiceClient->assignNotebookRuntime($formattedParent, $formattedNotebookRuntimeTemplate, $notebookRuntime);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $notebookServiceClient->resumeOperation($operationName, 'assignNotebookRuntime');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $notebookServiceClient->close();
     * }
     * ```
     *
     * @param string          $parent                  Required. The resource name of the Location to get the NotebookRuntime
     *                                                 assignment. Format: `projects/{project}/locations/{location}`
     * @param string          $notebookRuntimeTemplate Required. The resource name of the NotebookRuntimeTemplate based on which a
     *                                                 NotebookRuntime will be assigned (reuse or create a new one).
     * @param NotebookRuntime $notebookRuntime         Required. Provide runtime specific information (e.g. runtime owner,
     *                                                 notebook id) used for NotebookRuntime assignment.
     * @param array           $optionalArgs            {
     *     Optional.
     *
     *     @type string $notebookRuntimeId
     *           Optional. User specified ID for the notebook runtime.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function assignNotebookRuntime(
        $parent,
        $notebookRuntimeTemplate,
        $notebookRuntime,
        array $optionalArgs = []
    ) {
        $request = new AssignNotebookRuntimeRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setNotebookRuntimeTemplate($notebookRuntimeTemplate);
        $request->setNotebookRuntime($notebookRuntime);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['notebookRuntimeId'])) {
            $request->setNotebookRuntimeId($optionalArgs['notebookRuntimeId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'AssignNotebookRuntime',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a NotebookRuntimeTemplate.
     *
     * Sample code:
     * ```
     * $notebookServiceClient = new NotebookServiceClient();
     * try {
     *     $formattedParent = $notebookServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $notebookRuntimeTemplate = new NotebookRuntimeTemplate();
     *     $operationResponse = $notebookServiceClient->createNotebookRuntimeTemplate($formattedParent, $notebookRuntimeTemplate);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $notebookServiceClient->createNotebookRuntimeTemplate($formattedParent, $notebookRuntimeTemplate);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $notebookServiceClient->resumeOperation($operationName, 'createNotebookRuntimeTemplate');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $notebookServiceClient->close();
     * }
     * ```
     *
     * @param string                  $parent                  Required. The resource name of the Location to create the
     *                                                         NotebookRuntimeTemplate. Format: `projects/{project}/locations/{location}`
     * @param NotebookRuntimeTemplate $notebookRuntimeTemplate Required. The NotebookRuntimeTemplate to create.
     * @param array                   $optionalArgs            {
     *     Optional.
     *
     *     @type string $notebookRuntimeTemplateId
     *           Optional. User specified ID for the notebook runtime template.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createNotebookRuntimeTemplate(
        $parent,
        $notebookRuntimeTemplate,
        array $optionalArgs = []
    ) {
        $request = new CreateNotebookRuntimeTemplateRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setNotebookRuntimeTemplate($notebookRuntimeTemplate);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['notebookRuntimeTemplateId'])) {
            $request->setNotebookRuntimeTemplateId(
                $optionalArgs['notebookRuntimeTemplateId']
            );
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateNotebookRuntimeTemplate',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a NotebookRuntime.
     *
     * Sample code:
     * ```
     * $notebookServiceClient = new NotebookServiceClient();
     * try {
     *     $formattedName = $notebookServiceClient->notebookRuntimeName('[PROJECT]', '[LOCATION]', '[NOTEBOOK_RUNTIME]');
     *     $operationResponse = $notebookServiceClient->deleteNotebookRuntime($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $notebookServiceClient->deleteNotebookRuntime($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $notebookServiceClient->resumeOperation($operationName, 'deleteNotebookRuntime');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $notebookServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the NotebookRuntime resource to be deleted.
     *                             Instead of checking whether the name is in valid NotebookRuntime resource
     *                             name format, directly throw NotFound exception if there is no such
     *                             NotebookRuntime in spanner.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteNotebookRuntime($name, array $optionalArgs = [])
    {
        $request = new DeleteNotebookRuntimeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteNotebookRuntime',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a NotebookRuntimeTemplate.
     *
     * Sample code:
     * ```
     * $notebookServiceClient = new NotebookServiceClient();
     * try {
     *     $formattedName = $notebookServiceClient->notebookRuntimeTemplateName('[PROJECT]', '[LOCATION]', '[NOTEBOOK_RUNTIME_TEMPLATE]');
     *     $operationResponse = $notebookServiceClient->deleteNotebookRuntimeTemplate($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $notebookServiceClient->deleteNotebookRuntimeTemplate($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $notebookServiceClient->resumeOperation($operationName, 'deleteNotebookRuntimeTemplate');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $notebookServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the NotebookRuntimeTemplate resource to be deleted.
     *                             Format:
     *                             `projects/{project}/locations/{location}/notebookRuntimeTemplates/{notebook_runtime_template}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteNotebookRuntimeTemplate(
        $name,
        array $optionalArgs = []
    ) {
        $request = new DeleteNotebookRuntimeTemplateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteNotebookRuntimeTemplate',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets a NotebookRuntime.
     *
     * Sample code:
     * ```
     * $notebookServiceClient = new NotebookServiceClient();
     * try {
     *     $formattedName = $notebookServiceClient->notebookRuntimeName('[PROJECT]', '[LOCATION]', '[NOTEBOOK_RUNTIME]');
     *     $response = $notebookServiceClient->getNotebookRuntime($formattedName);
     * } finally {
     *     $notebookServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the NotebookRuntime resource.
     *                             Instead of checking whether the name is in valid NotebookRuntime resource
     *                             name format, directly throw NotFound exception if there is no such
     *                             NotebookRuntime in spanner.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\NotebookRuntime
     *
     * @throws ApiException if the remote call fails
     */
    public function getNotebookRuntime($name, array $optionalArgs = [])
    {
        $request = new GetNotebookRuntimeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetNotebookRuntime',
            NotebookRuntime::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a NotebookRuntimeTemplate.
     *
     * Sample code:
     * ```
     * $notebookServiceClient = new NotebookServiceClient();
     * try {
     *     $formattedName = $notebookServiceClient->notebookRuntimeTemplateName('[PROJECT]', '[LOCATION]', '[NOTEBOOK_RUNTIME_TEMPLATE]');
     *     $response = $notebookServiceClient->getNotebookRuntimeTemplate($formattedName);
     * } finally {
     *     $notebookServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the NotebookRuntimeTemplate resource.
     *                             Format:
     *                             `projects/{project}/locations/{location}/notebookRuntimeTemplates/{notebook_runtime_template}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\NotebookRuntimeTemplate
     *
     * @throws ApiException if the remote call fails
     */
    public function getNotebookRuntimeTemplate($name, array $optionalArgs = [])
    {
        $request = new GetNotebookRuntimeTemplateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetNotebookRuntimeTemplate',
            NotebookRuntimeTemplate::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists NotebookRuntimeTemplates in a Location.
     *
     * Sample code:
     * ```
     * $notebookServiceClient = new NotebookServiceClient();
     * try {
     *     $formattedParent = $notebookServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $notebookServiceClient->listNotebookRuntimeTemplates($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $notebookServiceClient->listNotebookRuntimeTemplates($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $notebookServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location from which to list the
     *                             NotebookRuntimeTemplates.
     *                             Format: `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Optional. An expression for filtering the results of the request. For field
     *           names both snake_case and camelCase are supported.
     *
     *           * `notebookRuntimeTemplate` supports = and !=. `notebookRuntimeTemplate`
     *           represents the NotebookRuntimeTemplate ID,
     *           i.e. the last segment of the NotebookRuntimeTemplate's [resource name]
     *           [google.cloud.aiplatform.v1.NotebookRuntimeTemplate.name].
     *           * `display_name` supports = and !=
     *           * `labels` supports general map functions that is:
     *           * `labels.key=value` - key:value equality
     *           * `labels.key:* or labels:key - key existence
     *           * A key including a space must be quoted. `labels."a key"`.
     *           * `notebookRuntimeType` supports = and !=. notebookRuntimeType enum:
     *           [USER_DEFINED, ONE_CLICK].
     *
     *           Some examples:
     *
     *           * `notebookRuntimeTemplate=notebookRuntimeTemplate123`
     *           * `displayName="myDisplayName"`
     *           * `labels.myKey="myValue"`
     *           * `notebookRuntimeType=USER_DEFINED`
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type FieldMask $readMask
     *           Optional. Mask specifying which fields to read.
     *     @type string $orderBy
     *           Optional. A comma-separated list of fields to order by, sorted in ascending
     *           order. Use "desc" after a field name for descending. Supported fields:
     *
     *           * `display_name`
     *           * `create_time`
     *           * `update_time`
     *
     *           Example: `display_name, create_time desc`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listNotebookRuntimeTemplates(
        $parent,
        array $optionalArgs = []
    ) {
        $request = new ListNotebookRuntimeTemplatesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListNotebookRuntimeTemplates',
            $optionalArgs,
            ListNotebookRuntimeTemplatesResponse::class,
            $request
        );
    }

    /**
     * Lists NotebookRuntimes in a Location.
     *
     * Sample code:
     * ```
     * $notebookServiceClient = new NotebookServiceClient();
     * try {
     *     $formattedParent = $notebookServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $notebookServiceClient->listNotebookRuntimes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $notebookServiceClient->listNotebookRuntimes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $notebookServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location from which to list the
     *                             NotebookRuntimes.
     *                             Format: `projects/{project}/locations/{location}`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Optional. An expression for filtering the results of the request. For field
     *           names both snake_case and camelCase are supported.
     *
     *           * `notebookRuntime` supports = and !=. `notebookRuntime` represents the
     *           NotebookRuntime ID,
     *           i.e. the last segment of the NotebookRuntime's [resource name]
     *           [google.cloud.aiplatform.v1.NotebookRuntime.name].
     *           * `displayName` supports = and != and regex.
     *           * `notebookRuntimeTemplate` supports = and !=. `notebookRuntimeTemplate`
     *           represents the NotebookRuntimeTemplate ID,
     *           i.e. the last segment of the NotebookRuntimeTemplate's [resource name]
     *           [google.cloud.aiplatform.v1.NotebookRuntimeTemplate.name].
     *           * `healthState` supports = and !=. healthState enum: [HEALTHY, UNHEALTHY,
     *           HEALTH_STATE_UNSPECIFIED].
     *           * `runtimeState` supports = and !=. runtimeState enum:
     *           [RUNTIME_STATE_UNSPECIFIED, RUNNING, BEING_STARTED, BEING_STOPPED,
     *           STOPPED, BEING_UPGRADED, ERROR, INVALID].
     *           * `runtimeUser` supports = and !=.
     *           * API version is UI only: `uiState` supports = and !=. uiState enum:
     *           [UI_RESOURCE_STATE_UNSPECIFIED, UI_RESOURCE_STATE_BEING_CREATED,
     *           UI_RESOURCE_STATE_ACTIVE, UI_RESOURCE_STATE_BEING_DELETED,
     *           UI_RESOURCE_STATE_CREATION_FAILED].
     *           * `notebookRuntimeType` supports = and !=. notebookRuntimeType enum:
     *           [USER_DEFINED, ONE_CLICK].
     *
     *           Some examples:
     *
     *           * `notebookRuntime="notebookRuntime123"`
     *           * `displayName="myDisplayName"` and `displayName=~"myDisplayNameRegex"`
     *           * `notebookRuntimeTemplate="notebookRuntimeTemplate321"`
     *           * `healthState=HEALTHY`
     *           * `runtimeState=RUNNING`
     *           * `runtimeUser="test&#64;google.com"`
     *           * `uiState=UI_RESOURCE_STATE_BEING_DELETED`
     *           * `notebookRuntimeType=USER_DEFINED`
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type FieldMask $readMask
     *           Optional. Mask specifying which fields to read.
     *     @type string $orderBy
     *           Optional. A comma-separated list of fields to order by, sorted in ascending
     *           order. Use "desc" after a field name for descending. Supported fields:
     *
     *           * `display_name`
     *           * `create_time`
     *           * `update_time`
     *
     *           Example: `display_name, create_time desc`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listNotebookRuntimes($parent, array $optionalArgs = [])
    {
        $request = new ListNotebookRuntimesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListNotebookRuntimes',
            $optionalArgs,
            ListNotebookRuntimesResponse::class,
            $request
        );
    }

    /**
     * Starts a NotebookRuntime.
     *
     * Sample code:
     * ```
     * $notebookServiceClient = new NotebookServiceClient();
     * try {
     *     $formattedName = $notebookServiceClient->notebookRuntimeName('[PROJECT]', '[LOCATION]', '[NOTEBOOK_RUNTIME]');
     *     $operationResponse = $notebookServiceClient->startNotebookRuntime($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $notebookServiceClient->startNotebookRuntime($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $notebookServiceClient->resumeOperation($operationName, 'startNotebookRuntime');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $notebookServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the NotebookRuntime resource to be started.
     *                             Instead of checking whether the name is in valid NotebookRuntime resource
     *                             name format, directly throw NotFound exception if there is no such
     *                             NotebookRuntime in spanner.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function startNotebookRuntime($name, array $optionalArgs = [])
    {
        $request = new StartNotebookRuntimeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'StartNotebookRuntime',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Upgrades a NotebookRuntime.
     *
     * Sample code:
     * ```
     * $notebookServiceClient = new NotebookServiceClient();
     * try {
     *     $formattedName = $notebookServiceClient->notebookRuntimeName('[PROJECT]', '[LOCATION]', '[NOTEBOOK_RUNTIME]');
     *     $operationResponse = $notebookServiceClient->upgradeNotebookRuntime($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $notebookServiceClient->upgradeNotebookRuntime($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $notebookServiceClient->resumeOperation($operationName, 'upgradeNotebookRuntime');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *         // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $notebookServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the NotebookRuntime resource to be upgrade.
     *                             Instead of checking whether the name is in valid NotebookRuntime resource
     *                             name format, directly throw NotFound exception if there is no such
     *                             NotebookRuntime in spanner.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function upgradeNotebookRuntime($name, array $optionalArgs = [])
    {
        $request = new UpgradeNotebookRuntimeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpgradeNotebookRuntime',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $notebookServiceClient = new NotebookServiceClient();
     * try {
     *     $response = $notebookServiceClient->getLocation();
     * } finally {
     *     $notebookServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $notebookServiceClient = new NotebookServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $notebookServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $notebookServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $notebookServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $notebookServiceClient = new NotebookServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $notebookServiceClient->getIamPolicy($resource);
     * } finally {
     *     $notebookServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $notebookServiceClient = new NotebookServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $notebookServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $notebookServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $notebookServiceClient = new NotebookServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $notebookServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $notebookServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
