<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/advisorynotifications/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AdvisoryNotifications\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AdvisoryNotifications\V1\GetNotificationRequest;
use Google\Cloud\AdvisoryNotifications\V1\GetSettingsRequest;
use Google\Cloud\AdvisoryNotifications\V1\ListNotificationsRequest;
use Google\Cloud\AdvisoryNotifications\V1\ListNotificationsResponse;
use Google\Cloud\AdvisoryNotifications\V1\Notification;
use Google\Cloud\AdvisoryNotifications\V1\Settings;
use Google\Cloud\AdvisoryNotifications\V1\UpdateSettingsRequest;

/**
 * Service Description: Service to manage Security and Privacy Notifications.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $advisoryNotificationsServiceClient = new AdvisoryNotificationsServiceClient();
 * try {
 *     $formattedName = $advisoryNotificationsServiceClient->notificationName('[ORGANIZATION]', '[LOCATION]', '[NOTIFICATION]');
 *     $response = $advisoryNotificationsServiceClient->getNotification($formattedName);
 * } finally {
 *     $advisoryNotificationsServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @deprecated Please use the new service client {@see \Google\Cloud\AdvisoryNotifications\V1\Client\AdvisoryNotificationsServiceClient}.
 */
class AdvisoryNotificationsServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.advisorynotifications.v1.AdvisoryNotificationsService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    const SERVICE_ADDRESS = 'advisorynotifications.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'advisorynotifications.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $locationNameTemplate;

    private static $notificationNameTemplate;

    private static $organizationLocationNameTemplate;

    private static $organizationLocationNotificationNameTemplate;

    private static $organizationLocationSettingsNameTemplate;

    private static $projectLocationNameTemplate;

    private static $projectLocationNotificationNameTemplate;

    private static $projectLocationSettingsNameTemplate;

    private static $settingsNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/advisory_notifications_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/advisory_notifications_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ .
                '/../resources/advisory_notifications_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/advisory_notifications_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getNotificationNameTemplate()
    {
        if (self::$notificationNameTemplate == null) {
            self::$notificationNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/notifications/{notification}'
            );
        }

        return self::$notificationNameTemplate;
    }

    private static function getOrganizationLocationNameTemplate()
    {
        if (self::$organizationLocationNameTemplate == null) {
            self::$organizationLocationNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}'
            );
        }

        return self::$organizationLocationNameTemplate;
    }

    private static function getOrganizationLocationNotificationNameTemplate()
    {
        if (self::$organizationLocationNotificationNameTemplate == null) {
            self::$organizationLocationNotificationNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/notifications/{notification}'
            );
        }

        return self::$organizationLocationNotificationNameTemplate;
    }

    private static function getOrganizationLocationSettingsNameTemplate()
    {
        if (self::$organizationLocationSettingsNameTemplate == null) {
            self::$organizationLocationSettingsNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/settings'
            );
        }

        return self::$organizationLocationSettingsNameTemplate;
    }

    private static function getProjectLocationNameTemplate()
    {
        if (self::$projectLocationNameTemplate == null) {
            self::$projectLocationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$projectLocationNameTemplate;
    }

    private static function getProjectLocationNotificationNameTemplate()
    {
        if (self::$projectLocationNotificationNameTemplate == null) {
            self::$projectLocationNotificationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/notifications/{notification}'
            );
        }

        return self::$projectLocationNotificationNameTemplate;
    }

    private static function getProjectLocationSettingsNameTemplate()
    {
        if (self::$projectLocationSettingsNameTemplate == null) {
            self::$projectLocationSettingsNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/settings'
            );
        }

        return self::$projectLocationSettingsNameTemplate;
    }

    private static function getSettingsNameTemplate()
    {
        if (self::$settingsNameTemplate == null) {
            self::$settingsNameTemplate = new PathTemplate(
                'organizations/{organization}/locations/{location}/settings'
            );
        }

        return self::$settingsNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'location' => self::getLocationNameTemplate(),
                'notification' => self::getNotificationNameTemplate(),
                'organizationLocation' => self::getOrganizationLocationNameTemplate(),
                'organizationLocationNotification' => self::getOrganizationLocationNotificationNameTemplate(),
                'organizationLocationSettings' => self::getOrganizationLocationSettingsNameTemplate(),
                'projectLocation' => self::getProjectLocationNameTemplate(),
                'projectLocationNotification' => self::getProjectLocationNotificationNameTemplate(),
                'projectLocationSettings' => self::getProjectLocationSettingsNameTemplate(),
                'settings' => self::getSettingsNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($organization, $location)
    {
        return self::getLocationNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a notification
     * resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $notification
     *
     * @return string The formatted notification resource.
     */
    public static function notificationName(
        $organization,
        $location,
        $notification
    ) {
        return self::getNotificationNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
            'notification' => $notification,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted organization_location resource.
     */
    public static function organizationLocationName($organization, $location)
    {
        return self::getOrganizationLocationNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_notification resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $notification
     *
     * @return string The formatted organization_location_notification resource.
     */
    public static function organizationLocationNotificationName(
        $organization,
        $location,
        $notification
    ) {
        return self::getOrganizationLocationNotificationNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
            'notification' => $notification,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_settings resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted organization_location_settings resource.
     */
    public static function organizationLocationSettingsName(
        $organization,
        $location
    ) {
        return self::getOrganizationLocationSettingsNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted project_location resource.
     */
    public static function projectLocationName($project, $location)
    {
        return self::getProjectLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_notification resource.
     *
     * @param string $project
     * @param string $location
     * @param string $notification
     *
     * @return string The formatted project_location_notification resource.
     */
    public static function projectLocationNotificationName(
        $project,
        $location,
        $notification
    ) {
        return self::getProjectLocationNotificationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'notification' => $notification,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_settings resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted project_location_settings resource.
     */
    public static function projectLocationSettingsName($project, $location)
    {
        return self::getProjectLocationSettingsNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a settings
     * resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted settings resource.
     */
    public static function settingsName($organization, $location)
    {
        return self::getSettingsNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - location: organizations/{organization}/locations/{location}
     * - notification: organizations/{organization}/locations/{location}/notifications/{notification}
     * - organizationLocation: organizations/{organization}/locations/{location}
     * - organizationLocationNotification: organizations/{organization}/locations/{location}/notifications/{notification}
     * - organizationLocationSettings: organizations/{organization}/locations/{location}/settings
     * - projectLocation: projects/{project}/locations/{location}
     * - projectLocationNotification: projects/{project}/locations/{location}/notifications/{notification}
     * - projectLocationSettings: projects/{project}/locations/{location}/settings
     * - settings: organizations/{organization}/locations/{location}/settings
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'advisorynotifications.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Gets a notification.
     *
     * Sample code:
     * ```
     * $advisoryNotificationsServiceClient = new AdvisoryNotificationsServiceClient();
     * try {
     *     $formattedName = $advisoryNotificationsServiceClient->notificationName('[ORGANIZATION]', '[LOCATION]', '[NOTIFICATION]');
     *     $response = $advisoryNotificationsServiceClient->getNotification($formattedName);
     * } finally {
     *     $advisoryNotificationsServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the notification to retrieve.
     *                             Format:
     *                             organizations/{organization}/locations/{location}/notifications/{notification}
     *                             or projects/{projects}/locations/{location}/notifications/{notification}.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $languageCode
     *           ISO code for requested localization language. If unset, will be
     *           interpereted as "en". If the requested language is valid, but not supported
     *           for this notification, English will be returned with an "Not applicable"
     *           LocalizationState. If the ISO code is invalid (i.e. not a real language),
     *           this RPC will throw an error.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AdvisoryNotifications\V1\Notification
     *
     * @throws ApiException if the remote call fails
     */
    public function getNotification($name, array $optionalArgs = [])
    {
        $request = new GetNotificationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['languageCode'])) {
            $request->setLanguageCode($optionalArgs['languageCode']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetNotification',
            Notification::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get notification settings.
     *
     * Sample code:
     * ```
     * $advisoryNotificationsServiceClient = new AdvisoryNotificationsServiceClient();
     * try {
     *     $formattedName = $advisoryNotificationsServiceClient->settingsName('[ORGANIZATION]', '[LOCATION]');
     *     $response = $advisoryNotificationsServiceClient->getSettings($formattedName);
     * } finally {
     *     $advisoryNotificationsServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the settings to retrieve.
     *                             Format:
     *                             organizations/{organization}/locations/{location}/settings or
     *                             projects/{projects}/locations/{location}/settings.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AdvisoryNotifications\V1\Settings
     *
     * @throws ApiException if the remote call fails
     */
    public function getSettings($name, array $optionalArgs = [])
    {
        $request = new GetSettingsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetSettings',
            Settings::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists notifications under a given parent.
     *
     * Sample code:
     * ```
     * $advisoryNotificationsServiceClient = new AdvisoryNotificationsServiceClient();
     * try {
     *     $formattedParent = $advisoryNotificationsServiceClient->locationName('[ORGANIZATION]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $advisoryNotificationsServiceClient->listNotifications($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $advisoryNotificationsServiceClient->listNotifications($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $advisoryNotificationsServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of notifications.
     *                             Must be of the form "organizations/{organization}/locations/{location}"
     *                             or "projects/{project}/locations/{location}".
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $view
     *           Specifies which parts of the notification resource should be returned
     *           in the response.
     *           For allowed values, use constants defined on {@see \Google\Cloud\AdvisoryNotifications\V1\NotificationView}
     *     @type string $languageCode
     *           ISO code for requested localization language.  If unset, will be
     *           interpereted as "en". If the requested language is valid, but not supported
     *           for this notification, English will be returned with an "Not applicable"
     *           LocalizationState. If the ISO code is invalid (i.e. not a real language),
     *           this RPC will throw an error.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listNotifications($parent, array $optionalArgs = [])
    {
        $request = new ListNotificationsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['view'])) {
            $request->setView($optionalArgs['view']);
        }

        if (isset($optionalArgs['languageCode'])) {
            $request->setLanguageCode($optionalArgs['languageCode']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListNotifications',
            $optionalArgs,
            ListNotificationsResponse::class,
            $request
        );
    }

    /**
     * Update notification settings.
     *
     * Sample code:
     * ```
     * $advisoryNotificationsServiceClient = new AdvisoryNotificationsServiceClient();
     * try {
     *     $settings = new Settings();
     *     $response = $advisoryNotificationsServiceClient->updateSettings($settings);
     * } finally {
     *     $advisoryNotificationsServiceClient->close();
     * }
     * ```
     *
     * @param Settings $settings     Required. New settings.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AdvisoryNotifications\V1\Settings
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSettings($settings, array $optionalArgs = [])
    {
        $request = new UpdateSettingsRequest();
        $requestParamHeaders = [];
        $request->setSettings($settings);
        $requestParamHeaders['settings.name'] = $settings->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateSettings',
            Settings::class,
            $optionalArgs,
            $request
        )->wait();
    }
}
