<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/gkebackup/v1/backup_plan.proto

namespace Google\Cloud\GkeBackup\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Defines a time window during which no backup should
 * happen. All time and date are in UTC.
 *
 * Generated from protobuf message <code>google.cloud.gkebackup.v1.ExclusionWindow</code>
 */
class ExclusionWindow extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Specifies the start time of the window using time of the day in
     * UTC.
     *
     * Generated from protobuf field <code>.google.type.TimeOfDay start_time = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $start_time = null;
    /**
     * Required. Specifies duration of the window.
     * Duration must be >= 5 minutes and < (target RPO - 20 minutes).
     * Additional restrictions based on the recurrence type to allow some time for
     * backup to happen:
     * - single_occurrence_date:  no restriction, but UI may warn about this when
     * duration >= target RPO
     * - daily window: duration < 24 hours
     * - weekly window:
     *   - days of week includes all seven days of a week: duration < 24 hours
     *   - all other weekly window: duration < 168 hours (i.e., 24 * 7 hours)
     *
     * Generated from protobuf field <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $duration = null;
    protected $recurrence;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Type\TimeOfDay $start_time
     *           Required. Specifies the start time of the window using time of the day in
     *           UTC.
     *     @type \Google\Protobuf\Duration $duration
     *           Required. Specifies duration of the window.
     *           Duration must be >= 5 minutes and < (target RPO - 20 minutes).
     *           Additional restrictions based on the recurrence type to allow some time for
     *           backup to happen:
     *           - single_occurrence_date:  no restriction, but UI may warn about this when
     *           duration >= target RPO
     *           - daily window: duration < 24 hours
     *           - weekly window:
     *             - days of week includes all seven days of a week: duration < 24 hours
     *             - all other weekly window: duration < 168 hours (i.e., 24 * 7 hours)
     *     @type \Google\Type\Date $single_occurrence_date
     *           No recurrence. The exclusion window occurs only once and on this
     *           date in UTC.
     *     @type bool $daily
     *           The exclusion window occurs every day if set to "True".
     *           Specifying this field to "False" is an error.
     *     @type \Google\Cloud\GkeBackup\V1\ExclusionWindow\DayOfWeekList $days_of_week
     *           The exclusion window occurs on these days of each week in UTC.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Gkebackup\V1\BackupPlan::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Specifies the start time of the window using time of the day in
     * UTC.
     *
     * Generated from protobuf field <code>.google.type.TimeOfDay start_time = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Type\TimeOfDay|null
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    public function hasStartTime()
    {
        return isset($this->start_time);
    }

    public function clearStartTime()
    {
        unset($this->start_time);
    }

    /**
     * Required. Specifies the start time of the window using time of the day in
     * UTC.
     *
     * Generated from protobuf field <code>.google.type.TimeOfDay start_time = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Type\TimeOfDay $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\TimeOfDay::class);
        $this->start_time = $var;

        return $this;
    }

    /**
     * Required. Specifies duration of the window.
     * Duration must be >= 5 minutes and < (target RPO - 20 minutes).
     * Additional restrictions based on the recurrence type to allow some time for
     * backup to happen:
     * - single_occurrence_date:  no restriction, but UI may warn about this when
     * duration >= target RPO
     * - daily window: duration < 24 hours
     * - weekly window:
     *   - days of week includes all seven days of a week: duration < 24 hours
     *   - all other weekly window: duration < 168 hours (i.e., 24 * 7 hours)
     *
     * Generated from protobuf field <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getDuration()
    {
        return $this->duration;
    }

    public function hasDuration()
    {
        return isset($this->duration);
    }

    public function clearDuration()
    {
        unset($this->duration);
    }

    /**
     * Required. Specifies duration of the window.
     * Duration must be >= 5 minutes and < (target RPO - 20 minutes).
     * Additional restrictions based on the recurrence type to allow some time for
     * backup to happen:
     * - single_occurrence_date:  no restriction, but UI may warn about this when
     * duration >= target RPO
     * - daily window: duration < 24 hours
     * - weekly window:
     *   - days of week includes all seven days of a week: duration < 24 hours
     *   - all other weekly window: duration < 168 hours (i.e., 24 * 7 hours)
     *
     * Generated from protobuf field <code>.google.protobuf.Duration duration = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->duration = $var;

        return $this;
    }

    /**
     * No recurrence. The exclusion window occurs only once and on this
     * date in UTC.
     *
     * Generated from protobuf field <code>.google.type.Date single_occurrence_date = 3;</code>
     * @return \Google\Type\Date|null
     */
    public function getSingleOccurrenceDate()
    {
        return $this->readOneof(3);
    }

    public function hasSingleOccurrenceDate()
    {
        return $this->hasOneof(3);
    }

    /**
     * No recurrence. The exclusion window occurs only once and on this
     * date in UTC.
     *
     * Generated from protobuf field <code>.google.type.Date single_occurrence_date = 3;</code>
     * @param \Google\Type\Date $var
     * @return $this
     */
    public function setSingleOccurrenceDate($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Date::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * The exclusion window occurs every day if set to "True".
     * Specifying this field to "False" is an error.
     *
     * Generated from protobuf field <code>bool daily = 4;</code>
     * @return bool
     */
    public function getDaily()
    {
        return $this->readOneof(4);
    }

    public function hasDaily()
    {
        return $this->hasOneof(4);
    }

    /**
     * The exclusion window occurs every day if set to "True".
     * Specifying this field to "False" is an error.
     *
     * Generated from protobuf field <code>bool daily = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setDaily($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * The exclusion window occurs on these days of each week in UTC.
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.ExclusionWindow.DayOfWeekList days_of_week = 5;</code>
     * @return \Google\Cloud\GkeBackup\V1\ExclusionWindow\DayOfWeekList|null
     */
    public function getDaysOfWeek()
    {
        return $this->readOneof(5);
    }

    public function hasDaysOfWeek()
    {
        return $this->hasOneof(5);
    }

    /**
     * The exclusion window occurs on these days of each week in UTC.
     *
     * Generated from protobuf field <code>.google.cloud.gkebackup.v1.ExclusionWindow.DayOfWeekList days_of_week = 5;</code>
     * @param \Google\Cloud\GkeBackup\V1\ExclusionWindow\DayOfWeekList $var
     * @return $this
     */
    public function setDaysOfWeek($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\GkeBackup\V1\ExclusionWindow\DayOfWeekList::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getRecurrence()
    {
        return $this->whichOneof("recurrence");
    }

}

