<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/edgenetwork/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\EdgeNetwork\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\EdgeNetwork\V1\CreateInterconnectAttachmentRequest;
use Google\Cloud\EdgeNetwork\V1\CreateNetworkRequest;
use Google\Cloud\EdgeNetwork\V1\CreateRouterRequest;
use Google\Cloud\EdgeNetwork\V1\CreateSubnetRequest;
use Google\Cloud\EdgeNetwork\V1\DeleteInterconnectAttachmentRequest;
use Google\Cloud\EdgeNetwork\V1\DeleteNetworkRequest;
use Google\Cloud\EdgeNetwork\V1\DeleteRouterRequest;
use Google\Cloud\EdgeNetwork\V1\DeleteSubnetRequest;
use Google\Cloud\EdgeNetwork\V1\DiagnoseInterconnectRequest;
use Google\Cloud\EdgeNetwork\V1\DiagnoseInterconnectResponse;
use Google\Cloud\EdgeNetwork\V1\DiagnoseNetworkRequest;
use Google\Cloud\EdgeNetwork\V1\DiagnoseNetworkResponse;
use Google\Cloud\EdgeNetwork\V1\DiagnoseRouterRequest;
use Google\Cloud\EdgeNetwork\V1\DiagnoseRouterResponse;
use Google\Cloud\EdgeNetwork\V1\GetInterconnectAttachmentRequest;
use Google\Cloud\EdgeNetwork\V1\GetInterconnectRequest;
use Google\Cloud\EdgeNetwork\V1\GetNetworkRequest;
use Google\Cloud\EdgeNetwork\V1\GetRouterRequest;
use Google\Cloud\EdgeNetwork\V1\GetSubnetRequest;
use Google\Cloud\EdgeNetwork\V1\GetZoneRequest;
use Google\Cloud\EdgeNetwork\V1\InitializeZoneRequest;
use Google\Cloud\EdgeNetwork\V1\InitializeZoneResponse;
use Google\Cloud\EdgeNetwork\V1\Interconnect;
use Google\Cloud\EdgeNetwork\V1\InterconnectAttachment;
use Google\Cloud\EdgeNetwork\V1\ListInterconnectAttachmentsRequest;
use Google\Cloud\EdgeNetwork\V1\ListInterconnectsRequest;
use Google\Cloud\EdgeNetwork\V1\ListNetworksRequest;
use Google\Cloud\EdgeNetwork\V1\ListRoutersRequest;
use Google\Cloud\EdgeNetwork\V1\ListSubnetsRequest;
use Google\Cloud\EdgeNetwork\V1\ListZonesRequest;
use Google\Cloud\EdgeNetwork\V1\Network;
use Google\Cloud\EdgeNetwork\V1\Router;
use Google\Cloud\EdgeNetwork\V1\Subnet;
use Google\Cloud\EdgeNetwork\V1\UpdateRouterRequest;
use Google\Cloud\EdgeNetwork\V1\UpdateSubnetRequest;
use Google\Cloud\EdgeNetwork\V1\Zone;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: EdgeNetwork API provides managed, highly available cloud dynamic network
 * configuration service to the GEC customer to enable edge application and
 * network function solutions. This allows the customers to easily define and
 * configure the network setup and property to meet the workload requirement.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface createInterconnectAttachmentAsync(CreateInterconnectAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createNetworkAsync(CreateNetworkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createRouterAsync(CreateRouterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSubnetAsync(CreateSubnetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteInterconnectAttachmentAsync(DeleteInterconnectAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteNetworkAsync(DeleteNetworkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteRouterAsync(DeleteRouterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteSubnetAsync(DeleteSubnetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface diagnoseInterconnectAsync(DiagnoseInterconnectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface diagnoseNetworkAsync(DiagnoseNetworkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface diagnoseRouterAsync(DiagnoseRouterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getInterconnectAsync(GetInterconnectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getInterconnectAttachmentAsync(GetInterconnectAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getNetworkAsync(GetNetworkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getRouterAsync(GetRouterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSubnetAsync(GetSubnetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getZoneAsync(GetZoneRequest $request, array $optionalArgs = [])
 * @method PromiseInterface initializeZoneAsync(InitializeZoneRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listInterconnectAttachmentsAsync(ListInterconnectAttachmentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listInterconnectsAsync(ListInterconnectsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listNetworksAsync(ListNetworksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listRoutersAsync(ListRoutersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSubnetsAsync(ListSubnetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listZonesAsync(ListZonesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateRouterAsync(UpdateRouterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSubnetAsync(UpdateSubnetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class EdgeNetworkClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.edgenetwork.v1.EdgeNetwork';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'edgenetwork.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'edgenetwork.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/edge_network_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/edge_network_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/edge_network_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/edge_network_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a interconnect
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $zone
     * @param string $interconnect
     *
     * @return string The formatted interconnect resource.
     */
    public static function interconnectName(
        string $project,
        string $location,
        string $zone,
        string $interconnect
    ): string {
        return self::getPathTemplate('interconnect')->render([
            'project' => $project,
            'location' => $location,
            'zone' => $zone,
            'interconnect' => $interconnect,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * interconnect_attachment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $zone
     * @param string $interconnectAttachment
     *
     * @return string The formatted interconnect_attachment resource.
     */
    public static function interconnectAttachmentName(
        string $project,
        string $location,
        string $zone,
        string $interconnectAttachment
    ): string {
        return self::getPathTemplate('interconnectAttachment')->render([
            'project' => $project,
            'location' => $location,
            'zone' => $zone,
            'interconnect_attachment' => $interconnectAttachment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $zone
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName(string $project, string $location, string $zone, string $network): string
    {
        return self::getPathTemplate('network')->render([
            'project' => $project,
            'location' => $location,
            'zone' => $zone,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a router
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $zone
     * @param string $router
     *
     * @return string The formatted router resource.
     */
    public static function routerName(string $project, string $location, string $zone, string $router): string
    {
        return self::getPathTemplate('router')->render([
            'project' => $project,
            'location' => $location,
            'zone' => $zone,
            'router' => $router,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a subnet
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $zone
     * @param string $subnet
     *
     * @return string The formatted subnet resource.
     */
    public static function subnetName(string $project, string $location, string $zone, string $subnet): string
    {
        return self::getPathTemplate('subnet')->render([
            'project' => $project,
            'location' => $location,
            'zone' => $zone,
            'subnet' => $subnet,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a zone
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $zone
     *
     * @return string The formatted zone resource.
     */
    public static function zoneName(string $project, string $location, string $zone): string
    {
        return self::getPathTemplate('zone')->render([
            'project' => $project,
            'location' => $location,
            'zone' => $zone,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - interconnect: projects/{project}/locations/{location}/zones/{zone}/interconnects/{interconnect}
     * - interconnectAttachment: projects/{project}/locations/{location}/zones/{zone}/interconnectAttachments/{interconnect_attachment}
     * - location: projects/{project}/locations/{location}
     * - network: projects/{project}/locations/{location}/zones/{zone}/networks/{network}
     * - router: projects/{project}/locations/{location}/zones/{zone}/routers/{router}
     * - subnet: projects/{project}/locations/{location}/zones/{zone}/subnets/{subnet}
     * - zone: projects/{project}/locations/{location}/zones/{zone}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'edgenetwork.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new InterconnectAttachment in a given project and location.
     *
     * The async variant is
     * {@see EdgeNetworkClient::createInterconnectAttachmentAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/create_interconnect_attachment.php
     *
     * @param CreateInterconnectAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createInterconnectAttachment(
        CreateInterconnectAttachmentRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateInterconnectAttachment', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Network in a given project and location.
     *
     * The async variant is {@see EdgeNetworkClient::createNetworkAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/create_network.php
     *
     * @param CreateNetworkRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createNetwork(CreateNetworkRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateNetwork', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Router in a given project and location.
     *
     * The async variant is {@see EdgeNetworkClient::createRouterAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/create_router.php
     *
     * @param CreateRouterRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRouter(CreateRouterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateRouter', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Subnet in a given project and location.
     *
     * The async variant is {@see EdgeNetworkClient::createSubnetAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/create_subnet.php
     *
     * @param CreateSubnetRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSubnet(CreateSubnetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateSubnet', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single InterconnectAttachment.
     *
     * The async variant is
     * {@see EdgeNetworkClient::deleteInterconnectAttachmentAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/delete_interconnect_attachment.php
     *
     * @param DeleteInterconnectAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteInterconnectAttachment(
        DeleteInterconnectAttachmentRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteInterconnectAttachment', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Network.
     *
     * The async variant is {@see EdgeNetworkClient::deleteNetworkAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/delete_network.php
     *
     * @param DeleteNetworkRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteNetwork(DeleteNetworkRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteNetwork', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Router.
     *
     * The async variant is {@see EdgeNetworkClient::deleteRouterAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/delete_router.php
     *
     * @param DeleteRouterRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteRouter(DeleteRouterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteRouter', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Subnet.
     *
     * The async variant is {@see EdgeNetworkClient::deleteSubnetAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/delete_subnet.php
     *
     * @param DeleteSubnetRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSubnet(DeleteSubnetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteSubnet', $request, $callOptions)->wait();
    }

    /**
     * Get the diagnostics of a single interconnect resource.
     *
     * The async variant is {@see EdgeNetworkClient::diagnoseInterconnectAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/diagnose_interconnect.php
     *
     * @param DiagnoseInterconnectRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DiagnoseInterconnectResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function diagnoseInterconnect(
        DiagnoseInterconnectRequest $request,
        array $callOptions = []
    ): DiagnoseInterconnectResponse {
        return $this->startApiCall('DiagnoseInterconnect', $request, $callOptions)->wait();
    }

    /**
     * Get the diagnostics of a single network resource.
     *
     * The async variant is {@see EdgeNetworkClient::diagnoseNetworkAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/diagnose_network.php
     *
     * @param DiagnoseNetworkRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DiagnoseNetworkResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function diagnoseNetwork(DiagnoseNetworkRequest $request, array $callOptions = []): DiagnoseNetworkResponse
    {
        return $this->startApiCall('DiagnoseNetwork', $request, $callOptions)->wait();
    }

    /**
     * Get the diagnostics of a single router resource.
     *
     * The async variant is {@see EdgeNetworkClient::diagnoseRouterAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/diagnose_router.php
     *
     * @param DiagnoseRouterRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DiagnoseRouterResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function diagnoseRouter(DiagnoseRouterRequest $request, array $callOptions = []): DiagnoseRouterResponse
    {
        return $this->startApiCall('DiagnoseRouter', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Interconnect.
     *
     * The async variant is {@see EdgeNetworkClient::getInterconnectAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/get_interconnect.php
     *
     * @param GetInterconnectRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Interconnect
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getInterconnect(GetInterconnectRequest $request, array $callOptions = []): Interconnect
    {
        return $this->startApiCall('GetInterconnect', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single InterconnectAttachment.
     *
     * The async variant is {@see EdgeNetworkClient::getInterconnectAttachmentAsync()}
     * .
     *
     * @example samples/V1/EdgeNetworkClient/get_interconnect_attachment.php
     *
     * @param GetInterconnectAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InterconnectAttachment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getInterconnectAttachment(
        GetInterconnectAttachmentRequest $request,
        array $callOptions = []
    ): InterconnectAttachment {
        return $this->startApiCall('GetInterconnectAttachment', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Network.
     *
     * The async variant is {@see EdgeNetworkClient::getNetworkAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/get_network.php
     *
     * @param GetNetworkRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Network
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getNetwork(GetNetworkRequest $request, array $callOptions = []): Network
    {
        return $this->startApiCall('GetNetwork', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Router.
     *
     * The async variant is {@see EdgeNetworkClient::getRouterAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/get_router.php
     *
     * @param GetRouterRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Router
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRouter(GetRouterRequest $request, array $callOptions = []): Router
    {
        return $this->startApiCall('GetRouter', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Subnet.
     *
     * The async variant is {@see EdgeNetworkClient::getSubnetAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/get_subnet.php
     *
     * @param GetSubnetRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Subnet
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSubnet(GetSubnetRequest $request, array $callOptions = []): Subnet
    {
        return $this->startApiCall('GetSubnet', $request, $callOptions)->wait();
    }

    /**
     * Deprecated: not implemented.
     * Gets details of a single Zone.
     *
     * The async variant is {@see EdgeNetworkClient::getZoneAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/get_zone.php
     *
     * @param GetZoneRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Zone
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function getZone(GetZoneRequest $request, array $callOptions = []): Zone
    {
        return $this->startApiCall('GetZone', $request, $callOptions)->wait();
    }

    /**
     * InitializeZone will initialize resources for a zone in a project.
     *
     * The async variant is {@see EdgeNetworkClient::initializeZoneAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/initialize_zone.php
     *
     * @param InitializeZoneRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InitializeZoneResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function initializeZone(InitializeZoneRequest $request, array $callOptions = []): InitializeZoneResponse
    {
        return $this->startApiCall('InitializeZone', $request, $callOptions)->wait();
    }

    /**
     * Lists InterconnectAttachments in a given project and location.
     *
     * The async variant is
     * {@see EdgeNetworkClient::listInterconnectAttachmentsAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/list_interconnect_attachments.php
     *
     * @param ListInterconnectAttachmentsRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listInterconnectAttachments(
        ListInterconnectAttachmentsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListInterconnectAttachments', $request, $callOptions);
    }

    /**
     * Lists Interconnects in a given project and location.
     *
     * The async variant is {@see EdgeNetworkClient::listInterconnectsAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/list_interconnects.php
     *
     * @param ListInterconnectsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listInterconnects(ListInterconnectsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListInterconnects', $request, $callOptions);
    }

    /**
     * Lists Networks in a given project and location.
     *
     * The async variant is {@see EdgeNetworkClient::listNetworksAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/list_networks.php
     *
     * @param ListNetworksRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listNetworks(ListNetworksRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListNetworks', $request, $callOptions);
    }

    /**
     * Lists Routers in a given project and location.
     *
     * The async variant is {@see EdgeNetworkClient::listRoutersAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/list_routers.php
     *
     * @param ListRoutersRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRouters(ListRoutersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRouters', $request, $callOptions);
    }

    /**
     * Lists Subnets in a given project and location.
     *
     * The async variant is {@see EdgeNetworkClient::listSubnetsAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/list_subnets.php
     *
     * @param ListSubnetsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSubnets(ListSubnetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSubnets', $request, $callOptions);
    }

    /**
     * Deprecated: not implemented.
     * Lists Zones in a given project and location.
     *
     * The async variant is {@see EdgeNetworkClient::listZonesAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/list_zones.php
     *
     * @param ListZonesRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     *
     * @deprecated This method will be removed in the next major version update.
     */
    public function listZones(ListZonesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListZones', $request, $callOptions);
    }

    /**
     * Updates the parameters of a single Router.
     *
     * The async variant is {@see EdgeNetworkClient::updateRouterAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/update_router.php
     *
     * @param UpdateRouterRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateRouter(UpdateRouterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateRouter', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Subnet.
     *
     * The async variant is {@see EdgeNetworkClient::updateSubnetAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/update_subnet.php
     *
     * @param UpdateSubnetRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSubnet(UpdateSubnetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateSubnet', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see EdgeNetworkClient::getLocationAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see EdgeNetworkClient::listLocationsAsync()} .
     *
     * @example samples/V1/EdgeNetworkClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
