<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/developerconnect/v1/developer_connect.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\DeveloperConnect\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\DeveloperConnect\V1\Connection;
use Google\Cloud\DeveloperConnect\V1\CreateConnectionRequest;
use Google\Cloud\DeveloperConnect\V1\CreateGitRepositoryLinkRequest;
use Google\Cloud\DeveloperConnect\V1\DeleteConnectionRequest;
use Google\Cloud\DeveloperConnect\V1\DeleteGitRepositoryLinkRequest;
use Google\Cloud\DeveloperConnect\V1\FetchGitHubInstallationsRequest;
use Google\Cloud\DeveloperConnect\V1\FetchGitHubInstallationsResponse;
use Google\Cloud\DeveloperConnect\V1\FetchGitRefsRequest;
use Google\Cloud\DeveloperConnect\V1\FetchLinkableGitRepositoriesRequest;
use Google\Cloud\DeveloperConnect\V1\FetchReadTokenRequest;
use Google\Cloud\DeveloperConnect\V1\FetchReadTokenResponse;
use Google\Cloud\DeveloperConnect\V1\FetchReadWriteTokenRequest;
use Google\Cloud\DeveloperConnect\V1\FetchReadWriteTokenResponse;
use Google\Cloud\DeveloperConnect\V1\GetConnectionRequest;
use Google\Cloud\DeveloperConnect\V1\GetGitRepositoryLinkRequest;
use Google\Cloud\DeveloperConnect\V1\GitRepositoryLink;
use Google\Cloud\DeveloperConnect\V1\ListConnectionsRequest;
use Google\Cloud\DeveloperConnect\V1\ListGitRepositoryLinksRequest;
use Google\Cloud\DeveloperConnect\V1\UpdateConnectionRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Service describing handlers for resources
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface createConnectionAsync(CreateConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createGitRepositoryLinkAsync(CreateGitRepositoryLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteConnectionAsync(DeleteConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteGitRepositoryLinkAsync(DeleteGitRepositoryLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface fetchGitHubInstallationsAsync(FetchGitHubInstallationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface fetchGitRefsAsync(FetchGitRefsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface fetchLinkableGitRepositoriesAsync(FetchLinkableGitRepositoriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface fetchReadTokenAsync(FetchReadTokenRequest $request, array $optionalArgs = [])
 * @method PromiseInterface fetchReadWriteTokenAsync(FetchReadWriteTokenRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getConnectionAsync(GetConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getGitRepositoryLinkAsync(GetGitRepositoryLinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listConnectionsAsync(ListConnectionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listGitRepositoryLinksAsync(ListGitRepositoryLinksRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateConnectionAsync(UpdateConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class DeveloperConnectClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.developerconnect.v1.DeveloperConnect';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'developerconnect.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'developerconnect.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/developer_connect_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/developer_connect_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/developer_connect_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/developer_connect_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a connection
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $connection
     *
     * @return string The formatted connection resource.
     */
    public static function connectionName(string $project, string $location, string $connection): string
    {
        return self::getPathTemplate('connection')->render([
            'project' => $project,
            'location' => $location,
            'connection' => $connection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * git_repository_link resource.
     *
     * @param string $project
     * @param string $location
     * @param string $connection
     * @param string $gitRepositoryLink
     *
     * @return string The formatted git_repository_link resource.
     */
    public static function gitRepositoryLinkName(
        string $project,
        string $location,
        string $connection,
        string $gitRepositoryLink
    ): string {
        return self::getPathTemplate('gitRepositoryLink')->render([
            'project' => $project,
            'location' => $location,
            'connection' => $connection,
            'git_repository_link' => $gitRepositoryLink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * secret_version resource.
     *
     * @param string $project
     * @param string $secret
     * @param string $secretVersion
     *
     * @return string The formatted secret_version resource.
     */
    public static function secretVersionName(string $project, string $secret, string $secretVersion): string
    {
        return self::getPathTemplate('secretVersion')->render([
            'project' => $project,
            'secret' => $secret,
            'secret_version' => $secretVersion,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - connection: projects/{project}/locations/{location}/connections/{connection}
     * - gitRepositoryLink: projects/{project}/locations/{location}/connections/{connection}/gitRepositoryLinks/{git_repository_link}
     * - location: projects/{project}/locations/{location}
     * - secretVersion: projects/{project}/secrets/{secret}/versions/{secret_version}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'developerconnect.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new Connection in a given project and location.
     *
     * The async variant is {@see DeveloperConnectClient::createConnectionAsync()} .
     *
     * @example samples/V1/DeveloperConnectClient/create_connection.php
     *
     * @param CreateConnectionRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createConnection(CreateConnectionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateConnection', $request, $callOptions)->wait();
    }

    /**
     * Creates a GitRepositoryLink. Upon linking a Git Repository, Developer
     * Connect will configure the Git Repository to send webhook events to
     * Developer Connect. Connections that use Firebase GitHub Application will
     * have events forwarded to the Firebase service. All other Connections will
     * have events forwarded to Cloud Build.
     *
     * The async variant is
     * {@see DeveloperConnectClient::createGitRepositoryLinkAsync()} .
     *
     * @example samples/V1/DeveloperConnectClient/create_git_repository_link.php
     *
     * @param CreateGitRepositoryLinkRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createGitRepositoryLink(
        CreateGitRepositoryLinkRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateGitRepositoryLink', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Connection.
     *
     * The async variant is {@see DeveloperConnectClient::deleteConnectionAsync()} .
     *
     * @example samples/V1/DeveloperConnectClient/delete_connection.php
     *
     * @param DeleteConnectionRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteConnection(DeleteConnectionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteConnection', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single GitRepositoryLink.
     *
     * The async variant is
     * {@see DeveloperConnectClient::deleteGitRepositoryLinkAsync()} .
     *
     * @example samples/V1/DeveloperConnectClient/delete_git_repository_link.php
     *
     * @param DeleteGitRepositoryLinkRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteGitRepositoryLink(
        DeleteGitRepositoryLinkRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteGitRepositoryLink', $request, $callOptions)->wait();
    }

    /**
     * FetchGitHubInstallations returns the list of GitHub Installations that
     * are available to be added to a Connection.
     * For github.com, only installations accessible to the authorizer token
     * are returned. For GitHub Enterprise, all installations are returned.
     *
     * The async variant is
     * {@see DeveloperConnectClient::fetchGitHubInstallationsAsync()} .
     *
     * @example samples/V1/DeveloperConnectClient/fetch_git_hub_installations.php
     *
     * @param FetchGitHubInstallationsRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchGitHubInstallationsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchGitHubInstallations(
        FetchGitHubInstallationsRequest $request,
        array $callOptions = []
    ): FetchGitHubInstallationsResponse {
        return $this->startApiCall('FetchGitHubInstallations', $request, $callOptions)->wait();
    }

    /**
     * Fetch the list of branches or tags for a given repository.
     *
     * The async variant is {@see DeveloperConnectClient::fetchGitRefsAsync()} .
     *
     * @example samples/V1/DeveloperConnectClient/fetch_git_refs.php
     *
     * @param FetchGitRefsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchGitRefs(FetchGitRefsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('FetchGitRefs', $request, $callOptions);
    }

    /**
     * FetchLinkableGitRepositories returns a list of git repositories from an SCM
     * that are available to be added to a Connection.
     *
     * The async variant is
     * {@see DeveloperConnectClient::fetchLinkableGitRepositoriesAsync()} .
     *
     * @example samples/V1/DeveloperConnectClient/fetch_linkable_git_repositories.php
     *
     * @param FetchLinkableGitRepositoriesRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchLinkableGitRepositories(
        FetchLinkableGitRepositoriesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('FetchLinkableGitRepositories', $request, $callOptions);
    }

    /**
     * Fetches read token of a given gitRepositoryLink.
     *
     * The async variant is {@see DeveloperConnectClient::fetchReadTokenAsync()} .
     *
     * @example samples/V1/DeveloperConnectClient/fetch_read_token.php
     *
     * @param FetchReadTokenRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchReadTokenResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchReadToken(FetchReadTokenRequest $request, array $callOptions = []): FetchReadTokenResponse
    {
        return $this->startApiCall('FetchReadToken', $request, $callOptions)->wait();
    }

    /**
     * Fetches read/write token of a given gitRepositoryLink.
     *
     * The async variant is {@see DeveloperConnectClient::fetchReadWriteTokenAsync()} .
     *
     * @example samples/V1/DeveloperConnectClient/fetch_read_write_token.php
     *
     * @param FetchReadWriteTokenRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FetchReadWriteTokenResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchReadWriteToken(
        FetchReadWriteTokenRequest $request,
        array $callOptions = []
    ): FetchReadWriteTokenResponse {
        return $this->startApiCall('FetchReadWriteToken', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Connection.
     *
     * The async variant is {@see DeveloperConnectClient::getConnectionAsync()} .
     *
     * @example samples/V1/DeveloperConnectClient/get_connection.php
     *
     * @param GetConnectionRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Connection
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getConnection(GetConnectionRequest $request, array $callOptions = []): Connection
    {
        return $this->startApiCall('GetConnection', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single GitRepositoryLink.
     *
     * The async variant is {@see DeveloperConnectClient::getGitRepositoryLinkAsync()}
     * .
     *
     * @example samples/V1/DeveloperConnectClient/get_git_repository_link.php
     *
     * @param GetGitRepositoryLinkRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GitRepositoryLink
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGitRepositoryLink(
        GetGitRepositoryLinkRequest $request,
        array $callOptions = []
    ): GitRepositoryLink {
        return $this->startApiCall('GetGitRepositoryLink', $request, $callOptions)->wait();
    }

    /**
     * Lists Connections in a given project and location.
     *
     * The async variant is {@see DeveloperConnectClient::listConnectionsAsync()} .
     *
     * @example samples/V1/DeveloperConnectClient/list_connections.php
     *
     * @param ListConnectionsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listConnections(ListConnectionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListConnections', $request, $callOptions);
    }

    /**
     * Lists GitRepositoryLinks in a given project, location, and connection.
     *
     * The async variant is
     * {@see DeveloperConnectClient::listGitRepositoryLinksAsync()} .
     *
     * @example samples/V1/DeveloperConnectClient/list_git_repository_links.php
     *
     * @param ListGitRepositoryLinksRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listGitRepositoryLinks(
        ListGitRepositoryLinksRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListGitRepositoryLinks', $request, $callOptions);
    }

    /**
     * Updates the parameters of a single Connection.
     *
     * The async variant is {@see DeveloperConnectClient::updateConnectionAsync()} .
     *
     * @example samples/V1/DeveloperConnectClient/update_connection.php
     *
     * @param UpdateConnectionRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateConnection(UpdateConnectionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateConnection', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see DeveloperConnectClient::getLocationAsync()} .
     *
     * @example samples/V1/DeveloperConnectClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see DeveloperConnectClient::listLocationsAsync()} .
     *
     * @example samples/V1/DeveloperConnectClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
