<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/type.proto

namespace Google\Cloud\Spanner\V1;

use UnexpectedValueException;

/**
 * `TypeAnnotationCode` is used as a part of [Type][google.spanner.v1.Type] to
 * disambiguate SQL types that should be used for a given Cloud Spanner value.
 * Disambiguation is needed because the same Cloud Spanner type can be mapped to
 * different SQL types depending on SQL dialect. TypeAnnotationCode doesn't
 * affect the way value is serialized.
 *
 * Protobuf type <code>google.spanner.v1.TypeAnnotationCode</code>
 */
class TypeAnnotationCode
{
    /**
     * Not specified.
     *
     * Generated from protobuf enum <code>TYPE_ANNOTATION_CODE_UNSPECIFIED = 0;</code>
     */
    const TYPE_ANNOTATION_CODE_UNSPECIFIED = 0;
    /**
     * PostgreSQL compatible NUMERIC type. This annotation needs to be applied to
     * [Type][google.spanner.v1.Type] instances having [NUMERIC][google.spanner.v1.TypeCode.NUMERIC]
     * type code to specify that values of this type should be treated as
     * PostgreSQL NUMERIC values. Currently this annotation is always needed for
     * [NUMERIC][google.spanner.v1.TypeCode.NUMERIC] when a client interacts with PostgreSQL-enabled
     * Spanner databases.
     *
     * Generated from protobuf enum <code>PG_NUMERIC = 2;</code>
     */
    const PG_NUMERIC = 2;
    /**
     * PostgreSQL compatible JSONB type. This annotation needs to be applied to
     * [Type][google.spanner.v1.Type] instances having [JSON][google.spanner.v1.TypeCode.JSON]
     * type code to specify that values of this type should be treated as
     * PostgreSQL JSONB values. Currently this annotation is always needed for
     * [JSON][google.spanner.v1.TypeCode.JSON] when a client interacts with PostgreSQL-enabled
     * Spanner databases.
     *
     * Generated from protobuf enum <code>PG_JSONB = 3;</code>
     */
    const PG_JSONB = 3;
    /**
     * PostgreSQL compatible OID type. This annotation can be used by a client
     * interacting with PostgreSQL-enabled Spanner database to specify that a
     * value should be treated using the semantics of the OID type.
     *
     * Generated from protobuf enum <code>PG_OID = 4;</code>
     */
    const PG_OID = 4;

    private static $valueToName = [
        self::TYPE_ANNOTATION_CODE_UNSPECIFIED => 'TYPE_ANNOTATION_CODE_UNSPECIFIED',
        self::PG_NUMERIC => 'PG_NUMERIC',
        self::PG_JSONB => 'PG_JSONB',
        self::PG_OID => 'PG_OID',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}

