<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/certificatemanager/v1/certificate_manager.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\CertificateManager\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\CertificateManager\V1\Certificate;
use Google\Cloud\CertificateManager\V1\CertificateIssuanceConfig;
use Google\Cloud\CertificateManager\V1\CertificateMap;
use Google\Cloud\CertificateManager\V1\CertificateMapEntry;
use Google\Cloud\CertificateManager\V1\CreateCertificateIssuanceConfigRequest;
use Google\Cloud\CertificateManager\V1\CreateCertificateMapEntryRequest;
use Google\Cloud\CertificateManager\V1\CreateCertificateMapRequest;
use Google\Cloud\CertificateManager\V1\CreateCertificateRequest;
use Google\Cloud\CertificateManager\V1\CreateDnsAuthorizationRequest;
use Google\Cloud\CertificateManager\V1\DeleteCertificateIssuanceConfigRequest;
use Google\Cloud\CertificateManager\V1\DeleteCertificateMapEntryRequest;
use Google\Cloud\CertificateManager\V1\DeleteCertificateMapRequest;
use Google\Cloud\CertificateManager\V1\DeleteCertificateRequest;
use Google\Cloud\CertificateManager\V1\DeleteDnsAuthorizationRequest;
use Google\Cloud\CertificateManager\V1\DnsAuthorization;
use Google\Cloud\CertificateManager\V1\GetCertificateIssuanceConfigRequest;
use Google\Cloud\CertificateManager\V1\GetCertificateMapEntryRequest;
use Google\Cloud\CertificateManager\V1\GetCertificateMapRequest;
use Google\Cloud\CertificateManager\V1\GetCertificateRequest;
use Google\Cloud\CertificateManager\V1\GetDnsAuthorizationRequest;
use Google\Cloud\CertificateManager\V1\ListCertificateIssuanceConfigsRequest;
use Google\Cloud\CertificateManager\V1\ListCertificateMapEntriesRequest;
use Google\Cloud\CertificateManager\V1\ListCertificateMapsRequest;
use Google\Cloud\CertificateManager\V1\ListCertificatesRequest;
use Google\Cloud\CertificateManager\V1\ListDnsAuthorizationsRequest;
use Google\Cloud\CertificateManager\V1\UpdateCertificateMapEntryRequest;
use Google\Cloud\CertificateManager\V1\UpdateCertificateMapRequest;
use Google\Cloud\CertificateManager\V1\UpdateCertificateRequest;
use Google\Cloud\CertificateManager\V1\UpdateDnsAuthorizationRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: API Overview
 *
 * Certificates Manager API allows customers to see and manage all their TLS
 * certificates.
 *
 * Certificates Manager API service provides methods to manage certificates,
 * group them into collections, and create serving configuration that can be
 * easily applied to other Cloud resources e.g. Target Proxies.
 *
 * Data Model
 *
 * The Certificates Manager service exposes the following resources:
 *
 * * `Certificate` that describes a single TLS certificate.
 * * `CertificateMap` that describes a collection of certificates that can be
 * attached to a target resource.
 * * `CertificateMapEntry` that describes a single configuration entry that
 * consists of a SNI and a group of certificates. It's a subresource of
 * CertificateMap.
 *
 * Certificate, CertificateMap and CertificateMapEntry IDs
 * have to fully match the regexp `[a-z0-9-]{1,63}`. In other words,
 * - only lower case letters, digits, and hyphen are allowed
 * - length of the resource ID has to be in [1,63] range.
 *
 * Provides methods to manage Cloud Certificate Manager entities.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface createCertificateAsync(CreateCertificateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createCertificateIssuanceConfigAsync(CreateCertificateIssuanceConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createCertificateMapAsync(CreateCertificateMapRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createCertificateMapEntryAsync(CreateCertificateMapEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createDnsAuthorizationAsync(CreateDnsAuthorizationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteCertificateAsync(DeleteCertificateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteCertificateIssuanceConfigAsync(DeleteCertificateIssuanceConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteCertificateMapAsync(DeleteCertificateMapRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteCertificateMapEntryAsync(DeleteCertificateMapEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteDnsAuthorizationAsync(DeleteDnsAuthorizationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCertificateAsync(GetCertificateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCertificateIssuanceConfigAsync(GetCertificateIssuanceConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCertificateMapAsync(GetCertificateMapRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getCertificateMapEntryAsync(GetCertificateMapEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDnsAuthorizationAsync(GetDnsAuthorizationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCertificateIssuanceConfigsAsync(ListCertificateIssuanceConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCertificateMapEntriesAsync(ListCertificateMapEntriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCertificateMapsAsync(ListCertificateMapsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listCertificatesAsync(ListCertificatesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDnsAuthorizationsAsync(ListDnsAuthorizationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCertificateAsync(UpdateCertificateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCertificateMapAsync(UpdateCertificateMapRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateCertificateMapEntryAsync(UpdateCertificateMapEntryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateDnsAuthorizationAsync(UpdateDnsAuthorizationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class CertificateManagerClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.certificatemanager.v1.CertificateManager';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'certificatemanager.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'certificatemanager.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/certificate_manager_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/certificate_manager_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/certificate_manager_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/certificate_manager_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a ca_pool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $caPool
     *
     * @return string The formatted ca_pool resource.
     */
    public static function caPoolName(string $project, string $location, string $caPool): string
    {
        return self::getPathTemplate('caPool')->render([
            'project' => $project,
            'location' => $location,
            'ca_pool' => $caPool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a certificate
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $certificate
     *
     * @return string The formatted certificate resource.
     */
    public static function certificateName(string $project, string $location, string $certificate): string
    {
        return self::getPathTemplate('certificate')->render([
            'project' => $project,
            'location' => $location,
            'certificate' => $certificate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * certificate_issuance_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $certificateIssuanceConfig
     *
     * @return string The formatted certificate_issuance_config resource.
     */
    public static function certificateIssuanceConfigName(string $project, string $location, string $certificateIssuanceConfig): string
    {
        return self::getPathTemplate('certificateIssuanceConfig')->render([
            'project' => $project,
            'location' => $location,
            'certificate_issuance_config' => $certificateIssuanceConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * certificate_map resource.
     *
     * @param string $project
     * @param string $location
     * @param string $certificateMap
     *
     * @return string The formatted certificate_map resource.
     */
    public static function certificateMapName(string $project, string $location, string $certificateMap): string
    {
        return self::getPathTemplate('certificateMap')->render([
            'project' => $project,
            'location' => $location,
            'certificate_map' => $certificateMap,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * certificate_map_entry resource.
     *
     * @param string $project
     * @param string $location
     * @param string $certificateMap
     * @param string $certificateMapEntry
     *
     * @return string The formatted certificate_map_entry resource.
     */
    public static function certificateMapEntryName(string $project, string $location, string $certificateMap, string $certificateMapEntry): string
    {
        return self::getPathTemplate('certificateMapEntry')->render([
            'project' => $project,
            'location' => $location,
            'certificate_map' => $certificateMap,
            'certificate_map_entry' => $certificateMapEntry,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * dns_authorization resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dnsAuthorization
     *
     * @return string The formatted dns_authorization resource.
     */
    public static function dnsAuthorizationName(string $project, string $location, string $dnsAuthorization): string
    {
        return self::getPathTemplate('dnsAuthorization')->render([
            'project' => $project,
            'location' => $location,
            'dns_authorization' => $dnsAuthorization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - caPool: projects/{project}/locations/{location}/caPools/{ca_pool}
     * - certificate: projects/{project}/locations/{location}/certificates/{certificate}
     * - certificateIssuanceConfig: projects/{project}/locations/{location}/certificateIssuanceConfigs/{certificate_issuance_config}
     * - certificateMap: projects/{project}/locations/{location}/certificateMaps/{certificate_map}
     * - certificateMapEntry: projects/{project}/locations/{location}/certificateMaps/{certificate_map}/certificateMapEntries/{certificate_map_entry}
     * - dnsAuthorization: projects/{project}/locations/{location}/dnsAuthorizations/{dns_authorization}
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'certificatemanager.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a new Certificate in a given project and location.
     *
     * The async variant is {@see CertificateManagerClient::createCertificateAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/create_certificate.php
     *
     * @param CreateCertificateRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCertificate(CreateCertificateRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateCertificate', $request, $callOptions)->wait();
    }

    /**
     * Creates a new CertificateIssuanceConfig in a given project and location.
     *
     * The async variant is
     * {@see CertificateManagerClient::createCertificateIssuanceConfigAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/create_certificate_issuance_config.php
     *
     * @param CreateCertificateIssuanceConfigRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCertificateIssuanceConfig(CreateCertificateIssuanceConfigRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateCertificateIssuanceConfig', $request, $callOptions)->wait();
    }

    /**
     * Creates a new CertificateMap in a given project and location.
     *
     * The async variant is
     * {@see CertificateManagerClient::createCertificateMapAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/create_certificate_map.php
     *
     * @param CreateCertificateMapRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCertificateMap(CreateCertificateMapRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateCertificateMap', $request, $callOptions)->wait();
    }

    /**
     * Creates a new CertificateMapEntry in a given project and location.
     *
     * The async variant is
     * {@see CertificateManagerClient::createCertificateMapEntryAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/create_certificate_map_entry.php
     *
     * @param CreateCertificateMapEntryRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCertificateMapEntry(CreateCertificateMapEntryRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateCertificateMapEntry', $request, $callOptions)->wait();
    }

    /**
     * Creates a new DnsAuthorization in a given project and location.
     *
     * The async variant is
     * {@see CertificateManagerClient::createDnsAuthorizationAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/create_dns_authorization.php
     *
     * @param CreateDnsAuthorizationRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDnsAuthorization(CreateDnsAuthorizationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateDnsAuthorization', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Certificate.
     *
     * The async variant is {@see CertificateManagerClient::deleteCertificateAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/delete_certificate.php
     *
     * @param DeleteCertificateRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCertificate(DeleteCertificateRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteCertificate', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single CertificateIssuanceConfig.
     *
     * The async variant is
     * {@see CertificateManagerClient::deleteCertificateIssuanceConfigAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/delete_certificate_issuance_config.php
     *
     * @param DeleteCertificateIssuanceConfigRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCertificateIssuanceConfig(DeleteCertificateIssuanceConfigRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteCertificateIssuanceConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single CertificateMap. A Certificate Map can't be deleted
     * if it contains Certificate Map Entries. Remove all the entries from
     * the map before calling this method.
     *
     * The async variant is
     * {@see CertificateManagerClient::deleteCertificateMapAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/delete_certificate_map.php
     *
     * @param DeleteCertificateMapRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCertificateMap(DeleteCertificateMapRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteCertificateMap', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single CertificateMapEntry.
     *
     * The async variant is
     * {@see CertificateManagerClient::deleteCertificateMapEntryAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/delete_certificate_map_entry.php
     *
     * @param DeleteCertificateMapEntryRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCertificateMapEntry(DeleteCertificateMapEntryRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteCertificateMapEntry', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single DnsAuthorization.
     *
     * The async variant is
     * {@see CertificateManagerClient::deleteDnsAuthorizationAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/delete_dns_authorization.php
     *
     * @param DeleteDnsAuthorizationRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDnsAuthorization(DeleteDnsAuthorizationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteDnsAuthorization', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Certificate.
     *
     * The async variant is {@see CertificateManagerClient::getCertificateAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/get_certificate.php
     *
     * @param GetCertificateRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Certificate
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCertificate(GetCertificateRequest $request, array $callOptions = []): Certificate
    {
        return $this->startApiCall('GetCertificate', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single CertificateIssuanceConfig.
     *
     * The async variant is
     * {@see CertificateManagerClient::getCertificateIssuanceConfigAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/get_certificate_issuance_config.php
     *
     * @param GetCertificateIssuanceConfigRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CertificateIssuanceConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCertificateIssuanceConfig(GetCertificateIssuanceConfigRequest $request, array $callOptions = []): CertificateIssuanceConfig
    {
        return $this->startApiCall('GetCertificateIssuanceConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single CertificateMap.
     *
     * The async variant is {@see CertificateManagerClient::getCertificateMapAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/get_certificate_map.php
     *
     * @param GetCertificateMapRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CertificateMap
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCertificateMap(GetCertificateMapRequest $request, array $callOptions = []): CertificateMap
    {
        return $this->startApiCall('GetCertificateMap', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single CertificateMapEntry.
     *
     * The async variant is
     * {@see CertificateManagerClient::getCertificateMapEntryAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/get_certificate_map_entry.php
     *
     * @param GetCertificateMapEntryRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return CertificateMapEntry
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCertificateMapEntry(GetCertificateMapEntryRequest $request, array $callOptions = []): CertificateMapEntry
    {
        return $this->startApiCall('GetCertificateMapEntry', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single DnsAuthorization.
     *
     * The async variant is {@see CertificateManagerClient::getDnsAuthorizationAsync()}
     * .
     *
     * @example samples/V1/CertificateManagerClient/get_dns_authorization.php
     *
     * @param GetDnsAuthorizationRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DnsAuthorization
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDnsAuthorization(GetDnsAuthorizationRequest $request, array $callOptions = []): DnsAuthorization
    {
        return $this->startApiCall('GetDnsAuthorization', $request, $callOptions)->wait();
    }

    /**
     * Lists CertificateIssuanceConfigs in a given project and location.
     *
     * The async variant is
     * {@see CertificateManagerClient::listCertificateIssuanceConfigsAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/list_certificate_issuance_configs.php
     *
     * @param ListCertificateIssuanceConfigsRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCertificateIssuanceConfigs(ListCertificateIssuanceConfigsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCertificateIssuanceConfigs', $request, $callOptions);
    }

    /**
     * Lists CertificateMapEntries in a given project and location.
     *
     * The async variant is
     * {@see CertificateManagerClient::listCertificateMapEntriesAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/list_certificate_map_entries.php
     *
     * @param ListCertificateMapEntriesRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCertificateMapEntries(ListCertificateMapEntriesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCertificateMapEntries', $request, $callOptions);
    }

    /**
     * Lists CertificateMaps in a given project and location.
     *
     * The async variant is {@see CertificateManagerClient::listCertificateMapsAsync()}
     * .
     *
     * @example samples/V1/CertificateManagerClient/list_certificate_maps.php
     *
     * @param ListCertificateMapsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCertificateMaps(ListCertificateMapsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCertificateMaps', $request, $callOptions);
    }

    /**
     * Lists Certificates in a given project and location.
     *
     * The async variant is {@see CertificateManagerClient::listCertificatesAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/list_certificates.php
     *
     * @param ListCertificatesRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listCertificates(ListCertificatesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListCertificates', $request, $callOptions);
    }

    /**
     * Lists DnsAuthorizations in a given project and location.
     *
     * The async variant is
     * {@see CertificateManagerClient::listDnsAuthorizationsAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/list_dns_authorizations.php
     *
     * @param ListDnsAuthorizationsRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDnsAuthorizations(ListDnsAuthorizationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDnsAuthorizations', $request, $callOptions);
    }

    /**
     * Updates a Certificate.
     *
     * The async variant is {@see CertificateManagerClient::updateCertificateAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/update_certificate.php
     *
     * @param UpdateCertificateRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCertificate(UpdateCertificateRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateCertificate', $request, $callOptions)->wait();
    }

    /**
     * Updates a CertificateMap.
     *
     * The async variant is
     * {@see CertificateManagerClient::updateCertificateMapAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/update_certificate_map.php
     *
     * @param UpdateCertificateMapRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCertificateMap(UpdateCertificateMapRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateCertificateMap', $request, $callOptions)->wait();
    }

    /**
     * Updates a CertificateMapEntry.
     *
     * The async variant is
     * {@see CertificateManagerClient::updateCertificateMapEntryAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/update_certificate_map_entry.php
     *
     * @param UpdateCertificateMapEntryRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCertificateMapEntry(UpdateCertificateMapEntryRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateCertificateMapEntry', $request, $callOptions)->wait();
    }

    /**
     * Updates a DnsAuthorization.
     *
     * The async variant is
     * {@see CertificateManagerClient::updateDnsAuthorizationAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/update_dns_authorization.php
     *
     * @param UpdateDnsAuthorizationRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDnsAuthorization(UpdateDnsAuthorizationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateDnsAuthorization', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see CertificateManagerClient::getLocationAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see CertificateManagerClient::listLocationsAsync()} .
     *
     * @example samples/V1/CertificateManagerClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
