<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/vmmigration/v1/vmmigration.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\VMMigration\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;

use Google\ApiCore\LongRunning\OperationsClient;

use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\VMMigration\V1\AddGroupMigrationRequest;

use Google\Cloud\VMMigration\V1\CancelCloneJobRequest;
use Google\Cloud\VMMigration\V1\CancelCutoverJobRequest;
use Google\Cloud\VMMigration\V1\CloneJob;
use Google\Cloud\VMMigration\V1\CreateCloneJobRequest;
use Google\Cloud\VMMigration\V1\CreateCutoverJobRequest;
use Google\Cloud\VMMigration\V1\CreateDatacenterConnectorRequest;
use Google\Cloud\VMMigration\V1\CreateGroupRequest;
use Google\Cloud\VMMigration\V1\CreateMigratingVmRequest;
use Google\Cloud\VMMigration\V1\CreateSourceRequest;
use Google\Cloud\VMMigration\V1\CreateTargetProjectRequest;
use Google\Cloud\VMMigration\V1\CreateUtilizationReportRequest;
use Google\Cloud\VMMigration\V1\CutoverJob;
use Google\Cloud\VMMigration\V1\DatacenterConnector;
use Google\Cloud\VMMigration\V1\DeleteDatacenterConnectorRequest;
use Google\Cloud\VMMigration\V1\DeleteGroupRequest;
use Google\Cloud\VMMigration\V1\DeleteMigratingVmRequest;
use Google\Cloud\VMMigration\V1\DeleteSourceRequest;
use Google\Cloud\VMMigration\V1\DeleteTargetProjectRequest;
use Google\Cloud\VMMigration\V1\DeleteUtilizationReportRequest;
use Google\Cloud\VMMigration\V1\FetchInventoryRequest;
use Google\Cloud\VMMigration\V1\FetchInventoryResponse;
use Google\Cloud\VMMigration\V1\FinalizeMigrationRequest;
use Google\Cloud\VMMigration\V1\GetCloneJobRequest;
use Google\Cloud\VMMigration\V1\GetCutoverJobRequest;
use Google\Cloud\VMMigration\V1\GetDatacenterConnectorRequest;
use Google\Cloud\VMMigration\V1\GetGroupRequest;
use Google\Cloud\VMMigration\V1\GetMigratingVmRequest;
use Google\Cloud\VMMigration\V1\GetSourceRequest;
use Google\Cloud\VMMigration\V1\GetTargetProjectRequest;
use Google\Cloud\VMMigration\V1\GetUtilizationReportRequest;
use Google\Cloud\VMMigration\V1\Group;
use Google\Cloud\VMMigration\V1\ListCloneJobsRequest;
use Google\Cloud\VMMigration\V1\ListCloneJobsResponse;
use Google\Cloud\VMMigration\V1\ListCutoverJobsRequest;
use Google\Cloud\VMMigration\V1\ListCutoverJobsResponse;
use Google\Cloud\VMMigration\V1\ListDatacenterConnectorsRequest;
use Google\Cloud\VMMigration\V1\ListDatacenterConnectorsResponse;
use Google\Cloud\VMMigration\V1\ListGroupsRequest;
use Google\Cloud\VMMigration\V1\ListGroupsResponse;
use Google\Cloud\VMMigration\V1\ListMigratingVmsRequest;
use Google\Cloud\VMMigration\V1\ListMigratingVmsResponse;
use Google\Cloud\VMMigration\V1\ListSourcesRequest;
use Google\Cloud\VMMigration\V1\ListSourcesResponse;
use Google\Cloud\VMMigration\V1\ListTargetProjectsRequest;
use Google\Cloud\VMMigration\V1\ListTargetProjectsResponse;
use Google\Cloud\VMMigration\V1\ListUtilizationReportsRequest;
use Google\Cloud\VMMigration\V1\ListUtilizationReportsResponse;
use Google\Cloud\VMMigration\V1\MigratingVm;
use Google\Cloud\VMMigration\V1\PauseMigrationRequest;
use Google\Cloud\VMMigration\V1\RemoveGroupMigrationRequest;
use Google\Cloud\VMMigration\V1\ResumeMigrationRequest;
use Google\Cloud\VMMigration\V1\Source;

use Google\Cloud\VMMigration\V1\StartMigrationRequest;
use Google\Cloud\VMMigration\V1\TargetProject;
use Google\Cloud\VMMigration\V1\UpdateGroupRequest;
use Google\Cloud\VMMigration\V1\UpdateMigratingVmRequest;
use Google\Cloud\VMMigration\V1\UpdateSourceRequest;
use Google\Cloud\VMMigration\V1\UpdateTargetProjectRequest;
use Google\Cloud\VMMigration\V1\UtilizationReport;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: VM Migration Service
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $vmMigrationClient = new VmMigrationClient();
 * try {
 *     $formattedGroup = $vmMigrationClient->groupName('[PROJECT]', '[LOCATION]', '[GROUP]');
 *     $operationResponse = $vmMigrationClient->addGroupMigration($formattedGroup);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $vmMigrationClient->addGroupMigration($formattedGroup);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'addGroupMigration');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $vmMigrationClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class VmMigrationGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.vmmigration.v1.VmMigration';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'vmmigration.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $cloneJobNameTemplate;

    private static $cutoverJobNameTemplate;

    private static $datacenterConnectorNameTemplate;

    private static $groupNameTemplate;

    private static $locationNameTemplate;

    private static $migratingVmNameTemplate;

    private static $sourceNameTemplate;

    private static $targetProjectNameTemplate;

    private static $utilizationReportNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/vm_migration_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/vm_migration_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/vm_migration_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/vm_migration_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getCloneJobNameTemplate()
    {
        if (self::$cloneJobNameTemplate == null) {
            self::$cloneJobNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/sources/{source}/migratingVms/{migrating_vm}/cloneJobs/{clone_job}'
            );
        }

        return self::$cloneJobNameTemplate;
    }

    private static function getCutoverJobNameTemplate()
    {
        if (self::$cutoverJobNameTemplate == null) {
            self::$cutoverJobNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/sources/{source}/migratingVms/{migrating_vm}/cutoverJobs/{cutover_job}'
            );
        }

        return self::$cutoverJobNameTemplate;
    }

    private static function getDatacenterConnectorNameTemplate()
    {
        if (self::$datacenterConnectorNameTemplate == null) {
            self::$datacenterConnectorNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/sources/{source}/datacenterConnectors/{datacenter_connector}'
            );
        }

        return self::$datacenterConnectorNameTemplate;
    }

    private static function getGroupNameTemplate()
    {
        if (self::$groupNameTemplate == null) {
            self::$groupNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/groups/{group}'
            );
        }

        return self::$groupNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getMigratingVmNameTemplate()
    {
        if (self::$migratingVmNameTemplate == null) {
            self::$migratingVmNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/sources/{source}/migratingVms/{migrating_vm}'
            );
        }

        return self::$migratingVmNameTemplate;
    }

    private static function getSourceNameTemplate()
    {
        if (self::$sourceNameTemplate == null) {
            self::$sourceNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/sources/{source}'
            );
        }

        return self::$sourceNameTemplate;
    }

    private static function getTargetProjectNameTemplate()
    {
        if (self::$targetProjectNameTemplate == null) {
            self::$targetProjectNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/targetProjects/{target_project}'
            );
        }

        return self::$targetProjectNameTemplate;
    }

    private static function getUtilizationReportNameTemplate()
    {
        if (self::$utilizationReportNameTemplate == null) {
            self::$utilizationReportNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/sources/{source}/utilizationReports/{utilization_report}'
            );
        }

        return self::$utilizationReportNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'cloneJob' => self::getCloneJobNameTemplate(),
                'cutoverJob' => self::getCutoverJobNameTemplate(),
                'datacenterConnector' => self::getDatacenterConnectorNameTemplate(),
                'group' => self::getGroupNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'migratingVm' => self::getMigratingVmNameTemplate(),
                'source' => self::getSourceNameTemplate(),
                'targetProject' => self::getTargetProjectNameTemplate(),
                'utilizationReport' => self::getUtilizationReportNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a clone_job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $source
     * @param string $migratingVm
     * @param string $cloneJob
     *
     * @return string The formatted clone_job resource.
     */
    public static function cloneJobName(
        $project,
        $location,
        $source,
        $migratingVm,
        $cloneJob
    ) {
        return self::getCloneJobNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'source' => $source,
            'migrating_vm' => $migratingVm,
            'clone_job' => $cloneJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cutover_job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $source
     * @param string $migratingVm
     * @param string $cutoverJob
     *
     * @return string The formatted cutover_job resource.
     */
    public static function cutoverJobName(
        $project,
        $location,
        $source,
        $migratingVm,
        $cutoverJob
    ) {
        return self::getCutoverJobNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'source' => $source,
            'migrating_vm' => $migratingVm,
            'cutover_job' => $cutoverJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * datacenter_connector resource.
     *
     * @param string $project
     * @param string $location
     * @param string $source
     * @param string $datacenterConnector
     *
     * @return string The formatted datacenter_connector resource.
     */
    public static function datacenterConnectorName(
        $project,
        $location,
        $source,
        $datacenterConnector
    ) {
        return self::getDatacenterConnectorNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'source' => $source,
            'datacenter_connector' => $datacenterConnector,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a group
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $group
     *
     * @return string The formatted group resource.
     */
    public static function groupName($project, $location, $group)
    {
        return self::getGroupNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'group' => $group,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a migrating_vm
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $source
     * @param string $migratingVm
     *
     * @return string The formatted migrating_vm resource.
     */
    public static function migratingVmName(
        $project,
        $location,
        $source,
        $migratingVm
    ) {
        return self::getMigratingVmNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'source' => $source,
            'migrating_vm' => $migratingVm,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a source
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $source
     *
     * @return string The formatted source resource.
     */
    public static function sourceName($project, $location, $source)
    {
        return self::getSourceNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'source' => $source,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * target_project resource.
     *
     * @param string $project
     * @param string $location
     * @param string $targetProject
     *
     * @return string The formatted target_project resource.
     */
    public static function targetProjectName(
        $project,
        $location,
        $targetProject
    ) {
        return self::getTargetProjectNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'target_project' => $targetProject,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * utilization_report resource.
     *
     * @param string $project
     * @param string $location
     * @param string $source
     * @param string $utilizationReport
     *
     * @return string The formatted utilization_report resource.
     */
    public static function utilizationReportName(
        $project,
        $location,
        $source,
        $utilizationReport
    ) {
        return self::getUtilizationReportNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'source' => $source,
            'utilization_report' => $utilizationReport,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - cloneJob: projects/{project}/locations/{location}/sources/{source}/migratingVms/{migrating_vm}/cloneJobs/{clone_job}
     * - cutoverJob: projects/{project}/locations/{location}/sources/{source}/migratingVms/{migrating_vm}/cutoverJobs/{cutover_job}
     * - datacenterConnector: projects/{project}/locations/{location}/sources/{source}/datacenterConnectors/{datacenter_connector}
     * - group: projects/{project}/locations/{location}/groups/{group}
     * - location: projects/{project}/locations/{location}
     * - migratingVm: projects/{project}/locations/{location}/sources/{source}/migratingVms/{migrating_vm}
     * - source: projects/{project}/locations/{location}/sources/{source}
     * - targetProject: projects/{project}/locations/{location}/targetProjects/{target_project}
     * - utilizationReport: projects/{project}/locations/{location}/sources/{source}/utilizationReports/{utilization_report}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'vmmigration.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Adds a MigratingVm to a Group.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedGroup = $vmMigrationClient->groupName('[PROJECT]', '[LOCATION]', '[GROUP]');
     *     $operationResponse = $vmMigrationClient->addGroupMigration($formattedGroup);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->addGroupMigration($formattedGroup);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'addGroupMigration');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $group        Required. The full path name of the Group to add to.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $migratingVm
     *           The full path name of the MigratingVm to add.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function addGroupMigration($group, array $optionalArgs = [])
    {
        $request = new AddGroupMigrationRequest();
        $requestParamHeaders = [];
        $request->setGroup($group);
        $requestParamHeaders['group'] = $group;
        if (isset($optionalArgs['migratingVm'])) {
            $request->setMigratingVm($optionalArgs['migratingVm']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'AddGroupMigration',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Initiates the cancellation of a running clone job.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->cloneJobName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[MIGRATING_VM]', '[CLONE_JOB]');
     *     $operationResponse = $vmMigrationClient->cancelCloneJob($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->cancelCloneJob($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'cancelCloneJob');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The clone job id
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function cancelCloneJob($name, array $optionalArgs = [])
    {
        $request = new CancelCloneJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CancelCloneJob',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Initiates the cancellation of a running cutover job.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->cutoverJobName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[MIGRATING_VM]', '[CUTOVER_JOB]');
     *     $operationResponse = $vmMigrationClient->cancelCutoverJob($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->cancelCutoverJob($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'cancelCutoverJob');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The cutover job id
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function cancelCutoverJob($name, array $optionalArgs = [])
    {
        $request = new CancelCutoverJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CancelCutoverJob',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Initiates a Clone of a specific migrating VM.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->migratingVmName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[MIGRATING_VM]');
     *     $cloneJobId = 'clone_job_id';
     *     $cloneJob = new CloneJob();
     *     $operationResponse = $vmMigrationClient->createCloneJob($formattedParent, $cloneJobId, $cloneJob);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->createCloneJob($formattedParent, $cloneJobId, $cloneJob);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'createCloneJob');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. The Clone's parent.
     * @param string   $cloneJobId   Required. The clone job identifier.
     * @param CloneJob $cloneJob     Required. The clone request body.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createCloneJob(
        $parent,
        $cloneJobId,
        $cloneJob,
        array $optionalArgs = []
    ) {
        $request = new CreateCloneJobRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setCloneJobId($cloneJobId);
        $request->setCloneJob($cloneJob);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateCloneJob',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Initiates a Cutover of a specific migrating VM.
     * The returned LRO is completed when the cutover job resource is created
     * and the job is initiated.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->migratingVmName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[MIGRATING_VM]');
     *     $cutoverJobId = 'cutover_job_id';
     *     $cutoverJob = new CutoverJob();
     *     $operationResponse = $vmMigrationClient->createCutoverJob($formattedParent, $cutoverJobId, $cutoverJob);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->createCutoverJob($formattedParent, $cutoverJobId, $cutoverJob);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'createCutoverJob');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The Cutover's parent.
     * @param string     $cutoverJobId Required. The cutover job identifier.
     * @param CutoverJob $cutoverJob   Required. The cutover request body.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createCutoverJob(
        $parent,
        $cutoverJobId,
        $cutoverJob,
        array $optionalArgs = []
    ) {
        $request = new CreateCutoverJobRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setCutoverJobId($cutoverJobId);
        $request->setCutoverJob($cutoverJob);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateCutoverJob',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new DatacenterConnector in a given Source.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->sourceName('[PROJECT]', '[LOCATION]', '[SOURCE]');
     *     $datacenterConnectorId = 'datacenter_connector_id';
     *     $datacenterConnector = new DatacenterConnector();
     *     $operationResponse = $vmMigrationClient->createDatacenterConnector($formattedParent, $datacenterConnectorId, $datacenterConnector);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->createDatacenterConnector($formattedParent, $datacenterConnectorId, $datacenterConnector);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'createDatacenterConnector');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string              $parent                Required. The DatacenterConnector's parent.
     *                                                   Required. The Source in where the new DatacenterConnector will be created.
     *                                                   For example:
     *                                                   `projects/my-project/locations/us-central1/sources/my-source`
     * @param string              $datacenterConnectorId Required. The datacenterConnector identifier.
     * @param DatacenterConnector $datacenterConnector   Required. The create request body.
     * @param array               $optionalArgs          {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createDatacenterConnector(
        $parent,
        $datacenterConnectorId,
        $datacenterConnector,
        array $optionalArgs = []
    ) {
        $request = new CreateDatacenterConnectorRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDatacenterConnectorId($datacenterConnectorId);
        $request->setDatacenterConnector($datacenterConnector);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateDatacenterConnector',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new Group in a given project and location.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->locationName('[PROJECT]', '[LOCATION]');
     *     $groupId = 'group_id';
     *     $group = new Group();
     *     $operationResponse = $vmMigrationClient->createGroup($formattedParent, $groupId, $group);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->createGroup($formattedParent, $groupId, $group);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'createGroup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The Group's parent.
     * @param string $groupId      Required. The group identifier.
     * @param Group  $group        Required. The create request body.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createGroup(
        $parent,
        $groupId,
        $group,
        array $optionalArgs = []
    ) {
        $request = new CreateGroupRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setGroupId($groupId);
        $request->setGroup($group);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateGroup',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new MigratingVm in a given Source.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->sourceName('[PROJECT]', '[LOCATION]', '[SOURCE]');
     *     $migratingVmId = 'migrating_vm_id';
     *     $migratingVm = new MigratingVm();
     *     $operationResponse = $vmMigrationClient->createMigratingVm($formattedParent, $migratingVmId, $migratingVm);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->createMigratingVm($formattedParent, $migratingVmId, $migratingVm);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'createMigratingVm');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string      $parent        Required. The MigratingVm's parent.
     * @param string      $migratingVmId Required. The migratingVm identifier.
     * @param MigratingVm $migratingVm   Required. The create request body.
     * @param array       $optionalArgs  {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createMigratingVm(
        $parent,
        $migratingVmId,
        $migratingVm,
        array $optionalArgs = []
    ) {
        $request = new CreateMigratingVmRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setMigratingVmId($migratingVmId);
        $request->setMigratingVm($migratingVm);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateMigratingVm',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new Source in a given project and location.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->locationName('[PROJECT]', '[LOCATION]');
     *     $sourceId = 'source_id';
     *     $source = new Source();
     *     $operationResponse = $vmMigrationClient->createSource($formattedParent, $sourceId, $source);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->createSource($formattedParent, $sourceId, $source);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'createSource');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The Source's parent.
     * @param string $sourceId     Required. The source identifier.
     * @param Source $source       Required. The create request body.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createSource(
        $parent,
        $sourceId,
        $source,
        array $optionalArgs = []
    ) {
        $request = new CreateSourceRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSourceId($sourceId);
        $request->setSource($source);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateSource',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new TargetProject in a given project.
     *
     * NOTE: TargetProject is a global resource; hence the only supported value
     * for location is `global`.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->locationName('[PROJECT]', '[LOCATION]');
     *     $targetProjectId = 'target_project_id';
     *     $targetProject = new TargetProject();
     *     $operationResponse = $vmMigrationClient->createTargetProject($formattedParent, $targetProjectId, $targetProject);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->createTargetProject($formattedParent, $targetProjectId, $targetProject);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'createTargetProject');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string        $parent          Required. The TargetProject's parent.
     * @param string        $targetProjectId Required. The target_project identifier.
     * @param TargetProject $targetProject   Required. The create request body.
     * @param array         $optionalArgs    {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createTargetProject(
        $parent,
        $targetProjectId,
        $targetProject,
        array $optionalArgs = []
    ) {
        $request = new CreateTargetProjectRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTargetProjectId($targetProjectId);
        $request->setTargetProject($targetProject);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateTargetProject',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new UtilizationReport.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->sourceName('[PROJECT]', '[LOCATION]', '[SOURCE]');
     *     $utilizationReport = new UtilizationReport();
     *     $utilizationReportId = 'utilization_report_id';
     *     $operationResponse = $vmMigrationClient->createUtilizationReport($formattedParent, $utilizationReport, $utilizationReportId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->createUtilizationReport($formattedParent, $utilizationReport, $utilizationReportId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'createUtilizationReport');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string            $parent              Required. The Utilization Report's parent.
     * @param UtilizationReport $utilizationReport   Required. The report to create.
     * @param string            $utilizationReportId Required. The ID to use for the report, which will become the final component of
     *                                               the reports's resource name.
     *
     *                                               This value maximum length is 63 characters, and valid characters
     *                                               are /[a-z][0-9]-/. It must start with an english letter and must not
     *                                               end with a hyphen.
     * @param array             $optionalArgs        {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createUtilizationReport(
        $parent,
        $utilizationReport,
        $utilizationReportId,
        array $optionalArgs = []
    ) {
        $request = new CreateUtilizationReportRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setUtilizationReport($utilizationReport);
        $request->setUtilizationReportId($utilizationReportId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateUtilizationReport',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single DatacenterConnector.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->datacenterConnectorName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[DATACENTER_CONNECTOR]');
     *     $operationResponse = $vmMigrationClient->deleteDatacenterConnector($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->deleteDatacenterConnector($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'deleteDatacenterConnector');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The DatacenterConnector name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteDatacenterConnector($name, array $optionalArgs = [])
    {
        $request = new DeleteDatacenterConnectorRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteDatacenterConnector',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single Group.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->groupName('[PROJECT]', '[LOCATION]', '[GROUP]');
     *     $operationResponse = $vmMigrationClient->deleteGroup($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->deleteGroup($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'deleteGroup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The Group name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteGroup($name, array $optionalArgs = [])
    {
        $request = new DeleteGroupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteGroup',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single MigratingVm.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->migratingVmName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[MIGRATING_VM]');
     *     $operationResponse = $vmMigrationClient->deleteMigratingVm($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->deleteMigratingVm($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'deleteMigratingVm');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the MigratingVm.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteMigratingVm($name, array $optionalArgs = [])
    {
        $request = new DeleteMigratingVmRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteMigratingVm',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single Source.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->sourceName('[PROJECT]', '[LOCATION]', '[SOURCE]');
     *     $operationResponse = $vmMigrationClient->deleteSource($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->deleteSource($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'deleteSource');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The Source name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteSource($name, array $optionalArgs = [])
    {
        $request = new DeleteSourceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteSource',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single TargetProject.
     *
     * NOTE: TargetProject is a global resource; hence the only supported value
     * for location is `global`.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->targetProjectName('[PROJECT]', '[LOCATION]', '[TARGET_PROJECT]');
     *     $operationResponse = $vmMigrationClient->deleteTargetProject($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->deleteTargetProject($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'deleteTargetProject');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The TargetProject name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTargetProject($name, array $optionalArgs = [])
    {
        $request = new DeleteTargetProjectRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteTargetProject',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single Utilization Report.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->utilizationReportName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[UTILIZATION_REPORT]');
     *     $operationResponse = $vmMigrationClient->deleteUtilizationReport($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->deleteUtilizationReport($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'deleteUtilizationReport');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The Utilization Report name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes after the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteUtilizationReport($name, array $optionalArgs = [])
    {
        $request = new DeleteUtilizationReportRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteUtilizationReport',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * List remote source's inventory of VMs.
     * The remote source is the onprem vCenter (remote in the sense it's not in
     * Compute Engine). The inventory describes the list of existing VMs in that
     * source. Note that this operation lists the VMs on the remote source, as
     * opposed to listing the MigratingVms resources in the vmmigration service.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedSource = $vmMigrationClient->sourceName('[PROJECT]', '[LOCATION]', '[SOURCE]');
     *     $response = $vmMigrationClient->fetchInventory($formattedSource);
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $source       Required. The name of the Source.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $forceRefresh
     *           If this flag is set to true, the source will be queried instead of using
     *           cached results. Using this flag will make the call slower.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VMMigration\V1\FetchInventoryResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function fetchInventory($source, array $optionalArgs = [])
    {
        $request = new FetchInventoryRequest();
        $requestParamHeaders = [];
        $request->setSource($source);
        $requestParamHeaders['source'] = $source;
        if (isset($optionalArgs['forceRefresh'])) {
            $request->setForceRefresh($optionalArgs['forceRefresh']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'FetchInventory',
            FetchInventoryResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Marks a migration as completed, deleting migration resources that are no
     * longer being used. Only applicable after cutover is done.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedMigratingVm = $vmMigrationClient->migratingVmName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[MIGRATING_VM]');
     *     $operationResponse = $vmMigrationClient->finalizeMigration($formattedMigratingVm);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->finalizeMigration($formattedMigratingVm);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'finalizeMigration');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $migratingVm  Required. The name of the MigratingVm.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function finalizeMigration($migratingVm, array $optionalArgs = [])
    {
        $request = new FinalizeMigrationRequest();
        $requestParamHeaders = [];
        $request->setMigratingVm($migratingVm);
        $requestParamHeaders['migrating_vm'] = $migratingVm;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'FinalizeMigration',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets details of a single CloneJob.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->cloneJobName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[MIGRATING_VM]', '[CLONE_JOB]');
     *     $response = $vmMigrationClient->getCloneJob($formattedName);
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the CloneJob.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VMMigration\V1\CloneJob
     *
     * @throws ApiException if the remote call fails
     */
    public function getCloneJob($name, array $optionalArgs = [])
    {
        $request = new GetCloneJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetCloneJob',
            CloneJob::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single CutoverJob.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->cutoverJobName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[MIGRATING_VM]', '[CUTOVER_JOB]');
     *     $response = $vmMigrationClient->getCutoverJob($formattedName);
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the CutoverJob.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VMMigration\V1\CutoverJob
     *
     * @throws ApiException if the remote call fails
     */
    public function getCutoverJob($name, array $optionalArgs = [])
    {
        $request = new GetCutoverJobRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetCutoverJob',
            CutoverJob::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single DatacenterConnector.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->datacenterConnectorName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[DATACENTER_CONNECTOR]');
     *     $response = $vmMigrationClient->getDatacenterConnector($formattedName);
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the DatacenterConnector.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VMMigration\V1\DatacenterConnector
     *
     * @throws ApiException if the remote call fails
     */
    public function getDatacenterConnector($name, array $optionalArgs = [])
    {
        $request = new GetDatacenterConnectorRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetDatacenterConnector',
            DatacenterConnector::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single Group.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->groupName('[PROJECT]', '[LOCATION]', '[GROUP]');
     *     $response = $vmMigrationClient->getGroup($formattedName);
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The group name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VMMigration\V1\Group
     *
     * @throws ApiException if the remote call fails
     */
    public function getGroup($name, array $optionalArgs = [])
    {
        $request = new GetGroupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetGroup',
            Group::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single MigratingVm.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->migratingVmName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[MIGRATING_VM]');
     *     $response = $vmMigrationClient->getMigratingVm($formattedName);
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the MigratingVm.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VMMigration\V1\MigratingVm
     *
     * @throws ApiException if the remote call fails
     */
    public function getMigratingVm($name, array $optionalArgs = [])
    {
        $request = new GetMigratingVmRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetMigratingVm',
            MigratingVm::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single Source.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->sourceName('[PROJECT]', '[LOCATION]', '[SOURCE]');
     *     $response = $vmMigrationClient->getSource($formattedName);
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The Source name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VMMigration\V1\Source
     *
     * @throws ApiException if the remote call fails
     */
    public function getSource($name, array $optionalArgs = [])
    {
        $request = new GetSourceRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetSource',
            Source::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single TargetProject.
     *
     * NOTE: TargetProject is a global resource; hence the only supported value
     * for location is `global`.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->targetProjectName('[PROJECT]', '[LOCATION]', '[TARGET_PROJECT]');
     *     $response = $vmMigrationClient->getTargetProject($formattedName);
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The TargetProject name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VMMigration\V1\TargetProject
     *
     * @throws ApiException if the remote call fails
     */
    public function getTargetProject($name, array $optionalArgs = [])
    {
        $request = new GetTargetProjectRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetTargetProject',
            TargetProject::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a single Utilization Report.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedName = $vmMigrationClient->utilizationReportName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[UTILIZATION_REPORT]');
     *     $response = $vmMigrationClient->getUtilizationReport($formattedName);
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The Utilization Report name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $view
     *           Optional. The level of details of the report.
     *           Defaults to FULL
     *           For allowed values, use constants defined on {@see \Google\Cloud\VMMigration\V1\UtilizationReportView}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\VMMigration\V1\UtilizationReport
     *
     * @throws ApiException if the remote call fails
     */
    public function getUtilizationReport($name, array $optionalArgs = [])
    {
        $request = new GetUtilizationReportRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['view'])) {
            $request->setView($optionalArgs['view']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetUtilizationReport',
            UtilizationReport::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists CloneJobs of a given migrating VM.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->migratingVmName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[MIGRATING_VM]');
     *     $pageToken = 'page_token';
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmMigrationClient->listCloneJobs($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmMigrationClient->listCloneJobs($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of source VMs.
     * @param string $pageToken    A page token is used to specify a page of values to be returned.
     *                             If no page token is specified (the default), the first page
     *                             of values will be returned. Any page token used here must have
     *                             been generated by a previous call to the API.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $filter
     *           Optional. The filter request.
     *     @type string $orderBy
     *           Optional. the order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listCloneJobs($parent, $pageToken, array $optionalArgs = [])
    {
        $request = new ListCloneJobsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setPageToken($pageToken);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListCloneJobs',
            $optionalArgs,
            ListCloneJobsResponse::class,
            $request
        );
    }

    /**
     * Lists CutoverJobs of a given migrating VM.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->migratingVmName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[MIGRATING_VM]');
     *     $pageToken = 'page_token';
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmMigrationClient->listCutoverJobs($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmMigrationClient->listCutoverJobs($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of migrating VMs.
     * @param string $pageToken    A page token is used to specify a page of values to be returned.
     *                             If no page token is specified (the default), the first page
     *                             of values will be returned. Any page token used here must have
     *                             been generated by a previous call to the API.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $filter
     *           Optional. The filter request.
     *     @type string $orderBy
     *           Optional. the order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listCutoverJobs(
        $parent,
        $pageToken,
        array $optionalArgs = []
    ) {
        $request = new ListCutoverJobsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setPageToken($pageToken);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListCutoverJobs',
            $optionalArgs,
            ListCutoverJobsResponse::class,
            $request
        );
    }

    /**
     * Lists DatacenterConnectors in a given Source.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->sourceName('[PROJECT]', '[LOCATION]', '[SOURCE]');
     *     $pageToken = 'page_token';
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmMigrationClient->listDatacenterConnectors($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmMigrationClient->listDatacenterConnectors($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of connectors.
     * @param string $pageToken    A page token is used to specify a page of values to be returned.
     *                             If no page token is specified (the default), the first page
     *                             of values will be returned. Any page token used here must have
     *                             been generated by a previous call to the API.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $filter
     *           Optional. The filter request.
     *     @type string $orderBy
     *           Optional. the order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDatacenterConnectors(
        $parent,
        $pageToken,
        array $optionalArgs = []
    ) {
        $request = new ListDatacenterConnectorsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setPageToken($pageToken);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListDatacenterConnectors',
            $optionalArgs,
            ListDatacenterConnectorsResponse::class,
            $request
        );
    }

    /**
     * Lists Groups in a given project and location.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->locationName('[PROJECT]', '[LOCATION]');
     *     $pageToken = 'page_token';
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmMigrationClient->listGroups($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmMigrationClient->listGroups($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of groups.
     * @param string $pageToken    A page token is used to specify a page of values to be returned.
     *                             If no page token is specified (the default), the first page
     *                             of values will be returned. Any page token used here must have
     *                             been generated by a previous call to the API.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $filter
     *           Optional. The filter request.
     *     @type string $orderBy
     *           Optional. the order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listGroups($parent, $pageToken, array $optionalArgs = [])
    {
        $request = new ListGroupsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setPageToken($pageToken);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListGroups',
            $optionalArgs,
            ListGroupsResponse::class,
            $request
        );
    }

    /**
     * Lists MigratingVms in a given Source.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->sourceName('[PROJECT]', '[LOCATION]', '[SOURCE]');
     *     $pageToken = 'page_token';
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmMigrationClient->listMigratingVms($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmMigrationClient->listMigratingVms($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of MigratingVms.
     * @param string $pageToken    A page token is used to specify a page of values to be returned.
     *                             If no page token is specified (the default), the first page
     *                             of values will be returned. Any page token used here must have
     *                             been generated by a previous call to the API.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $filter
     *           Optional. The filter request.
     *     @type string $orderBy
     *           Optional. the order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listMigratingVms(
        $parent,
        $pageToken,
        array $optionalArgs = []
    ) {
        $request = new ListMigratingVmsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setPageToken($pageToken);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListMigratingVms',
            $optionalArgs,
            ListMigratingVmsResponse::class,
            $request
        );
    }

    /**
     * Lists Sources in a given project and location.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->locationName('[PROJECT]', '[LOCATION]');
     *     $pageToken = 'page_token';
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmMigrationClient->listSources($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmMigrationClient->listSources($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of sources.
     * @param string $pageToken    A page token is used to specify a page of values to be returned.
     *                             If no page token is specified (the default), the first page
     *                             of values will be returned. Any page token used here must have
     *                             been generated by a previous call to the API.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $filter
     *           Optional. The filter request.
     *     @type string $orderBy
     *           Optional. the order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSources($parent, $pageToken, array $optionalArgs = [])
    {
        $request = new ListSourcesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setPageToken($pageToken);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListSources',
            $optionalArgs,
            ListSourcesResponse::class,
            $request
        );
    }

    /**
     * Lists TargetProjects in a given project.
     *
     * NOTE: TargetProject is a global resource; hence the only supported value
     * for location is `global`.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->locationName('[PROJECT]', '[LOCATION]');
     *     $pageToken = 'page_token';
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmMigrationClient->listTargetProjects($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmMigrationClient->listTargetProjects($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent, which owns this collection of targets.
     * @param string $pageToken    A page token is used to specify a page of values to be returned.
     *                             If no page token is specified (the default), the first page
     *                             of values will be returned. Any page token used here must have
     *                             been generated by a previous call to the API.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $filter
     *           Optional. The filter request.
     *     @type string $orderBy
     *           Optional. the order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTargetProjects(
        $parent,
        $pageToken,
        array $optionalArgs = []
    ) {
        $request = new ListTargetProjectsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setPageToken($pageToken);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListTargetProjects',
            $optionalArgs,
            ListTargetProjectsResponse::class,
            $request
        );
    }

    /**
     * Lists Utilization Reports of the given Source.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedParent = $vmMigrationClient->sourceName('[PROJECT]', '[LOCATION]', '[SOURCE]');
     *     $pageToken = 'page_token';
     *     // Iterate over pages of elements
     *     $pagedResponse = $vmMigrationClient->listUtilizationReports($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $vmMigrationClient->listUtilizationReports($formattedParent, $pageToken);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The Utilization Reports parent.
     * @param string $pageToken    A page token is used to specify a page of values to be returned.
     *                             If no page token is specified (the default), the first page
     *                             of values will be returned. Any page token used here must have
     *                             been generated by a previous call to the API.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $view
     *           Optional. The level of details of each report.
     *           Defaults to BASIC.
     *           For allowed values, use constants defined on {@see \Google\Cloud\VMMigration\V1\UtilizationReportView}
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $filter
     *           Optional. The filter request.
     *     @type string $orderBy
     *           Optional. the order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listUtilizationReports(
        $parent,
        $pageToken,
        array $optionalArgs = []
    ) {
        $request = new ListUtilizationReportsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setPageToken($pageToken);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['view'])) {
            $request->setView($optionalArgs['view']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListUtilizationReports',
            $optionalArgs,
            ListUtilizationReportsResponse::class,
            $request
        );
    }

    /**
     * Pauses a migration for a VM. If cycle tasks are running they will be
     * cancelled, preserving source task data. Further replication cycles will not
     * be triggered while the VM is paused.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedMigratingVm = $vmMigrationClient->migratingVmName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[MIGRATING_VM]');
     *     $operationResponse = $vmMigrationClient->pauseMigration($formattedMigratingVm);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->pauseMigration($formattedMigratingVm);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'pauseMigration');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $migratingVm  Required. The name of the MigratingVm.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function pauseMigration($migratingVm, array $optionalArgs = [])
    {
        $request = new PauseMigrationRequest();
        $requestParamHeaders = [];
        $request->setMigratingVm($migratingVm);
        $requestParamHeaders['migrating_vm'] = $migratingVm;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'PauseMigration',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Removes a MigratingVm from a Group.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedGroup = $vmMigrationClient->groupName('[PROJECT]', '[LOCATION]', '[GROUP]');
     *     $operationResponse = $vmMigrationClient->removeGroupMigration($formattedGroup);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->removeGroupMigration($formattedGroup);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'removeGroupMigration');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $group        Required. The name of the Group.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $migratingVm
     *           The MigratingVm to remove.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function removeGroupMigration($group, array $optionalArgs = [])
    {
        $request = new RemoveGroupMigrationRequest();
        $requestParamHeaders = [];
        $request->setGroup($group);
        $requestParamHeaders['group'] = $group;
        if (isset($optionalArgs['migratingVm'])) {
            $request->setMigratingVm($optionalArgs['migratingVm']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'RemoveGroupMigration',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Resumes a migration for a VM. When called on a paused migration, will start
     * the process of uploading data and creating snapshots; when called on a
     * completed cut-over migration, will update the migration to active state and
     * start the process of uploading data and creating snapshots.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedMigratingVm = $vmMigrationClient->migratingVmName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[MIGRATING_VM]');
     *     $operationResponse = $vmMigrationClient->resumeMigration($formattedMigratingVm);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->resumeMigration($formattedMigratingVm);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'resumeMigration');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $migratingVm  Required. The name of the MigratingVm.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function resumeMigration($migratingVm, array $optionalArgs = [])
    {
        $request = new ResumeMigrationRequest();
        $requestParamHeaders = [];
        $request->setMigratingVm($migratingVm);
        $requestParamHeaders['migrating_vm'] = $migratingVm;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'ResumeMigration',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Starts migration for a VM. Starts the process of uploading
     * data and creating snapshots, in replication cycles scheduled by the policy.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $formattedMigratingVm = $vmMigrationClient->migratingVmName('[PROJECT]', '[LOCATION]', '[SOURCE]', '[MIGRATING_VM]');
     *     $operationResponse = $vmMigrationClient->startMigration($formattedMigratingVm);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->startMigration($formattedMigratingVm);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'startMigration');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param string $migratingVm  Required. The name of the MigratingVm.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function startMigration($migratingVm, array $optionalArgs = [])
    {
        $request = new StartMigrationRequest();
        $requestParamHeaders = [];
        $request->setMigratingVm($migratingVm);
        $requestParamHeaders['migrating_vm'] = $migratingVm;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'StartMigration',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of a single Group.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $group = new Group();
     *     $operationResponse = $vmMigrationClient->updateGroup($group);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->updateGroup($group);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'updateGroup');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param Group $group        Required. The update request body.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Field mask is used to specify the fields to be overwritten in the
     *           Group resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateGroup($group, array $optionalArgs = [])
    {
        $request = new UpdateGroupRequest();
        $requestParamHeaders = [];
        $request->setGroup($group);
        $requestParamHeaders['group.name'] = $group->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateGroup',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of a single MigratingVm.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $migratingVm = new MigratingVm();
     *     $operationResponse = $vmMigrationClient->updateMigratingVm($migratingVm);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->updateMigratingVm($migratingVm);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'updateMigratingVm');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param MigratingVm $migratingVm  Required. The update request body.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Field mask is used to specify the fields to be overwritten in the
     *           MigratingVm resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateMigratingVm($migratingVm, array $optionalArgs = [])
    {
        $request = new UpdateMigratingVmRequest();
        $requestParamHeaders = [];
        $request->setMigratingVm($migratingVm);
        $requestParamHeaders['migrating_vm.name'] = $migratingVm->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateMigratingVm',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of a single Source.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $source = new Source();
     *     $operationResponse = $vmMigrationClient->updateSource($source);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->updateSource($source);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'updateSource');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param Source $source       Required. The update request body.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Field mask is used to specify the fields to be overwritten in the
     *           Source resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSource($source, array $optionalArgs = [])
    {
        $request = new UpdateSourceRequest();
        $requestParamHeaders = [];
        $request->setSource($source);
        $requestParamHeaders['source.name'] = $source->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateSource',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of a single TargetProject.
     *
     * NOTE: TargetProject is a global resource; hence the only supported value
     * for location is `global`.
     *
     * Sample code:
     * ```
     * $vmMigrationClient = new VmMigrationClient();
     * try {
     *     $targetProject = new TargetProject();
     *     $operationResponse = $vmMigrationClient->updateTargetProject($targetProject);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $vmMigrationClient->updateTargetProject($targetProject);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $vmMigrationClient->resumeOperation($operationName, 'updateTargetProject');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $vmMigrationClient->close();
     * }
     * ```
     *
     * @param TargetProject $targetProject Required. The update request body.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Field mask is used to specify the fields to be overwritten in the
     *           TargetProject resource by the update.
     *           The fields specified in the update_mask are relative to the resource, not
     *           the full request. A field will be overwritten if it is in the mask. If the
     *           user does not provide a mask then all fields will be overwritten.
     *     @type string $requestId
     *           A request ID to identify requests. Specify a unique request ID
     *           so that if you must retry your request, the server will know to ignore
     *           the request if it has already been completed. The server will guarantee
     *           that for at least 60 minutes since the first request.
     *
     *           For example, consider a situation where you make an initial request and t
     *           he request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTargetProject(
        $targetProject,
        array $optionalArgs = []
    ) {
        $request = new UpdateTargetProjectRequest();
        $requestParamHeaders = [];
        $request->setTargetProject($targetProject);
        $requestParamHeaders['target_project.name'] = $targetProject->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateTargetProject',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }
}
