<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/gkemulticloud/v1/azure_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\GkeMultiCloud\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;

use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;

use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;

use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\GkeMultiCloud\V1\AzureClient;
use Google\Cloud\GkeMultiCloud\V1\AzureCluster;
use Google\Cloud\GkeMultiCloud\V1\AzureNodePool;
use Google\Cloud\GkeMultiCloud\V1\AzureServerConfig;
use Google\Cloud\GkeMultiCloud\V1\CreateAzureClientRequest;
use Google\Cloud\GkeMultiCloud\V1\CreateAzureClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\CreateAzureNodePoolRequest;
use Google\Cloud\GkeMultiCloud\V1\DeleteAzureClientRequest;
use Google\Cloud\GkeMultiCloud\V1\DeleteAzureClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\DeleteAzureNodePoolRequest;
use Google\Cloud\GkeMultiCloud\V1\GenerateAzureAccessTokenRequest;
use Google\Cloud\GkeMultiCloud\V1\GenerateAzureAccessTokenResponse;
use Google\Cloud\GkeMultiCloud\V1\GetAzureClientRequest;
use Google\Cloud\GkeMultiCloud\V1\GetAzureClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\GetAzureNodePoolRequest;
use Google\Cloud\GkeMultiCloud\V1\GetAzureServerConfigRequest;
use Google\Cloud\GkeMultiCloud\V1\ListAzureClientsRequest;
use Google\Cloud\GkeMultiCloud\V1\ListAzureClientsResponse;
use Google\Cloud\GkeMultiCloud\V1\ListAzureClustersRequest;
use Google\Cloud\GkeMultiCloud\V1\ListAzureClustersResponse;
use Google\Cloud\GkeMultiCloud\V1\ListAzureNodePoolsRequest;
use Google\Cloud\GkeMultiCloud\V1\ListAzureNodePoolsResponse;
use Google\Cloud\GkeMultiCloud\V1\UpdateAzureClusterRequest;
use Google\Cloud\GkeMultiCloud\V1\UpdateAzureNodePoolRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: The AzureClusters API provides a single centrally managed service
 * to create and manage Anthos clusters that run on Azure infrastructure.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $azureClustersClient = new AzureClustersClient();
 * try {
 *     $formattedParent = $azureClustersClient->locationName('[PROJECT]', '[LOCATION]');
 *     $azureClient = new AzureClient();
 *     $azureClientId = 'azure_client_id';
 *     $operationResponse = $azureClustersClient->createAzureClient($formattedParent, $azureClient, $azureClientId);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $azureClustersClient->createAzureClient($formattedParent, $azureClient, $azureClientId);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $azureClustersClient->resumeOperation($operationName, 'createAzureClient');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $azureClustersClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class AzureClustersGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.gkemulticloud.v1.AzureClusters';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'gkemulticloud.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $azureClientNameTemplate;

    private static $azureClusterNameTemplate;

    private static $azureNodePoolNameTemplate;

    private static $azureServerConfigNameTemplate;

    private static $locationNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/azure_clusters_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/azure_clusters_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/azure_clusters_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/azure_clusters_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAzureClientNameTemplate()
    {
        if (self::$azureClientNameTemplate == null) {
            self::$azureClientNameTemplate = new PathTemplate('projects/{project}/locations/{location}/azureClients/{azure_client}');
        }

        return self::$azureClientNameTemplate;
    }

    private static function getAzureClusterNameTemplate()
    {
        if (self::$azureClusterNameTemplate == null) {
            self::$azureClusterNameTemplate = new PathTemplate('projects/{project}/locations/{location}/azureClusters/{azure_cluster}');
        }

        return self::$azureClusterNameTemplate;
    }

    private static function getAzureNodePoolNameTemplate()
    {
        if (self::$azureNodePoolNameTemplate == null) {
            self::$azureNodePoolNameTemplate = new PathTemplate('projects/{project}/locations/{location}/azureClusters/{azure_cluster}/azureNodePools/{azure_node_pool}');
        }

        return self::$azureNodePoolNameTemplate;
    }

    private static function getAzureServerConfigNameTemplate()
    {
        if (self::$azureServerConfigNameTemplate == null) {
            self::$azureServerConfigNameTemplate = new PathTemplate('projects/{project}/locations/{location}/azureServerConfig');
        }

        return self::$azureServerConfigNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'azureClient' => self::getAzureClientNameTemplate(),
                'azureCluster' => self::getAzureClusterNameTemplate(),
                'azureNodePool' => self::getAzureNodePoolNameTemplate(),
                'azureServerConfig' => self::getAzureServerConfigNameTemplate(),
                'location' => self::getLocationNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a azure_client
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $azureClient
     *
     * @return string The formatted azure_client resource.
     */
    public static function azureClientName($project, $location, $azureClient)
    {
        return self::getAzureClientNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'azure_client' => $azureClient,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * azure_cluster resource.
     *
     * @param string $project
     * @param string $location
     * @param string $azureCluster
     *
     * @return string The formatted azure_cluster resource.
     */
    public static function azureClusterName($project, $location, $azureCluster)
    {
        return self::getAzureClusterNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'azure_cluster' => $azureCluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * azure_node_pool resource.
     *
     * @param string $project
     * @param string $location
     * @param string $azureCluster
     * @param string $azureNodePool
     *
     * @return string The formatted azure_node_pool resource.
     */
    public static function azureNodePoolName($project, $location, $azureCluster, $azureNodePool)
    {
        return self::getAzureNodePoolNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'azure_cluster' => $azureCluster,
            'azure_node_pool' => $azureNodePool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * azure_server_config resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted azure_server_config resource.
     */
    public static function azureServerConfigName($project, $location)
    {
        return self::getAzureServerConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - azureClient: projects/{project}/locations/{location}/azureClients/{azure_client}
     * - azureCluster: projects/{project}/locations/{location}/azureClusters/{azure_cluster}
     * - azureNodePool: projects/{project}/locations/{location}/azureClusters/{azure_cluster}/azureNodePools/{azure_node_pool}
     * - azureServerConfig: projects/{project}/locations/{location}/azureServerConfig
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'gkemulticloud.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a new [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource on a given Google Cloud project
     * and region.
     *
     * `AzureClient` resources hold client authentication
     * information needed by the Anthos Multicloud API to manage Azure resources
     * on your Azure subscription on your behalf.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $formattedParent = $azureClustersClient->locationName('[PROJECT]', '[LOCATION]');
     *     $azureClient = new AzureClient();
     *     $azureClientId = 'azure_client_id';
     *     $operationResponse = $azureClustersClient->createAzureClient($formattedParent, $azureClient, $azureClientId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $azureClustersClient->createAzureClient($formattedParent, $azureClient, $azureClientId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $azureClustersClient->resumeOperation($operationName, 'createAzureClient');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param string      $parent        Required. The parent location where this [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource
     *                                   will be created.
     *
     *                                   Location names are formatted as `projects/<project-id>/locations/<region>`.
     *
     *                                   See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                                   for more details on Google Cloud resource names.
     * @param AzureClient $azureClient   Required. The specification of the [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] to create.
     * @param string      $azureClientId Required. A client provided ID the resource. Must be unique within the parent
     *                                   resource.
     *
     *                                   The provided ID will be part of the [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
     *                                   resource name formatted as
     *                                   `projects/<project-id>/locations/<region>/azureClients/<client-id>`.
     *
     *                                   Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 40 characters.
     * @param array       $optionalArgs  {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually create the client.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createAzureClient($parent, $azureClient, $azureClientId, array $optionalArgs = [])
    {
        $request = new CreateAzureClientRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAzureClient($azureClient);
        $request->setAzureClientId($azureClientId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateAzureClient', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource on a given GCP project and region.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $formattedParent = $azureClustersClient->locationName('[PROJECT]', '[LOCATION]');
     *     $azureCluster = new AzureCluster();
     *     $azureClusterId = 'azure_cluster_id';
     *     $operationResponse = $azureClustersClient->createAzureCluster($formattedParent, $azureCluster, $azureClusterId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $azureClustersClient->createAzureCluster($formattedParent, $azureCluster, $azureClusterId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $azureClustersClient->resumeOperation($operationName, 'createAzureCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param string       $parent         Required. The parent location where this [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource
     *                                     will be created.
     *
     *                                     Location names are formatted as `projects/<project-id>/locations/<region>`.
     *
     *                                     See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                                     for more details on Google Cloud resource names.
     * @param AzureCluster $azureCluster   Required. The specification of the [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] to create.
     * @param string       $azureClusterId Required. A client provided ID the resource. Must be unique within the parent
     *                                     resource.
     *
     *                                     The provided ID will be part of the [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
     *                                     resource name formatted as
     *                                     `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
     *
     *                                     Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 40 characters.
     * @param array        $optionalArgs   {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually create the cluster.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createAzureCluster($parent, $azureCluster, $azureClusterId, array $optionalArgs = [])
    {
        $request = new CreateAzureClusterRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAzureCluster($azureCluster);
        $request->setAzureClusterId($azureClusterId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateAzureCluster', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a new [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool], attached to a given [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $formattedParent = $azureClustersClient->azureClusterName('[PROJECT]', '[LOCATION]', '[AZURE_CLUSTER]');
     *     $azureNodePool = new AzureNodePool();
     *     $azureNodePoolId = 'azure_node_pool_id';
     *     $operationResponse = $azureClustersClient->createAzureNodePool($formattedParent, $azureNodePool, $azureNodePoolId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $azureClustersClient->createAzureNodePool($formattedParent, $azureNodePool, $azureNodePoolId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $azureClustersClient->resumeOperation($operationName, 'createAzureNodePool');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param string        $parent          Required. The [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource where this node pool will be created.
     *
     *                                       Location names are formatted as `projects/<project-id>/locations/<region>`.
     *
     *                                       See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                                       for more details on Google Cloud resource names.
     * @param AzureNodePool $azureNodePool   Required. The specification of the [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] to create.
     * @param string        $azureNodePoolId Required. A client provided ID the resource. Must be unique within the parent
     *                                       resource.
     *
     *                                       The provided ID will be part of the [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]
     *                                       resource name formatted as
     *                                       `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
     *
     *                                       Valid characters are `/[a-z][0-9]-/`. Cannot be longer than 40 characters.
     * @param array         $optionalArgs    {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually create the node
     *           pool.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createAzureNodePool($parent, $azureNodePool, $azureNodePoolId, array $optionalArgs = [])
    {
        $request = new CreateAzureNodePoolRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAzureNodePool($azureNodePool);
        $request->setAzureNodePoolId($azureNodePoolId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateAzureNodePool', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a specific [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource.
     *
     * If the client is used by one or more clusters, deletion will
     * fail and a `FAILED_PRECONDITION` error will be returned.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $formattedName = $azureClustersClient->azureClientName('[PROJECT]', '[LOCATION]', '[AZURE_CLIENT]');
     *     $operationResponse = $azureClustersClient->deleteAzureClient($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $azureClustersClient->deleteAzureClient($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $azureClustersClient->resumeOperation($operationName, 'deleteAzureClient');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name the [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] to delete.
     *
     *                             [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] names are formatted as
     *                             `projects/<project-id>/locations/<region>/azureClients/<client-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on Google Cloud resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $allowMissing
     *           If set to true, and the [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource is not found,
     *           the request will succeed but no action will be taken on the server and a
     *           completed [Operation][google.longrunning.Operation] will be returned.
     *
     *           Useful for idempotent deletion.
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually delete the resource.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAzureClient($name, array $optionalArgs = [])
    {
        $request = new DeleteAzureClientRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteAzureClient', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a specific [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
     *
     * Fails if the cluster has one or more associated [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]
     * resources.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $formattedName = $azureClustersClient->azureClusterName('[PROJECT]', '[LOCATION]', '[AZURE_CLUSTER]');
     *     $operationResponse = $azureClustersClient->deleteAzureCluster($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $azureClustersClient->deleteAzureCluster($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $azureClustersClient->resumeOperation($operationName, 'deleteAzureCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name the [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] to delete.
     *
     *                             `AzureCluster` names are formatted as
     *                             `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on GCP resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $allowMissing
     *           If set to true, and the [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource is not found,
     *           the request will succeed but no action will be taken on the server and a
     *           completed [Operation][google.longrunning.Operation] will be returned.
     *
     *           Useful for idempotent deletion.
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually delete the resource.
     *     @type string $etag
     *           The current etag of the [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
     *
     *           Allows clients to perform deletions through optimistic concurrency control.
     *
     *           If the provided etag does not match the current etag of the cluster,
     *           the request will fail and an ABORTED error will be returned.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAzureCluster($name, array $optionalArgs = [])
    {
        $request = new DeleteAzureClusterRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteAzureCluster', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a specific [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
     *
     * If successful, the response contains a newly created
     * [Operation][google.longrunning.Operation] resource that can be
     * described to track the status of the operation.
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $formattedName = $azureClustersClient->azureNodePoolName('[PROJECT]', '[LOCATION]', '[AZURE_CLUSTER]', '[AZURE_NODE_POOL]');
     *     $operationResponse = $azureClustersClient->deleteAzureNodePool($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $azureClustersClient->deleteAzureNodePool($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $azureClustersClient->resumeOperation($operationName, 'deleteAzureNodePool');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name the [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] to delete.
     *
     *                             `AzureNodePool` names are formatted as
     *                             `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on Google Cloud resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually delete the node
     *           pool.
     *     @type bool $allowMissing
     *           If set to true, and the [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource is not found,
     *           the request will succeed but no action will be taken on the server and a
     *           completed [Operation][google.longrunning.Operation] will be returned.
     *
     *           Useful for idempotent deletion.
     *     @type string $etag
     *           The current ETag of the [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool].
     *
     *           Allows clients to perform deletions through optimistic concurrency control.
     *
     *           If the provided ETag does not match the current etag of the node pool,
     *           the request will fail and an ABORTED error will be returned.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAzureNodePool($name, array $optionalArgs = [])
    {
        $request = new DeleteAzureNodePoolRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteAzureNodePool', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Generates a short-lived access token to authenticate to a given
     * [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $formattedAzureCluster = $azureClustersClient->azureClusterName('[PROJECT]', '[LOCATION]', '[AZURE_CLUSTER]');
     *     $response = $azureClustersClient->generateAzureAccessToken($formattedAzureCluster);
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param string $azureCluster Required. The name of the [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource to authenticate to.
     *
     *                             `AzureCluster` names are formatted as
     *                             `projects/<project-id>/locations/<region>/AzureClusters/<cluster-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on Google Cloud resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeMultiCloud\V1\GenerateAzureAccessTokenResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function generateAzureAccessToken($azureCluster, array $optionalArgs = [])
    {
        $request = new GenerateAzureAccessTokenRequest();
        $requestParamHeaders = [];
        $request->setAzureCluster($azureCluster);
        $requestParamHeaders['azure_cluster'] = $azureCluster;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GenerateAzureAccessToken', GenerateAzureAccessTokenResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Describes a specific [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource.
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $formattedName = $azureClustersClient->azureClientName('[PROJECT]', '[LOCATION]', '[AZURE_CLIENT]');
     *     $response = $azureClustersClient->getAzureClient($formattedName);
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource to describe.
     *
     *                             [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] names are formatted as
     *                             `projects/<project-id>/locations/<region>/azureClients/<client-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on Google Cloud resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeMultiCloud\V1\AzureClient
     *
     * @throws ApiException if the remote call fails
     */
    public function getAzureClient($name, array $optionalArgs = [])
    {
        $request = new GetAzureClientRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetAzureClient', AzureClient::class, $optionalArgs, $request)->wait();
    }

    /**
     * Describes a specific [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $formattedName = $azureClustersClient->azureClusterName('[PROJECT]', '[LOCATION]', '[AZURE_CLUSTER]');
     *     $response = $azureClustersClient->getAzureCluster($formattedName);
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource to describe.
     *
     *                             `AzureCluster` names are formatted as
     *                             `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on GCP resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeMultiCloud\V1\AzureCluster
     *
     * @throws ApiException if the remote call fails
     */
    public function getAzureCluster($name, array $optionalArgs = [])
    {
        $request = new GetAzureClusterRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetAzureCluster', AzureCluster::class, $optionalArgs, $request)->wait();
    }

    /**
     * Describes a specific [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $formattedName = $azureClustersClient->azureNodePoolName('[PROJECT]', '[LOCATION]', '[AZURE_CLUSTER]', '[AZURE_NODE_POOL]');
     *     $response = $azureClustersClient->getAzureNodePool($formattedName);
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource to describe.
     *
     *                             `AzureNodePool` names are formatted as
     *                             `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>/azureNodePools/<node-pool-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on Google Cloud resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeMultiCloud\V1\AzureNodePool
     *
     * @throws ApiException if the remote call fails
     */
    public function getAzureNodePool($name, array $optionalArgs = [])
    {
        $request = new GetAzureNodePoolRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetAzureNodePool', AzureNodePool::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns information, such as supported Azure regions and Kubernetes
     * versions, on a given Google Cloud location.
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $formattedName = $azureClustersClient->azureServerConfigName('[PROJECT]', '[LOCATION]');
     *     $response = $azureClustersClient->getAzureServerConfig($formattedName);
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the [AzureServerConfig][google.cloud.gkemulticloud.v1.AzureServerConfig] resource to describe.
     *
     *                             `AzureServerConfig` names are formatted as
     *                             `projects/<project-id>/locations/<region>/azureServerConfig`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on Google Cloud resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\GkeMultiCloud\V1\AzureServerConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getAzureServerConfig($name, array $optionalArgs = [])
    {
        $request = new GetAzureServerConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetAzureServerConfig', AzureServerConfig::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists all [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resources on a given Google Cloud project and
     * region.
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $formattedParent = $azureClustersClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $azureClustersClient->listAzureClients($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $azureClustersClient->listAzureClients($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent location which owns this collection of
     *                             [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resources.
     *
     *                             Location names are formatted as `projects/<project-id>/locations/<region>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on GCP resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAzureClients($parent, array $optionalArgs = [])
    {
        $request = new ListAzureClientsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListAzureClients', $optionalArgs, ListAzureClientsResponse::class, $request);
    }

    /**
     * Lists all [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resources on a given Google Cloud project and
     * region.
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $formattedParent = $azureClustersClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $azureClustersClient->listAzureClusters($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $azureClustersClient->listAzureClusters($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent location which owns this collection of
     *                             [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resources.
     *
     *                             Location names are formatted as `projects/<project-id>/locations/<region>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on GCP resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAzureClusters($parent, array $optionalArgs = [])
    {
        $request = new ListAzureClustersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListAzureClusters', $optionalArgs, ListAzureClustersResponse::class, $request);
    }

    /**
     * Lists all [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resources on a given [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $formattedParent = $azureClustersClient->azureClusterName('[PROJECT]', '[LOCATION]', '[AZURE_CLUSTER]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $azureClustersClient->listAzureNodePools($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $azureClustersClient->listAzureNodePools($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent `AzureCluster` which owns this collection of
     *                             [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resources.
     *
     *                             `AzureCluster` names are formatted as
     *                             `projects/<project-id>/locations/<region>/azureClusters/<cluster-id>`.
     *
     *                             See [Resource Names](https://cloud.google.com/apis/design/resource_names)
     *                             for more details on Google Cloud resource names.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAzureNodePools($parent, array $optionalArgs = [])
    {
        $request = new ListAzureNodePoolsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListAzureNodePools', $optionalArgs, ListAzureNodePoolsResponse::class, $request);
    }

    /**
     * Updates an [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $azureCluster = new AzureCluster();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $azureClustersClient->updateAzureCluster($azureCluster, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $azureClustersClient->updateAzureCluster($azureCluster, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $azureClustersClient->resumeOperation($operationName, 'updateAzureCluster');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param AzureCluster $azureCluster Required. The [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource to update.
     * @param FieldMask    $updateMask   Required. Mask of fields to update. At least one path must be supplied in
     *                                   this field. The elements of the repeated paths field can only include these
     *                                   fields from [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]:
     *
     *                                   *   `description`.
     *                                   *   `annotations`.
     *                                   *   `azureClient`.
     *                                   *   `control_plane.version`.
     *                                   *   `control_plane.vm_size`.
     *                                   *   `authorization.admin_users`.
     *                                   *   `control_plane.root_volume.size_gib`.
     *                                   *   `logging_config`
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but do not actually update the cluster.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAzureCluster($azureCluster, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateAzureClusterRequest();
        $requestParamHeaders = [];
        $request->setAzureCluster($azureCluster);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['azure_cluster.name'] = $azureCluster->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateAzureCluster', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates an [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool].
     *
     * Sample code:
     * ```
     * $azureClustersClient = new AzureClustersClient();
     * try {
     *     $azureNodePool = new AzureNodePool();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $azureClustersClient->updateAzureNodePool($azureNodePool, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $azureClustersClient->updateAzureNodePool($azureNodePool, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $azureClustersClient->resumeOperation($operationName, 'updateAzureNodePool');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $azureClustersClient->close();
     * }
     * ```
     *
     * @param AzureNodePool $azureNodePool Required. The [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource to update.
     * @param FieldMask     $updateMask    Required. Mask of fields to update. At least one path must be supplied in
     *                                     this field. The elements of the repeated paths field can only include these
     *                                     fields from [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]:
     *
     *                                     *.  `annotations`.
     *                                     *   `version`.
     *                                     *   `autoscaling.min_node_count`.
     *                                     *   `autoscaling.max_node_count`.
     *                                     *   `config.vm_size`.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           If set, only validate the request, but don't actually update the node pool.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAzureNodePool($azureNodePool, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateAzureNodePoolRequest();
        $requestParamHeaders = [];
        $request->setAzureNodePool($azureNodePool);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['azure_node_pool.name'] = $azureNodePool->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateAzureNodePool', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }
}
