<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/functions/v1/functions.proto

namespace Google\Cloud\Functions\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Describes a Cloud Function that contains user computation executed in
 * response to an event. It encapsulate function and triggers configurations.
 *
 * Generated from protobuf message <code>google.cloud.functions.v1.CloudFunction</code>
 */
class CloudFunction extends \Google\Protobuf\Internal\Message
{
    /**
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * User-provided description of a function.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     */
    private $description = '';
    /**
     * Output only. Status of the function deployment.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $status = 0;
    /**
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * For Node.js this is name of a function exported by the module specified
     * in `source_location`.
     *
     * Generated from protobuf field <code>string entry_point = 8;</code>
     */
    private $entry_point = '';
    /**
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     *
     * Generated from protobuf field <code>string runtime = 19;</code>
     */
    private $runtime = '';
    /**
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 9;</code>
     */
    private $timeout = null;
    /**
     * The amount of memory in MB available for a function.
     * Defaults to 256MB.
     *
     * Generated from protobuf field <code>int32 available_memory_mb = 10;</code>
     */
    private $available_memory_mb = 0;
    /**
     * The email of the function's service account. If empty, defaults to
     * `{project_id}&#64;appspot.gserviceaccount.com`.
     *
     * Generated from protobuf field <code>string service_account_email = 11;</code>
     */
    private $service_account_email = '';
    /**
     * Output only. The last update timestamp of a Cloud Function.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * Output only. The version identifier of the Cloud Function. Each deployment attempt
     * results in a new version of a function being created.
     *
     * Generated from protobuf field <code>int64 version_id = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $version_id = 0;
    /**
     * Labels associated with this Cloud Function.
     *
     * Generated from protobuf field <code>map<string, string> labels = 15;</code>
     */
    private $labels;
    /**
     * Environment variables that shall be available during function execution.
     *
     * Generated from protobuf field <code>map<string, string> environment_variables = 17;</code>
     */
    private $environment_variables;
    /**
     * Build environment variables that shall be available during build time.
     *
     * Generated from protobuf field <code>map<string, string> build_environment_variables = 28;</code>
     */
    private $build_environment_variables;
    /**
     * The VPC Network that this cloud function can connect to. It can be
     * either the fully-qualified URI, or the short name of the network resource.
     * If the short network name is used, the network must belong to the same
     * project. Otherwise, it must belong to a project within the same
     * organization. The format of this field is either
     * `projects/{project}/global/networks/{network}` or `{network}`, where
     * `{project}` is a project id where the network is defined, and `{network}`
     * is the short name of the network.
     * This field is mutually exclusive with `vpc_connector` and will be replaced
     * by it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     *
     * Generated from protobuf field <code>string network = 18;</code>
     */
    private $network = '';
    /**
     * The limit on the maximum number of function instances that may coexist at a
     * given time.
     * In some cases, such as rapid traffic surges, Cloud Functions may, for a
     * short period of time, create more instances than the specified max
     * instances limit. If your function cannot tolerate this temporary behavior,
     * you may want to factor in a safety margin and set a lower max instances
     * value than your function can tolerate.
     * See the [Max
     * Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
     * more details.
     *
     * Generated from protobuf field <code>int32 max_instances = 20;</code>
     */
    private $max_instances = 0;
    /**
     * A lower bound for the number function instances that may coexist at a
     * given time.
     *
     * Generated from protobuf field <code>int32 min_instances = 32;</code>
     */
    private $min_instances = 0;
    /**
     * The VPC Network Connector that this cloud function can connect to. It can
     * be either the fully-qualified URI, or the short name of the network
     * connector resource. The format of this field is
     * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
     * This field is mutually exclusive with `network` field and will eventually
     * replace it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     *
     * Generated from protobuf field <code>string vpc_connector = 22;</code>
     */
    private $vpc_connector = '';
    /**
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;</code>
     */
    private $vpc_connector_egress_settings = 0;
    /**
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
     */
    private $ingress_settings = 0;
    /**
     * Resource name of a KMS crypto key (managed by the user) used to
     * encrypt/decrypt function resources.
     * It must match the pattern
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * If specified, you must also provide an artifact registry repository using
     * the `docker_repository` field that was created with the same KMS crypto
     * key.
     * The following service accounts need to be granted the role 'Cloud KMS
     * CryptoKey Encrypter/Decrypter (roles/cloudkms.cryptoKeyEncrypterDecrypter)'
     * on the Key/KeyRing/Project/Organization (least access preferred).
     * 1. Google Cloud Functions service account
     *    (service-{project_number}&#64;gcf-admin-robot.iam.gserviceaccount.com) -
     *    Required to protect the function's image.
     * 2. Google Storage service account
     *    (service-{project_number}&#64;gs-project-accounts.iam.gserviceaccount.com) -
     *    Required to protect the function's source code.
     *    If this service account does not exist, deploying a function without a
     *    KMS key or retrieving the service agent name provisions it. For more
     *    information, see
     *    https://cloud.google.com/storage/docs/projects#service-agents and
     *    https://cloud.google.com/storage/docs/getting-service-agent#gsutil.
     * Google Cloud Functions delegates access to service agents to protect
     * function resources in internal projects that are not accessible by the
     * end user.
     *
     * Generated from protobuf field <code>string kms_key_name = 25 [(.google.api.resource_reference) = {</code>
     */
    private $kms_key_name = '';
    /**
     * Name of the Cloud Build Custom Worker Pool that should be used to build the
     * function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     * If the project id is not the same as the function, then the Cloud
     * Functions Service Agent
     * (`service-<project_number>&#64;gcf-admin-robot.iam.gserviceaccount.com`) must
     * be granted the role Cloud Build Custom Workers Builder
     * (`roles/cloudbuild.customworkers.builder`) in the project.
     *
     * Generated from protobuf field <code>string build_worker_pool = 26;</code>
     */
    private $build_worker_pool = '';
    /**
     * Output only. The Cloud Build ID of the latest successful deployment of the
     * function.
     *
     * Generated from protobuf field <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $build_id = '';
    /**
     * Output only. The Cloud Build Name of the function deployment.
     * `projects/<project-number>/locations/<region>/builds/<build-id>`.
     *
     * Generated from protobuf field <code>string build_name = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $build_name = '';
    /**
     * Secret environment variables configuration.
     *
     * Generated from protobuf field <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;</code>
     */
    private $secret_environment_variables;
    /**
     * Secret volumes configuration.
     *
     * Generated from protobuf field <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     */
    private $secret_volumes;
    /**
     * Input only. An identifier for Firebase function sources. Disclaimer: This field is only
     * supported for Firebase function deployments.
     *
     * Generated from protobuf field <code>string source_token = 31 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $source_token = '';
    /**
     * User managed repository created in Artifact Registry optionally with a
     * customer managed encryption key. If specified, deployments will use
     * Artifact Registry. If unspecified and the deployment is eligible to use
     * Artifact Registry, GCF will create and use a repository named
     * 'gcf-artifacts' for every deployed region. This is the repository to which
     * the function docker image will be pushed after it is built by Cloud Build.
     * It must match the pattern
     * `projects/{project}/locations/{location}/repositories/{repository}`.
     * Cross-project repositories are not supported.
     * Cross-location repositories are not supported.
     * Repository format must be 'DOCKER'.
     *
     * Generated from protobuf field <code>string docker_repository = 34 [(.google.api.resource_reference) = {</code>
     */
    private $docker_repository = '';
    /**
     * Docker Registry to use for this deployment.
     * If `docker_repository` field is specified, this field will be automatically
     * set as `ARTIFACT_REGISTRY`.
     * If unspecified, it currently defaults to `CONTAINER_REGISTRY`.
     * This field may be overridden by the backend for eligible deployments.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.CloudFunction.DockerRegistry docker_registry = 35;</code>
     */
    private $docker_registry = 0;
    protected $source_code;
    protected $trigger;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           A user-defined name of the function. Function names must be unique
     *           globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     *     @type string $description
     *           User-provided description of a function.
     *     @type string $source_archive_url
     *           The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
     *           archive which contains the function.
     *     @type \Google\Cloud\Functions\V1\SourceRepository $source_repository
     *           **Beta Feature**
     *           The source repository where a function is hosted.
     *     @type string $source_upload_url
     *           The Google Cloud Storage signed URL used for source uploading, generated
     *           by calling [google.cloud.functions.v1.GenerateUploadUrl].
     *           The signature is validated on write methods (Create, Update)
     *           The signature is stripped from the Function object on read methods (Get,
     *           List)
     *     @type \Google\Cloud\Functions\V1\HttpsTrigger $https_trigger
     *           An HTTPS endpoint type of source that can be triggered via URL.
     *     @type \Google\Cloud\Functions\V1\EventTrigger $event_trigger
     *           A source that fires events in response to a condition in another service.
     *     @type int $status
     *           Output only. Status of the function deployment.
     *     @type string $entry_point
     *           The name of the function (as defined in source code) that will be
     *           executed. Defaults to the resource name suffix, if not specified. For
     *           backward compatibility, if function with given name is not found, then the
     *           system will try to use function named "function".
     *           For Node.js this is name of a function exported by the module specified
     *           in `source_location`.
     *     @type string $runtime
     *           The runtime in which to run the function. Required when deploying a new
     *           function, optional when updating an existing function. For a complete
     *           list of possible choices, see the
     *           [`gcloud` command
     *           reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     *     @type \Google\Protobuf\Duration $timeout
     *           The function execution timeout. Execution is considered failed and
     *           can be terminated if the function is not completed at the end of the
     *           timeout period. Defaults to 60 seconds.
     *     @type int $available_memory_mb
     *           The amount of memory in MB available for a function.
     *           Defaults to 256MB.
     *     @type string $service_account_email
     *           The email of the function's service account. If empty, defaults to
     *           `{project_id}&#64;appspot.gserviceaccount.com`.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The last update timestamp of a Cloud Function.
     *     @type int|string $version_id
     *           Output only. The version identifier of the Cloud Function. Each deployment attempt
     *           results in a new version of a function being created.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels associated with this Cloud Function.
     *     @type array|\Google\Protobuf\Internal\MapField $environment_variables
     *           Environment variables that shall be available during function execution.
     *     @type array|\Google\Protobuf\Internal\MapField $build_environment_variables
     *           Build environment variables that shall be available during build time.
     *     @type string $network
     *           The VPC Network that this cloud function can connect to. It can be
     *           either the fully-qualified URI, or the short name of the network resource.
     *           If the short network name is used, the network must belong to the same
     *           project. Otherwise, it must belong to a project within the same
     *           organization. The format of this field is either
     *           `projects/{project}/global/networks/{network}` or `{network}`, where
     *           `{project}` is a project id where the network is defined, and `{network}`
     *           is the short name of the network.
     *           This field is mutually exclusive with `vpc_connector` and will be replaced
     *           by it.
     *           See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     *           more information on connecting Cloud projects.
     *     @type int $max_instances
     *           The limit on the maximum number of function instances that may coexist at a
     *           given time.
     *           In some cases, such as rapid traffic surges, Cloud Functions may, for a
     *           short period of time, create more instances than the specified max
     *           instances limit. If your function cannot tolerate this temporary behavior,
     *           you may want to factor in a safety margin and set a lower max instances
     *           value than your function can tolerate.
     *           See the [Max
     *           Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
     *           more details.
     *     @type int $min_instances
     *           A lower bound for the number function instances that may coexist at a
     *           given time.
     *     @type string $vpc_connector
     *           The VPC Network Connector that this cloud function can connect to. It can
     *           be either the fully-qualified URI, or the short name of the network
     *           connector resource. The format of this field is
     *           `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
     *           This field is mutually exclusive with `network` field and will eventually
     *           replace it.
     *           See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     *           more information on connecting Cloud projects.
     *     @type int $vpc_connector_egress_settings
     *           The egress settings for the connector, controlling what traffic is diverted
     *           through it.
     *     @type int $ingress_settings
     *           The ingress settings for the function, controlling what traffic can reach
     *           it.
     *     @type string $kms_key_name
     *           Resource name of a KMS crypto key (managed by the user) used to
     *           encrypt/decrypt function resources.
     *           It must match the pattern
     *           `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     *           If specified, you must also provide an artifact registry repository using
     *           the `docker_repository` field that was created with the same KMS crypto
     *           key.
     *           The following service accounts need to be granted the role 'Cloud KMS
     *           CryptoKey Encrypter/Decrypter (roles/cloudkms.cryptoKeyEncrypterDecrypter)'
     *           on the Key/KeyRing/Project/Organization (least access preferred).
     *           1. Google Cloud Functions service account
     *              (service-{project_number}&#64;gcf-admin-robot.iam.gserviceaccount.com) -
     *              Required to protect the function's image.
     *           2. Google Storage service account
     *              (service-{project_number}&#64;gs-project-accounts.iam.gserviceaccount.com) -
     *              Required to protect the function's source code.
     *              If this service account does not exist, deploying a function without a
     *              KMS key or retrieving the service agent name provisions it. For more
     *              information, see
     *              https://cloud.google.com/storage/docs/projects#service-agents and
     *              https://cloud.google.com/storage/docs/getting-service-agent#gsutil.
     *           Google Cloud Functions delegates access to service agents to protect
     *           function resources in internal projects that are not accessible by the
     *           end user.
     *     @type string $build_worker_pool
     *           Name of the Cloud Build Custom Worker Pool that should be used to build the
     *           function. The format of this field is
     *           `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     *           `{project}` and `{region}` are the project id and region respectively where
     *           the worker pool is defined and `{workerPool}` is the short name of the
     *           worker pool.
     *           If the project id is not the same as the function, then the Cloud
     *           Functions Service Agent
     *           (`service-<project_number>&#64;gcf-admin-robot.iam.gserviceaccount.com`) must
     *           be granted the role Cloud Build Custom Workers Builder
     *           (`roles/cloudbuild.customworkers.builder`) in the project.
     *     @type string $build_id
     *           Output only. The Cloud Build ID of the latest successful deployment of the
     *           function.
     *     @type string $build_name
     *           Output only. The Cloud Build Name of the function deployment.
     *           `projects/<project-number>/locations/<region>/builds/<build-id>`.
     *     @type \Google\Cloud\Functions\V1\SecretEnvVar[]|\Google\Protobuf\Internal\RepeatedField $secret_environment_variables
     *           Secret environment variables configuration.
     *     @type \Google\Cloud\Functions\V1\SecretVolume[]|\Google\Protobuf\Internal\RepeatedField $secret_volumes
     *           Secret volumes configuration.
     *     @type string $source_token
     *           Input only. An identifier for Firebase function sources. Disclaimer: This field is only
     *           supported for Firebase function deployments.
     *     @type string $docker_repository
     *           User managed repository created in Artifact Registry optionally with a
     *           customer managed encryption key. If specified, deployments will use
     *           Artifact Registry. If unspecified and the deployment is eligible to use
     *           Artifact Registry, GCF will create and use a repository named
     *           'gcf-artifacts' for every deployed region. This is the repository to which
     *           the function docker image will be pushed after it is built by Cloud Build.
     *           It must match the pattern
     *           `projects/{project}/locations/{location}/repositories/{repository}`.
     *           Cross-project repositories are not supported.
     *           Cross-location repositories are not supported.
     *           Repository format must be 'DOCKER'.
     *     @type int $docker_registry
     *           Docker Registry to use for this deployment.
     *           If `docker_repository` field is specified, this field will be automatically
     *           set as `ARTIFACT_REGISTRY`.
     *           If unspecified, it currently defaults to `CONTAINER_REGISTRY`.
     *           This field may be overridden by the backend for eligible deployments.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Functions\V1\Functions::initOnce();
        parent::__construct($data);
    }

    /**
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * User-provided description of a function.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * User-provided description of a function.
     *
     * Generated from protobuf field <code>string description = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
     * archive which contains the function.
     *
     * Generated from protobuf field <code>string source_archive_url = 3;</code>
     * @return string
     */
    public function getSourceArchiveUrl()
    {
        return $this->readOneof(3);
    }

    public function hasSourceArchiveUrl()
    {
        return $this->hasOneof(3);
    }

    /**
     * The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
     * archive which contains the function.
     *
     * Generated from protobuf field <code>string source_archive_url = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceArchiveUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * **Beta Feature**
     * The source repository where a function is hosted.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     * @return \Google\Cloud\Functions\V1\SourceRepository|null
     */
    public function getSourceRepository()
    {
        return $this->readOneof(4);
    }

    public function hasSourceRepository()
    {
        return $this->hasOneof(4);
    }

    /**
     * **Beta Feature**
     * The source repository where a function is hosted.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.SourceRepository source_repository = 4;</code>
     * @param \Google\Cloud\Functions\V1\SourceRepository $var
     * @return $this
     */
    public function setSourceRepository($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Functions\V1\SourceRepository::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * The Google Cloud Storage signed URL used for source uploading, generated
     * by calling [google.cloud.functions.v1.GenerateUploadUrl].
     * The signature is validated on write methods (Create, Update)
     * The signature is stripped from the Function object on read methods (Get,
     * List)
     *
     * Generated from protobuf field <code>string source_upload_url = 16;</code>
     * @return string
     */
    public function getSourceUploadUrl()
    {
        return $this->readOneof(16);
    }

    public function hasSourceUploadUrl()
    {
        return $this->hasOneof(16);
    }

    /**
     * The Google Cloud Storage signed URL used for source uploading, generated
     * by calling [google.cloud.functions.v1.GenerateUploadUrl].
     * The signature is validated on write methods (Create, Update)
     * The signature is stripped from the Function object on read methods (Get,
     * List)
     *
     * Generated from protobuf field <code>string source_upload_url = 16;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceUploadUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(16, $var);

        return $this;
    }

    /**
     * An HTTPS endpoint type of source that can be triggered via URL.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     * @return \Google\Cloud\Functions\V1\HttpsTrigger|null
     */
    public function getHttpsTrigger()
    {
        return $this->readOneof(5);
    }

    public function hasHttpsTrigger()
    {
        return $this->hasOneof(5);
    }

    /**
     * An HTTPS endpoint type of source that can be triggered via URL.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.HttpsTrigger https_trigger = 5;</code>
     * @param \Google\Cloud\Functions\V1\HttpsTrigger $var
     * @return $this
     */
    public function setHttpsTrigger($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Functions\V1\HttpsTrigger::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * A source that fires events in response to a condition in another service.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     * @return \Google\Cloud\Functions\V1\EventTrigger|null
     */
    public function getEventTrigger()
    {
        return $this->readOneof(6);
    }

    public function hasEventTrigger()
    {
        return $this->hasOneof(6);
    }

    /**
     * A source that fires events in response to a condition in another service.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.EventTrigger event_trigger = 6;</code>
     * @param \Google\Cloud\Functions\V1\EventTrigger $var
     * @return $this
     */
    public function setEventTrigger($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Functions\V1\EventTrigger::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Output only. Status of the function deployment.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Output only. Status of the function deployment.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.CloudFunctionStatus status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Functions\V1\CloudFunctionStatus::class);
        $this->status = $var;

        return $this;
    }

    /**
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * For Node.js this is name of a function exported by the module specified
     * in `source_location`.
     *
     * Generated from protobuf field <code>string entry_point = 8;</code>
     * @return string
     */
    public function getEntryPoint()
    {
        return $this->entry_point;
    }

    /**
     * The name of the function (as defined in source code) that will be
     * executed. Defaults to the resource name suffix, if not specified. For
     * backward compatibility, if function with given name is not found, then the
     * system will try to use function named "function".
     * For Node.js this is name of a function exported by the module specified
     * in `source_location`.
     *
     * Generated from protobuf field <code>string entry_point = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setEntryPoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->entry_point = $var;

        return $this;
    }

    /**
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     *
     * Generated from protobuf field <code>string runtime = 19;</code>
     * @return string
     */
    public function getRuntime()
    {
        return $this->runtime;
    }

    /**
     * The runtime in which to run the function. Required when deploying a new
     * function, optional when updating an existing function. For a complete
     * list of possible choices, see the
     * [`gcloud` command
     * reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
     *
     * Generated from protobuf field <code>string runtime = 19;</code>
     * @param string $var
     * @return $this
     */
    public function setRuntime($var)
    {
        GPBUtil::checkString($var, True);
        $this->runtime = $var;

        return $this;
    }

    /**
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 9;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTimeout()
    {
        return $this->timeout;
    }

    public function hasTimeout()
    {
        return isset($this->timeout);
    }

    public function clearTimeout()
    {
        unset($this->timeout);
    }

    /**
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 9;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->timeout = $var;

        return $this;
    }

    /**
     * The amount of memory in MB available for a function.
     * Defaults to 256MB.
     *
     * Generated from protobuf field <code>int32 available_memory_mb = 10;</code>
     * @return int
     */
    public function getAvailableMemoryMb()
    {
        return $this->available_memory_mb;
    }

    /**
     * The amount of memory in MB available for a function.
     * Defaults to 256MB.
     *
     * Generated from protobuf field <code>int32 available_memory_mb = 10;</code>
     * @param int $var
     * @return $this
     */
    public function setAvailableMemoryMb($var)
    {
        GPBUtil::checkInt32($var);
        $this->available_memory_mb = $var;

        return $this;
    }

    /**
     * The email of the function's service account. If empty, defaults to
     * `{project_id}&#64;appspot.gserviceaccount.com`.
     *
     * Generated from protobuf field <code>string service_account_email = 11;</code>
     * @return string
     */
    public function getServiceAccountEmail()
    {
        return $this->service_account_email;
    }

    /**
     * The email of the function's service account. If empty, defaults to
     * `{project_id}&#64;appspot.gserviceaccount.com`.
     *
     * Generated from protobuf field <code>string service_account_email = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccountEmail($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account_email = $var;

        return $this;
    }

    /**
     * Output only. The last update timestamp of a Cloud Function.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The last update timestamp of a Cloud Function.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. The version identifier of the Cloud Function. Each deployment attempt
     * results in a new version of a function being created.
     *
     * Generated from protobuf field <code>int64 version_id = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getVersionId()
    {
        return $this->version_id;
    }

    /**
     * Output only. The version identifier of the Cloud Function. Each deployment attempt
     * results in a new version of a function being created.
     *
     * Generated from protobuf field <code>int64 version_id = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setVersionId($var)
    {
        GPBUtil::checkInt64($var);
        $this->version_id = $var;

        return $this;
    }

    /**
     * Labels associated with this Cloud Function.
     *
     * Generated from protobuf field <code>map<string, string> labels = 15;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels associated with this Cloud Function.
     *
     * Generated from protobuf field <code>map<string, string> labels = 15;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Environment variables that shall be available during function execution.
     *
     * Generated from protobuf field <code>map<string, string> environment_variables = 17;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getEnvironmentVariables()
    {
        return $this->environment_variables;
    }

    /**
     * Environment variables that shall be available during function execution.
     *
     * Generated from protobuf field <code>map<string, string> environment_variables = 17;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setEnvironmentVariables($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->environment_variables = $arr;

        return $this;
    }

    /**
     * Build environment variables that shall be available during build time.
     *
     * Generated from protobuf field <code>map<string, string> build_environment_variables = 28;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getBuildEnvironmentVariables()
    {
        return $this->build_environment_variables;
    }

    /**
     * Build environment variables that shall be available during build time.
     *
     * Generated from protobuf field <code>map<string, string> build_environment_variables = 28;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setBuildEnvironmentVariables($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->build_environment_variables = $arr;

        return $this;
    }

    /**
     * The VPC Network that this cloud function can connect to. It can be
     * either the fully-qualified URI, or the short name of the network resource.
     * If the short network name is used, the network must belong to the same
     * project. Otherwise, it must belong to a project within the same
     * organization. The format of this field is either
     * `projects/{project}/global/networks/{network}` or `{network}`, where
     * `{project}` is a project id where the network is defined, and `{network}`
     * is the short name of the network.
     * This field is mutually exclusive with `vpc_connector` and will be replaced
     * by it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     *
     * Generated from protobuf field <code>string network = 18;</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * The VPC Network that this cloud function can connect to. It can be
     * either the fully-qualified URI, or the short name of the network resource.
     * If the short network name is used, the network must belong to the same
     * project. Otherwise, it must belong to a project within the same
     * organization. The format of this field is either
     * `projects/{project}/global/networks/{network}` or `{network}`, where
     * `{project}` is a project id where the network is defined, and `{network}`
     * is the short name of the network.
     * This field is mutually exclusive with `vpc_connector` and will be replaced
     * by it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     *
     * Generated from protobuf field <code>string network = 18;</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * The limit on the maximum number of function instances that may coexist at a
     * given time.
     * In some cases, such as rapid traffic surges, Cloud Functions may, for a
     * short period of time, create more instances than the specified max
     * instances limit. If your function cannot tolerate this temporary behavior,
     * you may want to factor in a safety margin and set a lower max instances
     * value than your function can tolerate.
     * See the [Max
     * Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
     * more details.
     *
     * Generated from protobuf field <code>int32 max_instances = 20;</code>
     * @return int
     */
    public function getMaxInstances()
    {
        return $this->max_instances;
    }

    /**
     * The limit on the maximum number of function instances that may coexist at a
     * given time.
     * In some cases, such as rapid traffic surges, Cloud Functions may, for a
     * short period of time, create more instances than the specified max
     * instances limit. If your function cannot tolerate this temporary behavior,
     * you may want to factor in a safety margin and set a lower max instances
     * value than your function can tolerate.
     * See the [Max
     * Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
     * more details.
     *
     * Generated from protobuf field <code>int32 max_instances = 20;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxInstances($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_instances = $var;

        return $this;
    }

    /**
     * A lower bound for the number function instances that may coexist at a
     * given time.
     *
     * Generated from protobuf field <code>int32 min_instances = 32;</code>
     * @return int
     */
    public function getMinInstances()
    {
        return $this->min_instances;
    }

    /**
     * A lower bound for the number function instances that may coexist at a
     * given time.
     *
     * Generated from protobuf field <code>int32 min_instances = 32;</code>
     * @param int $var
     * @return $this
     */
    public function setMinInstances($var)
    {
        GPBUtil::checkInt32($var);
        $this->min_instances = $var;

        return $this;
    }

    /**
     * The VPC Network Connector that this cloud function can connect to. It can
     * be either the fully-qualified URI, or the short name of the network
     * connector resource. The format of this field is
     * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
     * This field is mutually exclusive with `network` field and will eventually
     * replace it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     *
     * Generated from protobuf field <code>string vpc_connector = 22;</code>
     * @return string
     */
    public function getVpcConnector()
    {
        return $this->vpc_connector;
    }

    /**
     * The VPC Network Connector that this cloud function can connect to. It can
     * be either the fully-qualified URI, or the short name of the network
     * connector resource. The format of this field is
     * `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`
     * This field is mutually exclusive with `network` field and will eventually
     * replace it.
     * See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
     * more information on connecting Cloud projects.
     *
     * Generated from protobuf field <code>string vpc_connector = 22;</code>
     * @param string $var
     * @return $this
     */
    public function setVpcConnector($var)
    {
        GPBUtil::checkString($var, True);
        $this->vpc_connector = $var;

        return $this;
    }

    /**
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;</code>
     * @return int
     */
    public function getVpcConnectorEgressSettings()
    {
        return $this->vpc_connector_egress_settings;
    }

    /**
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings vpc_connector_egress_settings = 23;</code>
     * @param int $var
     * @return $this
     */
    public function setVpcConnectorEgressSettings($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Functions\V1\CloudFunction\VpcConnectorEgressSettings::class);
        $this->vpc_connector_egress_settings = $var;

        return $this;
    }

    /**
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
     * @return int
     */
    public function getIngressSettings()
    {
        return $this->ingress_settings;
    }

    /**
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.CloudFunction.IngressSettings ingress_settings = 24;</code>
     * @param int $var
     * @return $this
     */
    public function setIngressSettings($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Functions\V1\CloudFunction\IngressSettings::class);
        $this->ingress_settings = $var;

        return $this;
    }

    /**
     * Resource name of a KMS crypto key (managed by the user) used to
     * encrypt/decrypt function resources.
     * It must match the pattern
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * If specified, you must also provide an artifact registry repository using
     * the `docker_repository` field that was created with the same KMS crypto
     * key.
     * The following service accounts need to be granted the role 'Cloud KMS
     * CryptoKey Encrypter/Decrypter (roles/cloudkms.cryptoKeyEncrypterDecrypter)'
     * on the Key/KeyRing/Project/Organization (least access preferred).
     * 1. Google Cloud Functions service account
     *    (service-{project_number}&#64;gcf-admin-robot.iam.gserviceaccount.com) -
     *    Required to protect the function's image.
     * 2. Google Storage service account
     *    (service-{project_number}&#64;gs-project-accounts.iam.gserviceaccount.com) -
     *    Required to protect the function's source code.
     *    If this service account does not exist, deploying a function without a
     *    KMS key or retrieving the service agent name provisions it. For more
     *    information, see
     *    https://cloud.google.com/storage/docs/projects#service-agents and
     *    https://cloud.google.com/storage/docs/getting-service-agent#gsutil.
     * Google Cloud Functions delegates access to service agents to protect
     * function resources in internal projects that are not accessible by the
     * end user.
     *
     * Generated from protobuf field <code>string kms_key_name = 25 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getKmsKeyName()
    {
        return $this->kms_key_name;
    }

    /**
     * Resource name of a KMS crypto key (managed by the user) used to
     * encrypt/decrypt function resources.
     * It must match the pattern
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * If specified, you must also provide an artifact registry repository using
     * the `docker_repository` field that was created with the same KMS crypto
     * key.
     * The following service accounts need to be granted the role 'Cloud KMS
     * CryptoKey Encrypter/Decrypter (roles/cloudkms.cryptoKeyEncrypterDecrypter)'
     * on the Key/KeyRing/Project/Organization (least access preferred).
     * 1. Google Cloud Functions service account
     *    (service-{project_number}&#64;gcf-admin-robot.iam.gserviceaccount.com) -
     *    Required to protect the function's image.
     * 2. Google Storage service account
     *    (service-{project_number}&#64;gs-project-accounts.iam.gserviceaccount.com) -
     *    Required to protect the function's source code.
     *    If this service account does not exist, deploying a function without a
     *    KMS key or retrieving the service agent name provisions it. For more
     *    information, see
     *    https://cloud.google.com/storage/docs/projects#service-agents and
     *    https://cloud.google.com/storage/docs/getting-service-agent#gsutil.
     * Google Cloud Functions delegates access to service agents to protect
     * function resources in internal projects that are not accessible by the
     * end user.
     *
     * Generated from protobuf field <code>string kms_key_name = 25 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKeyName($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key_name = $var;

        return $this;
    }

    /**
     * Name of the Cloud Build Custom Worker Pool that should be used to build the
     * function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     * If the project id is not the same as the function, then the Cloud
     * Functions Service Agent
     * (`service-<project_number>&#64;gcf-admin-robot.iam.gserviceaccount.com`) must
     * be granted the role Cloud Build Custom Workers Builder
     * (`roles/cloudbuild.customworkers.builder`) in the project.
     *
     * Generated from protobuf field <code>string build_worker_pool = 26;</code>
     * @return string
     */
    public function getBuildWorkerPool()
    {
        return $this->build_worker_pool;
    }

    /**
     * Name of the Cloud Build Custom Worker Pool that should be used to build the
     * function. The format of this field is
     * `projects/{project}/locations/{region}/workerPools/{workerPool}` where
     * `{project}` and `{region}` are the project id and region respectively where
     * the worker pool is defined and `{workerPool}` is the short name of the
     * worker pool.
     * If the project id is not the same as the function, then the Cloud
     * Functions Service Agent
     * (`service-<project_number>&#64;gcf-admin-robot.iam.gserviceaccount.com`) must
     * be granted the role Cloud Build Custom Workers Builder
     * (`roles/cloudbuild.customworkers.builder`) in the project.
     *
     * Generated from protobuf field <code>string build_worker_pool = 26;</code>
     * @param string $var
     * @return $this
     */
    public function setBuildWorkerPool($var)
    {
        GPBUtil::checkString($var, True);
        $this->build_worker_pool = $var;

        return $this;
    }

    /**
     * Output only. The Cloud Build ID of the latest successful deployment of the
     * function.
     *
     * Generated from protobuf field <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getBuildId()
    {
        return $this->build_id;
    }

    /**
     * Output only. The Cloud Build ID of the latest successful deployment of the
     * function.
     *
     * Generated from protobuf field <code>string build_id = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setBuildId($var)
    {
        GPBUtil::checkString($var, True);
        $this->build_id = $var;

        return $this;
    }

    /**
     * Output only. The Cloud Build Name of the function deployment.
     * `projects/<project-number>/locations/<region>/builds/<build-id>`.
     *
     * Generated from protobuf field <code>string build_name = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getBuildName()
    {
        return $this->build_name;
    }

    /**
     * Output only. The Cloud Build Name of the function deployment.
     * `projects/<project-number>/locations/<region>/builds/<build-id>`.
     *
     * Generated from protobuf field <code>string build_name = 33 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setBuildName($var)
    {
        GPBUtil::checkString($var, True);
        $this->build_name = $var;

        return $this;
    }

    /**
     * Secret environment variables configuration.
     *
     * Generated from protobuf field <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSecretEnvironmentVariables()
    {
        return $this->secret_environment_variables;
    }

    /**
     * Secret environment variables configuration.
     *
     * Generated from protobuf field <code>repeated .google.cloud.functions.v1.SecretEnvVar secret_environment_variables = 29;</code>
     * @param \Google\Cloud\Functions\V1\SecretEnvVar[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSecretEnvironmentVariables($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Functions\V1\SecretEnvVar::class);
        $this->secret_environment_variables = $arr;

        return $this;
    }

    /**
     * Secret volumes configuration.
     *
     * Generated from protobuf field <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSecretVolumes()
    {
        return $this->secret_volumes;
    }

    /**
     * Secret volumes configuration.
     *
     * Generated from protobuf field <code>repeated .google.cloud.functions.v1.SecretVolume secret_volumes = 30;</code>
     * @param \Google\Cloud\Functions\V1\SecretVolume[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSecretVolumes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Functions\V1\SecretVolume::class);
        $this->secret_volumes = $arr;

        return $this;
    }

    /**
     * Input only. An identifier for Firebase function sources. Disclaimer: This field is only
     * supported for Firebase function deployments.
     *
     * Generated from protobuf field <code>string source_token = 31 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return string
     */
    public function getSourceToken()
    {
        return $this->source_token;
    }

    /**
     * Input only. An identifier for Firebase function sources. Disclaimer: This field is only
     * supported for Firebase function deployments.
     *
     * Generated from protobuf field <code>string source_token = 31 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSourceToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_token = $var;

        return $this;
    }

    /**
     * User managed repository created in Artifact Registry optionally with a
     * customer managed encryption key. If specified, deployments will use
     * Artifact Registry. If unspecified and the deployment is eligible to use
     * Artifact Registry, GCF will create and use a repository named
     * 'gcf-artifacts' for every deployed region. This is the repository to which
     * the function docker image will be pushed after it is built by Cloud Build.
     * It must match the pattern
     * `projects/{project}/locations/{location}/repositories/{repository}`.
     * Cross-project repositories are not supported.
     * Cross-location repositories are not supported.
     * Repository format must be 'DOCKER'.
     *
     * Generated from protobuf field <code>string docker_repository = 34 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getDockerRepository()
    {
        return $this->docker_repository;
    }

    /**
     * User managed repository created in Artifact Registry optionally with a
     * customer managed encryption key. If specified, deployments will use
     * Artifact Registry. If unspecified and the deployment is eligible to use
     * Artifact Registry, GCF will create and use a repository named
     * 'gcf-artifacts' for every deployed region. This is the repository to which
     * the function docker image will be pushed after it is built by Cloud Build.
     * It must match the pattern
     * `projects/{project}/locations/{location}/repositories/{repository}`.
     * Cross-project repositories are not supported.
     * Cross-location repositories are not supported.
     * Repository format must be 'DOCKER'.
     *
     * Generated from protobuf field <code>string docker_repository = 34 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setDockerRepository($var)
    {
        GPBUtil::checkString($var, True);
        $this->docker_repository = $var;

        return $this;
    }

    /**
     * Docker Registry to use for this deployment.
     * If `docker_repository` field is specified, this field will be automatically
     * set as `ARTIFACT_REGISTRY`.
     * If unspecified, it currently defaults to `CONTAINER_REGISTRY`.
     * This field may be overridden by the backend for eligible deployments.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.CloudFunction.DockerRegistry docker_registry = 35;</code>
     * @return int
     */
    public function getDockerRegistry()
    {
        return $this->docker_registry;
    }

    /**
     * Docker Registry to use for this deployment.
     * If `docker_repository` field is specified, this field will be automatically
     * set as `ARTIFACT_REGISTRY`.
     * If unspecified, it currently defaults to `CONTAINER_REGISTRY`.
     * This field may be overridden by the backend for eligible deployments.
     *
     * Generated from protobuf field <code>.google.cloud.functions.v1.CloudFunction.DockerRegistry docker_registry = 35;</code>
     * @param int $var
     * @return $this
     */
    public function setDockerRegistry($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Functions\V1\CloudFunction\DockerRegistry::class);
        $this->docker_registry = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getSourceCode()
    {
        return $this->whichOneof("source_code");
    }

    /**
     * @return string
     */
    public function getTrigger()
    {
        return $this->whichOneof("trigger");
    }

}

