<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/functions/v2/functions.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Functions\V2\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Functions\V2\CreateFunctionRequest;
use Google\Cloud\Functions\V2\DeleteFunctionRequest;
use Google\Cloud\Functions\V2\GenerateDownloadUrlRequest;
use Google\Cloud\Functions\V2\GenerateDownloadUrlResponse;
use Google\Cloud\Functions\V2\GenerateUploadUrlRequest;
use Google\Cloud\Functions\V2\GenerateUploadUrlResponse;
use Google\Cloud\Functions\V2\GetFunctionRequest;
use Google\Cloud\Functions\V2\ListFunctionsRequest;
use Google\Cloud\Functions\V2\ListFunctionsResponse;
use Google\Cloud\Functions\V2\ListRuntimesRequest;
use Google\Cloud\Functions\V2\ListRuntimesResponse;
use Google\Cloud\Functions\V2\PBFunction;
use Google\Cloud\Functions\V2\UpdateFunctionRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Google Cloud Functions is used to deploy functions that are executed by
 * Google in response to various events. Data connected with that event is
 * passed to a function as the input data.
 *
 * A **function** is a resource which describes a function that should be
 * executed and how it is triggered.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $functionServiceClient = new FunctionServiceClient();
 * try {
 *     $formattedParent = $functionServiceClient->locationName('[PROJECT]', '[LOCATION]');
 *     $function = new PBFunction();
 *     $operationResponse = $functionServiceClient->createFunction($formattedParent, $function);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $functionServiceClient->createFunction($formattedParent, $function);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $functionServiceClient->resumeOperation($operationName, 'createFunction');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $functionServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class FunctionServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.functions.v2.FunctionService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'cloudfunctions.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $buildNameTemplate;

    private static $channelNameTemplate;

    private static $connectorNameTemplate;

    private static $cryptoKeyNameTemplate;

    private static $functionNameTemplate;

    private static $locationNameTemplate;

    private static $repositoryNameTemplate;

    private static $serviceNameTemplate;

    private static $topicNameTemplate;

    private static $triggerNameTemplate;

    private static $workerPoolNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/function_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/function_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/function_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/function_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getBuildNameTemplate()
    {
        if (self::$buildNameTemplate == null) {
            self::$buildNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/builds/{build}'
            );
        }

        return self::$buildNameTemplate;
    }

    private static function getChannelNameTemplate()
    {
        if (self::$channelNameTemplate == null) {
            self::$channelNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/channels/{channel}'
            );
        }

        return self::$channelNameTemplate;
    }

    private static function getConnectorNameTemplate()
    {
        if (self::$connectorNameTemplate == null) {
            self::$connectorNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/connectors/{connector}'
            );
        }

        return self::$connectorNameTemplate;
    }

    private static function getCryptoKeyNameTemplate()
    {
        if (self::$cryptoKeyNameTemplate == null) {
            self::$cryptoKeyNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}'
            );
        }

        return self::$cryptoKeyNameTemplate;
    }

    private static function getFunctionNameTemplate()
    {
        if (self::$functionNameTemplate == null) {
            self::$functionNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/functions/{function}'
            );
        }

        return self::$functionNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getRepositoryNameTemplate()
    {
        if (self::$repositoryNameTemplate == null) {
            self::$repositoryNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/repositories/{repository}'
            );
        }

        return self::$repositoryNameTemplate;
    }

    private static function getServiceNameTemplate()
    {
        if (self::$serviceNameTemplate == null) {
            self::$serviceNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/services/{service}'
            );
        }

        return self::$serviceNameTemplate;
    }

    private static function getTopicNameTemplate()
    {
        if (self::$topicNameTemplate == null) {
            self::$topicNameTemplate = new PathTemplate(
                'projects/{project}/topics/{topic}'
            );
        }

        return self::$topicNameTemplate;
    }

    private static function getTriggerNameTemplate()
    {
        if (self::$triggerNameTemplate == null) {
            self::$triggerNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/triggers/{trigger}'
            );
        }

        return self::$triggerNameTemplate;
    }

    private static function getWorkerPoolNameTemplate()
    {
        if (self::$workerPoolNameTemplate == null) {
            self::$workerPoolNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/workerPools/{worker_pool}'
            );
        }

        return self::$workerPoolNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'build' => self::getBuildNameTemplate(),
                'channel' => self::getChannelNameTemplate(),
                'connector' => self::getConnectorNameTemplate(),
                'cryptoKey' => self::getCryptoKeyNameTemplate(),
                'function' => self::getFunctionNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'repository' => self::getRepositoryNameTemplate(),
                'service' => self::getServiceNameTemplate(),
                'topic' => self::getTopicNameTemplate(),
                'trigger' => self::getTriggerNameTemplate(),
                'workerPool' => self::getWorkerPoolNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a build
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $build
     *
     * @return string The formatted build resource.
     */
    public static function buildName($project, $location, $build)
    {
        return self::getBuildNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'build' => $build,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a channel
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $channel
     *
     * @return string The formatted channel resource.
     */
    public static function channelName($project, $location, $channel)
    {
        return self::getChannelNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'channel' => $channel,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a connector
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $connector
     *
     * @return string The formatted connector resource.
     */
    public static function connectorName($project, $location, $connector)
    {
        return self::getConnectorNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'connector' => $connector,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a crypto_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     *
     * @return string The formatted crypto_key resource.
     */
    public static function cryptoKeyName(
        $project,
        $location,
        $keyRing,
        $cryptoKey
    ) {
        return self::getCryptoKeyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a function
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $function
     *
     * @return string The formatted function resource.
     */
    public static function functionName($project, $location, $function)
    {
        return self::getFunctionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'function' => $function,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a repository
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     *
     * @return string The formatted repository resource.
     */
    public static function repositoryName($project, $location, $repository)
    {
        return self::getRepositoryNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a service
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $service
     *
     * @return string The formatted service resource.
     */
    public static function serviceName($project, $location, $service)
    {
        return self::getServiceNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'service' => $service,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a topic
     * resource.
     *
     * @param string $project
     * @param string $topic
     *
     * @return string The formatted topic resource.
     */
    public static function topicName($project, $topic)
    {
        return self::getTopicNameTemplate()->render([
            'project' => $project,
            'topic' => $topic,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a trigger
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $trigger
     *
     * @return string The formatted trigger resource.
     */
    public static function triggerName($project, $location, $trigger)
    {
        return self::getTriggerNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'trigger' => $trigger,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a worker_pool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $workerPool
     *
     * @return string The formatted worker_pool resource.
     */
    public static function workerPoolName($project, $location, $workerPool)
    {
        return self::getWorkerPoolNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'worker_pool' => $workerPool,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - build: projects/{project}/locations/{location}/builds/{build}
     * - channel: projects/{project}/locations/{location}/channels/{channel}
     * - connector: projects/{project}/locations/{location}/connectors/{connector}
     * - cryptoKey: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}
     * - function: projects/{project}/locations/{location}/functions/{function}
     * - location: projects/{project}/locations/{location}
     * - repository: projects/{project}/locations/{location}/repositories/{repository}
     * - service: projects/{project}/locations/{location}/services/{service}
     * - topic: projects/{project}/topics/{topic}
     * - trigger: projects/{project}/locations/{location}/triggers/{trigger}
     * - workerPool: projects/{project}/locations/{location}/workerPools/{worker_pool}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'cloudfunctions.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a new function. If a function with the given name already exists in
     * the specified project, the long running operation will return
     * `ALREADY_EXISTS` error.
     *
     * Sample code:
     * ```
     * $functionServiceClient = new FunctionServiceClient();
     * try {
     *     $formattedParent = $functionServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $function = new PBFunction();
     *     $operationResponse = $functionServiceClient->createFunction($formattedParent, $function);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $functionServiceClient->createFunction($formattedParent, $function);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $functionServiceClient->resumeOperation($operationName, 'createFunction');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $functionServiceClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The project and location in which the function should be created,
     *                                 specified in the format `projects/&#42;/locations/*`
     * @param PBFunction $function     Required. Function to be created.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type string $functionId
     *           The ID to use for the function, which will become the final component of
     *           the function's resource name.
     *
     *           This value should be 4-63 characters, and valid characters
     *           are /[a-z][0-9]-/.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createFunction($parent, $function, array $optionalArgs = [])
    {
        $request = new CreateFunctionRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFunction($function);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['functionId'])) {
            $request->setFunctionId($optionalArgs['functionId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateFunction',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a function with the given name from the specified project. If the
     * given function is used by some trigger, the trigger will be updated to
     * remove this function.
     *
     * Sample code:
     * ```
     * $functionServiceClient = new FunctionServiceClient();
     * try {
     *     $formattedName = $functionServiceClient->functionName('[PROJECT]', '[LOCATION]', '[FUNCTION]');
     *     $operationResponse = $functionServiceClient->deleteFunction($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $functionServiceClient->deleteFunction($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $functionServiceClient->resumeOperation($operationName, 'deleteFunction');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $functionServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the function which should be deleted.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteFunction($name, array $optionalArgs = [])
    {
        $request = new DeleteFunctionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteFunction',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Returns a signed URL for downloading deployed function source code.
     * The URL is only valid for a limited period and should be used within
     * 30 minutes of generation.
     * For more information about the signed URL usage see:
     * https://cloud.google.com/storage/docs/access-control/signed-urls
     *
     * Sample code:
     * ```
     * $functionServiceClient = new FunctionServiceClient();
     * try {
     *     $formattedName = $functionServiceClient->functionName('[PROJECT]', '[LOCATION]', '[FUNCTION]');
     *     $response = $functionServiceClient->generateDownloadUrl($formattedName);
     * } finally {
     *     $functionServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of function for which source code Google Cloud Storage
     *                             signed URL should be generated.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Functions\V2\GenerateDownloadUrlResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function generateDownloadUrl($name, array $optionalArgs = [])
    {
        $request = new GenerateDownloadUrlRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GenerateDownloadUrl',
            GenerateDownloadUrlResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns a signed URL for uploading a function source code.
     * For more information about the signed URL usage see:
     * https://cloud.google.com/storage/docs/access-control/signed-urls.
     * Once the function source code upload is complete, the used signed
     * URL should be provided in CreateFunction or UpdateFunction request
     * as a reference to the function source code.
     *
     * When uploading source code to the generated signed URL, please follow
     * these restrictions:
     *
     * * Source file type should be a zip file.
     * * No credentials should be attached - the signed URLs provide access to the
     * target bucket using internal service identity; if credentials were
     * attached, the identity from the credentials would be used, but that
     * identity does not have permissions to upload files to the URL.
     *
     * When making a HTTP PUT request, these two headers need to be specified:
     *
     * * `content-type: application/zip`
     *
     * And this header SHOULD NOT be specified:
     *
     * * `Authorization: Bearer YOUR_TOKEN`
     *
     * Sample code:
     * ```
     * $functionServiceClient = new FunctionServiceClient();
     * try {
     *     $formattedParent = $functionServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $response = $functionServiceClient->generateUploadUrl($formattedParent);
     * } finally {
     *     $functionServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location in which the Google Cloud Storage signed
     *                             URL should be generated, specified in the format `projects/&#42;/locations/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $kmsKeyName
     *           Resource name of a KMS crypto key (managed by the user) used to
     *           encrypt/decrypt function source code objects in intermediate Cloud Storage
     *           buckets. When you generate an upload url and upload your source code, it
     *           gets copied to an intermediate Cloud Storage bucket. The source code is
     *           then copied to a versioned directory in the sources bucket in the consumer
     *           project during the function deployment.
     *
     *           It must match the pattern
     *           `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     *
     *           The Google Cloud Functions service account
     *           (service-{project_number}&#64;gcf-admin-robot.iam.gserviceaccount.com) must be
     *           granted the role 'Cloud KMS CryptoKey Encrypter/Decrypter
     *           (roles/cloudkms.cryptoKeyEncrypterDecrypter)' on the
     *           Key/KeyRing/Project/Organization (least access preferred).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Functions\V2\GenerateUploadUrlResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function generateUploadUrl($parent, array $optionalArgs = [])
    {
        $request = new GenerateUploadUrlRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['kmsKeyName'])) {
            $request->setKmsKeyName($optionalArgs['kmsKeyName']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GenerateUploadUrl',
            GenerateUploadUrlResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns a function with the given name from the requested project.
     *
     * Sample code:
     * ```
     * $functionServiceClient = new FunctionServiceClient();
     * try {
     *     $formattedName = $functionServiceClient->functionName('[PROJECT]', '[LOCATION]', '[FUNCTION]');
     *     $response = $functionServiceClient->getFunction($formattedName);
     * } finally {
     *     $functionServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the function which details should be obtained.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Functions\V2\PBFunction
     *
     * @throws ApiException if the remote call fails
     */
    public function getFunction($name, array $optionalArgs = [])
    {
        $request = new GetFunctionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetFunction',
            PBFunction::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Returns a list of functions that belong to the requested project.
     *
     * Sample code:
     * ```
     * $functionServiceClient = new FunctionServiceClient();
     * try {
     *     $formattedParent = $functionServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $functionServiceClient->listFunctions($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $functionServiceClient->listFunctions($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $functionServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the function should be
     *                             listed, specified in the format `projects/&#42;/locations/*` If you want to
     *                             list functions in all locations, use "-" in place of a location. When
     *                             listing functions in all locations, if one or more location(s) are
     *                             unreachable, the response will contain functions from all reachable
     *                             locations along with the names of any unreachable locations.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           The filter for Functions that match the filter expression,
     *           following the syntax outlined in https://google.aip.dev/160.
     *     @type string $orderBy
     *           The sorting order of the resources returned. Value should be a comma
     *           separated list of fields. The default sorting oder is ascending.
     *           See https://google.aip.dev/132#ordering.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listFunctions($parent, array $optionalArgs = [])
    {
        $request = new ListFunctionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListFunctions',
            $optionalArgs,
            ListFunctionsResponse::class,
            $request
        );
    }

    /**
     * Returns a list of runtimes that are supported for the requested project.
     *
     * Sample code:
     * ```
     * $functionServiceClient = new FunctionServiceClient();
     * try {
     *     $formattedParent = $functionServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $response = $functionServiceClient->listRuntimes($formattedParent);
     * } finally {
     *     $functionServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the runtimes should be
     *                             listed, specified in the format `projects/&#42;/locations/*`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           The filter for Runtimes that match the filter expression,
     *           following the syntax outlined in https://google.aip.dev/160.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Functions\V2\ListRuntimesResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listRuntimes($parent, array $optionalArgs = [])
    {
        $request = new ListRuntimesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ListRuntimes',
            ListRuntimesResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates existing function.
     *
     * Sample code:
     * ```
     * $functionServiceClient = new FunctionServiceClient();
     * try {
     *     $function = new PBFunction();
     *     $operationResponse = $functionServiceClient->updateFunction($function);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $functionServiceClient->updateFunction($function);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $functionServiceClient->resumeOperation($operationName, 'updateFunction');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $functionServiceClient->close();
     * }
     * ```
     *
     * @param PBFunction $function     Required. New version of the function.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *           If no field mask is provided, all provided fields in the request will be
     *           updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateFunction($function, array $optionalArgs = [])
    {
        $request = new UpdateFunctionRequest();
        $requestParamHeaders = [];
        $request->setFunction($function);
        $requestParamHeaders['function.name'] = $function->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateFunction',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $functionServiceClient = new FunctionServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $functionServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $functionServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $functionServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $functionServiceClient = new FunctionServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $functionServiceClient->getIamPolicy($resource);
     * } finally {
     *     $functionServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $functionServiceClient = new FunctionServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $functionServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $functionServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $functionServiceClient = new FunctionServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $functionServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $functionServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
