<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/eventarc/v1/eventarc.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Eventarc\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Eventarc\V1\Channel;
use Google\Cloud\Eventarc\V1\ChannelConnection;
use Google\Cloud\Eventarc\V1\CreateChannelConnectionRequest;
use Google\Cloud\Eventarc\V1\CreateChannelRequest;
use Google\Cloud\Eventarc\V1\CreateTriggerRequest;
use Google\Cloud\Eventarc\V1\DeleteChannelConnectionRequest;
use Google\Cloud\Eventarc\V1\DeleteChannelRequest;
use Google\Cloud\Eventarc\V1\DeleteTriggerRequest;
use Google\Cloud\Eventarc\V1\GetChannelConnectionRequest;
use Google\Cloud\Eventarc\V1\GetChannelRequest;
use Google\Cloud\Eventarc\V1\GetGoogleChannelConfigRequest;
use Google\Cloud\Eventarc\V1\GetProviderRequest;
use Google\Cloud\Eventarc\V1\GetTriggerRequest;
use Google\Cloud\Eventarc\V1\GoogleChannelConfig;
use Google\Cloud\Eventarc\V1\ListChannelConnectionsRequest;
use Google\Cloud\Eventarc\V1\ListChannelConnectionsResponse;
use Google\Cloud\Eventarc\V1\ListChannelsRequest;
use Google\Cloud\Eventarc\V1\ListChannelsResponse;
use Google\Cloud\Eventarc\V1\ListProvidersRequest;
use Google\Cloud\Eventarc\V1\ListProvidersResponse;
use Google\Cloud\Eventarc\V1\ListTriggersRequest;
use Google\Cloud\Eventarc\V1\ListTriggersResponse;
use Google\Cloud\Eventarc\V1\Provider;
use Google\Cloud\Eventarc\V1\Trigger;
use Google\Cloud\Eventarc\V1\UpdateChannelRequest;
use Google\Cloud\Eventarc\V1\UpdateGoogleChannelConfigRequest;
use Google\Cloud\Eventarc\V1\UpdateTriggerRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Eventarc allows users to subscribe to various events that are provided by
 * Google Cloud services and forward them to supported destinations.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $eventarcClient = new EventarcClient();
 * try {
 *     $formattedParent = $eventarcClient->locationName('[PROJECT]', '[LOCATION]');
 *     $channel = new Channel();
 *     $channelId = 'channel_id';
 *     $validateOnly = false;
 *     $operationResponse = $eventarcClient->createChannel($formattedParent, $channel, $channelId, $validateOnly);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $eventarcClient->createChannel($formattedParent, $channel, $channelId, $validateOnly);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $eventarcClient->resumeOperation($operationName, 'createChannel');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $eventarcClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class EventarcGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.eventarc.v1.Eventarc';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'eventarc.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $channelNameTemplate;

    private static $channelConnectionNameTemplate;

    private static $cloudFunctionNameTemplate;

    private static $cryptoKeyNameTemplate;

    private static $googleChannelConfigNameTemplate;

    private static $locationNameTemplate;

    private static $providerNameTemplate;

    private static $serviceAccountNameTemplate;

    private static $triggerNameTemplate;

    private static $workflowNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/eventarc_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/eventarc_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/eventarc_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/eventarc_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getChannelNameTemplate()
    {
        if (self::$channelNameTemplate == null) {
            self::$channelNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/channels/{channel}'
            );
        }

        return self::$channelNameTemplate;
    }

    private static function getChannelConnectionNameTemplate()
    {
        if (self::$channelConnectionNameTemplate == null) {
            self::$channelConnectionNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/channelConnections/{channel_connection}'
            );
        }

        return self::$channelConnectionNameTemplate;
    }

    private static function getCloudFunctionNameTemplate()
    {
        if (self::$cloudFunctionNameTemplate == null) {
            self::$cloudFunctionNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/functions/{function}'
            );
        }

        return self::$cloudFunctionNameTemplate;
    }

    private static function getCryptoKeyNameTemplate()
    {
        if (self::$cryptoKeyNameTemplate == null) {
            self::$cryptoKeyNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}'
            );
        }

        return self::$cryptoKeyNameTemplate;
    }

    private static function getGoogleChannelConfigNameTemplate()
    {
        if (self::$googleChannelConfigNameTemplate == null) {
            self::$googleChannelConfigNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/googleChannelConfig'
            );
        }

        return self::$googleChannelConfigNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getProviderNameTemplate()
    {
        if (self::$providerNameTemplate == null) {
            self::$providerNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/providers/{provider}'
            );
        }

        return self::$providerNameTemplate;
    }

    private static function getServiceAccountNameTemplate()
    {
        if (self::$serviceAccountNameTemplate == null) {
            self::$serviceAccountNameTemplate = new PathTemplate(
                'projects/{project}/serviceAccounts/{service_account}'
            );
        }

        return self::$serviceAccountNameTemplate;
    }

    private static function getTriggerNameTemplate()
    {
        if (self::$triggerNameTemplate == null) {
            self::$triggerNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/triggers/{trigger}'
            );
        }

        return self::$triggerNameTemplate;
    }

    private static function getWorkflowNameTemplate()
    {
        if (self::$workflowNameTemplate == null) {
            self::$workflowNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/workflows/{workflow}'
            );
        }

        return self::$workflowNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'channel' => self::getChannelNameTemplate(),
                'channelConnection' => self::getChannelConnectionNameTemplate(),
                'cloudFunction' => self::getCloudFunctionNameTemplate(),
                'cryptoKey' => self::getCryptoKeyNameTemplate(),
                'googleChannelConfig' => self::getGoogleChannelConfigNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'provider' => self::getProviderNameTemplate(),
                'serviceAccount' => self::getServiceAccountNameTemplate(),
                'trigger' => self::getTriggerNameTemplate(),
                'workflow' => self::getWorkflowNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a channel
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $channel
     *
     * @return string The formatted channel resource.
     */
    public static function channelName($project, $location, $channel)
    {
        return self::getChannelNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'channel' => $channel,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * channel_connection resource.
     *
     * @param string $project
     * @param string $location
     * @param string $channelConnection
     *
     * @return string The formatted channel_connection resource.
     */
    public static function channelConnectionName(
        $project,
        $location,
        $channelConnection
    ) {
        return self::getChannelConnectionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'channel_connection' => $channelConnection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * cloud_function resource.
     *
     * @param string $project
     * @param string $location
     * @param string $function
     *
     * @return string The formatted cloud_function resource.
     */
    public static function cloudFunctionName($project, $location, $function)
    {
        return self::getCloudFunctionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'function' => $function,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a crypto_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     *
     * @return string The formatted crypto_key resource.
     */
    public static function cryptoKeyName(
        $project,
        $location,
        $keyRing,
        $cryptoKey
    ) {
        return self::getCryptoKeyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * google_channel_config resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted google_channel_config resource.
     */
    public static function googleChannelConfigName($project, $location)
    {
        return self::getGoogleChannelConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a provider
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $provider
     *
     * @return string The formatted provider resource.
     */
    public static function providerName($project, $location, $provider)
    {
        return self::getProviderNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'provider' => $provider,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_account resource.
     *
     * @param string $project
     * @param string $serviceAccount
     *
     * @return string The formatted service_account resource.
     */
    public static function serviceAccountName($project, $serviceAccount)
    {
        return self::getServiceAccountNameTemplate()->render([
            'project' => $project,
            'service_account' => $serviceAccount,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a trigger
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $trigger
     *
     * @return string The formatted trigger resource.
     */
    public static function triggerName($project, $location, $trigger)
    {
        return self::getTriggerNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'trigger' => $trigger,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a workflow
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $workflow
     *
     * @return string The formatted workflow resource.
     */
    public static function workflowName($project, $location, $workflow)
    {
        return self::getWorkflowNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'workflow' => $workflow,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - channel: projects/{project}/locations/{location}/channels/{channel}
     * - channelConnection: projects/{project}/locations/{location}/channelConnections/{channel_connection}
     * - cloudFunction: projects/{project}/locations/{location}/functions/{function}
     * - cryptoKey: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}
     * - googleChannelConfig: projects/{project}/locations/{location}/googleChannelConfig
     * - location: projects/{project}/locations/{location}
     * - provider: projects/{project}/locations/{location}/providers/{provider}
     * - serviceAccount: projects/{project}/serviceAccounts/{service_account}
     * - trigger: projects/{project}/locations/{location}/triggers/{trigger}
     * - workflow: projects/{project}/locations/{location}/workflows/{workflow}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'eventarc.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Create a new channel in a particular project and location.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedParent = $eventarcClient->locationName('[PROJECT]', '[LOCATION]');
     *     $channel = new Channel();
     *     $channelId = 'channel_id';
     *     $validateOnly = false;
     *     $operationResponse = $eventarcClient->createChannel($formattedParent, $channel, $channelId, $validateOnly);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $eventarcClient->createChannel($formattedParent, $channel, $channelId, $validateOnly);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $eventarcClient->resumeOperation($operationName, 'createChannel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The parent collection in which to add this channel.
     * @param Channel $channel      Required. The channel to create.
     * @param string  $channelId    Required. The user-provided ID to be assigned to the channel.
     * @param bool    $validateOnly Required. If set, validate the request and preview the review, but do not
     *                              post it.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createChannel(
        $parent,
        $channel,
        $channelId,
        $validateOnly,
        array $optionalArgs = []
    ) {
        $request = new CreateChannelRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setChannel($channel);
        $request->setChannelId($channelId);
        $request->setValidateOnly($validateOnly);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateChannel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Create a new ChannelConnection in a particular project and location.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedParent = $eventarcClient->locationName('[PROJECT]', '[LOCATION]');
     *     $channelConnection = new ChannelConnection();
     *     $channelConnectionId = 'channel_connection_id';
     *     $operationResponse = $eventarcClient->createChannelConnection($formattedParent, $channelConnection, $channelConnectionId);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $eventarcClient->createChannelConnection($formattedParent, $channelConnection, $channelConnectionId);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $eventarcClient->resumeOperation($operationName, 'createChannelConnection');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string            $parent              Required. The parent collection in which to add this channel connection.
     * @param ChannelConnection $channelConnection   Required. Channel connection to create.
     * @param string            $channelConnectionId Required. The user-provided ID to be assigned to the channel connection.
     * @param array             $optionalArgs        {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createChannelConnection(
        $parent,
        $channelConnection,
        $channelConnectionId,
        array $optionalArgs = []
    ) {
        $request = new CreateChannelConnectionRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setChannelConnection($channelConnection);
        $request->setChannelConnectionId($channelConnectionId);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateChannelConnection',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Create a new trigger in a particular project and location.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedParent = $eventarcClient->locationName('[PROJECT]', '[LOCATION]');
     *     $trigger = new Trigger();
     *     $triggerId = 'trigger_id';
     *     $validateOnly = false;
     *     $operationResponse = $eventarcClient->createTrigger($formattedParent, $trigger, $triggerId, $validateOnly);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $eventarcClient->createTrigger($formattedParent, $trigger, $triggerId, $validateOnly);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $eventarcClient->resumeOperation($operationName, 'createTrigger');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The parent collection in which to add this trigger.
     * @param Trigger $trigger      Required. The trigger to create.
     * @param string  $triggerId    Required. The user-provided ID to be assigned to the trigger.
     * @param bool    $validateOnly Required. If set, validate the request and preview the review, but do not
     *                              post it.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createTrigger(
        $parent,
        $trigger,
        $triggerId,
        $validateOnly,
        array $optionalArgs = []
    ) {
        $request = new CreateTriggerRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTrigger($trigger);
        $request->setTriggerId($triggerId);
        $request->setValidateOnly($validateOnly);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateTrigger',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Delete a single channel.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedName = $eventarcClient->channelName('[PROJECT]', '[LOCATION]', '[CHANNEL]');
     *     $validateOnly = false;
     *     $operationResponse = $eventarcClient->deleteChannel($formattedName, $validateOnly);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $eventarcClient->deleteChannel($formattedName, $validateOnly);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $eventarcClient->resumeOperation($operationName, 'deleteChannel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the channel to be deleted.
     * @param bool   $validateOnly Required. If set, validate the request and preview the review, but do not
     *                             post it.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteChannel(
        $name,
        $validateOnly,
        array $optionalArgs = []
    ) {
        $request = new DeleteChannelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setValidateOnly($validateOnly);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteChannel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Delete a single ChannelConnection.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedName = $eventarcClient->channelConnectionName('[PROJECT]', '[LOCATION]', '[CHANNEL_CONNECTION]');
     *     $operationResponse = $eventarcClient->deleteChannelConnection($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $eventarcClient->deleteChannelConnection($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $eventarcClient->resumeOperation($operationName, 'deleteChannelConnection');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the channel connection to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteChannelConnection($name, array $optionalArgs = [])
    {
        $request = new DeleteChannelConnectionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteChannelConnection',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Delete a single trigger.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedName = $eventarcClient->triggerName('[PROJECT]', '[LOCATION]', '[TRIGGER]');
     *     $validateOnly = false;
     *     $operationResponse = $eventarcClient->deleteTrigger($formattedName, $validateOnly);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $eventarcClient->deleteTrigger($formattedName, $validateOnly);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $eventarcClient->resumeOperation($operationName, 'deleteTrigger');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the trigger to be deleted.
     * @param bool   $validateOnly Required. If set, validate the request and preview the review, but do not
     *                             post it.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           If provided, the trigger will only be deleted if the etag matches the
     *           current etag on the resource.
     *     @type bool $allowMissing
     *           If set to true, and the trigger is not found, the request will succeed
     *           but no action will be taken on the server.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTrigger(
        $name,
        $validateOnly,
        array $optionalArgs = []
    ) {
        $request = new DeleteTriggerRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setValidateOnly($validateOnly);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteTrigger',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Get a single Channel.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedName = $eventarcClient->channelName('[PROJECT]', '[LOCATION]', '[CHANNEL]');
     *     $response = $eventarcClient->getChannel($formattedName);
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the channel to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Eventarc\V1\Channel
     *
     * @throws ApiException if the remote call fails
     */
    public function getChannel($name, array $optionalArgs = [])
    {
        $request = new GetChannelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetChannel',
            Channel::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get a single ChannelConnection.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedName = $eventarcClient->channelConnectionName('[PROJECT]', '[LOCATION]', '[CHANNEL_CONNECTION]');
     *     $response = $eventarcClient->getChannelConnection($formattedName);
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the channel connection to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Eventarc\V1\ChannelConnection
     *
     * @throws ApiException if the remote call fails
     */
    public function getChannelConnection($name, array $optionalArgs = [])
    {
        $request = new GetChannelConnectionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetChannelConnection',
            ChannelConnection::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get a GoogleChannelConfig
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedName = $eventarcClient->googleChannelConfigName('[PROJECT]', '[LOCATION]');
     *     $response = $eventarcClient->getGoogleChannelConfig($formattedName);
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the config to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Eventarc\V1\GoogleChannelConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getGoogleChannelConfig($name, array $optionalArgs = [])
    {
        $request = new GetGoogleChannelConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetGoogleChannelConfig',
            GoogleChannelConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get a single Provider.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedName = $eventarcClient->providerName('[PROJECT]', '[LOCATION]', '[PROVIDER]');
     *     $response = $eventarcClient->getProvider($formattedName);
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the provider to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Eventarc\V1\Provider
     *
     * @throws ApiException if the remote call fails
     */
    public function getProvider($name, array $optionalArgs = [])
    {
        $request = new GetProviderRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetProvider',
            Provider::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Get a single trigger.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedName = $eventarcClient->triggerName('[PROJECT]', '[LOCATION]', '[TRIGGER]');
     *     $response = $eventarcClient->getTrigger($formattedName);
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the trigger to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Eventarc\V1\Trigger
     *
     * @throws ApiException if the remote call fails
     */
    public function getTrigger($name, array $optionalArgs = [])
    {
        $request = new GetTriggerRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetTrigger',
            Trigger::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * List channel connections.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedParent = $eventarcClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $eventarcClient->listChannelConnections($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $eventarcClient->listChannelConnections($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent collection from which to list channel connections.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listChannelConnections($parent, array $optionalArgs = [])
    {
        $request = new ListChannelConnectionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListChannelConnections',
            $optionalArgs,
            ListChannelConnectionsResponse::class,
            $request
        );
    }

    /**
     * List channels.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedParent = $eventarcClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $eventarcClient->listChannels($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $eventarcClient->listChannels($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent collection to list channels on.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           The sorting order of the resources returned. Value should be a
     *           comma-separated list of fields. The default sorting order is ascending. To
     *           specify descending order for a field, append a `desc` suffix; for example:
     *           `name desc, channel_id`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listChannels($parent, array $optionalArgs = [])
    {
        $request = new ListChannelsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListChannels',
            $optionalArgs,
            ListChannelsResponse::class,
            $request
        );
    }

    /**
     * List providers.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedParent = $eventarcClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $eventarcClient->listProviders($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $eventarcClient->listProviders($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent of the provider to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           The sorting order of the resources returned. Value should be a
     *           comma-separated list of fields. The default sorting oder is ascending. To
     *           specify descending order for a field, append a `desc` suffix; for example:
     *           `name desc, _id`.
     *     @type string $filter
     *           The filter field that the list request will filter on.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listProviders($parent, array $optionalArgs = [])
    {
        $request = new ListProvidersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListProviders',
            $optionalArgs,
            ListProvidersResponse::class,
            $request
        );
    }

    /**
     * List triggers.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $formattedParent = $eventarcClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $eventarcClient->listTriggers($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $eventarcClient->listTriggers($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent collection to list triggers on.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           The sorting order of the resources returned. Value should be a
     *           comma-separated list of fields. The default sorting order is ascending. To
     *           specify descending order for a field, append a `desc` suffix; for example:
     *           `name desc, trigger_id`.
     *     @type string $filter
     *           Filter field. Used to filter the Triggers to be listed. Possible filters
     *           are described in https://google.aip.dev/160. For example, using
     *           "?filter=destination:gke" would list only Triggers with a gke destination.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTriggers($parent, array $optionalArgs = [])
    {
        $request = new ListTriggersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListTriggers',
            $optionalArgs,
            ListTriggersResponse::class,
            $request
        );
    }

    /**
     * Update a single channel.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $validateOnly = false;
     *     $operationResponse = $eventarcClient->updateChannel($validateOnly);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $eventarcClient->updateChannel($validateOnly);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $eventarcClient->resumeOperation($operationName, 'updateChannel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param bool  $validateOnly Required. If set, validate the request and preview the review, but do not
     *                            post it.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type Channel $channel
     *           The channel to be updated.
     *     @type FieldMask $updateMask
     *           The fields to be updated; only fields explicitly provided are updated.
     *           If no field mask is provided, all provided fields in the request are
     *           updated. To update all fields, provide a field mask of "*".
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateChannel($validateOnly, array $optionalArgs = [])
    {
        $request = new UpdateChannelRequest();
        $requestParamHeaders = [];
        $request->setValidateOnly($validateOnly);
        if (isset($optionalArgs['channel'])) {
            $request->setChannel($optionalArgs['channel']);
        }

        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateChannel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Update a single GoogleChannelConfig
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $googleChannelConfig = new GoogleChannelConfig();
     *     $response = $eventarcClient->updateGoogleChannelConfig($googleChannelConfig);
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param GoogleChannelConfig $googleChannelConfig Required. The config to be updated.
     * @param array               $optionalArgs        {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The fields to be updated; only fields explicitly provided are updated.
     *           If no field mask is provided, all provided fields in the request are
     *           updated. To update all fields, provide a field mask of "*".
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Eventarc\V1\GoogleChannelConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function updateGoogleChannelConfig(
        $googleChannelConfig,
        array $optionalArgs = []
    ) {
        $request = new UpdateGoogleChannelConfigRequest();
        $requestParamHeaders = [];
        $request->setGoogleChannelConfig($googleChannelConfig);
        $requestParamHeaders[
            'google_channel_config.name'
        ] = $googleChannelConfig->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateGoogleChannelConfig',
            GoogleChannelConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Update a single trigger.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $validateOnly = false;
     *     $operationResponse = $eventarcClient->updateTrigger($validateOnly);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $eventarcClient->updateTrigger($validateOnly);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $eventarcClient->resumeOperation($operationName, 'updateTrigger');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param bool  $validateOnly Required. If set, validate the request and preview the review, but do not
     *                            post it.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type Trigger $trigger
     *           The trigger to be updated.
     *     @type FieldMask $updateMask
     *           The fields to be updated; only fields explicitly provided are updated.
     *           If no field mask is provided, all provided fields in the request are
     *           updated. To update all fields, provide a field mask of "*".
     *     @type bool $allowMissing
     *           If set to true, and the trigger is not found, a new trigger will be
     *           created. In this situation, `update_mask` is ignored.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTrigger($validateOnly, array $optionalArgs = [])
    {
        $request = new UpdateTriggerRequest();
        $requestParamHeaders = [];
        $request->setValidateOnly($validateOnly);
        if (isset($optionalArgs['trigger'])) {
            $request->setTrigger($optionalArgs['trigger']);
        }

        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateTrigger',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $response = $eventarcClient->getLocation();
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $eventarcClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $eventarcClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $resource = 'resource';
     *     $response = $eventarcClient->getIamPolicy($resource);
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $eventarcClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $eventarcClient = new EventarcClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $eventarcClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $eventarcClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
