<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/retail/v2/product_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Retail\V2\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Retail\V2\AddFulfillmentPlacesRequest;
use Google\Cloud\Retail\V2\AddLocalInventoriesRequest;
use Google\Cloud\Retail\V2\CreateProductRequest;
use Google\Cloud\Retail\V2\DeleteProductRequest;
use Google\Cloud\Retail\V2\GetProductRequest;
use Google\Cloud\Retail\V2\ImportProductsRequest;
use Google\Cloud\Retail\V2\ListProductsRequest;
use Google\Cloud\Retail\V2\Product;
use Google\Cloud\Retail\V2\PurgeProductsRequest;
use Google\Cloud\Retail\V2\RemoveFulfillmentPlacesRequest;
use Google\Cloud\Retail\V2\RemoveLocalInventoriesRequest;
use Google\Cloud\Retail\V2\SetInventoryRequest;
use Google\Cloud\Retail\V2\UpdateProductRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Service for ingesting [Product][google.cloud.retail.v2.Product] information
 * of the customer's website.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> addFulfillmentPlacesAsync(AddFulfillmentPlacesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> addLocalInventoriesAsync(AddLocalInventoriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Product> createProductAsync(CreateProductRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteProductAsync(DeleteProductRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Product> getProductAsync(GetProductRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> importProductsAsync(ImportProductsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listProductsAsync(ListProductsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> purgeProductsAsync(PurgeProductsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> removeFulfillmentPlacesAsync(RemoveFulfillmentPlacesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> removeLocalInventoriesAsync(RemoveLocalInventoriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> setInventoryAsync(SetInventoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Product> updateProductAsync(UpdateProductRequest $request, array $optionalArgs = [])
 */
final class ProductServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.retail.v2.ProductService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'retail.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'retail.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/product_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/product_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/product_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/product_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a branch
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $catalog
     * @param string $branch
     *
     * @return string The formatted branch resource.
     */
    public static function branchName(string $project, string $location, string $catalog, string $branch): string
    {
        return self::getPathTemplate('branch')->render([
            'project' => $project,
            'location' => $location,
            'catalog' => $catalog,
            'branch' => $branch,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a product
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $catalog
     * @param string $branch
     * @param string $product
     *
     * @return string The formatted product resource.
     */
    public static function productName(
        string $project,
        string $location,
        string $catalog,
        string $branch,
        string $product
    ): string {
        return self::getPathTemplate('product')->render([
            'project' => $project,
            'location' => $location,
            'catalog' => $catalog,
            'branch' => $branch,
            'product' => $product,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - branch: projects/{project}/locations/{location}/catalogs/{catalog}/branches/{branch}
     * - product: projects/{project}/locations/{location}/catalogs/{catalog}/branches/{branch}/products/{product}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'retail.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * We recommend that you use the
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * method instead of the
     * [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2.ProductService.AddFulfillmentPlaces]
     * method.
     * [ProductService.AddLocalInventories][google.cloud.retail.v2.ProductService.AddLocalInventories]
     * achieves the same results but provides more fine-grained control over
     * ingesting local inventory data.
     *
     * Incrementally adds place IDs to
     * [Product.fulfillment_info.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids].
     *
     * This process is asynchronous and does not require the
     * [Product][google.cloud.retail.v2.Product] to exist before updating
     * fulfillment information. If the request is valid, the update will be
     * enqueued and processed downstream. As a consequence, when a response is
     * returned, the added place IDs are not immediately manifested in the
     * [Product][google.cloud.retail.v2.Product] queried by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * or
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     *
     * The returned [Operation][google.longrunning.Operation]s will be obsolete
     * after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
     * API will return NOT_FOUND afterwards.
     *
     * If conflicting updates are issued, the
     * [Operation][google.longrunning.Operation]s associated with the stale
     * updates will not be marked as [done][google.longrunning.Operation.done]
     * until being obsolete.
     *
     * The async variant is {@see ProductServiceClient::addFulfillmentPlacesAsync()} .
     *
     * @example samples/V2/ProductServiceClient/add_fulfillment_places.php
     *
     * @param AddFulfillmentPlacesRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function addFulfillmentPlaces(
        AddFulfillmentPlacesRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('AddFulfillmentPlaces', $request, $callOptions)->wait();
    }

    /**
     * Updates local inventory information for a
     * [Product][google.cloud.retail.v2.Product] at a list of places, while
     * respecting the last update timestamps of each inventory field.
     *
     * This process is asynchronous and does not require the
     * [Product][google.cloud.retail.v2.Product] to exist before updating
     * inventory information. If the request is valid, the update will be enqueued
     * and processed downstream. As a consequence, when a response is returned,
     * updates are not immediately manifested in the
     * [Product][google.cloud.retail.v2.Product] queried by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * or
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     *
     * Local inventory information can only be modified using this method.
     * [ProductService.CreateProduct][google.cloud.retail.v2.ProductService.CreateProduct]
     * and
     * [ProductService.UpdateProduct][google.cloud.retail.v2.ProductService.UpdateProduct]
     * has no effect on local inventories.
     *
     * The returned [Operation][google.longrunning.Operation]s will be obsolete
     * after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
     * API will return NOT_FOUND afterwards.
     *
     * If conflicting updates are issued, the
     * [Operation][google.longrunning.Operation]s associated with the stale
     * updates will not be marked as [done][google.longrunning.Operation.done]
     * until being obsolete.
     *
     * The async variant is {@see ProductServiceClient::addLocalInventoriesAsync()} .
     *
     * @example samples/V2/ProductServiceClient/add_local_inventories.php
     *
     * @param AddLocalInventoriesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function addLocalInventories(AddLocalInventoriesRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('AddLocalInventories', $request, $callOptions)->wait();
    }

    /**
     * Creates a [Product][google.cloud.retail.v2.Product].
     *
     * The async variant is {@see ProductServiceClient::createProductAsync()} .
     *
     * @example samples/V2/ProductServiceClient/create_product.php
     *
     * @param CreateProductRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Product
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createProduct(CreateProductRequest $request, array $callOptions = []): Product
    {
        return $this->startApiCall('CreateProduct', $request, $callOptions)->wait();
    }

    /**
     * Deletes a [Product][google.cloud.retail.v2.Product].
     *
     * The async variant is {@see ProductServiceClient::deleteProductAsync()} .
     *
     * @example samples/V2/ProductServiceClient/delete_product.php
     *
     * @param DeleteProductRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteProduct(DeleteProductRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteProduct', $request, $callOptions)->wait();
    }

    /**
     * Gets a [Product][google.cloud.retail.v2.Product].
     *
     * The async variant is {@see ProductServiceClient::getProductAsync()} .
     *
     * @example samples/V2/ProductServiceClient/get_product.php
     *
     * @param GetProductRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Product
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getProduct(GetProductRequest $request, array $callOptions = []): Product
    {
        return $this->startApiCall('GetProduct', $request, $callOptions)->wait();
    }

    /**
     * Bulk import of multiple [Product][google.cloud.retail.v2.Product]s.
     *
     * Request processing may be synchronous.
     * Non-existing items are created.
     *
     * Note that it is possible for a subset of the
     * [Product][google.cloud.retail.v2.Product]s to be successfully updated.
     *
     * The async variant is {@see ProductServiceClient::importProductsAsync()} .
     *
     * @example samples/V2/ProductServiceClient/import_products.php
     *
     * @param ImportProductsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function importProducts(ImportProductsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ImportProducts', $request, $callOptions)->wait();
    }

    /**
     * Gets a list of [Product][google.cloud.retail.v2.Product]s.
     *
     * The async variant is {@see ProductServiceClient::listProductsAsync()} .
     *
     * @example samples/V2/ProductServiceClient/list_products.php
     *
     * @param ListProductsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listProducts(ListProductsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListProducts', $request, $callOptions);
    }

    /**
     * Permanently deletes all selected [Product][google.cloud.retail.v2.Product]s
     * under a branch.
     *
     * This process is asynchronous. If the request is valid, the removal will be
     * enqueued and processed offline. Depending on the number of
     * [Product][google.cloud.retail.v2.Product]s, this operation could take hours
     * to complete. Before the operation completes, some
     * [Product][google.cloud.retail.v2.Product]s may still be returned by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * or
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     *
     * Depending on the number of [Product][google.cloud.retail.v2.Product]s, this
     * operation could take hours to complete. To get a sample of
     * [Product][google.cloud.retail.v2.Product]s that would be deleted, set
     * [PurgeProductsRequest.force][google.cloud.retail.v2.PurgeProductsRequest.force]
     * to false.
     *
     * The async variant is {@see ProductServiceClient::purgeProductsAsync()} .
     *
     * @example samples/V2/ProductServiceClient/purge_products.php
     *
     * @param PurgeProductsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function purgeProducts(PurgeProductsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('PurgeProducts', $request, $callOptions)->wait();
    }

    /**
     * We recommend that you use the
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * method instead of the
     * [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2.ProductService.RemoveFulfillmentPlaces]
     * method.
     * [ProductService.RemoveLocalInventories][google.cloud.retail.v2.ProductService.RemoveLocalInventories]
     * achieves the same results but provides more fine-grained control over
     * ingesting local inventory data.
     *
     * Incrementally removes place IDs from a
     * [Product.fulfillment_info.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids].
     *
     * This process is asynchronous and does not require the
     * [Product][google.cloud.retail.v2.Product] to exist before updating
     * fulfillment information. If the request is valid, the update will be
     * enqueued and processed downstream. As a consequence, when a response is
     * returned, the removed place IDs are not immediately manifested in the
     * [Product][google.cloud.retail.v2.Product] queried by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * or
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     *
     * The returned [Operation][google.longrunning.Operation]s will be obsolete
     * after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
     * API will return NOT_FOUND afterwards.
     *
     * If conflicting updates are issued, the
     * [Operation][google.longrunning.Operation]s associated with the stale
     * updates will not be marked as [done][google.longrunning.Operation.done]
     * until being obsolete.
     *
     * The async variant is {@see ProductServiceClient::removeFulfillmentPlacesAsync()}
     * .
     *
     * @example samples/V2/ProductServiceClient/remove_fulfillment_places.php
     *
     * @param RemoveFulfillmentPlacesRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function removeFulfillmentPlaces(
        RemoveFulfillmentPlacesRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('RemoveFulfillmentPlaces', $request, $callOptions)->wait();
    }

    /**
     * Remove local inventory information for a
     * [Product][google.cloud.retail.v2.Product] at a list of places at a removal
     * timestamp.
     *
     * This process is asynchronous. If the request is valid, the removal will be
     * enqueued and processed downstream. As a consequence, when a response is
     * returned, removals are not immediately manifested in the
     * [Product][google.cloud.retail.v2.Product] queried by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * or
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     *
     * Local inventory information can only be removed using this method.
     * [ProductService.CreateProduct][google.cloud.retail.v2.ProductService.CreateProduct]
     * and
     * [ProductService.UpdateProduct][google.cloud.retail.v2.ProductService.UpdateProduct]
     * has no effect on local inventories.
     *
     * The returned [Operation][google.longrunning.Operation]s will be obsolete
     * after 1 day, and [GetOperation][google.longrunning.Operations.GetOperation]
     * API will return NOT_FOUND afterwards.
     *
     * If conflicting updates are issued, the
     * [Operation][google.longrunning.Operation]s associated with the stale
     * updates will not be marked as [done][google.longrunning.Operation.done]
     * until being obsolete.
     *
     * The async variant is {@see ProductServiceClient::removeLocalInventoriesAsync()}
     * .
     *
     * @example samples/V2/ProductServiceClient/remove_local_inventories.php
     *
     * @param RemoveLocalInventoriesRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function removeLocalInventories(
        RemoveLocalInventoriesRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('RemoveLocalInventories', $request, $callOptions)->wait();
    }

    /**
     * Updates inventory information for a
     * [Product][google.cloud.retail.v2.Product] while respecting the last update
     * timestamps of each inventory field.
     *
     * This process is asynchronous and does not require the
     * [Product][google.cloud.retail.v2.Product] to exist before updating
     * fulfillment information. If the request is valid, the update is enqueued
     * and processed downstream. As a consequence, when a response is returned,
     * updates are not immediately manifested in the
     * [Product][google.cloud.retail.v2.Product] queried by
     * [ProductService.GetProduct][google.cloud.retail.v2.ProductService.GetProduct]
     * or
     * [ProductService.ListProducts][google.cloud.retail.v2.ProductService.ListProducts].
     *
     * When inventory is updated with
     * [ProductService.CreateProduct][google.cloud.retail.v2.ProductService.CreateProduct]
     * and
     * [ProductService.UpdateProduct][google.cloud.retail.v2.ProductService.UpdateProduct],
     * the specified inventory field value(s) overwrite any existing value(s)
     * while ignoring the last update time for this field. Furthermore, the last
     * update times for the specified inventory fields are overwritten by the
     * times of the
     * [ProductService.CreateProduct][google.cloud.retail.v2.ProductService.CreateProduct]
     * or
     * [ProductService.UpdateProduct][google.cloud.retail.v2.ProductService.UpdateProduct]
     * request.
     *
     * If no inventory fields are set in
     * [CreateProductRequest.product][google.cloud.retail.v2.CreateProductRequest.product],
     * then any pre-existing inventory information for this product is used.
     *
     * If no inventory fields are set in
     * [SetInventoryRequest.set_mask][google.cloud.retail.v2.SetInventoryRequest.set_mask],
     * then any existing inventory information is preserved.
     *
     * Pre-existing inventory information can only be updated with
     * [ProductService.SetInventory][google.cloud.retail.v2.ProductService.SetInventory],
     * [ProductService.AddFulfillmentPlaces][google.cloud.retail.v2.ProductService.AddFulfillmentPlaces],
     * and
     * [ProductService.RemoveFulfillmentPlaces][google.cloud.retail.v2.ProductService.RemoveFulfillmentPlaces].
     *
     * The returned [Operation][google.longrunning.Operation]s is obsolete after
     * one day, and the [GetOperation][google.longrunning.Operations.GetOperation]
     * API returns `NOT_FOUND` afterwards.
     *
     * If conflicting updates are issued, the
     * [Operation][google.longrunning.Operation]s associated with the stale
     * updates are not marked as [done][google.longrunning.Operation.done] until
     * they are obsolete.
     *
     * The async variant is {@see ProductServiceClient::setInventoryAsync()} .
     *
     * @example samples/V2/ProductServiceClient/set_inventory.php
     *
     * @param SetInventoryRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setInventory(SetInventoryRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SetInventory', $request, $callOptions)->wait();
    }

    /**
     * Updates a [Product][google.cloud.retail.v2.Product].
     *
     * The async variant is {@see ProductServiceClient::updateProductAsync()} .
     *
     * @example samples/V2/ProductServiceClient/update_product.php
     *
     * @param UpdateProductRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Product
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateProduct(UpdateProductRequest $request, array $callOptions = []): Product
    {
        return $this->startApiCall('UpdateProduct', $request, $callOptions)->wait();
    }
}
