<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/pubsub/v1/pubsub.proto

namespace Google\Cloud\PubSub\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A subscription resource. If none of `push_config`, `bigquery_config`, or
 * `cloud_storage_config` is set, then the subscriber will pull and ack messages
 * using API methods. At most one of these fields may be set.
 *
 * Generated from protobuf message <code>google.pubsub.v1.Subscription</code>
 */
class Subscription extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The name of the subscription. It must have the format
     * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
     * start with a letter, and contain only letters (`[A-Za-z]`), numbers
     * (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
     * plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
     * in length, and it must not start with `"goog"`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $name = '';
    /**
     * Required. The name of the topic from which this subscription is receiving
     * messages. Format is `projects/{project}/topics/{topic}`. The value of this
     * field will be `_deleted-topic_` if the topic has been deleted.
     *
     * Generated from protobuf field <code>string topic = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $topic = '';
    /**
     * Optional. If push delivery is used with this subscription, this field is
     * used to configure it.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $push_config = null;
    /**
     * Optional. If delivery to BigQuery is used with this subscription, this
     * field is used to configure it.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $bigquery_config = null;
    /**
     * Optional. If delivery to Google Cloud Storage is used with this
     * subscription, this field is used to configure it.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $cloud_storage_config = null;
    /**
     * Optional. The approximate amount of time (on a best-effort basis) Pub/Sub
     * waits for the subscriber to acknowledge receipt before resending the
     * message. In the interval after the message is delivered and before it is
     * acknowledged, it is considered to be _outstanding_. During that time
     * period, the message will not be redelivered (on a best-effort basis).
     * For pull subscriptions, this value is used as the initial value for the ack
     * deadline. To override this value for a given message, call
     * `ModifyAckDeadline` with the corresponding `ack_id` if using
     * non-streaming pull or send the `ack_id` in a
     * `StreamingModifyAckDeadlineRequest` if using streaming pull.
     * The minimum custom deadline you can specify is 10 seconds.
     * The maximum custom deadline you can specify is 600 seconds (10 minutes).
     * If this parameter is 0, a default value of 10 seconds is used.
     * For push delivery, this value is also used to set the request timeout for
     * the call to the push endpoint.
     * If the subscriber never acknowledges the message, the Pub/Sub
     * system will eventually redeliver the message.
     *
     * Generated from protobuf field <code>int32 ack_deadline_seconds = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $ack_deadline_seconds = 0;
    /**
     * Optional. Indicates whether to retain acknowledged messages. If true, then
     * messages are not expunged from the subscription's backlog, even if they are
     * acknowledged, until they fall out of the `message_retention_duration`
     * window. This must be true if you would like to [`Seek` to a timestamp]
     * (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
     * the past to replay previously-acknowledged messages.
     *
     * Generated from protobuf field <code>bool retain_acked_messages = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $retain_acked_messages = false;
    /**
     * Optional. How long to retain unacknowledged messages in the subscription's
     * backlog, from the moment a message is published. If `retain_acked_messages`
     * is true, then this also configures the retention of acknowledged messages,
     * and thus configures how far back in time a `Seek` can be done. Defaults to
     * 7 days. Cannot be more than 31 days or less than 10 minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $message_retention_duration = null;
    /**
     * Optional. See [Creating and managing
     * labels](https://cloud.google.com/pubsub/docs/labels).
     *
     * Generated from protobuf field <code>map<string, string> labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Optional. If true, messages published with the same `ordering_key` in
     * `PubsubMessage` will be delivered to the subscribers in the order in which
     * they are received by the Pub/Sub system. Otherwise, they may be delivered
     * in any order.
     *
     * Generated from protobuf field <code>bool enable_message_ordering = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $enable_message_ordering = false;
    /**
     * Optional. A policy that specifies the conditions for this subscription's
     * expiration. A subscription is considered active as long as any connected
     * subscriber is successfully consuming messages from the subscription or is
     * issuing operations on the subscription. If `expiration_policy` is not set,
     * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
     * but `expiration_policy.ttl` is not set, the subscription never expires.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $expiration_policy = null;
    /**
     * Optional. An expression written in the Pub/Sub [filter
     * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
     * then only `PubsubMessage`s whose `attributes` field matches the filter are
     * delivered on this subscription. If empty, then no messages are filtered
     * out.
     *
     * Generated from protobuf field <code>string filter = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $filter = '';
    /**
     * Optional. A policy that specifies the conditions for dead lettering
     * messages in this subscription. If dead_letter_policy is not set, dead
     * lettering is disabled.
     * The Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $dead_letter_policy = null;
    /**
     * Optional. A policy that specifies how Pub/Sub retries message delivery for
     * this subscription.
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $retry_policy = null;
    /**
     * Optional. Indicates whether the subscription is detached from its topic.
     * Detached subscriptions don't receive messages from their topic and don't
     * retain any backlog. `Pull` and `StreamingPull` requests will return
     * FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
     * the endpoint will not be made.
     *
     * Generated from protobuf field <code>bool detached = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $detached = false;
    /**
     * Optional. If true, Pub/Sub provides the following guarantees for the
     * delivery of a message with a given value of `message_id` on this
     * subscription:
     * * The message sent to a subscriber is guaranteed not to be resent
     * before the message's acknowledgement deadline expires.
     * * An acknowledged message will not be resent to a subscriber.
     * Note that subscribers may still receive multiple copies of a message
     * when `enable_exactly_once_delivery` is true if the message was published
     * multiple times by a publisher client. These copies are  considered distinct
     * by Pub/Sub and have distinct `message_id` values.
     *
     * Generated from protobuf field <code>bool enable_exactly_once_delivery = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $enable_exactly_once_delivery = false;
    /**
     * Output only. Indicates the minimum duration for which a message is retained
     * after it is published to the subscription's topic. If this field is set,
     * messages published to the subscription's topic in the last
     * `topic_message_retention_duration` are always available to subscribers. See
     * the `message_retention_duration` field in `Topic`. This field is set only
     * in responses from the server; it is ignored if it is set in any requests.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $topic_message_retention_duration = null;
    /**
     * Output only. An output-only field indicating whether or not the
     * subscription can receive messages.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.Subscription.State state = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Output only. Information about the associated Analytics Hub subscription.
     * Only set if the subscritpion is created by Analytics Hub.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo analytics_hub_subscription_info = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $analytics_hub_subscription_info = null;

    /**
     * @param string                             $name               Required. The name of the subscription. It must have the format
     *                                                               `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
     *                                                               start with a letter, and contain only letters (`[A-Za-z]`), numbers
     *                                                               (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
     *                                                               plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
     *                                                               in length, and it must not start with `"goog"`.
     * @param string                             $topic              Required. The name of the topic from which this subscription is receiving
     *                                                               messages. Format is `projects/{project}/topics/{topic}`. The value of this
     *                                                               field will be `_deleted-topic_` if the topic has been deleted. Please see
     *                                                               {@see SubscriberClient::topicName()} for help formatting this field.
     * @param \Google\Cloud\PubSub\V1\PushConfig $pushConfig         Optional. If push delivery is used with this subscription, this field is
     *                                                               used to configure it.
     * @param int                                $ackDeadlineSeconds Optional. The approximate amount of time (on a best-effort basis) Pub/Sub
     *                                                               waits for the subscriber to acknowledge receipt before resending the
     *                                                               message. In the interval after the message is delivered and before it is
     *                                                               acknowledged, it is considered to be _outstanding_. During that time
     *                                                               period, the message will not be redelivered (on a best-effort basis).
     *
     *                                                               For pull subscriptions, this value is used as the initial value for the ack
     *                                                               deadline. To override this value for a given message, call
     *                                                               `ModifyAckDeadline` with the corresponding `ack_id` if using
     *                                                               non-streaming pull or send the `ack_id` in a
     *                                                               `StreamingModifyAckDeadlineRequest` if using streaming pull.
     *                                                               The minimum custom deadline you can specify is 10 seconds.
     *                                                               The maximum custom deadline you can specify is 600 seconds (10 minutes).
     *                                                               If this parameter is 0, a default value of 10 seconds is used.
     *
     *                                                               For push delivery, this value is also used to set the request timeout for
     *                                                               the call to the push endpoint.
     *
     *                                                               If the subscriber never acknowledges the message, the Pub/Sub
     *                                                               system will eventually redeliver the message.
     *
     * @return \Google\Cloud\PubSub\V1\Subscription
     *
     * @experimental
     */
    public static function build(string $name, string $topic, \Google\Cloud\PubSub\V1\PushConfig $pushConfig, int $ackDeadlineSeconds): self
    {
        return (new self())
            ->setName($name)
            ->setTopic($topic)
            ->setPushConfig($pushConfig)
            ->setAckDeadlineSeconds($ackDeadlineSeconds);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. The name of the subscription. It must have the format
     *           `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
     *           start with a letter, and contain only letters (`[A-Za-z]`), numbers
     *           (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
     *           plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
     *           in length, and it must not start with `"goog"`.
     *     @type string $topic
     *           Required. The name of the topic from which this subscription is receiving
     *           messages. Format is `projects/{project}/topics/{topic}`. The value of this
     *           field will be `_deleted-topic_` if the topic has been deleted.
     *     @type \Google\Cloud\PubSub\V1\PushConfig $push_config
     *           Optional. If push delivery is used with this subscription, this field is
     *           used to configure it.
     *     @type \Google\Cloud\PubSub\V1\BigQueryConfig $bigquery_config
     *           Optional. If delivery to BigQuery is used with this subscription, this
     *           field is used to configure it.
     *     @type \Google\Cloud\PubSub\V1\CloudStorageConfig $cloud_storage_config
     *           Optional. If delivery to Google Cloud Storage is used with this
     *           subscription, this field is used to configure it.
     *     @type int $ack_deadline_seconds
     *           Optional. The approximate amount of time (on a best-effort basis) Pub/Sub
     *           waits for the subscriber to acknowledge receipt before resending the
     *           message. In the interval after the message is delivered and before it is
     *           acknowledged, it is considered to be _outstanding_. During that time
     *           period, the message will not be redelivered (on a best-effort basis).
     *           For pull subscriptions, this value is used as the initial value for the ack
     *           deadline. To override this value for a given message, call
     *           `ModifyAckDeadline` with the corresponding `ack_id` if using
     *           non-streaming pull or send the `ack_id` in a
     *           `StreamingModifyAckDeadlineRequest` if using streaming pull.
     *           The minimum custom deadline you can specify is 10 seconds.
     *           The maximum custom deadline you can specify is 600 seconds (10 minutes).
     *           If this parameter is 0, a default value of 10 seconds is used.
     *           For push delivery, this value is also used to set the request timeout for
     *           the call to the push endpoint.
     *           If the subscriber never acknowledges the message, the Pub/Sub
     *           system will eventually redeliver the message.
     *     @type bool $retain_acked_messages
     *           Optional. Indicates whether to retain acknowledged messages. If true, then
     *           messages are not expunged from the subscription's backlog, even if they are
     *           acknowledged, until they fall out of the `message_retention_duration`
     *           window. This must be true if you would like to [`Seek` to a timestamp]
     *           (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
     *           the past to replay previously-acknowledged messages.
     *     @type \Google\Protobuf\Duration $message_retention_duration
     *           Optional. How long to retain unacknowledged messages in the subscription's
     *           backlog, from the moment a message is published. If `retain_acked_messages`
     *           is true, then this also configures the retention of acknowledged messages,
     *           and thus configures how far back in time a `Seek` can be done. Defaults to
     *           7 days. Cannot be more than 31 days or less than 10 minutes.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. See [Creating and managing
     *           labels](https://cloud.google.com/pubsub/docs/labels).
     *     @type bool $enable_message_ordering
     *           Optional. If true, messages published with the same `ordering_key` in
     *           `PubsubMessage` will be delivered to the subscribers in the order in which
     *           they are received by the Pub/Sub system. Otherwise, they may be delivered
     *           in any order.
     *     @type \Google\Cloud\PubSub\V1\ExpirationPolicy $expiration_policy
     *           Optional. A policy that specifies the conditions for this subscription's
     *           expiration. A subscription is considered active as long as any connected
     *           subscriber is successfully consuming messages from the subscription or is
     *           issuing operations on the subscription. If `expiration_policy` is not set,
     *           a *default policy* with `ttl` of 31 days will be used. The minimum allowed
     *           value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
     *           but `expiration_policy.ttl` is not set, the subscription never expires.
     *     @type string $filter
     *           Optional. An expression written in the Pub/Sub [filter
     *           language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
     *           then only `PubsubMessage`s whose `attributes` field matches the filter are
     *           delivered on this subscription. If empty, then no messages are filtered
     *           out.
     *     @type \Google\Cloud\PubSub\V1\DeadLetterPolicy $dead_letter_policy
     *           Optional. A policy that specifies the conditions for dead lettering
     *           messages in this subscription. If dead_letter_policy is not set, dead
     *           lettering is disabled.
     *           The Pub/Sub service account associated with this subscriptions's
     *           parent project (i.e.,
     *           service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     *           permission to Acknowledge() messages on this subscription.
     *     @type \Google\Cloud\PubSub\V1\RetryPolicy $retry_policy
     *           Optional. A policy that specifies how Pub/Sub retries message delivery for
     *           this subscription.
     *           If not set, the default retry policy is applied. This generally implies
     *           that messages will be retried as soon as possible for healthy subscribers.
     *           RetryPolicy will be triggered on NACKs or acknowledgement deadline
     *           exceeded events for a given message.
     *     @type bool $detached
     *           Optional. Indicates whether the subscription is detached from its topic.
     *           Detached subscriptions don't receive messages from their topic and don't
     *           retain any backlog. `Pull` and `StreamingPull` requests will return
     *           FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
     *           the endpoint will not be made.
     *     @type bool $enable_exactly_once_delivery
     *           Optional. If true, Pub/Sub provides the following guarantees for the
     *           delivery of a message with a given value of `message_id` on this
     *           subscription:
     *           * The message sent to a subscriber is guaranteed not to be resent
     *           before the message's acknowledgement deadline expires.
     *           * An acknowledged message will not be resent to a subscriber.
     *           Note that subscribers may still receive multiple copies of a message
     *           when `enable_exactly_once_delivery` is true if the message was published
     *           multiple times by a publisher client. These copies are  considered distinct
     *           by Pub/Sub and have distinct `message_id` values.
     *     @type \Google\Protobuf\Duration $topic_message_retention_duration
     *           Output only. Indicates the minimum duration for which a message is retained
     *           after it is published to the subscription's topic. If this field is set,
     *           messages published to the subscription's topic in the last
     *           `topic_message_retention_duration` are always available to subscribers. See
     *           the `message_retention_duration` field in `Topic`. This field is set only
     *           in responses from the server; it is ignored if it is set in any requests.
     *     @type int $state
     *           Output only. An output-only field indicating whether or not the
     *           subscription can receive messages.
     *     @type \Google\Cloud\PubSub\V1\Subscription\AnalyticsHubSubscriptionInfo $analytics_hub_subscription_info
     *           Output only. Information about the associated Analytics Hub subscription.
     *           Only set if the subscritpion is created by Analytics Hub.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Pubsub\V1\Pubsub::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The name of the subscription. It must have the format
     * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
     * start with a letter, and contain only letters (`[A-Za-z]`), numbers
     * (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
     * plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
     * in length, and it must not start with `"goog"`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The name of the subscription. It must have the format
     * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
     * start with a letter, and contain only letters (`[A-Za-z]`), numbers
     * (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
     * plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
     * in length, and it must not start with `"goog"`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The name of the topic from which this subscription is receiving
     * messages. Format is `projects/{project}/topics/{topic}`. The value of this
     * field will be `_deleted-topic_` if the topic has been deleted.
     *
     * Generated from protobuf field <code>string topic = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getTopic()
    {
        return $this->topic;
    }

    /**
     * Required. The name of the topic from which this subscription is receiving
     * messages. Format is `projects/{project}/topics/{topic}`. The value of this
     * field will be `_deleted-topic_` if the topic has been deleted.
     *
     * Generated from protobuf field <code>string topic = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setTopic($var)
    {
        GPBUtil::checkString($var, True);
        $this->topic = $var;

        return $this;
    }

    /**
     * Optional. If push delivery is used with this subscription, this field is
     * used to configure it.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\PubSub\V1\PushConfig|null
     */
    public function getPushConfig()
    {
        return $this->push_config;
    }

    public function hasPushConfig()
    {
        return isset($this->push_config);
    }

    public function clearPushConfig()
    {
        unset($this->push_config);
    }

    /**
     * Optional. If push delivery is used with this subscription, this field is
     * used to configure it.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.PushConfig push_config = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\PubSub\V1\PushConfig $var
     * @return $this
     */
    public function setPushConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PubSub\V1\PushConfig::class);
        $this->push_config = $var;

        return $this;
    }

    /**
     * Optional. If delivery to BigQuery is used with this subscription, this
     * field is used to configure it.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\PubSub\V1\BigQueryConfig|null
     */
    public function getBigqueryConfig()
    {
        return $this->bigquery_config;
    }

    public function hasBigqueryConfig()
    {
        return isset($this->bigquery_config);
    }

    public function clearBigqueryConfig()
    {
        unset($this->bigquery_config);
    }

    /**
     * Optional. If delivery to BigQuery is used with this subscription, this
     * field is used to configure it.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.BigQueryConfig bigquery_config = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\PubSub\V1\BigQueryConfig $var
     * @return $this
     */
    public function setBigqueryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PubSub\V1\BigQueryConfig::class);
        $this->bigquery_config = $var;

        return $this;
    }

    /**
     * Optional. If delivery to Google Cloud Storage is used with this
     * subscription, this field is used to configure it.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\PubSub\V1\CloudStorageConfig|null
     */
    public function getCloudStorageConfig()
    {
        return $this->cloud_storage_config;
    }

    public function hasCloudStorageConfig()
    {
        return isset($this->cloud_storage_config);
    }

    public function clearCloudStorageConfig()
    {
        unset($this->cloud_storage_config);
    }

    /**
     * Optional. If delivery to Google Cloud Storage is used with this
     * subscription, this field is used to configure it.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.CloudStorageConfig cloud_storage_config = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\PubSub\V1\CloudStorageConfig $var
     * @return $this
     */
    public function setCloudStorageConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PubSub\V1\CloudStorageConfig::class);
        $this->cloud_storage_config = $var;

        return $this;
    }

    /**
     * Optional. The approximate amount of time (on a best-effort basis) Pub/Sub
     * waits for the subscriber to acknowledge receipt before resending the
     * message. In the interval after the message is delivered and before it is
     * acknowledged, it is considered to be _outstanding_. During that time
     * period, the message will not be redelivered (on a best-effort basis).
     * For pull subscriptions, this value is used as the initial value for the ack
     * deadline. To override this value for a given message, call
     * `ModifyAckDeadline` with the corresponding `ack_id` if using
     * non-streaming pull or send the `ack_id` in a
     * `StreamingModifyAckDeadlineRequest` if using streaming pull.
     * The minimum custom deadline you can specify is 10 seconds.
     * The maximum custom deadline you can specify is 600 seconds (10 minutes).
     * If this parameter is 0, a default value of 10 seconds is used.
     * For push delivery, this value is also used to set the request timeout for
     * the call to the push endpoint.
     * If the subscriber never acknowledges the message, the Pub/Sub
     * system will eventually redeliver the message.
     *
     * Generated from protobuf field <code>int32 ack_deadline_seconds = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getAckDeadlineSeconds()
    {
        return $this->ack_deadline_seconds;
    }

    /**
     * Optional. The approximate amount of time (on a best-effort basis) Pub/Sub
     * waits for the subscriber to acknowledge receipt before resending the
     * message. In the interval after the message is delivered and before it is
     * acknowledged, it is considered to be _outstanding_. During that time
     * period, the message will not be redelivered (on a best-effort basis).
     * For pull subscriptions, this value is used as the initial value for the ack
     * deadline. To override this value for a given message, call
     * `ModifyAckDeadline` with the corresponding `ack_id` if using
     * non-streaming pull or send the `ack_id` in a
     * `StreamingModifyAckDeadlineRequest` if using streaming pull.
     * The minimum custom deadline you can specify is 10 seconds.
     * The maximum custom deadline you can specify is 600 seconds (10 minutes).
     * If this parameter is 0, a default value of 10 seconds is used.
     * For push delivery, this value is also used to set the request timeout for
     * the call to the push endpoint.
     * If the subscriber never acknowledges the message, the Pub/Sub
     * system will eventually redeliver the message.
     *
     * Generated from protobuf field <code>int32 ack_deadline_seconds = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setAckDeadlineSeconds($var)
    {
        GPBUtil::checkInt32($var);
        $this->ack_deadline_seconds = $var;

        return $this;
    }

    /**
     * Optional. Indicates whether to retain acknowledged messages. If true, then
     * messages are not expunged from the subscription's backlog, even if they are
     * acknowledged, until they fall out of the `message_retention_duration`
     * window. This must be true if you would like to [`Seek` to a timestamp]
     * (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
     * the past to replay previously-acknowledged messages.
     *
     * Generated from protobuf field <code>bool retain_acked_messages = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getRetainAckedMessages()
    {
        return $this->retain_acked_messages;
    }

    /**
     * Optional. Indicates whether to retain acknowledged messages. If true, then
     * messages are not expunged from the subscription's backlog, even if they are
     * acknowledged, until they fall out of the `message_retention_duration`
     * window. This must be true if you would like to [`Seek` to a timestamp]
     * (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
     * the past to replay previously-acknowledged messages.
     *
     * Generated from protobuf field <code>bool retain_acked_messages = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setRetainAckedMessages($var)
    {
        GPBUtil::checkBool($var);
        $this->retain_acked_messages = $var;

        return $this;
    }

    /**
     * Optional. How long to retain unacknowledged messages in the subscription's
     * backlog, from the moment a message is published. If `retain_acked_messages`
     * is true, then this also configures the retention of acknowledged messages,
     * and thus configures how far back in time a `Seek` can be done. Defaults to
     * 7 days. Cannot be more than 31 days or less than 10 minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getMessageRetentionDuration()
    {
        return $this->message_retention_duration;
    }

    public function hasMessageRetentionDuration()
    {
        return isset($this->message_retention_duration);
    }

    public function clearMessageRetentionDuration()
    {
        unset($this->message_retention_duration);
    }

    /**
     * Optional. How long to retain unacknowledged messages in the subscription's
     * backlog, from the moment a message is published. If `retain_acked_messages`
     * is true, then this also configures the retention of acknowledged messages,
     * and thus configures how far back in time a `Seek` can be done. Defaults to
     * 7 days. Cannot be more than 31 days or less than 10 minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setMessageRetentionDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->message_retention_duration = $var;

        return $this;
    }

    /**
     * Optional. See [Creating and managing
     * labels](https://cloud.google.com/pubsub/docs/labels).
     *
     * Generated from protobuf field <code>map<string, string> labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. See [Creating and managing
     * labels](https://cloud.google.com/pubsub/docs/labels).
     *
     * Generated from protobuf field <code>map<string, string> labels = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. If true, messages published with the same `ordering_key` in
     * `PubsubMessage` will be delivered to the subscribers in the order in which
     * they are received by the Pub/Sub system. Otherwise, they may be delivered
     * in any order.
     *
     * Generated from protobuf field <code>bool enable_message_ordering = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnableMessageOrdering()
    {
        return $this->enable_message_ordering;
    }

    /**
     * Optional. If true, messages published with the same `ordering_key` in
     * `PubsubMessage` will be delivered to the subscribers in the order in which
     * they are received by the Pub/Sub system. Otherwise, they may be delivered
     * in any order.
     *
     * Generated from protobuf field <code>bool enable_message_ordering = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableMessageOrdering($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_message_ordering = $var;

        return $this;
    }

    /**
     * Optional. A policy that specifies the conditions for this subscription's
     * expiration. A subscription is considered active as long as any connected
     * subscriber is successfully consuming messages from the subscription or is
     * issuing operations on the subscription. If `expiration_policy` is not set,
     * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
     * but `expiration_policy.ttl` is not set, the subscription never expires.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\PubSub\V1\ExpirationPolicy|null
     */
    public function getExpirationPolicy()
    {
        return $this->expiration_policy;
    }

    public function hasExpirationPolicy()
    {
        return isset($this->expiration_policy);
    }

    public function clearExpirationPolicy()
    {
        unset($this->expiration_policy);
    }

    /**
     * Optional. A policy that specifies the conditions for this subscription's
     * expiration. A subscription is considered active as long as any connected
     * subscriber is successfully consuming messages from the subscription or is
     * issuing operations on the subscription. If `expiration_policy` is not set,
     * a *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day. If `expiration_policy` is set,
     * but `expiration_policy.ttl` is not set, the subscription never expires.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.ExpirationPolicy expiration_policy = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\PubSub\V1\ExpirationPolicy $var
     * @return $this
     */
    public function setExpirationPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PubSub\V1\ExpirationPolicy::class);
        $this->expiration_policy = $var;

        return $this;
    }

    /**
     * Optional. An expression written in the Pub/Sub [filter
     * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
     * then only `PubsubMessage`s whose `attributes` field matches the filter are
     * delivered on this subscription. If empty, then no messages are filtered
     * out.
     *
     * Generated from protobuf field <code>string filter = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * Optional. An expression written in the Pub/Sub [filter
     * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
     * then only `PubsubMessage`s whose `attributes` field matches the filter are
     * delivered on this subscription. If empty, then no messages are filtered
     * out.
     *
     * Generated from protobuf field <code>string filter = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * Optional. A policy that specifies the conditions for dead lettering
     * messages in this subscription. If dead_letter_policy is not set, dead
     * lettering is disabled.
     * The Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\PubSub\V1\DeadLetterPolicy|null
     */
    public function getDeadLetterPolicy()
    {
        return $this->dead_letter_policy;
    }

    public function hasDeadLetterPolicy()
    {
        return isset($this->dead_letter_policy);
    }

    public function clearDeadLetterPolicy()
    {
        unset($this->dead_letter_policy);
    }

    /**
     * Optional. A policy that specifies the conditions for dead lettering
     * messages in this subscription. If dead_letter_policy is not set, dead
     * lettering is disabled.
     * The Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\PubSub\V1\DeadLetterPolicy $var
     * @return $this
     */
    public function setDeadLetterPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PubSub\V1\DeadLetterPolicy::class);
        $this->dead_letter_policy = $var;

        return $this;
    }

    /**
     * Optional. A policy that specifies how Pub/Sub retries message delivery for
     * this subscription.
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\PubSub\V1\RetryPolicy|null
     */
    public function getRetryPolicy()
    {
        return $this->retry_policy;
    }

    public function hasRetryPolicy()
    {
        return isset($this->retry_policy);
    }

    public function clearRetryPolicy()
    {
        unset($this->retry_policy);
    }

    /**
     * Optional. A policy that specifies how Pub/Sub retries message delivery for
     * this subscription.
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.RetryPolicy retry_policy = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\PubSub\V1\RetryPolicy $var
     * @return $this
     */
    public function setRetryPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PubSub\V1\RetryPolicy::class);
        $this->retry_policy = $var;

        return $this;
    }

    /**
     * Optional. Indicates whether the subscription is detached from its topic.
     * Detached subscriptions don't receive messages from their topic and don't
     * retain any backlog. `Pull` and `StreamingPull` requests will return
     * FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
     * the endpoint will not be made.
     *
     * Generated from protobuf field <code>bool detached = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getDetached()
    {
        return $this->detached;
    }

    /**
     * Optional. Indicates whether the subscription is detached from its topic.
     * Detached subscriptions don't receive messages from their topic and don't
     * retain any backlog. `Pull` and `StreamingPull` requests will return
     * FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
     * the endpoint will not be made.
     *
     * Generated from protobuf field <code>bool detached = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setDetached($var)
    {
        GPBUtil::checkBool($var);
        $this->detached = $var;

        return $this;
    }

    /**
     * Optional. If true, Pub/Sub provides the following guarantees for the
     * delivery of a message with a given value of `message_id` on this
     * subscription:
     * * The message sent to a subscriber is guaranteed not to be resent
     * before the message's acknowledgement deadline expires.
     * * An acknowledged message will not be resent to a subscriber.
     * Note that subscribers may still receive multiple copies of a message
     * when `enable_exactly_once_delivery` is true if the message was published
     * multiple times by a publisher client. These copies are  considered distinct
     * by Pub/Sub and have distinct `message_id` values.
     *
     * Generated from protobuf field <code>bool enable_exactly_once_delivery = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnableExactlyOnceDelivery()
    {
        return $this->enable_exactly_once_delivery;
    }

    /**
     * Optional. If true, Pub/Sub provides the following guarantees for the
     * delivery of a message with a given value of `message_id` on this
     * subscription:
     * * The message sent to a subscriber is guaranteed not to be resent
     * before the message's acknowledgement deadline expires.
     * * An acknowledged message will not be resent to a subscriber.
     * Note that subscribers may still receive multiple copies of a message
     * when `enable_exactly_once_delivery` is true if the message was published
     * multiple times by a publisher client. These copies are  considered distinct
     * by Pub/Sub and have distinct `message_id` values.
     *
     * Generated from protobuf field <code>bool enable_exactly_once_delivery = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableExactlyOnceDelivery($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_exactly_once_delivery = $var;

        return $this;
    }

    /**
     * Output only. Indicates the minimum duration for which a message is retained
     * after it is published to the subscription's topic. If this field is set,
     * messages published to the subscription's topic in the last
     * `topic_message_retention_duration` are always available to subscribers. See
     * the `message_retention_duration` field in `Topic`. This field is set only
     * in responses from the server; it is ignored if it is set in any requests.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTopicMessageRetentionDuration()
    {
        return $this->topic_message_retention_duration;
    }

    public function hasTopicMessageRetentionDuration()
    {
        return isset($this->topic_message_retention_duration);
    }

    public function clearTopicMessageRetentionDuration()
    {
        unset($this->topic_message_retention_duration);
    }

    /**
     * Output only. Indicates the minimum duration for which a message is retained
     * after it is published to the subscription's topic. If this field is set,
     * messages published to the subscription's topic in the last
     * `topic_message_retention_duration` are always available to subscribers. See
     * the `message_retention_duration` field in `Topic`. This field is set only
     * in responses from the server; it is ignored if it is set in any requests.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTopicMessageRetentionDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->topic_message_retention_duration = $var;

        return $this;
    }

    /**
     * Output only. An output-only field indicating whether or not the
     * subscription can receive messages.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.Subscription.State state = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. An output-only field indicating whether or not the
     * subscription can receive messages.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.Subscription.State state = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\PubSub\V1\Subscription\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Information about the associated Analytics Hub subscription.
     * Only set if the subscritpion is created by Analytics Hub.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo analytics_hub_subscription_info = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\PubSub\V1\Subscription\AnalyticsHubSubscriptionInfo|null
     */
    public function getAnalyticsHubSubscriptionInfo()
    {
        return $this->analytics_hub_subscription_info;
    }

    public function hasAnalyticsHubSubscriptionInfo()
    {
        return isset($this->analytics_hub_subscription_info);
    }

    public function clearAnalyticsHubSubscriptionInfo()
    {
        unset($this->analytics_hub_subscription_info);
    }

    /**
     * Output only. Information about the associated Analytics Hub subscription.
     * Only set if the subscritpion is created by Analytics Hub.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.Subscription.AnalyticsHubSubscriptionInfo analytics_hub_subscription_info = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\PubSub\V1\Subscription\AnalyticsHubSubscriptionInfo $var
     * @return $this
     */
    public function setAnalyticsHubSubscriptionInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PubSub\V1\Subscription\AnalyticsHubSubscriptionInfo::class);
        $this->analytics_hub_subscription_info = $var;

        return $this;
    }

}

