<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/networkconnectivity/v1/hub.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\NetworkConnectivity\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\NetworkConnectivity\V1\AcceptHubSpokeRequest;
use Google\Cloud\NetworkConnectivity\V1\CreateHubRequest;
use Google\Cloud\NetworkConnectivity\V1\CreateSpokeRequest;
use Google\Cloud\NetworkConnectivity\V1\DeleteHubRequest;
use Google\Cloud\NetworkConnectivity\V1\DeleteSpokeRequest;
use Google\Cloud\NetworkConnectivity\V1\GetGroupRequest;
use Google\Cloud\NetworkConnectivity\V1\GetHubRequest;
use Google\Cloud\NetworkConnectivity\V1\GetRouteRequest;
use Google\Cloud\NetworkConnectivity\V1\GetRouteTableRequest;
use Google\Cloud\NetworkConnectivity\V1\GetSpokeRequest;
use Google\Cloud\NetworkConnectivity\V1\Group;
use Google\Cloud\NetworkConnectivity\V1\Hub;
use Google\Cloud\NetworkConnectivity\V1\ListGroupsRequest;
use Google\Cloud\NetworkConnectivity\V1\ListHubSpokesRequest;
use Google\Cloud\NetworkConnectivity\V1\ListHubsRequest;
use Google\Cloud\NetworkConnectivity\V1\ListRouteTablesRequest;
use Google\Cloud\NetworkConnectivity\V1\ListRoutesRequest;
use Google\Cloud\NetworkConnectivity\V1\ListSpokesRequest;
use Google\Cloud\NetworkConnectivity\V1\QueryHubStatusRequest;
use Google\Cloud\NetworkConnectivity\V1\RejectHubSpokeRequest;
use Google\Cloud\NetworkConnectivity\V1\Route;
use Google\Cloud\NetworkConnectivity\V1\RouteTable;
use Google\Cloud\NetworkConnectivity\V1\Spoke;
use Google\Cloud\NetworkConnectivity\V1\UpdateGroupRequest;
use Google\Cloud\NetworkConnectivity\V1\UpdateHubRequest;
use Google\Cloud\NetworkConnectivity\V1\UpdateSpokeRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Network Connectivity Center is a hub-and-spoke abstraction for network
 * connectivity management in Google Cloud. It reduces operational complexity
 * through a simple, centralized connectivity management model.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> acceptHubSpokeAsync(AcceptHubSpokeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createHubAsync(CreateHubRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createSpokeAsync(CreateSpokeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteHubAsync(DeleteHubRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteSpokeAsync(DeleteSpokeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Group> getGroupAsync(GetGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Hub> getHubAsync(GetHubRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Route> getRouteAsync(GetRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RouteTable> getRouteTableAsync(GetRouteTableRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Spoke> getSpokeAsync(GetSpokeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listGroupsAsync(ListGroupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listHubSpokesAsync(ListHubSpokesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listHubsAsync(ListHubsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listRouteTablesAsync(ListRouteTablesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listRoutesAsync(ListRoutesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSpokesAsync(ListSpokesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> queryHubStatusAsync(QueryHubStatusRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> rejectHubSpokeAsync(RejectHubSpokeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateGroupAsync(UpdateGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateHubAsync(UpdateHubRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateSpokeAsync(UpdateSpokeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class HubServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.networkconnectivity.v1.HubService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'networkconnectivity.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'networkconnectivity.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/hub_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/hub_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/hub_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/hub_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a group
     * resource.
     *
     * @param string $project
     * @param string $hub
     * @param string $group
     *
     * @return string The formatted group resource.
     */
    public static function groupName(string $project, string $hub, string $group): string
    {
        return self::getPathTemplate('group')->render([
            'project' => $project,
            'hub' => $hub,
            'group' => $group,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a hub
     * resource.
     *
     * @param string $project
     * @param string $hub
     *
     * @return string The formatted hub resource.
     */
    public static function hubName(string $project, string $hub): string
    {
        return self::getPathTemplate('hub')->render([
            'project' => $project,
            'hub' => $hub,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a hub_route
     * resource.
     *
     * @param string $project
     * @param string $hub
     * @param string $routeTable
     * @param string $route
     *
     * @return string The formatted hub_route resource.
     */
    public static function hubRouteName(string $project, string $hub, string $routeTable, string $route): string
    {
        return self::getPathTemplate('hubRoute')->render([
            'project' => $project,
            'hub' => $hub,
            'route_table' => $routeTable,
            'route' => $route,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $zone
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName(string $project, string $zone, string $instance): string
    {
        return self::getPathTemplate('instance')->render([
            'project' => $project,
            'zone' => $zone,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * interconnect_attachment resource.
     *
     * @param string $project
     * @param string $region
     * @param string $resourceId
     *
     * @return string The formatted interconnect_attachment resource.
     */
    public static function interconnectAttachmentName(string $project, string $region, string $resourceId): string
    {
        return self::getPathTemplate('interconnectAttachment')->render([
            'project' => $project,
            'region' => $region,
            'resource_id' => $resourceId,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $resourceId
     *
     * @return string The formatted network resource.
     */
    public static function networkName(string $project, string $resourceId): string
    {
        return self::getPathTemplate('network')->render([
            'project' => $project,
            'resource_id' => $resourceId,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a route_table
     * resource.
     *
     * @param string $project
     * @param string $hub
     * @param string $routeTable
     *
     * @return string The formatted route_table resource.
     */
    public static function routeTableName(string $project, string $hub, string $routeTable): string
    {
        return self::getPathTemplate('routeTable')->render([
            'project' => $project,
            'hub' => $hub,
            'route_table' => $routeTable,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a spoke
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $spoke
     *
     * @return string The formatted spoke resource.
     */
    public static function spokeName(string $project, string $location, string $spoke): string
    {
        return self::getPathTemplate('spoke')->render([
            'project' => $project,
            'location' => $location,
            'spoke' => $spoke,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a vpn_tunnel
     * resource.
     *
     * @param string $project
     * @param string $region
     * @param string $resourceId
     *
     * @return string The formatted vpn_tunnel resource.
     */
    public static function vpnTunnelName(string $project, string $region, string $resourceId): string
    {
        return self::getPathTemplate('vpnTunnel')->render([
            'project' => $project,
            'region' => $region,
            'resource_id' => $resourceId,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - group: projects/{project}/locations/global/hubs/{hub}/groups/{group}
     * - hub: projects/{project}/locations/global/hubs/{hub}
     * - hubRoute: projects/{project}/locations/global/hubs/{hub}/routeTables/{route_table}/routes/{route}
     * - instance: projects/{project}/zones/{zone}/instances/{instance}
     * - interconnectAttachment: projects/{project}/regions/{region}/interconnectAttachments/{resource_id}
     * - location: projects/{project}/locations/{location}
     * - network: projects/{project}/global/networks/{resource_id}
     * - routeTable: projects/{project}/locations/global/hubs/{hub}/routeTables/{route_table}
     * - spoke: projects/{project}/locations/{location}/spokes/{spoke}
     * - vpnTunnel: projects/{project}/regions/{region}/vpnTunnels/{resource_id}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'networkconnectivity.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Accepts a proposal to attach a Network Connectivity Center spoke
     * to a hub.
     *
     * The async variant is {@see HubServiceClient::acceptHubSpokeAsync()} .
     *
     * @example samples/V1/HubServiceClient/accept_hub_spoke.php
     *
     * @param AcceptHubSpokeRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function acceptHubSpoke(AcceptHubSpokeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('AcceptHubSpoke', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Network Connectivity Center hub in the specified project.
     *
     * The async variant is {@see HubServiceClient::createHubAsync()} .
     *
     * @example samples/V1/HubServiceClient/create_hub.php
     *
     * @param CreateHubRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createHub(CreateHubRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateHub', $request, $callOptions)->wait();
    }

    /**
     * Creates a Network Connectivity Center spoke.
     *
     * The async variant is {@see HubServiceClient::createSpokeAsync()} .
     *
     * @example samples/V1/HubServiceClient/create_spoke.php
     *
     * @param CreateSpokeRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSpoke(CreateSpokeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateSpoke', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Network Connectivity Center hub.
     *
     * The async variant is {@see HubServiceClient::deleteHubAsync()} .
     *
     * @example samples/V1/HubServiceClient/delete_hub.php
     *
     * @param DeleteHubRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteHub(DeleteHubRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteHub', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Network Connectivity Center spoke.
     *
     * The async variant is {@see HubServiceClient::deleteSpokeAsync()} .
     *
     * @example samples/V1/HubServiceClient/delete_spoke.php
     *
     * @param DeleteSpokeRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSpoke(DeleteSpokeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteSpoke', $request, $callOptions)->wait();
    }

    /**
     * Gets details about a Network Connectivity Center group.
     *
     * The async variant is {@see HubServiceClient::getGroupAsync()} .
     *
     * @example samples/V1/HubServiceClient/get_group.php
     *
     * @param GetGroupRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Group
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGroup(GetGroupRequest $request, array $callOptions = []): Group
    {
        return $this->startApiCall('GetGroup', $request, $callOptions)->wait();
    }

    /**
     * Gets details about a Network Connectivity Center hub.
     *
     * The async variant is {@see HubServiceClient::getHubAsync()} .
     *
     * @example samples/V1/HubServiceClient/get_hub.php
     *
     * @param GetHubRequest $request     A request to house fields associated with the call.
     * @param array         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Hub
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getHub(GetHubRequest $request, array $callOptions = []): Hub
    {
        return $this->startApiCall('GetHub', $request, $callOptions)->wait();
    }

    /**
     * Gets details about the specified route.
     *
     * The async variant is {@see HubServiceClient::getRouteAsync()} .
     *
     * @example samples/V1/HubServiceClient/get_route.php
     *
     * @param GetRouteRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Route
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRoute(GetRouteRequest $request, array $callOptions = []): Route
    {
        return $this->startApiCall('GetRoute', $request, $callOptions)->wait();
    }

    /**
     * Gets details about a Network Connectivity Center route table.
     *
     * The async variant is {@see HubServiceClient::getRouteTableAsync()} .
     *
     * @example samples/V1/HubServiceClient/get_route_table.php
     *
     * @param GetRouteTableRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RouteTable
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRouteTable(GetRouteTableRequest $request, array $callOptions = []): RouteTable
    {
        return $this->startApiCall('GetRouteTable', $request, $callOptions)->wait();
    }

    /**
     * Gets details about a Network Connectivity Center spoke.
     *
     * The async variant is {@see HubServiceClient::getSpokeAsync()} .
     *
     * @example samples/V1/HubServiceClient/get_spoke.php
     *
     * @param GetSpokeRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Spoke
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSpoke(GetSpokeRequest $request, array $callOptions = []): Spoke
    {
        return $this->startApiCall('GetSpoke', $request, $callOptions)->wait();
    }

    /**
     * Lists groups in a given hub.
     *
     * The async variant is {@see HubServiceClient::listGroupsAsync()} .
     *
     * @example samples/V1/HubServiceClient/list_groups.php
     *
     * @param ListGroupsRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listGroups(ListGroupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListGroups', $request, $callOptions);
    }

    /**
     * Lists the Network Connectivity Center spokes associated with a
     * specified hub and location. The list includes both spokes that are attached
     * to the hub and spokes that have been proposed but not yet accepted.
     *
     * The async variant is {@see HubServiceClient::listHubSpokesAsync()} .
     *
     * @example samples/V1/HubServiceClient/list_hub_spokes.php
     *
     * @param ListHubSpokesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listHubSpokes(ListHubSpokesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListHubSpokes', $request, $callOptions);
    }

    /**
     * Lists the Network Connectivity Center hubs associated with a given project.
     *
     * The async variant is {@see HubServiceClient::listHubsAsync()} .
     *
     * @example samples/V1/HubServiceClient/list_hubs.php
     *
     * @param ListHubsRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listHubs(ListHubsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListHubs', $request, $callOptions);
    }

    /**
     * Lists route tables in a given hub.
     *
     * The async variant is {@see HubServiceClient::listRouteTablesAsync()} .
     *
     * @example samples/V1/HubServiceClient/list_route_tables.php
     *
     * @param ListRouteTablesRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRouteTables(ListRouteTablesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRouteTables', $request, $callOptions);
    }

    /**
     * Lists routes in a given route table.
     *
     * The async variant is {@see HubServiceClient::listRoutesAsync()} .
     *
     * @example samples/V1/HubServiceClient/list_routes.php
     *
     * @param ListRoutesRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRoutes(ListRoutesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRoutes', $request, $callOptions);
    }

    /**
     * Lists the Network Connectivity Center spokes in a specified project and
     * location.
     *
     * The async variant is {@see HubServiceClient::listSpokesAsync()} .
     *
     * @example samples/V1/HubServiceClient/list_spokes.php
     *
     * @param ListSpokesRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSpokes(ListSpokesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSpokes', $request, $callOptions);
    }

    /**
     * Query the Private Service Connect propagation status of a Network
     * Connectivity Center hub.
     *
     * The async variant is {@see HubServiceClient::queryHubStatusAsync()} .
     *
     * @example samples/V1/HubServiceClient/query_hub_status.php
     *
     * @param QueryHubStatusRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function queryHubStatus(QueryHubStatusRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('QueryHubStatus', $request, $callOptions);
    }

    /**
     * Rejects a Network Connectivity Center spoke from being attached to a hub.
     * If the spoke was previously in the `ACTIVE` state, it
     * transitions to the `INACTIVE` state and is no longer able to
     * connect to other spokes that are attached to the hub.
     *
     * The async variant is {@see HubServiceClient::rejectHubSpokeAsync()} .
     *
     * @example samples/V1/HubServiceClient/reject_hub_spoke.php
     *
     * @param RejectHubSpokeRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function rejectHubSpoke(RejectHubSpokeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RejectHubSpoke', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a Network Connectivity Center group.
     *
     * The async variant is {@see HubServiceClient::updateGroupAsync()} .
     *
     * @example samples/V1/HubServiceClient/update_group.php
     *
     * @param UpdateGroupRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateGroup(UpdateGroupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateGroup', $request, $callOptions)->wait();
    }

    /**
     * Updates the description and/or labels of a Network Connectivity Center
     * hub.
     *
     * The async variant is {@see HubServiceClient::updateHubAsync()} .
     *
     * @example samples/V1/HubServiceClient/update_hub.php
     *
     * @param UpdateHubRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateHub(UpdateHubRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateHub', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a Network Connectivity Center spoke.
     *
     * The async variant is {@see HubServiceClient::updateSpokeAsync()} .
     *
     * @example samples/V1/HubServiceClient/update_spoke.php
     *
     * @param UpdateSpokeRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSpoke(UpdateSpokeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateSpoke', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see HubServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/HubServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see HubServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/HubServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see HubServiceClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/HubServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see HubServiceClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/HubServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see HubServiceClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/HubServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
