<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/netapp/v1/cloud_netapp_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\NetApp\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\NetApp\V1\ActiveDirectory;
use Google\Cloud\NetApp\V1\Backup;
use Google\Cloud\NetApp\V1\BackupPolicy;
use Google\Cloud\NetApp\V1\BackupVault;
use Google\Cloud\NetApp\V1\CreateActiveDirectoryRequest;
use Google\Cloud\NetApp\V1\CreateBackupPolicyRequest;
use Google\Cloud\NetApp\V1\CreateBackupRequest;
use Google\Cloud\NetApp\V1\CreateBackupVaultRequest;
use Google\Cloud\NetApp\V1\CreateKmsConfigRequest;
use Google\Cloud\NetApp\V1\CreateReplicationRequest;
use Google\Cloud\NetApp\V1\CreateSnapshotRequest;
use Google\Cloud\NetApp\V1\CreateStoragePoolRequest;
use Google\Cloud\NetApp\V1\CreateVolumeRequest;
use Google\Cloud\NetApp\V1\DeleteActiveDirectoryRequest;
use Google\Cloud\NetApp\V1\DeleteBackupPolicyRequest;
use Google\Cloud\NetApp\V1\DeleteBackupRequest;
use Google\Cloud\NetApp\V1\DeleteBackupVaultRequest;
use Google\Cloud\NetApp\V1\DeleteKmsConfigRequest;
use Google\Cloud\NetApp\V1\DeleteReplicationRequest;
use Google\Cloud\NetApp\V1\DeleteSnapshotRequest;
use Google\Cloud\NetApp\V1\DeleteStoragePoolRequest;
use Google\Cloud\NetApp\V1\DeleteVolumeRequest;
use Google\Cloud\NetApp\V1\EncryptVolumesRequest;
use Google\Cloud\NetApp\V1\EstablishPeeringRequest;
use Google\Cloud\NetApp\V1\GetActiveDirectoryRequest;
use Google\Cloud\NetApp\V1\GetBackupPolicyRequest;
use Google\Cloud\NetApp\V1\GetBackupRequest;
use Google\Cloud\NetApp\V1\GetBackupVaultRequest;
use Google\Cloud\NetApp\V1\GetKmsConfigRequest;
use Google\Cloud\NetApp\V1\GetReplicationRequest;
use Google\Cloud\NetApp\V1\GetSnapshotRequest;
use Google\Cloud\NetApp\V1\GetStoragePoolRequest;
use Google\Cloud\NetApp\V1\GetVolumeRequest;
use Google\Cloud\NetApp\V1\KmsConfig;
use Google\Cloud\NetApp\V1\ListActiveDirectoriesRequest;
use Google\Cloud\NetApp\V1\ListBackupPoliciesRequest;
use Google\Cloud\NetApp\V1\ListBackupVaultsRequest;
use Google\Cloud\NetApp\V1\ListBackupsRequest;
use Google\Cloud\NetApp\V1\ListKmsConfigsRequest;
use Google\Cloud\NetApp\V1\ListReplicationsRequest;
use Google\Cloud\NetApp\V1\ListSnapshotsRequest;
use Google\Cloud\NetApp\V1\ListStoragePoolsRequest;
use Google\Cloud\NetApp\V1\ListVolumesRequest;
use Google\Cloud\NetApp\V1\Replication;
use Google\Cloud\NetApp\V1\ResumeReplicationRequest;
use Google\Cloud\NetApp\V1\ReverseReplicationDirectionRequest;
use Google\Cloud\NetApp\V1\RevertVolumeRequest;
use Google\Cloud\NetApp\V1\Snapshot;
use Google\Cloud\NetApp\V1\StopReplicationRequest;
use Google\Cloud\NetApp\V1\StoragePool;
use Google\Cloud\NetApp\V1\SwitchActiveReplicaZoneRequest;
use Google\Cloud\NetApp\V1\SyncReplicationRequest;
use Google\Cloud\NetApp\V1\UpdateActiveDirectoryRequest;
use Google\Cloud\NetApp\V1\UpdateBackupPolicyRequest;
use Google\Cloud\NetApp\V1\UpdateBackupRequest;
use Google\Cloud\NetApp\V1\UpdateBackupVaultRequest;
use Google\Cloud\NetApp\V1\UpdateKmsConfigRequest;
use Google\Cloud\NetApp\V1\UpdateReplicationRequest;
use Google\Cloud\NetApp\V1\UpdateSnapshotRequest;
use Google\Cloud\NetApp\V1\UpdateStoragePoolRequest;
use Google\Cloud\NetApp\V1\UpdateVolumeRequest;
use Google\Cloud\NetApp\V1\VerifyKmsConfigRequest;
use Google\Cloud\NetApp\V1\VerifyKmsConfigResponse;
use Google\Cloud\NetApp\V1\Volume;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: NetApp Files Google Cloud Service
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> createActiveDirectoryAsync(CreateActiveDirectoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createBackupAsync(CreateBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createBackupPolicyAsync(CreateBackupPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createBackupVaultAsync(CreateBackupVaultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createKmsConfigAsync(CreateKmsConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createReplicationAsync(CreateReplicationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createSnapshotAsync(CreateSnapshotRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createStoragePoolAsync(CreateStoragePoolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createVolumeAsync(CreateVolumeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteActiveDirectoryAsync(DeleteActiveDirectoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteBackupAsync(DeleteBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteBackupPolicyAsync(DeleteBackupPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteBackupVaultAsync(DeleteBackupVaultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteKmsConfigAsync(DeleteKmsConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteReplicationAsync(DeleteReplicationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteSnapshotAsync(DeleteSnapshotRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteStoragePoolAsync(DeleteStoragePoolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteVolumeAsync(DeleteVolumeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> encryptVolumesAsync(EncryptVolumesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> establishPeeringAsync(EstablishPeeringRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ActiveDirectory> getActiveDirectoryAsync(GetActiveDirectoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Backup> getBackupAsync(GetBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BackupPolicy> getBackupPolicyAsync(GetBackupPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BackupVault> getBackupVaultAsync(GetBackupVaultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<KmsConfig> getKmsConfigAsync(GetKmsConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Replication> getReplicationAsync(GetReplicationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Snapshot> getSnapshotAsync(GetSnapshotRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<StoragePool> getStoragePoolAsync(GetStoragePoolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Volume> getVolumeAsync(GetVolumeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listActiveDirectoriesAsync(ListActiveDirectoriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listBackupPoliciesAsync(ListBackupPoliciesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listBackupVaultsAsync(ListBackupVaultsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listBackupsAsync(ListBackupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listKmsConfigsAsync(ListKmsConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listReplicationsAsync(ListReplicationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSnapshotsAsync(ListSnapshotsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listStoragePoolsAsync(ListStoragePoolsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listVolumesAsync(ListVolumesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> resumeReplicationAsync(ResumeReplicationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> reverseReplicationDirectionAsync(ReverseReplicationDirectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> revertVolumeAsync(RevertVolumeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> stopReplicationAsync(StopReplicationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> switchActiveReplicaZoneAsync(SwitchActiveReplicaZoneRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> syncReplicationAsync(SyncReplicationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateActiveDirectoryAsync(UpdateActiveDirectoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateBackupAsync(UpdateBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateBackupPolicyAsync(UpdateBackupPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateBackupVaultAsync(UpdateBackupVaultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateKmsConfigAsync(UpdateKmsConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateReplicationAsync(UpdateReplicationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateSnapshotAsync(UpdateSnapshotRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateStoragePoolAsync(UpdateStoragePoolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateVolumeAsync(UpdateVolumeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<VerifyKmsConfigResponse> verifyKmsConfigAsync(VerifyKmsConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class NetAppClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.netapp.v1.NetApp';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'netapp.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'netapp.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/net_app_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/net_app_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/net_app_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/net_app_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * active_directory resource.
     *
     * @param string $project
     * @param string $location
     * @param string $activeDirectory
     *
     * @return string The formatted active_directory resource.
     */
    public static function activeDirectoryName(string $project, string $location, string $activeDirectory): string
    {
        return self::getPathTemplate('activeDirectory')->render([
            'project' => $project,
            'location' => $location,
            'active_directory' => $activeDirectory,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backupVault
     * @param string $backup
     *
     * @return string The formatted backup resource.
     */
    public static function backupName(string $project, string $location, string $backupVault, string $backup): string
    {
        return self::getPathTemplate('backup')->render([
            'project' => $project,
            'location' => $location,
            'backup_vault' => $backupVault,
            'backup' => $backup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * backup_policy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backupPolicy
     *
     * @return string The formatted backup_policy resource.
     */
    public static function backupPolicyName(string $project, string $location, string $backupPolicy): string
    {
        return self::getPathTemplate('backupPolicy')->render([
            'project' => $project,
            'location' => $location,
            'backup_policy' => $backupPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup_vault
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backupVault
     *
     * @return string The formatted backup_vault resource.
     */
    public static function backupVaultName(string $project, string $location, string $backupVault): string
    {
        return self::getPathTemplate('backupVault')->render([
            'project' => $project,
            'location' => $location,
            'backup_vault' => $backupVault,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a kms_config
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $kmsConfig
     *
     * @return string The formatted kms_config resource.
     */
    public static function kmsConfigName(string $project, string $location, string $kmsConfig): string
    {
        return self::getPathTemplate('kmsConfig')->render([
            'project' => $project,
            'location' => $location,
            'kms_config' => $kmsConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName(string $project, string $network): string
    {
        return self::getPathTemplate('network')->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a replication
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $volume
     * @param string $replication
     *
     * @return string The formatted replication resource.
     */
    public static function replicationName(
        string $project,
        string $location,
        string $volume,
        string $replication
    ): string {
        return self::getPathTemplate('replication')->render([
            'project' => $project,
            'location' => $location,
            'volume' => $volume,
            'replication' => $replication,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a snapshot
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $volume
     * @param string $snapshot
     *
     * @return string The formatted snapshot resource.
     */
    public static function snapshotName(string $project, string $location, string $volume, string $snapshot): string
    {
        return self::getPathTemplate('snapshot')->render([
            'project' => $project,
            'location' => $location,
            'volume' => $volume,
            'snapshot' => $snapshot,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a storage_pool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $storagePool
     *
     * @return string The formatted storage_pool resource.
     */
    public static function storagePoolName(string $project, string $location, string $storagePool): string
    {
        return self::getPathTemplate('storagePool')->render([
            'project' => $project,
            'location' => $location,
            'storage_pool' => $storagePool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a volume
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $volume
     *
     * @return string The formatted volume resource.
     */
    public static function volumeName(string $project, string $location, string $volume): string
    {
        return self::getPathTemplate('volume')->render([
            'project' => $project,
            'location' => $location,
            'volume' => $volume,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - activeDirectory: projects/{project}/locations/{location}/activeDirectories/{active_directory}
     * - backup: projects/{project}/locations/{location}/backupVaults/{backup_vault}/backups/{backup}
     * - backupPolicy: projects/{project}/locations/{location}/backupPolicies/{backup_policy}
     * - backupVault: projects/{project}/locations/{location}/backupVaults/{backup_vault}
     * - kmsConfig: projects/{project}/locations/{location}/kmsConfigs/{kms_config}
     * - location: projects/{project}/locations/{location}
     * - network: projects/{project}/global/networks/{network}
     * - replication: projects/{project}/locations/{location}/volumes/{volume}/replications/{replication}
     * - snapshot: projects/{project}/locations/{location}/volumes/{volume}/snapshots/{snapshot}
     * - storagePool: projects/{project}/locations/{location}/storagePools/{storage_pool}
     * - volume: projects/{project}/locations/{location}/volumes/{volume}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'netapp.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * CreateActiveDirectory
     * Creates the active directory specified in the request.
     *
     * The async variant is {@see NetAppClient::createActiveDirectoryAsync()} .
     *
     * @example samples/V1/NetAppClient/create_active_directory.php
     *
     * @param CreateActiveDirectoryRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createActiveDirectory(
        CreateActiveDirectoryRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateActiveDirectory', $request, $callOptions)->wait();
    }

    /**
     * Creates a backup from the volume specified in the request
     * The backup can be created from the given snapshot if specified in the
     * request. If no snapshot specified, there'll be a new snapshot taken to
     * initiate the backup creation.
     *
     * The async variant is {@see NetAppClient::createBackupAsync()} .
     *
     * @example samples/V1/NetAppClient/create_backup.php
     *
     * @param CreateBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBackup(CreateBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateBackup', $request, $callOptions)->wait();
    }

    /**
     * Creates new backup policy
     *
     * The async variant is {@see NetAppClient::createBackupPolicyAsync()} .
     *
     * @example samples/V1/NetAppClient/create_backup_policy.php
     *
     * @param CreateBackupPolicyRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBackupPolicy(CreateBackupPolicyRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateBackupPolicy', $request, $callOptions)->wait();
    }

    /**
     * Creates new backup vault
     *
     * The async variant is {@see NetAppClient::createBackupVaultAsync()} .
     *
     * @example samples/V1/NetAppClient/create_backup_vault.php
     *
     * @param CreateBackupVaultRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBackupVault(CreateBackupVaultRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateBackupVault', $request, $callOptions)->wait();
    }

    /**
     * Creates a new KMS config.
     *
     * The async variant is {@see NetAppClient::createKmsConfigAsync()} .
     *
     * @example samples/V1/NetAppClient/create_kms_config.php
     *
     * @param CreateKmsConfigRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createKmsConfig(CreateKmsConfigRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateKmsConfig', $request, $callOptions)->wait();
    }

    /**
     * Create a new replication for a volume.
     *
     * The async variant is {@see NetAppClient::createReplicationAsync()} .
     *
     * @example samples/V1/NetAppClient/create_replication.php
     *
     * @param CreateReplicationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createReplication(CreateReplicationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateReplication', $request, $callOptions)->wait();
    }

    /**
     * Create a new snapshot for a volume.
     *
     * The async variant is {@see NetAppClient::createSnapshotAsync()} .
     *
     * @example samples/V1/NetAppClient/create_snapshot.php
     *
     * @param CreateSnapshotRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSnapshot(CreateSnapshotRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateSnapshot', $request, $callOptions)->wait();
    }

    /**
     * Creates a new storage pool.
     *
     * The async variant is {@see NetAppClient::createStoragePoolAsync()} .
     *
     * @example samples/V1/NetAppClient/create_storage_pool.php
     *
     * @param CreateStoragePoolRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createStoragePool(CreateStoragePoolRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateStoragePool', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Volume in a given project and location.
     *
     * The async variant is {@see NetAppClient::createVolumeAsync()} .
     *
     * @example samples/V1/NetAppClient/create_volume.php
     *
     * @param CreateVolumeRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createVolume(CreateVolumeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateVolume', $request, $callOptions)->wait();
    }

    /**
     * Delete the active directory specified in the request.
     *
     * The async variant is {@see NetAppClient::deleteActiveDirectoryAsync()} .
     *
     * @example samples/V1/NetAppClient/delete_active_directory.php
     *
     * @param DeleteActiveDirectoryRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteActiveDirectory(
        DeleteActiveDirectoryRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteActiveDirectory', $request, $callOptions)->wait();
    }

    /**
     * Warning! This operation will permanently delete the backup.
     *
     * The async variant is {@see NetAppClient::deleteBackupAsync()} .
     *
     * @example samples/V1/NetAppClient/delete_backup.php
     *
     * @param DeleteBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBackup(DeleteBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteBackup', $request, $callOptions)->wait();
    }

    /**
     * Warning! This operation will permanently delete the backup policy.
     *
     * The async variant is {@see NetAppClient::deleteBackupPolicyAsync()} .
     *
     * @example samples/V1/NetAppClient/delete_backup_policy.php
     *
     * @param DeleteBackupPolicyRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBackupPolicy(DeleteBackupPolicyRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteBackupPolicy', $request, $callOptions)->wait();
    }

    /**
     * Warning! This operation will permanently delete the backup vault.
     *
     * The async variant is {@see NetAppClient::deleteBackupVaultAsync()} .
     *
     * @example samples/V1/NetAppClient/delete_backup_vault.php
     *
     * @param DeleteBackupVaultRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBackupVault(DeleteBackupVaultRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteBackupVault', $request, $callOptions)->wait();
    }

    /**
     * Warning! This operation will permanently delete the Kms config.
     *
     * The async variant is {@see NetAppClient::deleteKmsConfigAsync()} .
     *
     * @example samples/V1/NetAppClient/delete_kms_config.php
     *
     * @param DeleteKmsConfigRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteKmsConfig(DeleteKmsConfigRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteKmsConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes a replication.
     *
     * The async variant is {@see NetAppClient::deleteReplicationAsync()} .
     *
     * @example samples/V1/NetAppClient/delete_replication.php
     *
     * @param DeleteReplicationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteReplication(DeleteReplicationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteReplication', $request, $callOptions)->wait();
    }

    /**
     * Deletes a snapshot.
     *
     * The async variant is {@see NetAppClient::deleteSnapshotAsync()} .
     *
     * @example samples/V1/NetAppClient/delete_snapshot.php
     *
     * @param DeleteSnapshotRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSnapshot(DeleteSnapshotRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteSnapshot', $request, $callOptions)->wait();
    }

    /**
     * Warning! This operation will permanently delete the storage pool.
     *
     * The async variant is {@see NetAppClient::deleteStoragePoolAsync()} .
     *
     * @example samples/V1/NetAppClient/delete_storage_pool.php
     *
     * @param DeleteStoragePoolRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteStoragePool(DeleteStoragePoolRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteStoragePool', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Volume.
     *
     * The async variant is {@see NetAppClient::deleteVolumeAsync()} .
     *
     * @example samples/V1/NetAppClient/delete_volume.php
     *
     * @param DeleteVolumeRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteVolume(DeleteVolumeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteVolume', $request, $callOptions)->wait();
    }

    /**
     * Encrypt the existing volumes without CMEK encryption with the desired the
     * KMS config for the whole region.
     *
     * The async variant is {@see NetAppClient::encryptVolumesAsync()} .
     *
     * @example samples/V1/NetAppClient/encrypt_volumes.php
     *
     * @param EncryptVolumesRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function encryptVolumes(EncryptVolumesRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('EncryptVolumes', $request, $callOptions)->wait();
    }

    /**
     * Establish replication peering.
     *
     * The async variant is {@see NetAppClient::establishPeeringAsync()} .
     *
     * @example samples/V1/NetAppClient/establish_peering.php
     *
     * @param EstablishPeeringRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function establishPeering(EstablishPeeringRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('EstablishPeering', $request, $callOptions)->wait();
    }

    /**
     * Describes a specified active directory.
     *
     * The async variant is {@see NetAppClient::getActiveDirectoryAsync()} .
     *
     * @example samples/V1/NetAppClient/get_active_directory.php
     *
     * @param GetActiveDirectoryRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ActiveDirectory
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getActiveDirectory(GetActiveDirectoryRequest $request, array $callOptions = []): ActiveDirectory
    {
        return $this->startApiCall('GetActiveDirectory', $request, $callOptions)->wait();
    }

    /**
     * Returns the description of the specified backup
     *
     * The async variant is {@see NetAppClient::getBackupAsync()} .
     *
     * @example samples/V1/NetAppClient/get_backup.php
     *
     * @param GetBackupRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Backup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBackup(GetBackupRequest $request, array $callOptions = []): Backup
    {
        return $this->startApiCall('GetBackup', $request, $callOptions)->wait();
    }

    /**
     * Returns the description of the specified backup policy by backup_policy_id.
     *
     * The async variant is {@see NetAppClient::getBackupPolicyAsync()} .
     *
     * @example samples/V1/NetAppClient/get_backup_policy.php
     *
     * @param GetBackupPolicyRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BackupPolicy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBackupPolicy(GetBackupPolicyRequest $request, array $callOptions = []): BackupPolicy
    {
        return $this->startApiCall('GetBackupPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns the description of the specified backup vault
     *
     * The async variant is {@see NetAppClient::getBackupVaultAsync()} .
     *
     * @example samples/V1/NetAppClient/get_backup_vault.php
     *
     * @param GetBackupVaultRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BackupVault
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBackupVault(GetBackupVaultRequest $request, array $callOptions = []): BackupVault
    {
        return $this->startApiCall('GetBackupVault', $request, $callOptions)->wait();
    }

    /**
     * Returns the description of the specified KMS config by kms_config_id.
     *
     * The async variant is {@see NetAppClient::getKmsConfigAsync()} .
     *
     * @example samples/V1/NetAppClient/get_kms_config.php
     *
     * @param GetKmsConfigRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return KmsConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getKmsConfig(GetKmsConfigRequest $request, array $callOptions = []): KmsConfig
    {
        return $this->startApiCall('GetKmsConfig', $request, $callOptions)->wait();
    }

    /**
     * Describe a replication for a volume.
     *
     * The async variant is {@see NetAppClient::getReplicationAsync()} .
     *
     * @example samples/V1/NetAppClient/get_replication.php
     *
     * @param GetReplicationRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Replication
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getReplication(GetReplicationRequest $request, array $callOptions = []): Replication
    {
        return $this->startApiCall('GetReplication', $request, $callOptions)->wait();
    }

    /**
     * Describe a snapshot for a volume.
     *
     * The async variant is {@see NetAppClient::getSnapshotAsync()} .
     *
     * @example samples/V1/NetAppClient/get_snapshot.php
     *
     * @param GetSnapshotRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Snapshot
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSnapshot(GetSnapshotRequest $request, array $callOptions = []): Snapshot
    {
        return $this->startApiCall('GetSnapshot', $request, $callOptions)->wait();
    }

    /**
     * Returns the description of the specified storage pool by poolId.
     *
     * The async variant is {@see NetAppClient::getStoragePoolAsync()} .
     *
     * @example samples/V1/NetAppClient/get_storage_pool.php
     *
     * @param GetStoragePoolRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return StoragePool
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getStoragePool(GetStoragePoolRequest $request, array $callOptions = []): StoragePool
    {
        return $this->startApiCall('GetStoragePool', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Volume.
     *
     * The async variant is {@see NetAppClient::getVolumeAsync()} .
     *
     * @example samples/V1/NetAppClient/get_volume.php
     *
     * @param GetVolumeRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Volume
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getVolume(GetVolumeRequest $request, array $callOptions = []): Volume
    {
        return $this->startApiCall('GetVolume', $request, $callOptions)->wait();
    }

    /**
     * Lists active directories.
     *
     * The async variant is {@see NetAppClient::listActiveDirectoriesAsync()} .
     *
     * @example samples/V1/NetAppClient/list_active_directories.php
     *
     * @param ListActiveDirectoriesRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listActiveDirectories(
        ListActiveDirectoriesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListActiveDirectories', $request, $callOptions);
    }

    /**
     * Returns list of all available backup policies.
     *
     * The async variant is {@see NetAppClient::listBackupPoliciesAsync()} .
     *
     * @example samples/V1/NetAppClient/list_backup_policies.php
     *
     * @param ListBackupPoliciesRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackupPolicies(ListBackupPoliciesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBackupPolicies', $request, $callOptions);
    }

    /**
     * Returns list of all available backup vaults.
     *
     * The async variant is {@see NetAppClient::listBackupVaultsAsync()} .
     *
     * @example samples/V1/NetAppClient/list_backup_vaults.php
     *
     * @param ListBackupVaultsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackupVaults(ListBackupVaultsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBackupVaults', $request, $callOptions);
    }

    /**
     * Returns descriptions of all backups for a backupVault.
     *
     * The async variant is {@see NetAppClient::listBackupsAsync()} .
     *
     * @example samples/V1/NetAppClient/list_backups.php
     *
     * @param ListBackupsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackups(ListBackupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBackups', $request, $callOptions);
    }

    /**
     * Returns descriptions of all KMS configs owned by the caller.
     *
     * The async variant is {@see NetAppClient::listKmsConfigsAsync()} .
     *
     * @example samples/V1/NetAppClient/list_kms_configs.php
     *
     * @param ListKmsConfigsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listKmsConfigs(ListKmsConfigsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListKmsConfigs', $request, $callOptions);
    }

    /**
     * Returns descriptions of all replications for a volume.
     *
     * The async variant is {@see NetAppClient::listReplicationsAsync()} .
     *
     * @example samples/V1/NetAppClient/list_replications.php
     *
     * @param ListReplicationsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listReplications(ListReplicationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListReplications', $request, $callOptions);
    }

    /**
     * Returns descriptions of all snapshots for a volume.
     *
     * The async variant is {@see NetAppClient::listSnapshotsAsync()} .
     *
     * @example samples/V1/NetAppClient/list_snapshots.php
     *
     * @param ListSnapshotsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSnapshots(ListSnapshotsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSnapshots', $request, $callOptions);
    }

    /**
     * Returns descriptions of all storage pools owned by the caller.
     *
     * The async variant is {@see NetAppClient::listStoragePoolsAsync()} .
     *
     * @example samples/V1/NetAppClient/list_storage_pools.php
     *
     * @param ListStoragePoolsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listStoragePools(ListStoragePoolsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListStoragePools', $request, $callOptions);
    }

    /**
     * Lists Volumes in a given project.
     *
     * The async variant is {@see NetAppClient::listVolumesAsync()} .
     *
     * @example samples/V1/NetAppClient/list_volumes.php
     *
     * @param ListVolumesRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listVolumes(ListVolumesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListVolumes', $request, $callOptions);
    }

    /**
     * Resume Cross Region Replication.
     *
     * The async variant is {@see NetAppClient::resumeReplicationAsync()} .
     *
     * @example samples/V1/NetAppClient/resume_replication.php
     *
     * @param ResumeReplicationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resumeReplication(ResumeReplicationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ResumeReplication', $request, $callOptions)->wait();
    }

    /**
     * Reverses direction of replication. Source becomes destination and
     * destination becomes source.
     *
     * The async variant is {@see NetAppClient::reverseReplicationDirectionAsync()} .
     *
     * @example samples/V1/NetAppClient/reverse_replication_direction.php
     *
     * @param ReverseReplicationDirectionRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function reverseReplicationDirection(
        ReverseReplicationDirectionRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('ReverseReplicationDirection', $request, $callOptions)->wait();
    }

    /**
     * Revert an existing volume to a specified snapshot.
     * Warning! This operation will permanently revert all changes made after the
     * snapshot was created.
     *
     * The async variant is {@see NetAppClient::revertVolumeAsync()} .
     *
     * @example samples/V1/NetAppClient/revert_volume.php
     *
     * @param RevertVolumeRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function revertVolume(RevertVolumeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RevertVolume', $request, $callOptions)->wait();
    }

    /**
     * Stop Cross Region Replication.
     *
     * The async variant is {@see NetAppClient::stopReplicationAsync()} .
     *
     * @example samples/V1/NetAppClient/stop_replication.php
     *
     * @param StopReplicationRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function stopReplication(StopReplicationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('StopReplication', $request, $callOptions)->wait();
    }

    /**
     * This operation will switch the active/replica zone for a regional
     * storagePool.
     *
     * The async variant is {@see NetAppClient::switchActiveReplicaZoneAsync()} .
     *
     * @example samples/V1/NetAppClient/switch_active_replica_zone.php
     *
     * @param SwitchActiveReplicaZoneRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function switchActiveReplicaZone(
        SwitchActiveReplicaZoneRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('SwitchActiveReplicaZone', $request, $callOptions)->wait();
    }

    /**
     * Syncs the replication. This will invoke one time volume data transfer from
     * source to destination.
     *
     * The async variant is {@see NetAppClient::syncReplicationAsync()} .
     *
     * @example samples/V1/NetAppClient/sync_replication.php
     *
     * @param SyncReplicationRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function syncReplication(SyncReplicationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SyncReplication', $request, $callOptions)->wait();
    }

    /**
     * Update the parameters of an active directories.
     *
     * The async variant is {@see NetAppClient::updateActiveDirectoryAsync()} .
     *
     * @example samples/V1/NetAppClient/update_active_directory.php
     *
     * @param UpdateActiveDirectoryRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateActiveDirectory(
        UpdateActiveDirectoryRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateActiveDirectory', $request, $callOptions)->wait();
    }

    /**
     * Update backup with full spec.
     *
     * The async variant is {@see NetAppClient::updateBackupAsync()} .
     *
     * @example samples/V1/NetAppClient/update_backup.php
     *
     * @param UpdateBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBackup(UpdateBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateBackup', $request, $callOptions)->wait();
    }

    /**
     * Updates settings of a specific backup policy.
     *
     * The async variant is {@see NetAppClient::updateBackupPolicyAsync()} .
     *
     * @example samples/V1/NetAppClient/update_backup_policy.php
     *
     * @param UpdateBackupPolicyRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBackupPolicy(UpdateBackupPolicyRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateBackupPolicy', $request, $callOptions)->wait();
    }

    /**
     * Updates the settings of a specific backup vault.
     *
     * The async variant is {@see NetAppClient::updateBackupVaultAsync()} .
     *
     * @example samples/V1/NetAppClient/update_backup_vault.php
     *
     * @param UpdateBackupVaultRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBackupVault(UpdateBackupVaultRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateBackupVault', $request, $callOptions)->wait();
    }

    /**
     * Updates the Kms config properties with the full spec
     *
     * The async variant is {@see NetAppClient::updateKmsConfigAsync()} .
     *
     * @example samples/V1/NetAppClient/update_kms_config.php
     *
     * @param UpdateKmsConfigRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateKmsConfig(UpdateKmsConfigRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateKmsConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates the settings of a specific replication.
     *
     * The async variant is {@see NetAppClient::updateReplicationAsync()} .
     *
     * @example samples/V1/NetAppClient/update_replication.php
     *
     * @param UpdateReplicationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateReplication(UpdateReplicationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateReplication', $request, $callOptions)->wait();
    }

    /**
     * Updates the settings of a specific snapshot.
     *
     * The async variant is {@see NetAppClient::updateSnapshotAsync()} .
     *
     * @example samples/V1/NetAppClient/update_snapshot.php
     *
     * @param UpdateSnapshotRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSnapshot(UpdateSnapshotRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateSnapshot', $request, $callOptions)->wait();
    }

    /**
     * Updates the storage pool properties with the full spec
     *
     * The async variant is {@see NetAppClient::updateStoragePoolAsync()} .
     *
     * @example samples/V1/NetAppClient/update_storage_pool.php
     *
     * @param UpdateStoragePoolRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateStoragePool(UpdateStoragePoolRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateStoragePool', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Volume.
     *
     * The async variant is {@see NetAppClient::updateVolumeAsync()} .
     *
     * @example samples/V1/NetAppClient/update_volume.php
     *
     * @param UpdateVolumeRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateVolume(UpdateVolumeRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateVolume', $request, $callOptions)->wait();
    }

    /**
     * Verifies KMS config reachability.
     *
     * The async variant is {@see NetAppClient::verifyKmsConfigAsync()} .
     *
     * @example samples/V1/NetAppClient/verify_kms_config.php
     *
     * @param VerifyKmsConfigRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return VerifyKmsConfigResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function verifyKmsConfig(VerifyKmsConfigRequest $request, array $callOptions = []): VerifyKmsConfigResponse
    {
        return $this->startApiCall('VerifyKmsConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see NetAppClient::getLocationAsync()} .
     *
     * @example samples/V1/NetAppClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see NetAppClient::listLocationsAsync()} .
     *
     * @example samples/V1/NetAppClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
