<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/bigtable/admin/v2/bigtable_table_admin.proto

namespace Google\Cloud\Bigtable\Admin\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [google.bigtable.admin.v2.BigtableTableAdmin.CreateTableFromSnapshot][google.bigtable.admin.v2.BigtableTableAdmin.CreateTableFromSnapshot]
 * Note: This is a private alpha release of Cloud Bigtable snapshots. This
 * feature is not currently available to most Cloud Bigtable customers. This
 * feature might be changed in backward-incompatible ways and is not recommended
 * for production use. It is not subject to any SLA or deprecation policy.
 *
 * Generated from protobuf message <code>google.bigtable.admin.v2.CreateTableFromSnapshotRequest</code>
 */
class CreateTableFromSnapshotRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The unique name of the instance in which to create the table.
     * Values are of the form `projects/{project}/instances/{instance}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The name by which the new table should be referred to within the
     * parent instance, e.g., `foobar` rather than `{parent}/tables/foobar`.
     *
     * Generated from protobuf field <code>string table_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $table_id = '';
    /**
     * Required. The unique name of the snapshot from which to restore the table.
     * The snapshot and the table must be in the same instance. Values are of the
     * form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
     *
     * Generated from protobuf field <code>string source_snapshot = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $source_snapshot = '';

    /**
     * @param string $parent         Required. The unique name of the instance in which to create the table.
     *                               Values are of the form `projects/{project}/instances/{instance}`. Please see
     *                               {@see BigtableTableAdminClient::instanceName()} for help formatting this field.
     * @param string $tableId        Required. The name by which the new table should be referred to within the
     *                               parent instance, e.g., `foobar` rather than `{parent}/tables/foobar`.
     * @param string $sourceSnapshot Required. The unique name of the snapshot from which to restore the table.
     *                               The snapshot and the table must be in the same instance. Values are of the
     *                               form
     *                               `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`. Please see
     *                               {@see BigtableTableAdminClient::snapshotName()} for help formatting this field.
     *
     * @return \Google\Cloud\Bigtable\Admin\V2\CreateTableFromSnapshotRequest
     *
     * @experimental
     */
    public static function build(string $parent, string $tableId, string $sourceSnapshot): self
    {
        return (new self())
            ->setParent($parent)
            ->setTableId($tableId)
            ->setSourceSnapshot($sourceSnapshot);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The unique name of the instance in which to create the table.
     *           Values are of the form `projects/{project}/instances/{instance}`.
     *     @type string $table_id
     *           Required. The name by which the new table should be referred to within the
     *           parent instance, e.g., `foobar` rather than `{parent}/tables/foobar`.
     *     @type string $source_snapshot
     *           Required. The unique name of the snapshot from which to restore the table.
     *           The snapshot and the table must be in the same instance. Values are of the
     *           form
     *           `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Bigtable\Admin\V2\BigtableTableAdmin::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The unique name of the instance in which to create the table.
     * Values are of the form `projects/{project}/instances/{instance}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The unique name of the instance in which to create the table.
     * Values are of the form `projects/{project}/instances/{instance}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The name by which the new table should be referred to within the
     * parent instance, e.g., `foobar` rather than `{parent}/tables/foobar`.
     *
     * Generated from protobuf field <code>string table_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTableId()
    {
        return $this->table_id;
    }

    /**
     * Required. The name by which the new table should be referred to within the
     * parent instance, e.g., `foobar` rather than `{parent}/tables/foobar`.
     *
     * Generated from protobuf field <code>string table_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTableId($var)
    {
        GPBUtil::checkString($var, True);
        $this->table_id = $var;

        return $this;
    }

    /**
     * Required. The unique name of the snapshot from which to restore the table.
     * The snapshot and the table must be in the same instance. Values are of the
     * form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
     *
     * Generated from protobuf field <code>string source_snapshot = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSourceSnapshot()
    {
        return $this->source_snapshot;
    }

    /**
     * Required. The unique name of the snapshot from which to restore the table.
     * The snapshot and the table must be in the same instance. Values are of the
     * form
     * `projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}`.
     *
     * Generated from protobuf field <code>string source_snapshot = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSourceSnapshot($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_snapshot = $var;

        return $this;
    }

}

