<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/apihub/v1/runtime_project_attachment_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\ApiHub\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\ApiHub\V1\CreateRuntimeProjectAttachmentRequest;
use Google\Cloud\ApiHub\V1\DeleteRuntimeProjectAttachmentRequest;
use Google\Cloud\ApiHub\V1\GetRuntimeProjectAttachmentRequest;
use Google\Cloud\ApiHub\V1\ListRuntimeProjectAttachmentsRequest;
use Google\Cloud\ApiHub\V1\LookupRuntimeProjectAttachmentRequest;
use Google\Cloud\ApiHub\V1\LookupRuntimeProjectAttachmentResponse;
use Google\Cloud\ApiHub\V1\RuntimeProjectAttachment;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: This service is used for managing the runtime project attachments.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<RuntimeProjectAttachment> createRuntimeProjectAttachmentAsync(CreateRuntimeProjectAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteRuntimeProjectAttachmentAsync(DeleteRuntimeProjectAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RuntimeProjectAttachment> getRuntimeProjectAttachmentAsync(GetRuntimeProjectAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listRuntimeProjectAttachmentsAsync(ListRuntimeProjectAttachmentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<LookupRuntimeProjectAttachmentResponse> lookupRuntimeProjectAttachmentAsync(LookupRuntimeProjectAttachmentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class RuntimeProjectAttachmentServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.apihub.v1.RuntimeProjectAttachmentService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'apihub.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'apihub.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/runtime_project_attachment_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/runtime_project_attachment_service_descriptor_config.php',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
                'useJwtAccessWithScope' => false,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ . '/../resources/runtime_project_attachment_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /** Implements GapicClientTrait::defaultTransport. */
    private static function defaultTransport()
    {
        return 'rest';
    }

    /** Implements ClientOptionsTrait::supportedTransports. */
    private static function supportedTransports()
    {
        return ['rest'];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * runtime_project_attachment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $runtimeProjectAttachment
     *
     * @return string The formatted runtime_project_attachment resource.
     */
    public static function runtimeProjectAttachmentName(
        string $project,
        string $location,
        string $runtimeProjectAttachment
    ): string {
        return self::getPathTemplate('runtimeProjectAttachment')->render([
            'project' => $project,
            'location' => $location,
            'runtime_project_attachment' => $runtimeProjectAttachment,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - location: projects/{project}/locations/{location}
     * - project: projects/{project}
     * - runtimeProjectAttachment: projects/{project}/locations/{location}/runtimeProjectAttachments/{runtime_project_attachment}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'apihub.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. At the moment, supports only
     *           `rest`. *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\RestTransport::build()} method for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Attaches a runtime project to the host project.
     *
     * The async variant is
     * {@see RuntimeProjectAttachmentServiceClient::createRuntimeProjectAttachmentAsync()}
     * .
     *
     * @example samples/V1/RuntimeProjectAttachmentServiceClient/create_runtime_project_attachment.php
     *
     * @param CreateRuntimeProjectAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RuntimeProjectAttachment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRuntimeProjectAttachment(
        CreateRuntimeProjectAttachmentRequest $request,
        array $callOptions = []
    ): RuntimeProjectAttachment {
        return $this->startApiCall('CreateRuntimeProjectAttachment', $request, $callOptions)->wait();
    }

    /**
     * Delete a runtime project attachment in the API Hub. This call will detach
     * the runtime project from the host project.
     *
     * The async variant is
     * {@see RuntimeProjectAttachmentServiceClient::deleteRuntimeProjectAttachmentAsync()}
     * .
     *
     * @example samples/V1/RuntimeProjectAttachmentServiceClient/delete_runtime_project_attachment.php
     *
     * @param DeleteRuntimeProjectAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteRuntimeProjectAttachment(
        DeleteRuntimeProjectAttachmentRequest $request,
        array $callOptions = []
    ): void {
        $this->startApiCall('DeleteRuntimeProjectAttachment', $request, $callOptions)->wait();
    }

    /**
     * Gets a runtime project attachment.
     *
     * The async variant is
     * {@see RuntimeProjectAttachmentServiceClient::getRuntimeProjectAttachmentAsync()}
     * .
     *
     * @example samples/V1/RuntimeProjectAttachmentServiceClient/get_runtime_project_attachment.php
     *
     * @param GetRuntimeProjectAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RuntimeProjectAttachment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRuntimeProjectAttachment(
        GetRuntimeProjectAttachmentRequest $request,
        array $callOptions = []
    ): RuntimeProjectAttachment {
        return $this->startApiCall('GetRuntimeProjectAttachment', $request, $callOptions)->wait();
    }

    /**
     * List runtime projects attached to the host project.
     *
     * The async variant is
     * {@see RuntimeProjectAttachmentServiceClient::listRuntimeProjectAttachmentsAsync()}
     * .
     *
     * @example samples/V1/RuntimeProjectAttachmentServiceClient/list_runtime_project_attachments.php
     *
     * @param ListRuntimeProjectAttachmentsRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRuntimeProjectAttachments(
        ListRuntimeProjectAttachmentsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListRuntimeProjectAttachments', $request, $callOptions);
    }

    /**
     * Look up a runtime project attachment. This API can be called in the context
     * of any project.
     *
     * The async variant is
     * {@see RuntimeProjectAttachmentServiceClient::lookupRuntimeProjectAttachmentAsync()}
     * .
     *
     * @example samples/V1/RuntimeProjectAttachmentServiceClient/lookup_runtime_project_attachment.php
     *
     * @param LookupRuntimeProjectAttachmentRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LookupRuntimeProjectAttachmentResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function lookupRuntimeProjectAttachment(
        LookupRuntimeProjectAttachmentRequest $request,
        array $callOptions = []
    ): LookupRuntimeProjectAttachmentResponse {
        return $this->startApiCall('LookupRuntimeProjectAttachment', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is
     * {@see RuntimeProjectAttachmentServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/RuntimeProjectAttachmentServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is
     * {@see RuntimeProjectAttachmentServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/RuntimeProjectAttachmentServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
