<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents an Instance resource.
 * An instance is a virtual machine that is hosted on Google Cloud Platform. For more information, read Virtual Machine Instances. (== resource_for {$api_version}.instances ==)
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.Instance</code>
 */
class Instance extends \Google\Protobuf\Internal\Message
{
    /**
     * Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding.
     *
     * Generated from protobuf field <code>bool can_ip_forward = 199295868;</code>
     */
    private $can_ip_forward = false;
    /**
     * Generated from protobuf field <code>.google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 222202229;</code>
     */
    private $confidential_instance_config = null;
    /**
     * [Output Only] The CPU platform used by this instance.
     *
     * Generated from protobuf field <code>string cpu_platform = 141849898;</code>
     */
    private $cpu_platform = '';
    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     */
    private $creation_timestamp = '';
    /**
     * Whether the resource should be protected against deletion.
     *
     * Generated from protobuf field <code>bool deletion_protection = 189579242;</code>
     */
    private $deletion_protection = false;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     */
    private $description = '';
    /**
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    private $disks;
    /**
     * Enables display device for the instance.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
     */
    private $display_device = null;
    /**
     * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance.
     * To see the latest fingerprint, make get() request to the instance.
     *
     * Generated from protobuf field <code>string fingerprint = 234678500;</code>
     */
    private $fingerprint = '';
    /**
     * A list of the type and count of accelerator cards attached to the instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 195159663;</code>
     */
    private $guest_accelerators;
    /**
     * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
     *
     * Generated from protobuf field <code>string hostname = 237067315;</code>
     */
    private $hostname = '';
    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     */
    private $id = '';
    /**
     * [Output Only] Type of the resource. Always compute#instance for instances.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     */
    private $kind = '';
    /**
     * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels.
     * To see the latest fingerprint, make get() request to the instance.
     *
     * Generated from protobuf field <code>string label_fingerprint = 178124825;</code>
     */
    private $label_fingerprint = '';
    /**
     * Labels to apply to this instance. These can be later modified by the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 231759871;</code>
     */
    private $labels;
    /**
     * [Output Only] Last start timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string last_start_timestamp = 175395280;</code>
     */
    private $last_start_timestamp = '';
    /**
     * [Output Only] Last stop timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string last_stop_timestamp = 144387554;</code>
     */
    private $last_stop_timestamp = '';
    /**
     * [Output Only] Last suspended timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string last_suspended_timestamp = 87839881;</code>
     */
    private $last_suspended_timestamp = '';
    /**
     * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type:
     * zones/us-central1-f/machineTypes/n1-standard-1
     * To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB):
     * zones/zone/machineTypes/custom-CPUS-MEMORY
     * For example: zones/us-central1-f/machineTypes/custom-4-5120
     * For a full list of restrictions, read the Specifications for custom machine types.
     *
     * Generated from protobuf field <code>string machine_type = 227711026;</code>
     */
    private $machine_type = '';
    /**
     * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    private $metadata = null;
    /**
     * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
     *
     * Generated from protobuf field <code>string min_cpu_platform = 242912759;</code>
     */
    private $min_cpu_platform = '';
    /**
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     */
    private $name = '';
    /**
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
     */
    private $network_interfaces;
    /**
     * The private IPv6 google access type for the VM. If not specified, use  INHERIT_FROM_SUBNETWORK as default.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Instance.PrivateIpv6GoogleAccess private_ipv6_google_access = 48277006;</code>
     */
    private $private_ipv6_google_access = 0;
    /**
     * Specifies the reservations that this instance can consume from.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;</code>
     */
    private $reservation_affinity = null;
    /**
     * Resource policies applied to this instance.
     *
     * Generated from protobuf field <code>repeated string resource_policies = 22220385;</code>
     */
    private $resource_policies;
    /**
     * Sets the scheduling options for this instance.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Scheduling scheduling = 118252948;</code>
     */
    private $scheduling = null;
    /**
     * [Output Only] Server-defined URL for this resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     */
    private $self_link = '';
    /**
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported.
     * Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 9101872;</code>
     */
    private $service_accounts;
    /**
     * Generated from protobuf field <code>.google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;</code>
     */
    private $shielded_instance_config = null;
    /**
     * Generated from protobuf field <code>.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;</code>
     */
    private $shielded_instance_integrity_policy = null;
    /**
     * [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
     *
     * Generated from protobuf field <code>bool start_restricted = 123693144;</code>
     */
    private $start_restricted = false;
    /**
     * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see  Instance life cycle.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Instance.Status status = 181260274;</code>
     */
    private $status = 0;
    /**
     * [Output Only] An optional, human-readable explanation of the status.
     *
     * Generated from protobuf field <code>string status_message = 28992698;</code>
     */
    private $status_message = '';
    /**
     * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    private $tags = null;
    /**
     * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string zone = 3744684;</code>
     */
    private $zone = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $can_ip_forward
     *           Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding.
     *     @type \Google\Cloud\Compute\V1\ConfidentialInstanceConfig $confidential_instance_config
     *     @type string $cpu_platform
     *           [Output Only] The CPU platform used by this instance.
     *     @type string $creation_timestamp
     *           [Output Only] Creation timestamp in RFC3339 text format.
     *     @type bool $deletion_protection
     *           Whether the resource should be protected against deletion.
     *     @type string $description
     *           An optional description of this resource. Provide this property when you create the resource.
     *     @type \Google\Cloud\Compute\V1\AttachedDisk[]|\Google\Protobuf\Internal\RepeatedField $disks
     *           Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     *     @type \Google\Cloud\Compute\V1\DisplayDevice $display_device
     *           Enables display device for the instance.
     *     @type string $fingerprint
     *           Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance.
     *           To see the latest fingerprint, make get() request to the instance.
     *     @type \Google\Cloud\Compute\V1\AcceleratorConfig[]|\Google\Protobuf\Internal\RepeatedField $guest_accelerators
     *           A list of the type and count of accelerator cards attached to the instance.
     *     @type string $hostname
     *           Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
     *     @type string $id
     *           [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *     @type string $kind
     *           [Output Only] Type of the resource. Always compute#instance for instances.
     *     @type string $label_fingerprint
     *           A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels.
     *           To see the latest fingerprint, make get() request to the instance.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels to apply to this instance. These can be later modified by the setLabels method.
     *     @type string $last_start_timestamp
     *           [Output Only] Last start timestamp in RFC3339 text format.
     *     @type string $last_stop_timestamp
     *           [Output Only] Last stop timestamp in RFC3339 text format.
     *     @type string $last_suspended_timestamp
     *           [Output Only] Last suspended timestamp in RFC3339 text format.
     *     @type string $machine_type
     *           Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type:
     *           zones/us-central1-f/machineTypes/n1-standard-1
     *           To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB):
     *           zones/zone/machineTypes/custom-CPUS-MEMORY
     *           For example: zones/us-central1-f/machineTypes/custom-4-5120
     *           For a full list of restrictions, read the Specifications for custom machine types.
     *     @type \Google\Cloud\Compute\V1\Metadata $metadata
     *           The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
     *     @type string $min_cpu_platform
     *           Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
     *     @type string $name
     *           The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *     @type \Google\Cloud\Compute\V1\NetworkInterface[]|\Google\Protobuf\Internal\RepeatedField $network_interfaces
     *           An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     *     @type int $private_ipv6_google_access
     *           The private IPv6 google access type for the VM. If not specified, use  INHERIT_FROM_SUBNETWORK as default.
     *     @type \Google\Cloud\Compute\V1\ReservationAffinity $reservation_affinity
     *           Specifies the reservations that this instance can consume from.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $resource_policies
     *           Resource policies applied to this instance.
     *     @type \Google\Cloud\Compute\V1\Scheduling $scheduling
     *           Sets the scheduling options for this instance.
     *     @type string $self_link
     *           [Output Only] Server-defined URL for this resource.
     *     @type \Google\Cloud\Compute\V1\ServiceAccount[]|\Google\Protobuf\Internal\RepeatedField $service_accounts
     *           A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported.
     *           Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     *     @type \Google\Cloud\Compute\V1\ShieldedInstanceConfig $shielded_instance_config
     *     @type \Google\Cloud\Compute\V1\ShieldedInstanceIntegrityPolicy $shielded_instance_integrity_policy
     *     @type bool $start_restricted
     *           [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
     *     @type int $status
     *           [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see  Instance life cycle.
     *     @type string $status_message
     *           [Output Only] An optional, human-readable explanation of the status.
     *     @type \Google\Cloud\Compute\V1\Tags $tags
     *           Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
     *     @type string $zone
     *           [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding.
     *
     * Generated from protobuf field <code>bool can_ip_forward = 199295868;</code>
     * @return bool
     */
    public function getCanIpForward()
    {
        return $this->can_ip_forward;
    }

    /**
     * Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding.
     *
     * Generated from protobuf field <code>bool can_ip_forward = 199295868;</code>
     * @param bool $var
     * @return $this
     */
    public function setCanIpForward($var)
    {
        GPBUtil::checkBool($var);
        $this->can_ip_forward = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>.google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 222202229;</code>
     * @return \Google\Cloud\Compute\V1\ConfidentialInstanceConfig
     */
    public function getConfidentialInstanceConfig()
    {
        return isset($this->confidential_instance_config) ? $this->confidential_instance_config : null;
    }

    public function hasConfidentialInstanceConfig()
    {
        return isset($this->confidential_instance_config);
    }

    public function clearConfidentialInstanceConfig()
    {
        unset($this->confidential_instance_config);
    }

    /**
     * Generated from protobuf field <code>.google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 222202229;</code>
     * @param \Google\Cloud\Compute\V1\ConfidentialInstanceConfig $var
     * @return $this
     */
    public function setConfidentialInstanceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\ConfidentialInstanceConfig::class);
        $this->confidential_instance_config = $var;

        return $this;
    }

    /**
     * [Output Only] The CPU platform used by this instance.
     *
     * Generated from protobuf field <code>string cpu_platform = 141849898;</code>
     * @return string
     */
    public function getCpuPlatform()
    {
        return $this->cpu_platform;
    }

    /**
     * [Output Only] The CPU platform used by this instance.
     *
     * Generated from protobuf field <code>string cpu_platform = 141849898;</code>
     * @param string $var
     * @return $this
     */
    public function setCpuPlatform($var)
    {
        GPBUtil::checkString($var, True);
        $this->cpu_platform = $var;

        return $this;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return $this->creation_timestamp;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * Whether the resource should be protected against deletion.
     *
     * Generated from protobuf field <code>bool deletion_protection = 189579242;</code>
     * @return bool
     */
    public function getDeletionProtection()
    {
        return $this->deletion_protection;
    }

    /**
     * Whether the resource should be protected against deletion.
     *
     * Generated from protobuf field <code>bool deletion_protection = 189579242;</code>
     * @param bool $var
     * @return $this
     */
    public function setDeletionProtection($var)
    {
        GPBUtil::checkBool($var);
        $this->deletion_protection = $var;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDisks()
    {
        return $this->disks;
    }

    /**
     * Array of disks associated with this instance. Persistent disks must be created before you can assign them.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     * @param \Google\Cloud\Compute\V1\AttachedDisk[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDisks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\AttachedDisk::class);
        $this->disks = $arr;

        return $this;
    }

    /**
     * Enables display device for the instance.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
     * @return \Google\Cloud\Compute\V1\DisplayDevice
     */
    public function getDisplayDevice()
    {
        return isset($this->display_device) ? $this->display_device : null;
    }

    public function hasDisplayDevice()
    {
        return isset($this->display_device);
    }

    public function clearDisplayDevice()
    {
        unset($this->display_device);
    }

    /**
     * Enables display device for the instance.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.DisplayDevice display_device = 258933875;</code>
     * @param \Google\Cloud\Compute\V1\DisplayDevice $var
     * @return $this
     */
    public function setDisplayDevice($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\DisplayDevice::class);
        $this->display_device = $var;

        return $this;
    }

    /**
     * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance.
     * To see the latest fingerprint, make get() request to the instance.
     *
     * Generated from protobuf field <code>string fingerprint = 234678500;</code>
     * @return string
     */
    public function getFingerprint()
    {
        return $this->fingerprint;
    }

    /**
     * Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance.
     * To see the latest fingerprint, make get() request to the instance.
     *
     * Generated from protobuf field <code>string fingerprint = 234678500;</code>
     * @param string $var
     * @return $this
     */
    public function setFingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->fingerprint = $var;

        return $this;
    }

    /**
     * A list of the type and count of accelerator cards attached to the instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 195159663;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGuestAccelerators()
    {
        return $this->guest_accelerators;
    }

    /**
     * A list of the type and count of accelerator cards attached to the instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 195159663;</code>
     * @param \Google\Cloud\Compute\V1\AcceleratorConfig[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGuestAccelerators($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\AcceleratorConfig::class);
        $this->guest_accelerators = $arr;

        return $this;
    }

    /**
     * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
     *
     * Generated from protobuf field <code>string hostname = 237067315;</code>
     * @return string
     */
    public function getHostname()
    {
        return $this->hostname;
    }

    /**
     * Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
     *
     * Generated from protobuf field <code>string hostname = 237067315;</code>
     * @param string $var
     * @return $this
     */
    public function setHostname($var)
    {
        GPBUtil::checkString($var, True);
        $this->hostname = $var;

        return $this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * [Output Only] Type of the resource. Always compute#instance for instances.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * [Output Only] Type of the resource. Always compute#instance for instances.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels.
     * To see the latest fingerprint, make get() request to the instance.
     *
     * Generated from protobuf field <code>string label_fingerprint = 178124825;</code>
     * @return string
     */
    public function getLabelFingerprint()
    {
        return $this->label_fingerprint;
    }

    /**
     * A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels.
     * To see the latest fingerprint, make get() request to the instance.
     *
     * Generated from protobuf field <code>string label_fingerprint = 178124825;</code>
     * @param string $var
     * @return $this
     */
    public function setLabelFingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->label_fingerprint = $var;

        return $this;
    }

    /**
     * Labels to apply to this instance. These can be later modified by the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 231759871;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels to apply to this instance. These can be later modified by the setLabels method.
     *
     * Generated from protobuf field <code>map<string, string> labels = 231759871;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * [Output Only] Last start timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string last_start_timestamp = 175395280;</code>
     * @return string
     */
    public function getLastStartTimestamp()
    {
        return $this->last_start_timestamp;
    }

    /**
     * [Output Only] Last start timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string last_start_timestamp = 175395280;</code>
     * @param string $var
     * @return $this
     */
    public function setLastStartTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_start_timestamp = $var;

        return $this;
    }

    /**
     * [Output Only] Last stop timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string last_stop_timestamp = 144387554;</code>
     * @return string
     */
    public function getLastStopTimestamp()
    {
        return $this->last_stop_timestamp;
    }

    /**
     * [Output Only] Last stop timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string last_stop_timestamp = 144387554;</code>
     * @param string $var
     * @return $this
     */
    public function setLastStopTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_stop_timestamp = $var;

        return $this;
    }

    /**
     * [Output Only] Last suspended timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string last_suspended_timestamp = 87839881;</code>
     * @return string
     */
    public function getLastSuspendedTimestamp()
    {
        return $this->last_suspended_timestamp;
    }

    /**
     * [Output Only] Last suspended timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string last_suspended_timestamp = 87839881;</code>
     * @param string $var
     * @return $this
     */
    public function setLastSuspendedTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_suspended_timestamp = $var;

        return $this;
    }

    /**
     * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type:
     * zones/us-central1-f/machineTypes/n1-standard-1
     * To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB):
     * zones/zone/machineTypes/custom-CPUS-MEMORY
     * For example: zones/us-central1-f/machineTypes/custom-4-5120
     * For a full list of restrictions, read the Specifications for custom machine types.
     *
     * Generated from protobuf field <code>string machine_type = 227711026;</code>
     * @return string
     */
    public function getMachineType()
    {
        return $this->machine_type;
    }

    /**
     * Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type:
     * zones/us-central1-f/machineTypes/n1-standard-1
     * To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB):
     * zones/zone/machineTypes/custom-CPUS-MEMORY
     * For example: zones/us-central1-f/machineTypes/custom-4-5120
     * For a full list of restrictions, read the Specifications for custom machine types.
     *
     * Generated from protobuf field <code>string machine_type = 227711026;</code>
     * @param string $var
     * @return $this
     */
    public function setMachineType($var)
    {
        GPBUtil::checkString($var, True);
        $this->machine_type = $var;

        return $this;
    }

    /**
     * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     * @return \Google\Cloud\Compute\V1\Metadata
     */
    public function getMetadata()
    {
        return isset($this->metadata) ? $this->metadata : null;
    }

    public function hasMetadata()
    {
        return isset($this->metadata);
    }

    public function clearMetadata()
    {
        unset($this->metadata);
    }

    /**
     * The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     * @param \Google\Cloud\Compute\V1\Metadata $var
     * @return $this
     */
    public function setMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\Metadata::class);
        $this->metadata = $var;

        return $this;
    }

    /**
     * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
     *
     * Generated from protobuf field <code>string min_cpu_platform = 242912759;</code>
     * @return string
     */
    public function getMinCpuPlatform()
    {
        return $this->min_cpu_platform;
    }

    /**
     * Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
     *
     * Generated from protobuf field <code>string min_cpu_platform = 242912759;</code>
     * @param string $var
     * @return $this
     */
    public function setMinCpuPlatform($var)
    {
        GPBUtil::checkString($var, True);
        $this->min_cpu_platform = $var;

        return $this;
    }

    /**
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getNetworkInterfaces()
    {
        return $this->network_interfaces;
    }

    /**
     * An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
     * @param \Google\Cloud\Compute\V1\NetworkInterface[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setNetworkInterfaces($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\NetworkInterface::class);
        $this->network_interfaces = $arr;

        return $this;
    }

    /**
     * The private IPv6 google access type for the VM. If not specified, use  INHERIT_FROM_SUBNETWORK as default.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Instance.PrivateIpv6GoogleAccess private_ipv6_google_access = 48277006;</code>
     * @return int
     */
    public function getPrivateIpv6GoogleAccess()
    {
        return $this->private_ipv6_google_access;
    }

    /**
     * The private IPv6 google access type for the VM. If not specified, use  INHERIT_FROM_SUBNETWORK as default.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Instance.PrivateIpv6GoogleAccess private_ipv6_google_access = 48277006;</code>
     * @param int $var
     * @return $this
     */
    public function setPrivateIpv6GoogleAccess($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\Instance\PrivateIpv6GoogleAccess::class);
        $this->private_ipv6_google_access = $var;

        return $this;
    }

    /**
     * Specifies the reservations that this instance can consume from.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;</code>
     * @return \Google\Cloud\Compute\V1\ReservationAffinity
     */
    public function getReservationAffinity()
    {
        return isset($this->reservation_affinity) ? $this->reservation_affinity : null;
    }

    public function hasReservationAffinity()
    {
        return isset($this->reservation_affinity);
    }

    public function clearReservationAffinity()
    {
        unset($this->reservation_affinity);
    }

    /**
     * Specifies the reservations that this instance can consume from.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;</code>
     * @param \Google\Cloud\Compute\V1\ReservationAffinity $var
     * @return $this
     */
    public function setReservationAffinity($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\ReservationAffinity::class);
        $this->reservation_affinity = $var;

        return $this;
    }

    /**
     * Resource policies applied to this instance.
     *
     * Generated from protobuf field <code>repeated string resource_policies = 22220385;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResourcePolicies()
    {
        return $this->resource_policies;
    }

    /**
     * Resource policies applied to this instance.
     *
     * Generated from protobuf field <code>repeated string resource_policies = 22220385;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResourcePolicies($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->resource_policies = $arr;

        return $this;
    }

    /**
     * Sets the scheduling options for this instance.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Scheduling scheduling = 118252948;</code>
     * @return \Google\Cloud\Compute\V1\Scheduling
     */
    public function getScheduling()
    {
        return isset($this->scheduling) ? $this->scheduling : null;
    }

    public function hasScheduling()
    {
        return isset($this->scheduling);
    }

    public function clearScheduling()
    {
        unset($this->scheduling);
    }

    /**
     * Sets the scheduling options for this instance.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Scheduling scheduling = 118252948;</code>
     * @param \Google\Cloud\Compute\V1\Scheduling $var
     * @return $this
     */
    public function setScheduling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\Scheduling::class);
        $this->scheduling = $var;

        return $this;
    }

    /**
     * [Output Only] Server-defined URL for this resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * [Output Only] Server-defined URL for this resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported.
     * Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 9101872;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getServiceAccounts()
    {
        return $this->service_accounts;
    }

    /**
     * A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported.
     * Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 9101872;</code>
     * @param \Google\Cloud\Compute\V1\ServiceAccount[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setServiceAccounts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\ServiceAccount::class);
        $this->service_accounts = $arr;

        return $this;
    }

    /**
     * Generated from protobuf field <code>.google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;</code>
     * @return \Google\Cloud\Compute\V1\ShieldedInstanceConfig
     */
    public function getShieldedInstanceConfig()
    {
        return isset($this->shielded_instance_config) ? $this->shielded_instance_config : null;
    }

    public function hasShieldedInstanceConfig()
    {
        return isset($this->shielded_instance_config);
    }

    public function clearShieldedInstanceConfig()
    {
        unset($this->shielded_instance_config);
    }

    /**
     * Generated from protobuf field <code>.google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;</code>
     * @param \Google\Cloud\Compute\V1\ShieldedInstanceConfig $var
     * @return $this
     */
    public function setShieldedInstanceConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\ShieldedInstanceConfig::class);
        $this->shielded_instance_config = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;</code>
     * @return \Google\Cloud\Compute\V1\ShieldedInstanceIntegrityPolicy
     */
    public function getShieldedInstanceIntegrityPolicy()
    {
        return isset($this->shielded_instance_integrity_policy) ? $this->shielded_instance_integrity_policy : null;
    }

    public function hasShieldedInstanceIntegrityPolicy()
    {
        return isset($this->shielded_instance_integrity_policy);
    }

    public function clearShieldedInstanceIntegrityPolicy()
    {
        unset($this->shielded_instance_integrity_policy);
    }

    /**
     * Generated from protobuf field <code>.google.cloud.compute.v1.ShieldedInstanceIntegrityPolicy shielded_instance_integrity_policy = 163696919;</code>
     * @param \Google\Cloud\Compute\V1\ShieldedInstanceIntegrityPolicy $var
     * @return $this
     */
    public function setShieldedInstanceIntegrityPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\ShieldedInstanceIntegrityPolicy::class);
        $this->shielded_instance_integrity_policy = $var;

        return $this;
    }

    /**
     * [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
     *
     * Generated from protobuf field <code>bool start_restricted = 123693144;</code>
     * @return bool
     */
    public function getStartRestricted()
    {
        return $this->start_restricted;
    }

    /**
     * [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
     *
     * Generated from protobuf field <code>bool start_restricted = 123693144;</code>
     * @param bool $var
     * @return $this
     */
    public function setStartRestricted($var)
    {
        GPBUtil::checkBool($var);
        $this->start_restricted = $var;

        return $this;
    }

    /**
     * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see  Instance life cycle.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Instance.Status status = 181260274;</code>
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see  Instance life cycle.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Instance.Status status = 181260274;</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\Instance\Status::class);
        $this->status = $var;

        return $this;
    }

    /**
     * [Output Only] An optional, human-readable explanation of the status.
     *
     * Generated from protobuf field <code>string status_message = 28992698;</code>
     * @return string
     */
    public function getStatusMessage()
    {
        return $this->status_message;
    }

    /**
     * [Output Only] An optional, human-readable explanation of the status.
     *
     * Generated from protobuf field <code>string status_message = 28992698;</code>
     * @param string $var
     * @return $this
     */
    public function setStatusMessage($var)
    {
        GPBUtil::checkString($var, True);
        $this->status_message = $var;

        return $this;
    }

    /**
     * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Tags tags = 3552281;</code>
     * @return \Google\Cloud\Compute\V1\Tags
     */
    public function getTags()
    {
        return isset($this->tags) ? $this->tags : null;
    }

    public function hasTags()
    {
        return isset($this->tags);
    }

    public function clearTags()
    {
        unset($this->tags);
    }

    /**
     * Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Tags tags = 3552281;</code>
     * @param \Google\Cloud\Compute\V1\Tags $var
     * @return $this
     */
    public function setTags($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\Tags::class);
        $this->tags = $var;

        return $this;
    }

    /**
     * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string zone = 3744684;</code>
     * @return string
     */
    public function getZone()
    {
        return $this->zone;
    }

    /**
     * [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string zone = 3744684;</code>
     * @param string $var
     * @return $this
     */
    public function setZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->zone = $var;

        return $this;
    }

}

