<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
 * This property is mutually exclusive with the source property; you can only define one or the other, but not both.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.AttachedDiskInitializeParams</code>
 */
class AttachedDiskInitializeParams extends \Google\Protobuf\Internal\Message
{
    /**
     * An optional description. Provide this property when creating the disk.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     */
    private $description = '';
    /**
     * Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
     *
     * Generated from protobuf field <code>string disk_name = 92807149;</code>
     */
    private $disk_name = '';
    /**
     * Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
     *
     * Generated from protobuf field <code>string disk_size_gb = 47828279;</code>
     */
    private $disk_size_gb = '';
    /**
     * Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example:
     * https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/pd-standard
     * Other values include pd-ssd and local-ssd. If you define this field, you can provide either the full or partial URL. For example, the following are valid values:
     * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/diskType
     * - projects/project/zones/zone/diskTypes/diskType
     * - zones/zone/diskTypes/diskType  Note that for InstanceTemplate, this is the name of the disk type, not URL.
     *
     * Generated from protobuf field <code>string disk_type = 93009052;</code>
     */
    private $disk_type = '';
    /**
     * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
     *
     * Generated from protobuf field <code>map<string, string> labels = 231759871;</code>
     */
    private $labels;
    /**
     * Specifies which action to take on instance update with this disk. Default is to use the existing disk.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.AttachedDiskInitializeParams.OnUpdateAction on_update_action = 202451980;</code>
     */
    private $on_update_action = 0;
    /**
     * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
     *
     * Generated from protobuf field <code>repeated string resource_policies = 22220385;</code>
     */
    private $resource_policies;
    /**
     * The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD.
     * To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image:
     * projects/debian-cloud/global/images/family/debian-9
     * Alternatively, use a specific version of a public operating system image:
     * projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
     * To create a disk with a custom image that you created, specify the image name in the following format:
     * global/images/my-custom-image
     * You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name:
     * global/images/family/my-image-family
     * If the source image is deleted later, this field will not be set.
     *
     * Generated from protobuf field <code>string source_image = 50443319;</code>
     */
    private $source_image = '';
    /**
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
     * Instance templates do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 113068203;</code>
     */
    private $source_image_encryption_key = null;
    /**
     * The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD.
     * To create a disk with a snapshot that you created, specify the snapshot name in the following format:
     * global/snapshots/my-backup
     * If the source snapshot is deleted later, this field will not be set.
     *
     * Generated from protobuf field <code>string source_snapshot = 126061928;</code>
     */
    private $source_snapshot = '';
    /**
     * The customer-supplied encryption key of the source snapshot.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 35243866;</code>
     */
    private $source_snapshot_encryption_key = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $description
     *           An optional description. Provide this property when creating the disk.
     *     @type string $disk_name
     *           Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
     *     @type string $disk_size_gb
     *           Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
     *     @type string $disk_type
     *           Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example:
     *           https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/pd-standard
     *           Other values include pd-ssd and local-ssd. If you define this field, you can provide either the full or partial URL. For example, the following are valid values:
     *           - https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/diskType
     *           - projects/project/zones/zone/diskTypes/diskType
     *           - zones/zone/diskTypes/diskType  Note that for InstanceTemplate, this is the name of the disk type, not URL.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
     *     @type int $on_update_action
     *           Specifies which action to take on instance update with this disk. Default is to use the existing disk.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $resource_policies
     *           Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
     *     @type string $source_image
     *           The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD.
     *           To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image:
     *           projects/debian-cloud/global/images/family/debian-9
     *           Alternatively, use a specific version of a public operating system image:
     *           projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
     *           To create a disk with a custom image that you created, specify the image name in the following format:
     *           global/images/my-custom-image
     *           You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name:
     *           global/images/family/my-image-family
     *           If the source image is deleted later, this field will not be set.
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $source_image_encryption_key
     *           The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
     *           Instance templates do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
     *     @type string $source_snapshot
     *           The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD.
     *           To create a disk with a snapshot that you created, specify the snapshot name in the following format:
     *           global/snapshots/my-backup
     *           If the source snapshot is deleted later, this field will not be set.
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $source_snapshot_encryption_key
     *           The customer-supplied encryption key of the source snapshot.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * An optional description. Provide this property when creating the disk.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * An optional description. Provide this property when creating the disk.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
     *
     * Generated from protobuf field <code>string disk_name = 92807149;</code>
     * @return string
     */
    public function getDiskName()
    {
        return $this->disk_name;
    }

    /**
     * Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
     *
     * Generated from protobuf field <code>string disk_name = 92807149;</code>
     * @param string $var
     * @return $this
     */
    public function setDiskName($var)
    {
        GPBUtil::checkString($var, True);
        $this->disk_name = $var;

        return $this;
    }

    /**
     * Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
     *
     * Generated from protobuf field <code>string disk_size_gb = 47828279;</code>
     * @return string
     */
    public function getDiskSizeGb()
    {
        return $this->disk_size_gb;
    }

    /**
     * Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
     *
     * Generated from protobuf field <code>string disk_size_gb = 47828279;</code>
     * @param string $var
     * @return $this
     */
    public function setDiskSizeGb($var)
    {
        GPBUtil::checkString($var, True);
        $this->disk_size_gb = $var;

        return $this;
    }

    /**
     * Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example:
     * https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/pd-standard
     * Other values include pd-ssd and local-ssd. If you define this field, you can provide either the full or partial URL. For example, the following are valid values:
     * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/diskType
     * - projects/project/zones/zone/diskTypes/diskType
     * - zones/zone/diskTypes/diskType  Note that for InstanceTemplate, this is the name of the disk type, not URL.
     *
     * Generated from protobuf field <code>string disk_type = 93009052;</code>
     * @return string
     */
    public function getDiskType()
    {
        return $this->disk_type;
    }

    /**
     * Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example:
     * https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/pd-standard
     * Other values include pd-ssd and local-ssd. If you define this field, you can provide either the full or partial URL. For example, the following are valid values:
     * - https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/diskType
     * - projects/project/zones/zone/diskTypes/diskType
     * - zones/zone/diskTypes/diskType  Note that for InstanceTemplate, this is the name of the disk type, not URL.
     *
     * Generated from protobuf field <code>string disk_type = 93009052;</code>
     * @param string $var
     * @return $this
     */
    public function setDiskType($var)
    {
        GPBUtil::checkString($var, True);
        $this->disk_type = $var;

        return $this;
    }

    /**
     * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
     *
     * Generated from protobuf field <code>map<string, string> labels = 231759871;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
     *
     * Generated from protobuf field <code>map<string, string> labels = 231759871;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Specifies which action to take on instance update with this disk. Default is to use the existing disk.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.AttachedDiskInitializeParams.OnUpdateAction on_update_action = 202451980;</code>
     * @return int
     */
    public function getOnUpdateAction()
    {
        return $this->on_update_action;
    }

    /**
     * Specifies which action to take on instance update with this disk. Default is to use the existing disk.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.AttachedDiskInitializeParams.OnUpdateAction on_update_action = 202451980;</code>
     * @param int $var
     * @return $this
     */
    public function setOnUpdateAction($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\AttachedDiskInitializeParams\OnUpdateAction::class);
        $this->on_update_action = $var;

        return $this;
    }

    /**
     * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
     *
     * Generated from protobuf field <code>repeated string resource_policies = 22220385;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResourcePolicies()
    {
        return $this->resource_policies;
    }

    /**
     * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
     *
     * Generated from protobuf field <code>repeated string resource_policies = 22220385;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResourcePolicies($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->resource_policies = $arr;

        return $this;
    }

    /**
     * The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD.
     * To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image:
     * projects/debian-cloud/global/images/family/debian-9
     * Alternatively, use a specific version of a public operating system image:
     * projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
     * To create a disk with a custom image that you created, specify the image name in the following format:
     * global/images/my-custom-image
     * You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name:
     * global/images/family/my-image-family
     * If the source image is deleted later, this field will not be set.
     *
     * Generated from protobuf field <code>string source_image = 50443319;</code>
     * @return string
     */
    public function getSourceImage()
    {
        return $this->source_image;
    }

    /**
     * The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD.
     * To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image:
     * projects/debian-cloud/global/images/family/debian-9
     * Alternatively, use a specific version of a public operating system image:
     * projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
     * To create a disk with a custom image that you created, specify the image name in the following format:
     * global/images/my-custom-image
     * You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name:
     * global/images/family/my-image-family
     * If the source image is deleted later, this field will not be set.
     *
     * Generated from protobuf field <code>string source_image = 50443319;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceImage($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_image = $var;

        return $this;
    }

    /**
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
     * Instance templates do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 113068203;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey
     */
    public function getSourceImageEncryptionKey()
    {
        return isset($this->source_image_encryption_key) ? $this->source_image_encryption_key : null;
    }

    public function hasSourceImageEncryptionKey()
    {
        return isset($this->source_image_encryption_key);
    }

    public function clearSourceImageEncryptionKey()
    {
        unset($this->source_image_encryption_key);
    }

    /**
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
     * Instance templates do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 113068203;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setSourceImageEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->source_image_encryption_key = $var;

        return $this;
    }

    /**
     * The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD.
     * To create a disk with a snapshot that you created, specify the snapshot name in the following format:
     * global/snapshots/my-backup
     * If the source snapshot is deleted later, this field will not be set.
     *
     * Generated from protobuf field <code>string source_snapshot = 126061928;</code>
     * @return string
     */
    public function getSourceSnapshot()
    {
        return $this->source_snapshot;
    }

    /**
     * The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD.
     * To create a disk with a snapshot that you created, specify the snapshot name in the following format:
     * global/snapshots/my-backup
     * If the source snapshot is deleted later, this field will not be set.
     *
     * Generated from protobuf field <code>string source_snapshot = 126061928;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceSnapshot($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_snapshot = $var;

        return $this;
    }

    /**
     * The customer-supplied encryption key of the source snapshot.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 35243866;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey
     */
    public function getSourceSnapshotEncryptionKey()
    {
        return isset($this->source_snapshot_encryption_key) ? $this->source_snapshot_encryption_key : null;
    }

    public function hasSourceSnapshotEncryptionKey()
    {
        return isset($this->source_snapshot_encryption_key);
    }

    public function clearSourceSnapshotEncryptionKey()
    {
        unset($this->source_snapshot_encryption_key);
    }

    /**
     * The customer-supplied encryption key of the source snapshot.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 35243866;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setSourceSnapshotEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->source_snapshot_encryption_key = $var;

        return $this;
    }

}

