<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dialogflow/cx/v3/session.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dialogflow\Cx\V3\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dialogflow\Cx\V3\AnswerFeedback;
use Google\Cloud\Dialogflow\Cx\V3\DetectIntentRequest;
use Google\Cloud\Dialogflow\Cx\V3\DetectIntentResponse;
use Google\Cloud\Dialogflow\Cx\V3\FulfillIntentRequest;
use Google\Cloud\Dialogflow\Cx\V3\FulfillIntentResponse;
use Google\Cloud\Dialogflow\Cx\V3\MatchIntentRequest;
use Google\Cloud\Dialogflow\Cx\V3\MatchIntentResponse;
use Google\Cloud\Dialogflow\Cx\V3\OutputAudioConfig;
use Google\Cloud\Dialogflow\Cx\V3\PBMatch;
use Google\Cloud\Dialogflow\Cx\V3\QueryInput;
use Google\Cloud\Dialogflow\Cx\V3\QueryParameters;
use Google\Cloud\Dialogflow\Cx\V3\StreamingDetectIntentRequest;
use Google\Cloud\Dialogflow\Cx\V3\StreamingDetectIntentResponse;
use Google\Cloud\Dialogflow\Cx\V3\SubmitAnswerFeedbackRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Protobuf\FieldMask;

/**
 * Service Description: A session represents an interaction with a user. You retrieve user input
 * and pass it to the
 * [DetectIntent][google.cloud.dialogflow.cx.v3.Sessions.DetectIntent] method to
 * determine user intent and respond.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $sessionsClient = new SessionsClient();
 * try {
 *     $formattedSession = $sessionsClient->sessionName('[PROJECT]', '[LOCATION]', '[AGENT]', '[SESSION]');
 *     $queryInput = new QueryInput();
 *     $response = $sessionsClient->detectIntent($formattedSession, $queryInput);
 * } finally {
 *     $sessionsClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class SessionsGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.dialogflow.cx.v3.Sessions';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'dialogflow.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/dialogflow',
    ];

    private static $agentNameTemplate;

    private static $dataStoreNameTemplate;

    private static $entityTypeNameTemplate;

    private static $intentNameTemplate;

    private static $pageNameTemplate;

    private static $projectLocationAgentEnvironmentSessionNameTemplate;

    private static $projectLocationAgentEnvironmentSessionEntityTypeNameTemplate;

    private static $projectLocationAgentSessionNameTemplate;

    private static $projectLocationAgentSessionEntityTypeNameTemplate;

    private static $projectLocationCollectionDataStoreNameTemplate;

    private static $projectLocationDataStoreNameTemplate;

    private static $sessionNameTemplate;

    private static $sessionEntityTypeNameTemplate;

    private static $versionNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/sessions_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/sessions_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/sessions_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/sessions_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAgentNameTemplate()
    {
        if (self::$agentNameTemplate == null) {
            self::$agentNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}');
        }

        return self::$agentNameTemplate;
    }

    private static function getDataStoreNameTemplate()
    {
        if (self::$dataStoreNameTemplate == null) {
            self::$dataStoreNameTemplate = new PathTemplate('projects/{project}/locations/{location}/dataStores/{data_store}');
        }

        return self::$dataStoreNameTemplate;
    }

    private static function getEntityTypeNameTemplate()
    {
        if (self::$entityTypeNameTemplate == null) {
            self::$entityTypeNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}/entityTypes/{entity_type}');
        }

        return self::$entityTypeNameTemplate;
    }

    private static function getIntentNameTemplate()
    {
        if (self::$intentNameTemplate == null) {
            self::$intentNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}/intents/{intent}');
        }

        return self::$intentNameTemplate;
    }

    private static function getPageNameTemplate()
    {
        if (self::$pageNameTemplate == null) {
            self::$pageNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/pages/{page}');
        }

        return self::$pageNameTemplate;
    }

    private static function getProjectLocationAgentEnvironmentSessionNameTemplate()
    {
        if (self::$projectLocationAgentEnvironmentSessionNameTemplate == null) {
            self::$projectLocationAgentEnvironmentSessionNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}/environments/{environment}/sessions/{session}');
        }

        return self::$projectLocationAgentEnvironmentSessionNameTemplate;
    }

    private static function getProjectLocationAgentEnvironmentSessionEntityTypeNameTemplate()
    {
        if (self::$projectLocationAgentEnvironmentSessionEntityTypeNameTemplate == null) {
            self::$projectLocationAgentEnvironmentSessionEntityTypeNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}/environments/{environment}/sessions/{session}/entityTypes/{entity_type}');
        }

        return self::$projectLocationAgentEnvironmentSessionEntityTypeNameTemplate;
    }

    private static function getProjectLocationAgentSessionNameTemplate()
    {
        if (self::$projectLocationAgentSessionNameTemplate == null) {
            self::$projectLocationAgentSessionNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}/sessions/{session}');
        }

        return self::$projectLocationAgentSessionNameTemplate;
    }

    private static function getProjectLocationAgentSessionEntityTypeNameTemplate()
    {
        if (self::$projectLocationAgentSessionEntityTypeNameTemplate == null) {
            self::$projectLocationAgentSessionEntityTypeNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}/sessions/{session}/entityTypes/{entity_type}');
        }

        return self::$projectLocationAgentSessionEntityTypeNameTemplate;
    }

    private static function getProjectLocationCollectionDataStoreNameTemplate()
    {
        if (self::$projectLocationCollectionDataStoreNameTemplate == null) {
            self::$projectLocationCollectionDataStoreNameTemplate = new PathTemplate('projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}');
        }

        return self::$projectLocationCollectionDataStoreNameTemplate;
    }

    private static function getProjectLocationDataStoreNameTemplate()
    {
        if (self::$projectLocationDataStoreNameTemplate == null) {
            self::$projectLocationDataStoreNameTemplate = new PathTemplate('projects/{project}/locations/{location}/dataStores/{data_store}');
        }

        return self::$projectLocationDataStoreNameTemplate;
    }

    private static function getSessionNameTemplate()
    {
        if (self::$sessionNameTemplate == null) {
            self::$sessionNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}/sessions/{session}');
        }

        return self::$sessionNameTemplate;
    }

    private static function getSessionEntityTypeNameTemplate()
    {
        if (self::$sessionEntityTypeNameTemplate == null) {
            self::$sessionEntityTypeNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}/sessions/{session}/entityTypes/{entity_type}');
        }

        return self::$sessionEntityTypeNameTemplate;
    }

    private static function getVersionNameTemplate()
    {
        if (self::$versionNameTemplate == null) {
            self::$versionNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/versions/{version}');
        }

        return self::$versionNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'agent' => self::getAgentNameTemplate(),
                'dataStore' => self::getDataStoreNameTemplate(),
                'entityType' => self::getEntityTypeNameTemplate(),
                'intent' => self::getIntentNameTemplate(),
                'page' => self::getPageNameTemplate(),
                'projectLocationAgentEnvironmentSession' => self::getProjectLocationAgentEnvironmentSessionNameTemplate(),
                'projectLocationAgentEnvironmentSessionEntityType' => self::getProjectLocationAgentEnvironmentSessionEntityTypeNameTemplate(),
                'projectLocationAgentSession' => self::getProjectLocationAgentSessionNameTemplate(),
                'projectLocationAgentSessionEntityType' => self::getProjectLocationAgentSessionEntityTypeNameTemplate(),
                'projectLocationCollectionDataStore' => self::getProjectLocationCollectionDataStoreNameTemplate(),
                'projectLocationDataStore' => self::getProjectLocationDataStoreNameTemplate(),
                'session' => self::getSessionNameTemplate(),
                'sessionEntityType' => self::getSessionEntityTypeNameTemplate(),
                'version' => self::getVersionNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a agent
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     *
     * @return string The formatted agent resource.
     */
    public static function agentName($project, $location, $agent)
    {
        return self::getAgentNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a data_store
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     *
     * @return string The formatted data_store resource.
     */
    public static function dataStoreName($project, $location, $dataStore)
    {
        return self::getDataStoreNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entity_type
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $entityType
     *
     * @return string The formatted entity_type resource.
     */
    public static function entityTypeName($project, $location, $agent, $entityType)
    {
        return self::getEntityTypeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a intent
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $intent
     *
     * @return string The formatted intent resource.
     */
    public static function intentName($project, $location, $agent, $intent)
    {
        return self::getIntentNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'intent' => $intent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a page
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $flow
     * @param string $page
     *
     * @return string The formatted page resource.
     */
    public static function pageName($project, $location, $agent, $flow, $page)
    {
        return self::getPageNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'flow' => $flow,
            'page' => $page,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_agent_environment_session resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $environment
     * @param string $session
     *
     * @return string The formatted project_location_agent_environment_session resource.
     */
    public static function projectLocationAgentEnvironmentSessionName($project, $location, $agent, $environment, $session)
    {
        return self::getProjectLocationAgentEnvironmentSessionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'environment' => $environment,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_agent_environment_session_entity_type resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $environment
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted project_location_agent_environment_session_entity_type resource.
     */
    public static function projectLocationAgentEnvironmentSessionEntityTypeName($project, $location, $agent, $environment, $session, $entityType)
    {
        return self::getProjectLocationAgentEnvironmentSessionEntityTypeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'environment' => $environment,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_agent_session resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $session
     *
     * @return string The formatted project_location_agent_session resource.
     */
    public static function projectLocationAgentSessionName($project, $location, $agent, $session)
    {
        return self::getProjectLocationAgentSessionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_agent_session_entity_type resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted project_location_agent_session_entity_type resource.
     */
    public static function projectLocationAgentSessionEntityTypeName($project, $location, $agent, $session, $entityType)
    {
        return self::getProjectLocationAgentSessionEntityTypeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_collection_data_store resource.
     *
     * @param string $project
     * @param string $location
     * @param string $collection
     * @param string $dataStore
     *
     * @return string The formatted project_location_collection_data_store resource.
     */
    public static function projectLocationCollectionDataStoreName($project, $location, $collection, $dataStore)
    {
        return self::getProjectLocationCollectionDataStoreNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'collection' => $collection,
            'data_store' => $dataStore,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_data_store resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataStore
     *
     * @return string The formatted project_location_data_store resource.
     */
    public static function projectLocationDataStoreName($project, $location, $dataStore)
    {
        return self::getProjectLocationDataStoreNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'data_store' => $dataStore,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a session
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $session
     *
     * @return string The formatted session resource.
     */
    public static function sessionName($project, $location, $agent, $session)
    {
        return self::getSessionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * session_entity_type resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $session
     * @param string $entityType
     *
     * @return string The formatted session_entity_type resource.
     */
    public static function sessionEntityTypeName($project, $location, $agent, $session, $entityType)
    {
        return self::getSessionEntityTypeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'session' => $session,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a version
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $flow
     * @param string $version
     *
     * @return string The formatted version resource.
     */
    public static function versionName($project, $location, $agent, $flow, $version)
    {
        return self::getVersionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'flow' => $flow,
            'version' => $version,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - agent: projects/{project}/locations/{location}/agents/{agent}
     * - dataStore: projects/{project}/locations/{location}/dataStores/{data_store}
     * - entityType: projects/{project}/locations/{location}/agents/{agent}/entityTypes/{entity_type}
     * - intent: projects/{project}/locations/{location}/agents/{agent}/intents/{intent}
     * - page: projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/pages/{page}
     * - projectLocationAgentEnvironmentSession: projects/{project}/locations/{location}/agents/{agent}/environments/{environment}/sessions/{session}
     * - projectLocationAgentEnvironmentSessionEntityType: projects/{project}/locations/{location}/agents/{agent}/environments/{environment}/sessions/{session}/entityTypes/{entity_type}
     * - projectLocationAgentSession: projects/{project}/locations/{location}/agents/{agent}/sessions/{session}
     * - projectLocationAgentSessionEntityType: projects/{project}/locations/{location}/agents/{agent}/sessions/{session}/entityTypes/{entity_type}
     * - projectLocationCollectionDataStore: projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}
     * - projectLocationDataStore: projects/{project}/locations/{location}/dataStores/{data_store}
     * - session: projects/{project}/locations/{location}/agents/{agent}/sessions/{session}
     * - sessionEntityType: projects/{project}/locations/{location}/agents/{agent}/sessions/{session}/entityTypes/{entity_type}
     * - version: projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/versions/{version}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dialogflow.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Processes a natural language query and returns structured, actionable data
     * as a result. This method is not idempotent, because it may cause session
     * entity types to be updated, which in turn might affect results of future
     * queries.
     *
     * Note: Always use agent versions for production traffic.
     * See [Versions and
     * environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
     *
     * Sample code:
     * ```
     * $sessionsClient = new SessionsClient();
     * try {
     *     $formattedSession = $sessionsClient->sessionName('[PROJECT]', '[LOCATION]', '[AGENT]', '[SESSION]');
     *     $queryInput = new QueryInput();
     *     $response = $sessionsClient->detectIntent($formattedSession, $queryInput);
     * } finally {
     *     $sessionsClient->close();
     * }
     * ```
     *
     * @param string     $session      Required. The name of the session this query is sent to.
     *                                 Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *                                 ID>/sessions/<Session ID>` or `projects/<Project ID>/locations/<Location
     *                                 ID>/agents/<Agent ID>/environments/<Environment ID>/sessions/<Session ID>`.
     *                                 If `Environment ID` is not specified, we assume default 'draft'
     *                                 environment.
     *                                 It's up to the API caller to choose an appropriate `Session ID`. It can be
     *                                 a random number or some type of session identifiers (preferably hashed).
     *                                 The length of the `Session ID` must not exceed 36 characters.
     *
     *                                 For more information, see the [sessions
     *                                 guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
     *
     *                                 Note: Always use agent versions for production traffic.
     *                                 See [Versions and
     *                                 environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
     * @param QueryInput $queryInput   Required. The input specification.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type QueryParameters $queryParams
     *           The parameters of this query.
     *     @type OutputAudioConfig $outputAudioConfig
     *           Instructs the speech synthesizer how to generate the output audio.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dialogflow\Cx\V3\DetectIntentResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function detectIntent($session, $queryInput, array $optionalArgs = [])
    {
        $request = new DetectIntentRequest();
        $requestParamHeaders = [];
        $request->setSession($session);
        $request->setQueryInput($queryInput);
        $requestParamHeaders['session'] = $session;
        if (isset($optionalArgs['queryParams'])) {
            $request->setQueryParams($optionalArgs['queryParams']);
        }

        if (isset($optionalArgs['outputAudioConfig'])) {
            $request->setOutputAudioConfig($optionalArgs['outputAudioConfig']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DetectIntent', DetectIntentResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Fulfills a matched intent returned by
     * [MatchIntent][google.cloud.dialogflow.cx.v3.Sessions.MatchIntent]. Must be
     * called after
     * [MatchIntent][google.cloud.dialogflow.cx.v3.Sessions.MatchIntent], with
     * input from
     * [MatchIntentResponse][google.cloud.dialogflow.cx.v3.MatchIntentResponse].
     * Otherwise, the behavior is undefined.
     *
     * Sample code:
     * ```
     * $sessionsClient = new SessionsClient();
     * try {
     *     $response = $sessionsClient->fulfillIntent();
     * } finally {
     *     $sessionsClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type MatchIntentRequest $matchIntentRequest
     *           Must be same as the corresponding MatchIntent request, otherwise the
     *           behavior is undefined.
     *     @type PBMatch $match
     *           The matched intent/event to fulfill.
     *     @type OutputAudioConfig $outputAudioConfig
     *           Instructs the speech synthesizer how to generate output audio.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dialogflow\Cx\V3\FulfillIntentResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function fulfillIntent(array $optionalArgs = [])
    {
        $request = new FulfillIntentRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['matchIntentRequest'])) {
            $request->setMatchIntentRequest($optionalArgs['matchIntentRequest']);
        }

        if (isset($optionalArgs['match'])) {
            $request->setMatch($optionalArgs['match']);
        }

        if (isset($optionalArgs['outputAudioConfig'])) {
            $request->setOutputAudioConfig($optionalArgs['outputAudioConfig']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('FulfillIntent', FulfillIntentResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Returns preliminary intent match results, doesn't change the session
     * status.
     *
     * Sample code:
     * ```
     * $sessionsClient = new SessionsClient();
     * try {
     *     $formattedSession = $sessionsClient->sessionName('[PROJECT]', '[LOCATION]', '[AGENT]', '[SESSION]');
     *     $queryInput = new QueryInput();
     *     $response = $sessionsClient->matchIntent($formattedSession, $queryInput);
     * } finally {
     *     $sessionsClient->close();
     * }
     * ```
     *
     * @param string     $session      Required. The name of the session this query is sent to.
     *                                 Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *                                 ID>/sessions/<Session ID>` or `projects/<Project ID>/locations/<Location
     *                                 ID>/agents/<Agent ID>/environments/<Environment ID>/sessions/<Session ID>`.
     *                                 If `Environment ID` is not specified, we assume default 'draft'
     *                                 environment.
     *                                 It's up to the API caller to choose an appropriate `Session ID`. It can be
     *                                 a random number or some type of session identifiers (preferably hashed).
     *                                 The length of the `Session ID` must not exceed 36 characters.
     *
     *                                 For more information, see the [sessions
     *                                 guide](https://cloud.google.com/dialogflow/cx/docs/concept/session).
     * @param QueryInput $queryInput   Required. The input specification.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type QueryParameters $queryParams
     *           The parameters of this query.
     *     @type bool $persistParameterChanges
     *           Persist session parameter changes from `query_params`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dialogflow\Cx\V3\MatchIntentResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function matchIntent($session, $queryInput, array $optionalArgs = [])
    {
        $request = new MatchIntentRequest();
        $requestParamHeaders = [];
        $request->setSession($session);
        $request->setQueryInput($queryInput);
        $requestParamHeaders['session'] = $session;
        if (isset($optionalArgs['queryParams'])) {
            $request->setQueryParams($optionalArgs['queryParams']);
        }

        if (isset($optionalArgs['persistParameterChanges'])) {
            $request->setPersistParameterChanges($optionalArgs['persistParameterChanges']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('MatchIntent', MatchIntentResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Processes a natural language query in audio format in a streaming fashion
     * and returns structured, actionable data as a result. This method is only
     * available via the gRPC API (not REST).
     *
     * Note: Always use agent versions for production traffic.
     * See [Versions and
     * environments](https://cloud.google.com/dialogflow/cx/docs/concept/version).
     *
     * Sample code:
     * ```
     * $sessionsClient = new SessionsClient();
     * try {
     *     $queryInput = new QueryInput();
     *     $request = new StreamingDetectIntentRequest();
     *     $request->setQueryInput($queryInput);
     *     // Write all requests to the server, then read all responses until the
     *     // stream is complete
     *     $requests = [
     *         $request,
     *     ];
     *     $stream = $sessionsClient->streamingDetectIntent();
     *     $stream->writeAll($requests);
     *     foreach ($stream->closeWriteAndReadAll() as $element) {
     *         // doSomethingWith($element);
     *     }
     *     // Alternatively:
     *     // Write requests individually, making read() calls if
     *     // required. Call closeWrite() once writes are complete, and read the
     *     // remaining responses from the server.
     *     $requests = [
     *         $request,
     *     ];
     *     $stream = $sessionsClient->streamingDetectIntent();
     *     foreach ($requests as $request) {
     *         $stream->write($request);
     *         // if required, read a single response from the stream
     *         $element = $stream->read();
     *         // doSomethingWith($element)
     *     }
     *     $stream->closeWrite();
     *     $element = $stream->read();
     *     while (!is_null($element)) {
     *         // doSomethingWith($element)
     *         $element = $stream->read();
     *     }
     * } finally {
     *     $sessionsClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type int $timeoutMillis
     *           Timeout to use for this call.
     * }
     *
     * @return \Google\ApiCore\BidiStream
     *
     * @throws ApiException if the remote call fails
     */
    public function streamingDetectIntent(array $optionalArgs = [])
    {
        return $this->startCall('StreamingDetectIntent', StreamingDetectIntentResponse::class, $optionalArgs, null, Call::BIDI_STREAMING_CALL);
    }

    /**
     * Updates the feedback received from the user for a single turn of the bot
     * response.
     *
     * Sample code:
     * ```
     * $sessionsClient = new SessionsClient();
     * try {
     *     $formattedSession = $sessionsClient->sessionName('[PROJECT]', '[LOCATION]', '[AGENT]', '[SESSION]');
     *     $responseId = 'response_id';
     *     $answerFeedback = new AnswerFeedback();
     *     $response = $sessionsClient->submitAnswerFeedback($formattedSession, $responseId, $answerFeedback);
     * } finally {
     *     $sessionsClient->close();
     * }
     * ```
     *
     * @param string         $session        Required. The name of the session the feedback was sent to.
     * @param string         $responseId     Required. ID of the response to update its feedback. This is the same as
     *                                       DetectIntentResponse.response_id.
     * @param AnswerFeedback $answerFeedback Required. Feedback provided for a bot answer.
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. The mask to control which fields to update. If the mask is not
     *           present, all fields will be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dialogflow\Cx\V3\AnswerFeedback
     *
     * @throws ApiException if the remote call fails
     */
    public function submitAnswerFeedback($session, $responseId, $answerFeedback, array $optionalArgs = [])
    {
        $request = new SubmitAnswerFeedbackRequest();
        $requestParamHeaders = [];
        $request->setSession($session);
        $request->setResponseId($responseId);
        $request->setAnswerFeedback($answerFeedback);
        $requestParamHeaders['session'] = $session;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('SubmitAnswerFeedback', AnswerFeedback::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $sessionsClient = new SessionsClient();
     * try {
     *     $response = $sessionsClient->getLocation();
     * } finally {
     *     $sessionsClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetLocation', Location::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.cloud.location.Locations')->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $sessionsClient = new SessionsClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $sessionsClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $sessionsClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $sessionsClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListLocations', $optionalArgs, ListLocationsResponse::class, $request, 'google.cloud.location.Locations');
    }
}
