<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dialogflow/cx/v3/environment.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dialogflow\Cx\V3\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dialogflow\Cx\V3\CreateEnvironmentRequest;
use Google\Cloud\Dialogflow\Cx\V3\DeleteEnvironmentRequest;
use Google\Cloud\Dialogflow\Cx\V3\DeployFlowMetadata;
use Google\Cloud\Dialogflow\Cx\V3\DeployFlowRequest;
use Google\Cloud\Dialogflow\Cx\V3\DeployFlowResponse;
use Google\Cloud\Dialogflow\Cx\V3\Environment;
use Google\Cloud\Dialogflow\Cx\V3\GetEnvironmentRequest;
use Google\Cloud\Dialogflow\Cx\V3\ListContinuousTestResultsRequest;
use Google\Cloud\Dialogflow\Cx\V3\ListContinuousTestResultsResponse;
use Google\Cloud\Dialogflow\Cx\V3\ListEnvironmentsRequest;
use Google\Cloud\Dialogflow\Cx\V3\ListEnvironmentsResponse;
use Google\Cloud\Dialogflow\Cx\V3\LookupEnvironmentHistoryRequest;
use Google\Cloud\Dialogflow\Cx\V3\LookupEnvironmentHistoryResponse;
use Google\Cloud\Dialogflow\Cx\V3\RunContinuousTestMetadata;
use Google\Cloud\Dialogflow\Cx\V3\RunContinuousTestRequest;
use Google\Cloud\Dialogflow\Cx\V3\RunContinuousTestResponse;
use Google\Cloud\Dialogflow\Cx\V3\UpdateEnvironmentRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;
use Google\Protobuf\Struct;

/**
 * Service Description: Service for managing
 * [Environments][google.cloud.dialogflow.cx.v3.Environment].
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $environmentsClient = new EnvironmentsClient();
 * try {
 *     $formattedParent = $environmentsClient->agentName('[PROJECT]', '[LOCATION]', '[AGENT]');
 *     $environment = new Environment();
 *     $operationResponse = $environmentsClient->createEnvironment($formattedParent, $environment);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $environmentsClient->createEnvironment($formattedParent, $environment);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $environmentsClient->resumeOperation($operationName, 'createEnvironment');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $environmentsClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class EnvironmentsGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.dialogflow.cx.v3.Environments';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'dialogflow.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/dialogflow',
    ];

    private static $agentNameTemplate;

    private static $environmentNameTemplate;

    private static $serviceNameTemplate;

    private static $testCaseNameTemplate;

    private static $versionNameTemplate;

    private static $webhookNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/environments_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/environments_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/environments_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/environments_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAgentNameTemplate()
    {
        if (self::$agentNameTemplate == null) {
            self::$agentNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}');
        }

        return self::$agentNameTemplate;
    }

    private static function getEnvironmentNameTemplate()
    {
        if (self::$environmentNameTemplate == null) {
            self::$environmentNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}/environments/{environment}');
        }

        return self::$environmentNameTemplate;
    }

    private static function getServiceNameTemplate()
    {
        if (self::$serviceNameTemplate == null) {
            self::$serviceNameTemplate = new PathTemplate('projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}');
        }

        return self::$serviceNameTemplate;
    }

    private static function getTestCaseNameTemplate()
    {
        if (self::$testCaseNameTemplate == null) {
            self::$testCaseNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}/testCases/{test_case}');
        }

        return self::$testCaseNameTemplate;
    }

    private static function getVersionNameTemplate()
    {
        if (self::$versionNameTemplate == null) {
            self::$versionNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/versions/{version}');
        }

        return self::$versionNameTemplate;
    }

    private static function getWebhookNameTemplate()
    {
        if (self::$webhookNameTemplate == null) {
            self::$webhookNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agents/{agent}/webhooks/{webhook}');
        }

        return self::$webhookNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'agent' => self::getAgentNameTemplate(),
                'environment' => self::getEnvironmentNameTemplate(),
                'service' => self::getServiceNameTemplate(),
                'testCase' => self::getTestCaseNameTemplate(),
                'version' => self::getVersionNameTemplate(),
                'webhook' => self::getWebhookNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a agent
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     *
     * @return string The formatted agent resource.
     */
    public static function agentName($project, $location, $agent)
    {
        return self::getAgentNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a environment
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $environment
     *
     * @return string The formatted environment resource.
     */
    public static function environmentName($project, $location, $agent, $environment)
    {
        return self::getEnvironmentNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'environment' => $environment,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a service
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $namespace
     * @param string $service
     *
     * @return string The formatted service resource.
     */
    public static function serviceName($project, $location, $namespace, $service)
    {
        return self::getServiceNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'namespace' => $namespace,
            'service' => $service,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a test_case
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $testCase
     *
     * @return string The formatted test_case resource.
     */
    public static function testCaseName($project, $location, $agent, $testCase)
    {
        return self::getTestCaseNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'test_case' => $testCase,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a version
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $flow
     * @param string $version
     *
     * @return string The formatted version resource.
     */
    public static function versionName($project, $location, $agent, $flow, $version)
    {
        return self::getVersionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'flow' => $flow,
            'version' => $version,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a webhook
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $agent
     * @param string $webhook
     *
     * @return string The formatted webhook resource.
     */
    public static function webhookName($project, $location, $agent, $webhook)
    {
        return self::getWebhookNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'agent' => $agent,
            'webhook' => $webhook,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - agent: projects/{project}/locations/{location}/agents/{agent}
     * - environment: projects/{project}/locations/{location}/agents/{agent}/environments/{environment}
     * - service: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}
     * - testCase: projects/{project}/locations/{location}/agents/{agent}/testCases/{test_case}
     * - version: projects/{project}/locations/{location}/agents/{agent}/flows/{flow}/versions/{version}
     * - webhook: projects/{project}/locations/{location}/agents/{agent}/webhooks/{webhook}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dialogflow.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates an [Environment][google.cloud.dialogflow.cx.v3.Environment] in the
     * specified [Agent][google.cloud.dialogflow.cx.v3.Agent].
     *
     * This method is a [long-running
     * operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
     * The returned `Operation` type has the following method-specific fields:
     *
     * - `metadata`: An empty [Struct
     * message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
     * - `response`: [Environment][google.cloud.dialogflow.cx.v3.Environment]
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $formattedParent = $environmentsClient->agentName('[PROJECT]', '[LOCATION]', '[AGENT]');
     *     $environment = new Environment();
     *     $operationResponse = $environmentsClient->createEnvironment($formattedParent, $environment);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $environmentsClient->createEnvironment($formattedParent, $environment);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $environmentsClient->resumeOperation($operationName, 'createEnvironment');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param string      $parent       Required. The [Agent][google.cloud.dialogflow.cx.v3.Agent] to create an
     *                                  [Environment][google.cloud.dialogflow.cx.v3.Environment] for. Format:
     *                                  `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
     * @param Environment $environment  Required. The environment to create.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createEnvironment($parent, $environment, array $optionalArgs = [])
    {
        $request = new CreateEnvironmentRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEnvironment($environment);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateEnvironment', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes the specified
     * [Environment][google.cloud.dialogflow.cx.v3.Environment].
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $formattedName = $environmentsClient->environmentName('[PROJECT]', '[LOCATION]', '[AGENT]', '[ENVIRONMENT]');
     *     $environmentsClient->deleteEnvironment($formattedName);
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the
     *                             [Environment][google.cloud.dialogflow.cx.v3.Environment] to delete. Format:
     *                             `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *                             ID>/environments/<Environment ID>`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteEnvironment($name, array $optionalArgs = [])
    {
        $request = new DeleteEnvironmentRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteEnvironment', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deploys a flow to the specified
     * [Environment][google.cloud.dialogflow.cx.v3.Environment].
     *
     * This method is a [long-running
     * operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
     * The returned `Operation` type has the following method-specific fields:
     *
     * - `metadata`:
     * [DeployFlowMetadata][google.cloud.dialogflow.cx.v3.DeployFlowMetadata]
     * - `response`:
     * [DeployFlowResponse][google.cloud.dialogflow.cx.v3.DeployFlowResponse]
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $formattedEnvironment = $environmentsClient->environmentName('[PROJECT]', '[LOCATION]', '[AGENT]', '[ENVIRONMENT]');
     *     $formattedFlowVersion = $environmentsClient->versionName('[PROJECT]', '[LOCATION]', '[AGENT]', '[FLOW]', '[VERSION]');
     *     $operationResponse = $environmentsClient->deployFlow($formattedEnvironment, $formattedFlowVersion);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $environmentsClient->deployFlow($formattedEnvironment, $formattedFlowVersion);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $environmentsClient->resumeOperation($operationName, 'deployFlow');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param string $environment  Required. The environment to deploy the flow to.
     *                             Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/
     *                             environments/<Environment ID>`.
     * @param string $flowVersion  Required. The flow version to deploy.
     *                             Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/
     *                             flows/<Flow ID>/versions/<Version ID>`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deployFlow($environment, $flowVersion, array $optionalArgs = [])
    {
        $request = new DeployFlowRequest();
        $requestParamHeaders = [];
        $request->setEnvironment($environment);
        $request->setFlowVersion($flowVersion);
        $requestParamHeaders['environment'] = $environment;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeployFlow', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Retrieves the specified
     * [Environment][google.cloud.dialogflow.cx.v3.Environment].
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $formattedName = $environmentsClient->environmentName('[PROJECT]', '[LOCATION]', '[AGENT]', '[ENVIRONMENT]');
     *     $response = $environmentsClient->getEnvironment($formattedName);
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the
     *                             [Environment][google.cloud.dialogflow.cx.v3.Environment]. Format:
     *                             `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *                             ID>/environments/<Environment ID>`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dialogflow\Cx\V3\Environment
     *
     * @throws ApiException if the remote call fails
     */
    public function getEnvironment($name, array $optionalArgs = [])
    {
        $request = new GetEnvironmentRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetEnvironment', Environment::class, $optionalArgs, $request)->wait();
    }

    /**
     * Fetches a list of continuous test results for a given environment.
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $formattedParent = $environmentsClient->environmentName('[PROJECT]', '[LOCATION]', '[AGENT]', '[ENVIRONMENT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $environmentsClient->listContinuousTestResults($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $environmentsClient->listContinuousTestResults($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The environment to list results for.
     *                             Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/
     *                             environments/<Environment ID>`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listContinuousTestResults($parent, array $optionalArgs = [])
    {
        $request = new ListContinuousTestResultsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListContinuousTestResults', $optionalArgs, ListContinuousTestResultsResponse::class, $request);
    }

    /**
     * Returns the list of all environments in the specified
     * [Agent][google.cloud.dialogflow.cx.v3.Agent].
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $formattedParent = $environmentsClient->agentName('[PROJECT]', '[LOCATION]', '[AGENT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $environmentsClient->listEnvironments($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $environmentsClient->listEnvironments($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The [Agent][google.cloud.dialogflow.cx.v3.Agent] to list all
     *                             environments for. Format: `projects/<Project ID>/locations/<Location
     *                             ID>/agents/<Agent ID>`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEnvironments($parent, array $optionalArgs = [])
    {
        $request = new ListEnvironmentsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListEnvironments', $optionalArgs, ListEnvironmentsResponse::class, $request);
    }

    /**
     * Looks up the history of the specified
     * [Environment][google.cloud.dialogflow.cx.v3.Environment].
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $formattedName = $environmentsClient->environmentName('[PROJECT]', '[LOCATION]', '[AGENT]', '[ENVIRONMENT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $environmentsClient->lookupEnvironmentHistory($formattedName);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $environmentsClient->lookupEnvironmentHistory($formattedName);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. Resource name of the environment to look up the history for.
     *                             Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *                             ID>/environments/<Environment ID>`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function lookupEnvironmentHistory($name, array $optionalArgs = [])
    {
        $request = new LookupEnvironmentHistoryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('LookupEnvironmentHistory', $optionalArgs, LookupEnvironmentHistoryResponse::class, $request);
    }

    /**
     * Kicks off a continuous test under the specified
     * [Environment][google.cloud.dialogflow.cx.v3.Environment].
     *
     * This method is a [long-running
     * operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
     * The returned `Operation` type has the following method-specific fields:
     *
     * - `metadata`:
     * [RunContinuousTestMetadata][google.cloud.dialogflow.cx.v3.RunContinuousTestMetadata]
     * - `response`:
     * [RunContinuousTestResponse][google.cloud.dialogflow.cx.v3.RunContinuousTestResponse]
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $formattedEnvironment = $environmentsClient->environmentName('[PROJECT]', '[LOCATION]', '[AGENT]', '[ENVIRONMENT]');
     *     $operationResponse = $environmentsClient->runContinuousTest($formattedEnvironment);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $environmentsClient->runContinuousTest($formattedEnvironment);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $environmentsClient->resumeOperation($operationName, 'runContinuousTest');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param string $environment  Required. Format: `projects/<Project ID>/locations/<Location
     *                             ID>/agents/<Agent ID>/environments/<Environment ID>`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function runContinuousTest($environment, array $optionalArgs = [])
    {
        $request = new RunContinuousTestRequest();
        $requestParamHeaders = [];
        $request->setEnvironment($environment);
        $requestParamHeaders['environment'] = $environment;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('RunContinuousTest', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Updates the specified
     * [Environment][google.cloud.dialogflow.cx.v3.Environment].
     *
     * This method is a [long-running
     * operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
     * The returned `Operation` type has the following method-specific fields:
     *
     * - `metadata`: An empty [Struct
     * message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
     * - `response`: [Environment][google.cloud.dialogflow.cx.v3.Environment]
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $environment = new Environment();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $environmentsClient->updateEnvironment($environment, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $environmentsClient->updateEnvironment($environment, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $environmentsClient->resumeOperation($operationName, 'updateEnvironment');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param Environment $environment  Required. The environment to update.
     * @param FieldMask   $updateMask   Required. The mask to control which fields get updated.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateEnvironment($environment, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateEnvironmentRequest();
        $requestParamHeaders = [];
        $request->setEnvironment($environment);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['environment.name'] = $environment->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UpdateEnvironment', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     $response = $environmentsClient->getLocation();
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetLocation', Location::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.cloud.location.Locations')->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $environmentsClient = new EnvironmentsClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $environmentsClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $environmentsClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $environmentsClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListLocations', $optionalArgs, ListLocationsResponse::class, $request, 'google.cloud.location.Locations');
    }
}
