<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dataplex/v1/data_taxonomy.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dataplex\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dataplex\V1\CreateDataAttributeBindingRequest;
use Google\Cloud\Dataplex\V1\CreateDataAttributeRequest;
use Google\Cloud\Dataplex\V1\CreateDataTaxonomyRequest;
use Google\Cloud\Dataplex\V1\DataAttribute;
use Google\Cloud\Dataplex\V1\DataAttributeBinding;
use Google\Cloud\Dataplex\V1\DataTaxonomy;
use Google\Cloud\Dataplex\V1\DeleteDataAttributeBindingRequest;
use Google\Cloud\Dataplex\V1\DeleteDataAttributeRequest;
use Google\Cloud\Dataplex\V1\DeleteDataTaxonomyRequest;
use Google\Cloud\Dataplex\V1\GetDataAttributeBindingRequest;
use Google\Cloud\Dataplex\V1\GetDataAttributeRequest;
use Google\Cloud\Dataplex\V1\GetDataTaxonomyRequest;
use Google\Cloud\Dataplex\V1\ListDataAttributeBindingsRequest;
use Google\Cloud\Dataplex\V1\ListDataAttributeBindingsResponse;
use Google\Cloud\Dataplex\V1\ListDataAttributesRequest;
use Google\Cloud\Dataplex\V1\ListDataAttributesResponse;
use Google\Cloud\Dataplex\V1\ListDataTaxonomiesRequest;
use Google\Cloud\Dataplex\V1\ListDataTaxonomiesResponse;
use Google\Cloud\Dataplex\V1\UpdateDataAttributeBindingRequest;
use Google\Cloud\Dataplex\V1\UpdateDataAttributeRequest;
use Google\Cloud\Dataplex\V1\UpdateDataTaxonomyRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: DataTaxonomyService enables attribute-based governance. The resources
 * currently offered include DataTaxonomy and DataAttribute.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
 * try {
 *     $formattedParent = $dataTaxonomyServiceClient->dataTaxonomyName('[PROJECT]', '[LOCATION]', '[DATA_TAXONOMY_ID]');
 *     $dataAttributeId = 'data_attribute_id';
 *     $dataAttribute = new DataAttribute();
 *     $operationResponse = $dataTaxonomyServiceClient->createDataAttribute($formattedParent, $dataAttributeId, $dataAttribute);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $dataTaxonomyServiceClient->createDataAttribute($formattedParent, $dataAttributeId, $dataAttribute);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $dataTaxonomyServiceClient->resumeOperation($operationName, 'createDataAttribute');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $dataTaxonomyServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\Dataplex\V1\Client\DataTaxonomyServiceClient} to use the new
 * surface.
 */
class DataTaxonomyServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.dataplex.v1.DataTaxonomyService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'dataplex.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $dataAttributeNameTemplate;

    private static $dataAttributeBindingNameTemplate;

    private static $dataTaxonomyNameTemplate;

    private static $locationNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/data_taxonomy_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/data_taxonomy_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ .
                '/../resources/data_taxonomy_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/data_taxonomy_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getDataAttributeNameTemplate()
    {
        if (self::$dataAttributeNameTemplate == null) {
            self::$dataAttributeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}'
            );
        }

        return self::$dataAttributeNameTemplate;
    }

    private static function getDataAttributeBindingNameTemplate()
    {
        if (self::$dataAttributeBindingNameTemplate == null) {
            self::$dataAttributeBindingNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/dataAttributeBindings/{data_attribute_binding_id}'
            );
        }

        return self::$dataAttributeBindingNameTemplate;
    }

    private static function getDataTaxonomyNameTemplate()
    {
        if (self::$dataTaxonomyNameTemplate == null) {
            self::$dataTaxonomyNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/dataTaxonomies/{data_taxonomy_id}'
            );
        }

        return self::$dataTaxonomyNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'dataAttribute' => self::getDataAttributeNameTemplate(),
                'dataAttributeBinding' => self::getDataAttributeBindingNameTemplate(),
                'dataTaxonomy' => self::getDataTaxonomyNameTemplate(),
                'location' => self::getLocationNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_attribute resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataTaxonomy
     * @param string $dataAttributeId
     *
     * @return string The formatted data_attribute resource.
     */
    public static function dataAttributeName(
        $project,
        $location,
        $dataTaxonomy,
        $dataAttributeId
    ) {
        return self::getDataAttributeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'dataTaxonomy' => $dataTaxonomy,
            'data_attribute_id' => $dataAttributeId,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_attribute_binding resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataAttributeBindingId
     *
     * @return string The formatted data_attribute_binding resource.
     */
    public static function dataAttributeBindingName(
        $project,
        $location,
        $dataAttributeBindingId
    ) {
        return self::getDataAttributeBindingNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'data_attribute_binding_id' => $dataAttributeBindingId,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_taxonomy resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dataTaxonomyId
     *
     * @return string The formatted data_taxonomy resource.
     */
    public static function dataTaxonomyName(
        $project,
        $location,
        $dataTaxonomyId
    ) {
        return self::getDataTaxonomyNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'data_taxonomy_id' => $dataTaxonomyId,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - dataAttribute: projects/{project}/locations/{location}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}
     * - dataAttributeBinding: projects/{project}/locations/{location}/dataAttributeBindings/{data_attribute_binding_id}
     * - dataTaxonomy: projects/{project}/locations/{location}/dataTaxonomies/{data_taxonomy_id}
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dataplex.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Create a DataAttribute resource.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $formattedParent = $dataTaxonomyServiceClient->dataTaxonomyName('[PROJECT]', '[LOCATION]', '[DATA_TAXONOMY_ID]');
     *     $dataAttributeId = 'data_attribute_id';
     *     $dataAttribute = new DataAttribute();
     *     $operationResponse = $dataTaxonomyServiceClient->createDataAttribute($formattedParent, $dataAttributeId, $dataAttribute);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataTaxonomyServiceClient->createDataAttribute($formattedParent, $dataAttributeId, $dataAttribute);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataTaxonomyServiceClient->resumeOperation($operationName, 'createDataAttribute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param string        $parent          Required. The resource name of the parent data taxonomy
     *                                       projects/{project_number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}
     * @param string        $dataAttributeId Required. DataAttribute identifier.
     *                                       * Must contain only lowercase letters, numbers and hyphens.
     *                                       * Must start with a letter.
     *                                       * Must be between 1-63 characters.
     *                                       * Must end with a number or a letter.
     *                                       * Must be unique within the DataTaxonomy.
     * @param DataAttribute $dataAttribute   Required. DataAttribute resource.
     * @param array         $optionalArgs    {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createDataAttribute(
        $parent,
        $dataAttributeId,
        $dataAttribute,
        array $optionalArgs = []
    ) {
        $request = new CreateDataAttributeRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDataAttributeId($dataAttributeId);
        $request->setDataAttribute($dataAttribute);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateDataAttribute',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Create a DataAttributeBinding resource.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $formattedParent = $dataTaxonomyServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $dataAttributeBindingId = 'data_attribute_binding_id';
     *     $dataAttributeBinding = new DataAttributeBinding();
     *     $operationResponse = $dataTaxonomyServiceClient->createDataAttributeBinding($formattedParent, $dataAttributeBindingId, $dataAttributeBinding);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataTaxonomyServiceClient->createDataAttributeBinding($formattedParent, $dataAttributeBindingId, $dataAttributeBinding);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataTaxonomyServiceClient->resumeOperation($operationName, 'createDataAttributeBinding');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param string               $parent                 Required. The resource name of the parent data taxonomy
     *                                                     projects/{project_number}/locations/{location_id}
     * @param string               $dataAttributeBindingId Required. DataAttributeBinding identifier.
     *                                                     * Must contain only lowercase letters, numbers and hyphens.
     *                                                     * Must start with a letter.
     *                                                     * Must be between 1-63 characters.
     *                                                     * Must end with a number or a letter.
     *                                                     * Must be unique within the Location.
     * @param DataAttributeBinding $dataAttributeBinding   Required. DataAttributeBinding resource.
     * @param array                $optionalArgs           {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createDataAttributeBinding(
        $parent,
        $dataAttributeBindingId,
        $dataAttributeBinding,
        array $optionalArgs = []
    ) {
        $request = new CreateDataAttributeBindingRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDataAttributeBindingId($dataAttributeBindingId);
        $request->setDataAttributeBinding($dataAttributeBinding);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateDataAttributeBinding',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Create a DataTaxonomy resource.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $formattedParent = $dataTaxonomyServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $dataTaxonomyId = 'data_taxonomy_id';
     *     $dataTaxonomy = new DataTaxonomy();
     *     $operationResponse = $dataTaxonomyServiceClient->createDataTaxonomy($formattedParent, $dataTaxonomyId, $dataTaxonomy);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataTaxonomyServiceClient->createDataTaxonomy($formattedParent, $dataTaxonomyId, $dataTaxonomy);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataTaxonomyServiceClient->resumeOperation($operationName, 'createDataTaxonomy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param string       $parent         Required. The resource name of the data taxonomy location, of the form:
     *                                     projects/{project_number}/locations/{location_id}
     *                                     where `location_id` refers to a GCP region.
     * @param string       $dataTaxonomyId Required. DataTaxonomy identifier.
     *                                     * Must contain only lowercase letters, numbers and hyphens.
     *                                     * Must start with a letter.
     *                                     * Must be between 1-63 characters.
     *                                     * Must end with a number or a letter.
     *                                     * Must be unique within the Project.
     * @param DataTaxonomy $dataTaxonomy   Required. DataTaxonomy resource.
     * @param array        $optionalArgs   {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createDataTaxonomy(
        $parent,
        $dataTaxonomyId,
        $dataTaxonomy,
        array $optionalArgs = []
    ) {
        $request = new CreateDataTaxonomyRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDataTaxonomyId($dataTaxonomyId);
        $request->setDataTaxonomy($dataTaxonomy);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateDataTaxonomy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a Data Attribute resource.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $formattedName = $dataTaxonomyServiceClient->dataAttributeName('[PROJECT]', '[LOCATION]', '[DATATAXONOMY]', '[DATA_ATTRIBUTE_ID]');
     *     $operationResponse = $dataTaxonomyServiceClient->deleteDataAttribute($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataTaxonomyServiceClient->deleteDataAttribute($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataTaxonomyServiceClient->resumeOperation($operationName, 'deleteDataAttribute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the DataAttribute:
     *                             projects/{project_number}/locations/{location_id}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           Optional. If the client provided etag value does not match the current etag
     *           value, the DeleteDataAttribute method returns an ABORTED error response.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteDataAttribute($name, array $optionalArgs = [])
    {
        $request = new DeleteDataAttributeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteDataAttribute',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a DataAttributeBinding resource. All attributes within the
     * DataAttributeBinding must be deleted before the DataAttributeBinding can be
     * deleted.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $formattedName = $dataTaxonomyServiceClient->dataAttributeBindingName('[PROJECT]', '[LOCATION]', '[DATA_ATTRIBUTE_BINDING_ID]');
     *     $etag = 'etag';
     *     $operationResponse = $dataTaxonomyServiceClient->deleteDataAttributeBinding($formattedName, $etag);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataTaxonomyServiceClient->deleteDataAttributeBinding($formattedName, $etag);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataTaxonomyServiceClient->resumeOperation($operationName, 'deleteDataAttributeBinding');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the DataAttributeBinding:
     *                             projects/{project_number}/locations/{location_id}/dataAttributeBindings/{data_attribute_binding_id}
     * @param string $etag         Required. If the client provided etag value does not match the current etag
     *                             value, the DeleteDataAttributeBindingRequest method returns an ABORTED
     *                             error response. Etags must be used when calling the
     *                             DeleteDataAttributeBinding.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteDataAttributeBinding(
        $name,
        $etag,
        array $optionalArgs = []
    ) {
        $request = new DeleteDataAttributeBindingRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setEtag($etag);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteDataAttributeBinding',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a DataTaxonomy resource. All attributes within the DataTaxonomy
     * must be deleted before the DataTaxonomy can be deleted.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $formattedName = $dataTaxonomyServiceClient->dataTaxonomyName('[PROJECT]', '[LOCATION]', '[DATA_TAXONOMY_ID]');
     *     $operationResponse = $dataTaxonomyServiceClient->deleteDataTaxonomy($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataTaxonomyServiceClient->deleteDataTaxonomy($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataTaxonomyServiceClient->resumeOperation($operationName, 'deleteDataTaxonomy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the DataTaxonomy:
     *                             projects/{project_number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $etag
     *           Optional. If the client provided etag value does not match the current etag
     *           value,the DeleteDataTaxonomy method returns an ABORTED error.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteDataTaxonomy($name, array $optionalArgs = [])
    {
        $request = new DeleteDataTaxonomyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['etag'])) {
            $request->setEtag($optionalArgs['etag']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteDataTaxonomy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Retrieves a Data Attribute resource.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $formattedName = $dataTaxonomyServiceClient->dataAttributeName('[PROJECT]', '[LOCATION]', '[DATATAXONOMY]', '[DATA_ATTRIBUTE_ID]');
     *     $response = $dataTaxonomyServiceClient->getDataAttribute($formattedName);
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the dataAttribute:
     *                             projects/{project_number}/locations/{location_id}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\DataAttribute
     *
     * @throws ApiException if the remote call fails
     */
    public function getDataAttribute($name, array $optionalArgs = [])
    {
        $request = new GetDataAttributeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetDataAttribute',
            DataAttribute::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a DataAttributeBinding resource.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $formattedName = $dataTaxonomyServiceClient->dataAttributeBindingName('[PROJECT]', '[LOCATION]', '[DATA_ATTRIBUTE_BINDING_ID]');
     *     $response = $dataTaxonomyServiceClient->getDataAttributeBinding($formattedName);
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the DataAttributeBinding:
     *                             projects/{project_number}/locations/{location_id}/dataAttributeBindings/{data_attribute_binding_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\DataAttributeBinding
     *
     * @throws ApiException if the remote call fails
     */
    public function getDataAttributeBinding($name, array $optionalArgs = [])
    {
        $request = new GetDataAttributeBindingRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetDataAttributeBinding',
            DataAttributeBinding::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Retrieves a DataTaxonomy resource.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $formattedName = $dataTaxonomyServiceClient->dataTaxonomyName('[PROJECT]', '[LOCATION]', '[DATA_TAXONOMY_ID]');
     *     $response = $dataTaxonomyServiceClient->getDataTaxonomy($formattedName);
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the DataTaxonomy:
     *                             projects/{project_number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dataplex\V1\DataTaxonomy
     *
     * @throws ApiException if the remote call fails
     */
    public function getDataTaxonomy($name, array $optionalArgs = [])
    {
        $request = new GetDataTaxonomyRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetDataTaxonomy',
            DataTaxonomy::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists DataAttributeBinding resources in a project and location.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $formattedParent = $dataTaxonomyServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataTaxonomyServiceClient->listDataAttributeBindings($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataTaxonomyServiceClient->listDataAttributeBindings($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the Location:
     *                             projects/{project_number}/locations/{location_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filter request.
     *           Filter using resource: filter=resource:"resource-name"
     *           Filter using attribute: filter=attributes:"attribute-name"
     *           Filter using attribute in paths list:
     *           filter=paths.attributes:"attribute-name"
     *     @type string $orderBy
     *           Optional. Order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDataAttributeBindings($parent, array $optionalArgs = [])
    {
        $request = new ListDataAttributeBindingsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListDataAttributeBindings',
            $optionalArgs,
            ListDataAttributeBindingsResponse::class,
            $request
        );
    }

    /**
     * Lists Data Attribute resources in a DataTaxonomy.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $formattedParent = $dataTaxonomyServiceClient->dataTaxonomyName('[PROJECT]', '[LOCATION]', '[DATA_TAXONOMY_ID]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataTaxonomyServiceClient->listDataAttributes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataTaxonomyServiceClient->listDataAttributes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the DataTaxonomy:
     *                             projects/{project_number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filter request.
     *     @type string $orderBy
     *           Optional. Order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDataAttributes($parent, array $optionalArgs = [])
    {
        $request = new ListDataAttributesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListDataAttributes',
            $optionalArgs,
            ListDataAttributesResponse::class,
            $request
        );
    }

    /**
     * Lists DataTaxonomy resources in a project and location.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $formattedParent = $dataTaxonomyServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataTaxonomyServiceClient->listDataTaxonomies($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataTaxonomyServiceClient->listDataTaxonomies($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The resource name of the DataTaxonomy location, of the form:
     *                             projects/{project_number}/locations/{location_id}
     *                             where `location_id` refers to a GCP region.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Optional. Filter request.
     *     @type string $orderBy
     *           Optional. Order by fields for the result.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDataTaxonomies($parent, array $optionalArgs = [])
    {
        $request = new ListDataTaxonomiesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListDataTaxonomies',
            $optionalArgs,
            ListDataTaxonomiesResponse::class,
            $request
        );
    }

    /**
     * Updates a DataAttribute resource.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $dataAttribute = new DataAttribute();
     *     $operationResponse = $dataTaxonomyServiceClient->updateDataAttribute($updateMask, $dataAttribute);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataTaxonomyServiceClient->updateDataAttribute($updateMask, $dataAttribute);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataTaxonomyServiceClient->resumeOperation($operationName, 'updateDataAttribute');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask     $updateMask    Required. Mask of fields to update.
     * @param DataAttribute $dataAttribute Required. Only fields specified in `update_mask` are updated.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateDataAttribute(
        $updateMask,
        $dataAttribute,
        array $optionalArgs = []
    ) {
        $request = new UpdateDataAttributeRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setDataAttribute($dataAttribute);
        $requestParamHeaders['data_attribute.name'] = $dataAttribute->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateDataAttribute',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates a DataAttributeBinding resource.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $dataAttributeBinding = new DataAttributeBinding();
     *     $operationResponse = $dataTaxonomyServiceClient->updateDataAttributeBinding($updateMask, $dataAttributeBinding);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataTaxonomyServiceClient->updateDataAttributeBinding($updateMask, $dataAttributeBinding);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataTaxonomyServiceClient->resumeOperation($operationName, 'updateDataAttributeBinding');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask            $updateMask           Required. Mask of fields to update.
     * @param DataAttributeBinding $dataAttributeBinding Required. Only fields specified in `update_mask` are updated.
     * @param array                $optionalArgs         {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateDataAttributeBinding(
        $updateMask,
        $dataAttributeBinding,
        array $optionalArgs = []
    ) {
        $request = new UpdateDataAttributeBindingRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setDataAttributeBinding($dataAttributeBinding);
        $requestParamHeaders[
            'data_attribute_binding.name'
        ] = $dataAttributeBinding->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateDataAttributeBinding',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates a DataTaxonomy resource.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $updateMask = new FieldMask();
     *     $dataTaxonomy = new DataTaxonomy();
     *     $operationResponse = $dataTaxonomyServiceClient->updateDataTaxonomy($updateMask, $dataTaxonomy);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $dataTaxonomyServiceClient->updateDataTaxonomy($updateMask, $dataTaxonomy);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $dataTaxonomyServiceClient->resumeOperation($operationName, 'updateDataTaxonomy');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param FieldMask    $updateMask   Required. Mask of fields to update.
     * @param DataTaxonomy $dataTaxonomy Required. Only fields specified in `update_mask` are updated.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type bool $validateOnly
     *           Optional. Only validate the request, but do not perform mutations.
     *           The default is false.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateDataTaxonomy(
        $updateMask,
        $dataTaxonomy,
        array $optionalArgs = []
    ) {
        $request = new UpdateDataTaxonomyRequest();
        $requestParamHeaders = [];
        $request->setUpdateMask($updateMask);
        $request->setDataTaxonomy($dataTaxonomy);
        $requestParamHeaders['data_taxonomy.name'] = $dataTaxonomy->getName();
        if (isset($optionalArgs['validateOnly'])) {
            $request->setValidateOnly($optionalArgs['validateOnly']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateDataTaxonomy',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $dataTaxonomyServiceClient->getIamPolicy($resource);
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $dataTaxonomyServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $dataTaxonomyServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     $response = $dataTaxonomyServiceClient->getLocation();
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $dataTaxonomyServiceClient = new DataTaxonomyServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataTaxonomyServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataTaxonomyServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataTaxonomyServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }
}
