<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/billing/budgets/v1/budget_model.proto

namespace Google\Cloud\Billing\Budgets\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * NotificationsRule defines notifications that are sent based on budget spend
 * and thresholds.
 *
 * Generated from protobuf message <code>google.cloud.billing.budgets.v1.NotificationsRule</code>
 */
class NotificationsRule extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. The name of the Pub/Sub topic where budget-related messages are
     * published, in the form `projects/{project_id}/topics/{topic_id}`. Updates
     * are sent to the topic at regular intervals; the timing of the updates is
     * not dependent on the [threshold rules](#thresholdrule) you've set.
     * Note that if you want your
     * [Pub/Sub JSON
     * object](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format)
     * to contain data for `alertThresholdExceeded`, you need at least one
     * [alert threshold rule](#thresholdrule). When you set threshold rules, you
     * must also enable at least one of the email notification options, either
     * using the default IAM recipients or Cloud Monitoring email notification
     * channels.
     * To use Pub/Sub topics with budgets, you must do the following:
     * 1. Create the Pub/Sub topic
     * before connecting it to your budget. For guidance, see
     * [Manage programmatic budget alert
     * notifications](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications).
     * 2. Grant the API caller the `pubsub.topics.setIamPolicy` permission on
     * the Pub/Sub topic. If not set, the API call fails with PERMISSION_DENIED.
     * For additional details on Pub/Sub roles and permissions, see
     * [Permissions required for this
     * task](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#permissions_required_for_this_task).
     *
     * Generated from protobuf field <code>string pubsub_topic = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $pubsub_topic = '';
    /**
     * Optional. Required when
     * [NotificationsRule.pubsub_topic][google.cloud.billing.budgets.v1.NotificationsRule.pubsub_topic]
     * is set. The schema version of the notification sent to
     * [NotificationsRule.pubsub_topic][google.cloud.billing.budgets.v1.NotificationsRule.pubsub_topic].
     * Only "1.0" is accepted. It represents the JSON schema as defined in
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format.
     *
     * Generated from protobuf field <code>string schema_version = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $schema_version = '';
    /**
     * Optional. Email targets to send notifications to when a threshold is
     * exceeded. This is in addition to the `DefaultIamRecipients` who receive
     * alert emails based on their billing account IAM role. The value is the full
     * REST resource name of a Cloud Monitoring email notification channel with
     * the form `projects/{project_id}/notificationChannels/{channel_id}`. A
     * maximum of 5 email notifications are allowed.
     * To customize budget alert email recipients with monitoring notification
     * channels, you _must create the monitoring notification channels before
     * you link them to a budget_. For guidance on setting up notification
     * channels to use with budgets, see
     * [Customize budget alert email
     * recipients](https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients).
     * For Cloud Billing budget alerts, you _must use email notification
     * channels_. The other types of notification channels are _not_
     * supported, such as Slack, SMS, or PagerDuty. If you want to
     * [send budget notifications to
     * Slack](https://cloud.google.com/billing/docs/how-to/notify#send_notifications_to_slack),
     * use a pubsubTopic and configure
     * [programmatic
     * notifications](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications).
     *
     * Generated from protobuf field <code>repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $monitoring_notification_channels;
    /**
     * Optional. When set to true, disables default notifications sent when a
     * threshold is exceeded. Default notifications are sent to those with Billing
     * Account Administrator and Billing Account User IAM roles for the target
     * account.
     *
     * Generated from protobuf field <code>bool disable_default_iam_recipients = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $disable_default_iam_recipients = false;
    /**
     * Optional. When set to true, and when the budget has a single project
     * configured, notifications will be sent to project level recipients of that
     * project. This field will be ignored if the budget has multiple or no
     * project configured.
     * Currently, project level recipients are the users with `Owner` role on a
     * cloud project.
     *
     * Generated from protobuf field <code>bool enable_project_level_recipients = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $enable_project_level_recipients = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $pubsub_topic
     *           Optional. The name of the Pub/Sub topic where budget-related messages are
     *           published, in the form `projects/{project_id}/topics/{topic_id}`. Updates
     *           are sent to the topic at regular intervals; the timing of the updates is
     *           not dependent on the [threshold rules](#thresholdrule) you've set.
     *           Note that if you want your
     *           [Pub/Sub JSON
     *           object](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format)
     *           to contain data for `alertThresholdExceeded`, you need at least one
     *           [alert threshold rule](#thresholdrule). When you set threshold rules, you
     *           must also enable at least one of the email notification options, either
     *           using the default IAM recipients or Cloud Monitoring email notification
     *           channels.
     *           To use Pub/Sub topics with budgets, you must do the following:
     *           1. Create the Pub/Sub topic
     *           before connecting it to your budget. For guidance, see
     *           [Manage programmatic budget alert
     *           notifications](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications).
     *           2. Grant the API caller the `pubsub.topics.setIamPolicy` permission on
     *           the Pub/Sub topic. If not set, the API call fails with PERMISSION_DENIED.
     *           For additional details on Pub/Sub roles and permissions, see
     *           [Permissions required for this
     *           task](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#permissions_required_for_this_task).
     *     @type string $schema_version
     *           Optional. Required when
     *           [NotificationsRule.pubsub_topic][google.cloud.billing.budgets.v1.NotificationsRule.pubsub_topic]
     *           is set. The schema version of the notification sent to
     *           [NotificationsRule.pubsub_topic][google.cloud.billing.budgets.v1.NotificationsRule.pubsub_topic].
     *           Only "1.0" is accepted. It represents the JSON schema as defined in
     *           https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $monitoring_notification_channels
     *           Optional. Email targets to send notifications to when a threshold is
     *           exceeded. This is in addition to the `DefaultIamRecipients` who receive
     *           alert emails based on their billing account IAM role. The value is the full
     *           REST resource name of a Cloud Monitoring email notification channel with
     *           the form `projects/{project_id}/notificationChannels/{channel_id}`. A
     *           maximum of 5 email notifications are allowed.
     *           To customize budget alert email recipients with monitoring notification
     *           channels, you _must create the monitoring notification channels before
     *           you link them to a budget_. For guidance on setting up notification
     *           channels to use with budgets, see
     *           [Customize budget alert email
     *           recipients](https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients).
     *           For Cloud Billing budget alerts, you _must use email notification
     *           channels_. The other types of notification channels are _not_
     *           supported, such as Slack, SMS, or PagerDuty. If you want to
     *           [send budget notifications to
     *           Slack](https://cloud.google.com/billing/docs/how-to/notify#send_notifications_to_slack),
     *           use a pubsubTopic and configure
     *           [programmatic
     *           notifications](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications).
     *     @type bool $disable_default_iam_recipients
     *           Optional. When set to true, disables default notifications sent when a
     *           threshold is exceeded. Default notifications are sent to those with Billing
     *           Account Administrator and Billing Account User IAM roles for the target
     *           account.
     *     @type bool $enable_project_level_recipients
     *           Optional. When set to true, and when the budget has a single project
     *           configured, notifications will be sent to project level recipients of that
     *           project. This field will be ignored if the budget has multiple or no
     *           project configured.
     *           Currently, project level recipients are the users with `Owner` role on a
     *           cloud project.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Billing\Budgets\V1\BudgetModel::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. The name of the Pub/Sub topic where budget-related messages are
     * published, in the form `projects/{project_id}/topics/{topic_id}`. Updates
     * are sent to the topic at regular intervals; the timing of the updates is
     * not dependent on the [threshold rules](#thresholdrule) you've set.
     * Note that if you want your
     * [Pub/Sub JSON
     * object](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format)
     * to contain data for `alertThresholdExceeded`, you need at least one
     * [alert threshold rule](#thresholdrule). When you set threshold rules, you
     * must also enable at least one of the email notification options, either
     * using the default IAM recipients or Cloud Monitoring email notification
     * channels.
     * To use Pub/Sub topics with budgets, you must do the following:
     * 1. Create the Pub/Sub topic
     * before connecting it to your budget. For guidance, see
     * [Manage programmatic budget alert
     * notifications](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications).
     * 2. Grant the API caller the `pubsub.topics.setIamPolicy` permission on
     * the Pub/Sub topic. If not set, the API call fails with PERMISSION_DENIED.
     * For additional details on Pub/Sub roles and permissions, see
     * [Permissions required for this
     * task](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#permissions_required_for_this_task).
     *
     * Generated from protobuf field <code>string pubsub_topic = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPubsubTopic()
    {
        return $this->pubsub_topic;
    }

    /**
     * Optional. The name of the Pub/Sub topic where budget-related messages are
     * published, in the form `projects/{project_id}/topics/{topic_id}`. Updates
     * are sent to the topic at regular intervals; the timing of the updates is
     * not dependent on the [threshold rules](#thresholdrule) you've set.
     * Note that if you want your
     * [Pub/Sub JSON
     * object](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format)
     * to contain data for `alertThresholdExceeded`, you need at least one
     * [alert threshold rule](#thresholdrule). When you set threshold rules, you
     * must also enable at least one of the email notification options, either
     * using the default IAM recipients or Cloud Monitoring email notification
     * channels.
     * To use Pub/Sub topics with budgets, you must do the following:
     * 1. Create the Pub/Sub topic
     * before connecting it to your budget. For guidance, see
     * [Manage programmatic budget alert
     * notifications](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications).
     * 2. Grant the API caller the `pubsub.topics.setIamPolicy` permission on
     * the Pub/Sub topic. If not set, the API call fails with PERMISSION_DENIED.
     * For additional details on Pub/Sub roles and permissions, see
     * [Permissions required for this
     * task](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#permissions_required_for_this_task).
     *
     * Generated from protobuf field <code>string pubsub_topic = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPubsubTopic($var)
    {
        GPBUtil::checkString($var, True);
        $this->pubsub_topic = $var;

        return $this;
    }

    /**
     * Optional. Required when
     * [NotificationsRule.pubsub_topic][google.cloud.billing.budgets.v1.NotificationsRule.pubsub_topic]
     * is set. The schema version of the notification sent to
     * [NotificationsRule.pubsub_topic][google.cloud.billing.budgets.v1.NotificationsRule.pubsub_topic].
     * Only "1.0" is accepted. It represents the JSON schema as defined in
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format.
     *
     * Generated from protobuf field <code>string schema_version = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getSchemaVersion()
    {
        return $this->schema_version;
    }

    /**
     * Optional. Required when
     * [NotificationsRule.pubsub_topic][google.cloud.billing.budgets.v1.NotificationsRule.pubsub_topic]
     * is set. The schema version of the notification sent to
     * [NotificationsRule.pubsub_topic][google.cloud.billing.budgets.v1.NotificationsRule.pubsub_topic].
     * Only "1.0" is accepted. It represents the JSON schema as defined in
     * https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications#notification_format.
     *
     * Generated from protobuf field <code>string schema_version = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setSchemaVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->schema_version = $var;

        return $this;
    }

    /**
     * Optional. Email targets to send notifications to when a threshold is
     * exceeded. This is in addition to the `DefaultIamRecipients` who receive
     * alert emails based on their billing account IAM role. The value is the full
     * REST resource name of a Cloud Monitoring email notification channel with
     * the form `projects/{project_id}/notificationChannels/{channel_id}`. A
     * maximum of 5 email notifications are allowed.
     * To customize budget alert email recipients with monitoring notification
     * channels, you _must create the monitoring notification channels before
     * you link them to a budget_. For guidance on setting up notification
     * channels to use with budgets, see
     * [Customize budget alert email
     * recipients](https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients).
     * For Cloud Billing budget alerts, you _must use email notification
     * channels_. The other types of notification channels are _not_
     * supported, such as Slack, SMS, or PagerDuty. If you want to
     * [send budget notifications to
     * Slack](https://cloud.google.com/billing/docs/how-to/notify#send_notifications_to_slack),
     * use a pubsubTopic and configure
     * [programmatic
     * notifications](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications).
     *
     * Generated from protobuf field <code>repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMonitoringNotificationChannels()
    {
        return $this->monitoring_notification_channels;
    }

    /**
     * Optional. Email targets to send notifications to when a threshold is
     * exceeded. This is in addition to the `DefaultIamRecipients` who receive
     * alert emails based on their billing account IAM role. The value is the full
     * REST resource name of a Cloud Monitoring email notification channel with
     * the form `projects/{project_id}/notificationChannels/{channel_id}`. A
     * maximum of 5 email notifications are allowed.
     * To customize budget alert email recipients with monitoring notification
     * channels, you _must create the monitoring notification channels before
     * you link them to a budget_. For guidance on setting up notification
     * channels to use with budgets, see
     * [Customize budget alert email
     * recipients](https://cloud.google.com/billing/docs/how-to/budgets-notification-recipients).
     * For Cloud Billing budget alerts, you _must use email notification
     * channels_. The other types of notification channels are _not_
     * supported, such as Slack, SMS, or PagerDuty. If you want to
     * [send budget notifications to
     * Slack](https://cloud.google.com/billing/docs/how-to/notify#send_notifications_to_slack),
     * use a pubsubTopic and configure
     * [programmatic
     * notifications](https://cloud.google.com/billing/docs/how-to/budgets-programmatic-notifications).
     *
     * Generated from protobuf field <code>repeated string monitoring_notification_channels = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMonitoringNotificationChannels($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->monitoring_notification_channels = $arr;

        return $this;
    }

    /**
     * Optional. When set to true, disables default notifications sent when a
     * threshold is exceeded. Default notifications are sent to those with Billing
     * Account Administrator and Billing Account User IAM roles for the target
     * account.
     *
     * Generated from protobuf field <code>bool disable_default_iam_recipients = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getDisableDefaultIamRecipients()
    {
        return $this->disable_default_iam_recipients;
    }

    /**
     * Optional. When set to true, disables default notifications sent when a
     * threshold is exceeded. Default notifications are sent to those with Billing
     * Account Administrator and Billing Account User IAM roles for the target
     * account.
     *
     * Generated from protobuf field <code>bool disable_default_iam_recipients = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setDisableDefaultIamRecipients($var)
    {
        GPBUtil::checkBool($var);
        $this->disable_default_iam_recipients = $var;

        return $this;
    }

    /**
     * Optional. When set to true, and when the budget has a single project
     * configured, notifications will be sent to project level recipients of that
     * project. This field will be ignored if the budget has multiple or no
     * project configured.
     * Currently, project level recipients are the users with `Owner` role on a
     * cloud project.
     *
     * Generated from protobuf field <code>bool enable_project_level_recipients = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnableProjectLevelRecipients()
    {
        return $this->enable_project_level_recipients;
    }

    /**
     * Optional. When set to true, and when the budget has a single project
     * configured, notifications will be sent to project level recipients of that
     * project. This field will be ignored if the budget has multiple or no
     * project configured.
     * Currently, project level recipients are the users with `Owner` role on a
     * cloud project.
     *
     * Generated from protobuf field <code>bool enable_project_level_recipients = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableProjectLevelRecipients($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_project_level_recipients = $var;

        return $this;
    }

}

