<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/tasks/v2beta2/queue.proto

namespace Google\Cloud\Tasks\V2beta2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A queue is a container of related tasks. Queues are configured to manage
 * how those tasks are dispatched. Configurable properties include rate limits,
 * retry options, target types, and others.
 *
 * Generated from protobuf message <code>google.cloud.tasks.v2beta2.Queue</code>
 */
class Queue extends \Google\Protobuf\Internal\Message
{
    /**
     * Caller-specified and required in
     * [CreateQueue][google.cloud.tasks.v2beta2.CloudTasks.CreateQueue], after
     * which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
     * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
     * because they both control task attempts however they control how tasks are
     * attempted in different ways:
     * * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
     * total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     * what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     *   task retries (the second attempt, third attempt, etc).
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.RateLimits rate_limits = 5;</code>
     */
    private $rate_limits = null;
    /**
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.RetryConfig retry_config = 6;</code>
     */
    private $retry_config = null;
    /**
     * Output only. The state of the queue.
     * `state` can only be changed by called
     * [PauseQueue][google.cloud.tasks.v2beta2.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta2.CloudTasks.ResumeQueue], or
     * uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta2.CloudTasks.UpdateQueue] cannot be
     * used to change `state`.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.Queue.State state = 7;</code>
     */
    private $state = 0;
    /**
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
     * before this time were purged.
     * A queue can be purged using
     * [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
     * Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp purge_time = 8;</code>
     */
    private $purge_time = null;
    /**
     * The maximum amount of time that a task will be retained in
     * this queue.
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     *
     * Generated from protobuf field <code>.google.protobuf.Duration task_ttl = 9;</code>
     */
    private $task_ttl = null;
    /**
     * The task tombstone time to live (TTL).
     * After a task is deleted or completed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration tombstone_ttl = 10;</code>
     */
    private $tombstone_ttl = null;
    /**
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.QueueStats stats = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $stats = null;
    protected $target_type;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Caller-specified and required in
     *           [CreateQueue][google.cloud.tasks.v2beta2.CloudTasks.CreateQueue], after
     *           which it becomes output only.
     *           The queue name.
     *           The queue name must have the following format:
     *           `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     *           * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *              hyphens (-), colons (:), or periods (.).
     *              For more information, see
     *              [Identifying
     *              projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     *           * `LOCATION_ID` is the canonical ID for the queue's location.
     *              The list of available locations can be obtained by calling
     *              [ListLocations][google.cloud.location.Locations.ListLocations].
     *              For more information, see https://cloud.google.com/about/locations/.
     *           * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *             hyphens (-). The maximum length is 100 characters.
     *     @type \Google\Cloud\Tasks\V2beta2\AppEngineHttpTarget $app_engine_http_target
     *           App Engine HTTP target.
     *           An App Engine queue is a queue that has an
     *           [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget].
     *     @type \Google\Cloud\Tasks\V2beta2\PullTarget $pull_target
     *           Pull target.
     *           A pull queue is a queue that has a
     *           [PullTarget][google.cloud.tasks.v2beta2.PullTarget].
     *     @type \Google\Cloud\Tasks\V2beta2\HttpTarget $http_target
     *           An http_target is used to override the target values for HTTP tasks.
     *     @type \Google\Cloud\Tasks\V2beta2\RateLimits $rate_limits
     *           Rate limits for task dispatches.
     *           [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
     *           [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
     *           because they both control task attempts however they control how tasks are
     *           attempted in different ways:
     *           * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
     *           total rate of
     *             dispatches from a queue (i.e. all traffic dispatched from the
     *             queue, regardless of whether the dispatch is from a first
     *             attempt or a retry).
     *           * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     *           what happens to
     *             particular a task after its first attempt fails. That is,
     *             [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     *             task retries (the second attempt, third attempt, etc).
     *     @type \Google\Cloud\Tasks\V2beta2\RetryConfig $retry_config
     *           Settings that determine the retry behavior.
     *           * For tasks created using Cloud Tasks: the queue-level retry settings
     *             apply to all tasks in the queue that were created using Cloud Tasks.
     *             Retry settings cannot be set on individual tasks.
     *           * For tasks created using the App Engine SDK: the queue-level retry
     *             settings apply to all tasks in the queue which do not have retry settings
     *             explicitly set on the task and were created by the App Engine SDK. See
     *             [App Engine
     *             documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     *     @type int $state
     *           Output only. The state of the queue.
     *           `state` can only be changed by called
     *           [PauseQueue][google.cloud.tasks.v2beta2.CloudTasks.PauseQueue],
     *           [ResumeQueue][google.cloud.tasks.v2beta2.CloudTasks.ResumeQueue], or
     *           uploading
     *           [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     *           [UpdateQueue][google.cloud.tasks.v2beta2.CloudTasks.UpdateQueue] cannot be
     *           used to change `state`.
     *     @type \Google\Protobuf\Timestamp $purge_time
     *           Output only. The last time this queue was purged.
     *           All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
     *           before this time were purged.
     *           A queue can be purged using
     *           [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
     *           Engine Task Queue SDK, or the Cloud
     *           Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     *           Purge time will be truncated to the nearest microsecond. Purge
     *           time will be unset if the queue has never been purged.
     *     @type \Google\Protobuf\Duration $task_ttl
     *           The maximum amount of time that a task will be retained in
     *           this queue.
     *           Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     *           After a task has lived for `task_ttl`, the task will be deleted
     *           regardless of whether it was dispatched or not.
     *           The `task_ttl` for queues created via queue.yaml/xml is equal to the
     *           maximum duration because there is a
     *           [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     *           these queues. To view the maximum valid duration, see the documentation for
     *           [Duration][google.protobuf.Duration].
     *     @type \Google\Protobuf\Duration $tombstone_ttl
     *           The task tombstone time to live (TTL).
     *           After a task is deleted or completed, the task's tombstone is
     *           retained for the length of time specified by `tombstone_ttl`.
     *           The tombstone is used by task de-duplication; another task with the same
     *           name can't be created until the tombstone has expired. For more information
     *           about task de-duplication, see the documentation for
     *           [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
     *           Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     *     @type \Google\Cloud\Tasks\V2beta2\QueueStats $stats
     *           Output only. The realtime, informational statistics for a queue. In order
     *           to receive the statistics the caller should include this field in the
     *           FieldMask.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Tasks\V2Beta2\Queue::initOnce();
        parent::__construct($data);
    }

    /**
     * Caller-specified and required in
     * [CreateQueue][google.cloud.tasks.v2beta2.CloudTasks.CreateQueue], after
     * which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Caller-specified and required in
     * [CreateQueue][google.cloud.tasks.v2beta2.CloudTasks.CreateQueue], after
     * which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * App Engine HTTP target.
     * An App Engine queue is a queue that has an
     * [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget].
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.AppEngineHttpTarget app_engine_http_target = 3;</code>
     * @return \Google\Cloud\Tasks\V2beta2\AppEngineHttpTarget|null
     */
    public function getAppEngineHttpTarget()
    {
        return $this->readOneof(3);
    }

    public function hasAppEngineHttpTarget()
    {
        return $this->hasOneof(3);
    }

    /**
     * App Engine HTTP target.
     * An App Engine queue is a queue that has an
     * [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget].
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.AppEngineHttpTarget app_engine_http_target = 3;</code>
     * @param \Google\Cloud\Tasks\V2beta2\AppEngineHttpTarget $var
     * @return $this
     */
    public function setAppEngineHttpTarget($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta2\AppEngineHttpTarget::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Pull target.
     * A pull queue is a queue that has a
     * [PullTarget][google.cloud.tasks.v2beta2.PullTarget].
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.PullTarget pull_target = 4;</code>
     * @return \Google\Cloud\Tasks\V2beta2\PullTarget|null
     */
    public function getPullTarget()
    {
        return $this->readOneof(4);
    }

    public function hasPullTarget()
    {
        return $this->hasOneof(4);
    }

    /**
     * Pull target.
     * A pull queue is a queue that has a
     * [PullTarget][google.cloud.tasks.v2beta2.PullTarget].
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.PullTarget pull_target = 4;</code>
     * @param \Google\Cloud\Tasks\V2beta2\PullTarget $var
     * @return $this
     */
    public function setPullTarget($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta2\PullTarget::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * An http_target is used to override the target values for HTTP tasks.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.HttpTarget http_target = 17;</code>
     * @return \Google\Cloud\Tasks\V2beta2\HttpTarget|null
     */
    public function getHttpTarget()
    {
        return $this->readOneof(17);
    }

    public function hasHttpTarget()
    {
        return $this->hasOneof(17);
    }

    /**
     * An http_target is used to override the target values for HTTP tasks.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.HttpTarget http_target = 17;</code>
     * @param \Google\Cloud\Tasks\V2beta2\HttpTarget $var
     * @return $this
     */
    public function setHttpTarget($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta2\HttpTarget::class);
        $this->writeOneof(17, $var);

        return $this;
    }

    /**
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
     * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
     * because they both control task attempts however they control how tasks are
     * attempted in different ways:
     * * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
     * total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     * what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     *   task retries (the second attempt, third attempt, etc).
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.RateLimits rate_limits = 5;</code>
     * @return \Google\Cloud\Tasks\V2beta2\RateLimits|null
     */
    public function getRateLimits()
    {
        return $this->rate_limits;
    }

    public function hasRateLimits()
    {
        return isset($this->rate_limits);
    }

    public function clearRateLimits()
    {
        unset($this->rate_limits);
    }

    /**
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
     * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
     * because they both control task attempts however they control how tasks are
     * attempted in different ways:
     * * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
     * total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     * what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     *   task retries (the second attempt, third attempt, etc).
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.RateLimits rate_limits = 5;</code>
     * @param \Google\Cloud\Tasks\V2beta2\RateLimits $var
     * @return $this
     */
    public function setRateLimits($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta2\RateLimits::class);
        $this->rate_limits = $var;

        return $this;
    }

    /**
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.RetryConfig retry_config = 6;</code>
     * @return \Google\Cloud\Tasks\V2beta2\RetryConfig|null
     */
    public function getRetryConfig()
    {
        return $this->retry_config;
    }

    public function hasRetryConfig()
    {
        return isset($this->retry_config);
    }

    public function clearRetryConfig()
    {
        unset($this->retry_config);
    }

    /**
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.RetryConfig retry_config = 6;</code>
     * @param \Google\Cloud\Tasks\V2beta2\RetryConfig $var
     * @return $this
     */
    public function setRetryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta2\RetryConfig::class);
        $this->retry_config = $var;

        return $this;
    }

    /**
     * Output only. The state of the queue.
     * `state` can only be changed by called
     * [PauseQueue][google.cloud.tasks.v2beta2.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta2.CloudTasks.ResumeQueue], or
     * uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta2.CloudTasks.UpdateQueue] cannot be
     * used to change `state`.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.Queue.State state = 7;</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The state of the queue.
     * `state` can only be changed by called
     * [PauseQueue][google.cloud.tasks.v2beta2.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta2.CloudTasks.ResumeQueue], or
     * uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta2.CloudTasks.UpdateQueue] cannot be
     * used to change `state`.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.Queue.State state = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Tasks\V2beta2\Queue\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
     * before this time were purged.
     * A queue can be purged using
     * [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
     * Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp purge_time = 8;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getPurgeTime()
    {
        return $this->purge_time;
    }

    public function hasPurgeTime()
    {
        return isset($this->purge_time);
    }

    public function clearPurgeTime()
    {
        unset($this->purge_time);
    }

    /**
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
     * before this time were purged.
     * A queue can be purged using
     * [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
     * Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp purge_time = 8;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setPurgeTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->purge_time = $var;

        return $this;
    }

    /**
     * The maximum amount of time that a task will be retained in
     * this queue.
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     *
     * Generated from protobuf field <code>.google.protobuf.Duration task_ttl = 9;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTaskTtl()
    {
        return $this->task_ttl;
    }

    public function hasTaskTtl()
    {
        return isset($this->task_ttl);
    }

    public function clearTaskTtl()
    {
        unset($this->task_ttl);
    }

    /**
     * The maximum amount of time that a task will be retained in
     * this queue.
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     *
     * Generated from protobuf field <code>.google.protobuf.Duration task_ttl = 9;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTaskTtl($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->task_ttl = $var;

        return $this;
    }

    /**
     * The task tombstone time to live (TTL).
     * After a task is deleted or completed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration tombstone_ttl = 10;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTombstoneTtl()
    {
        return $this->tombstone_ttl;
    }

    public function hasTombstoneTtl()
    {
        return isset($this->tombstone_ttl);
    }

    public function clearTombstoneTtl()
    {
        unset($this->tombstone_ttl);
    }

    /**
     * The task tombstone time to live (TTL).
     * After a task is deleted or completed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration tombstone_ttl = 10;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTombstoneTtl($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->tombstone_ttl = $var;

        return $this;
    }

    /**
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.QueueStats stats = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Tasks\V2beta2\QueueStats|null
     */
    public function getStats()
    {
        return $this->stats;
    }

    public function hasStats()
    {
        return isset($this->stats);
    }

    public function clearStats()
    {
        unset($this->stats);
    }

    /**
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     *
     * Generated from protobuf field <code>.google.cloud.tasks.v2beta2.QueueStats stats = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Tasks\V2beta2\QueueStats $var
     * @return $this
     */
    public function setStats($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Tasks\V2beta2\QueueStats::class);
        $this->stats = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTargetType()
    {
        return $this->whichOneof("target_type");
    }

}

