<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: grafeas/v1/vulnerability.proto

namespace Grafeas\V1\VulnerabilityOccurrence;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A detail for a distro and package this vulnerability occurrence was found
 * in and its associated fix (if one is available).
 *
 * Generated from protobuf message <code>grafeas.v1.VulnerabilityOccurrence.PackageIssue</code>
 */
class PackageIssue extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The [CPE URI](https://cpe.mitre.org/specification/) this
     * vulnerability was found in.
     *
     * Generated from protobuf field <code>string affected_cpe_uri = 1;</code>
     */
    private $affected_cpe_uri = '';
    /**
     * Required. The package this vulnerability was found in.
     *
     * Generated from protobuf field <code>string affected_package = 2;</code>
     */
    private $affected_package = '';
    /**
     * Required. The version of the package that is installed on the resource
     * affected by this vulnerability.
     *
     * Generated from protobuf field <code>.grafeas.v1.Version affected_version = 3;</code>
     */
    private $affected_version = null;
    /**
     * The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability
     * was fixed in. It is possible for this to be different from the
     * affected_cpe_uri.
     *
     * Generated from protobuf field <code>string fixed_cpe_uri = 4;</code>
     */
    private $fixed_cpe_uri = '';
    /**
     * The package this vulnerability was fixed in. It is possible for this to
     * be different from the affected_package.
     *
     * Generated from protobuf field <code>string fixed_package = 5;</code>
     */
    private $fixed_package = '';
    /**
     * Required. The version of the package this vulnerability was fixed in.
     * Setting this to VersionKind.MAXIMUM means no fix is yet available.
     *
     * Generated from protobuf field <code>.grafeas.v1.Version fixed_version = 6;</code>
     */
    private $fixed_version = null;
    /**
     * Output only. Whether a fix is available for this package.
     *
     * Generated from protobuf field <code>bool fix_available = 7;</code>
     */
    private $fix_available = false;
    /**
     * The type of package (e.g. OS, MAVEN, GO).
     *
     * Generated from protobuf field <code>string package_type = 8;</code>
     */
    private $package_type = '';
    /**
     * The distro or language system assigned severity for this vulnerability
     * when that is available and note provider assigned severity when it is not
     * available.
     *
     * Generated from protobuf field <code>.grafeas.v1.Severity effective_severity = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $effective_severity = 0;
    /**
     * The location at which this package was found.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.FileLocation file_location = 10;</code>
     */
    private $file_location;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $affected_cpe_uri
     *           Required. The [CPE URI](https://cpe.mitre.org/specification/) this
     *           vulnerability was found in.
     *     @type string $affected_package
     *           Required. The package this vulnerability was found in.
     *     @type \Grafeas\V1\Version $affected_version
     *           Required. The version of the package that is installed on the resource
     *           affected by this vulnerability.
     *     @type string $fixed_cpe_uri
     *           The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability
     *           was fixed in. It is possible for this to be different from the
     *           affected_cpe_uri.
     *     @type string $fixed_package
     *           The package this vulnerability was fixed in. It is possible for this to
     *           be different from the affected_package.
     *     @type \Grafeas\V1\Version $fixed_version
     *           Required. The version of the package this vulnerability was fixed in.
     *           Setting this to VersionKind.MAXIMUM means no fix is yet available.
     *     @type bool $fix_available
     *           Output only. Whether a fix is available for this package.
     *     @type string $package_type
     *           The type of package (e.g. OS, MAVEN, GO).
     *     @type int $effective_severity
     *           The distro or language system assigned severity for this vulnerability
     *           when that is available and note provider assigned severity when it is not
     *           available.
     *     @type array<\Grafeas\V1\FileLocation>|\Google\Protobuf\Internal\RepeatedField $file_location
     *           The location at which this package was found.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Grafeas\V1\Vulnerability::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The [CPE URI](https://cpe.mitre.org/specification/) this
     * vulnerability was found in.
     *
     * Generated from protobuf field <code>string affected_cpe_uri = 1;</code>
     * @return string
     */
    public function getAffectedCpeUri()
    {
        return $this->affected_cpe_uri;
    }

    /**
     * Required. The [CPE URI](https://cpe.mitre.org/specification/) this
     * vulnerability was found in.
     *
     * Generated from protobuf field <code>string affected_cpe_uri = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setAffectedCpeUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->affected_cpe_uri = $var;

        return $this;
    }

    /**
     * Required. The package this vulnerability was found in.
     *
     * Generated from protobuf field <code>string affected_package = 2;</code>
     * @return string
     */
    public function getAffectedPackage()
    {
        return $this->affected_package;
    }

    /**
     * Required. The package this vulnerability was found in.
     *
     * Generated from protobuf field <code>string affected_package = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setAffectedPackage($var)
    {
        GPBUtil::checkString($var, True);
        $this->affected_package = $var;

        return $this;
    }

    /**
     * Required. The version of the package that is installed on the resource
     * affected by this vulnerability.
     *
     * Generated from protobuf field <code>.grafeas.v1.Version affected_version = 3;</code>
     * @return \Grafeas\V1\Version|null
     */
    public function getAffectedVersion()
    {
        return $this->affected_version;
    }

    public function hasAffectedVersion()
    {
        return isset($this->affected_version);
    }

    public function clearAffectedVersion()
    {
        unset($this->affected_version);
    }

    /**
     * Required. The version of the package that is installed on the resource
     * affected by this vulnerability.
     *
     * Generated from protobuf field <code>.grafeas.v1.Version affected_version = 3;</code>
     * @param \Grafeas\V1\Version $var
     * @return $this
     */
    public function setAffectedVersion($var)
    {
        GPBUtil::checkMessage($var, \Grafeas\V1\Version::class);
        $this->affected_version = $var;

        return $this;
    }

    /**
     * The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability
     * was fixed in. It is possible for this to be different from the
     * affected_cpe_uri.
     *
     * Generated from protobuf field <code>string fixed_cpe_uri = 4;</code>
     * @return string
     */
    public function getFixedCpeUri()
    {
        return $this->fixed_cpe_uri;
    }

    /**
     * The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability
     * was fixed in. It is possible for this to be different from the
     * affected_cpe_uri.
     *
     * Generated from protobuf field <code>string fixed_cpe_uri = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setFixedCpeUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->fixed_cpe_uri = $var;

        return $this;
    }

    /**
     * The package this vulnerability was fixed in. It is possible for this to
     * be different from the affected_package.
     *
     * Generated from protobuf field <code>string fixed_package = 5;</code>
     * @return string
     */
    public function getFixedPackage()
    {
        return $this->fixed_package;
    }

    /**
     * The package this vulnerability was fixed in. It is possible for this to
     * be different from the affected_package.
     *
     * Generated from protobuf field <code>string fixed_package = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setFixedPackage($var)
    {
        GPBUtil::checkString($var, True);
        $this->fixed_package = $var;

        return $this;
    }

    /**
     * Required. The version of the package this vulnerability was fixed in.
     * Setting this to VersionKind.MAXIMUM means no fix is yet available.
     *
     * Generated from protobuf field <code>.grafeas.v1.Version fixed_version = 6;</code>
     * @return \Grafeas\V1\Version|null
     */
    public function getFixedVersion()
    {
        return $this->fixed_version;
    }

    public function hasFixedVersion()
    {
        return isset($this->fixed_version);
    }

    public function clearFixedVersion()
    {
        unset($this->fixed_version);
    }

    /**
     * Required. The version of the package this vulnerability was fixed in.
     * Setting this to VersionKind.MAXIMUM means no fix is yet available.
     *
     * Generated from protobuf field <code>.grafeas.v1.Version fixed_version = 6;</code>
     * @param \Grafeas\V1\Version $var
     * @return $this
     */
    public function setFixedVersion($var)
    {
        GPBUtil::checkMessage($var, \Grafeas\V1\Version::class);
        $this->fixed_version = $var;

        return $this;
    }

    /**
     * Output only. Whether a fix is available for this package.
     *
     * Generated from protobuf field <code>bool fix_available = 7;</code>
     * @return bool
     */
    public function getFixAvailable()
    {
        return $this->fix_available;
    }

    /**
     * Output only. Whether a fix is available for this package.
     *
     * Generated from protobuf field <code>bool fix_available = 7;</code>
     * @param bool $var
     * @return $this
     */
    public function setFixAvailable($var)
    {
        GPBUtil::checkBool($var);
        $this->fix_available = $var;

        return $this;
    }

    /**
     * The type of package (e.g. OS, MAVEN, GO).
     *
     * Generated from protobuf field <code>string package_type = 8;</code>
     * @return string
     */
    public function getPackageType()
    {
        return $this->package_type;
    }

    /**
     * The type of package (e.g. OS, MAVEN, GO).
     *
     * Generated from protobuf field <code>string package_type = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setPackageType($var)
    {
        GPBUtil::checkString($var, True);
        $this->package_type = $var;

        return $this;
    }

    /**
     * The distro or language system assigned severity for this vulnerability
     * when that is available and note provider assigned severity when it is not
     * available.
     *
     * Generated from protobuf field <code>.grafeas.v1.Severity effective_severity = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getEffectiveSeverity()
    {
        return $this->effective_severity;
    }

    /**
     * The distro or language system assigned severity for this vulnerability
     * when that is available and note provider assigned severity when it is not
     * available.
     *
     * Generated from protobuf field <code>.grafeas.v1.Severity effective_severity = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setEffectiveSeverity($var)
    {
        GPBUtil::checkEnum($var, \Grafeas\V1\Severity::class);
        $this->effective_severity = $var;

        return $this;
    }

    /**
     * The location at which this package was found.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.FileLocation file_location = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFileLocation()
    {
        return $this->file_location;
    }

    /**
     * The location at which this package was found.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.FileLocation file_location = 10;</code>
     * @param array<\Grafeas\V1\FileLocation>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFileLocation($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Grafeas\V1\FileLocation::class);
        $this->file_location = $arr;

        return $this;
    }

}


