<?php
/*
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dialogflow/v2/answer_record.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dialogflow\V2\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dialogflow\V2\AnswerRecord;
use Google\Cloud\Dialogflow\V2\ListAnswerRecordsRequest;
use Google\Cloud\Dialogflow\V2\ListAnswerRecordsResponse;
use Google\Cloud\Dialogflow\V2\UpdateAnswerRecordRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Service for managing
 * [AnswerRecords][google.cloud.dialogflow.v2.AnswerRecord].
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $answerRecordsClient = new AnswerRecordsClient();
 * try {
 *     $formattedParent = $answerRecordsClient->projectName('[PROJECT]');
 *     // Iterate over pages of elements
 *     $pagedResponse = $answerRecordsClient->listAnswerRecords($formattedParent);
 *     foreach ($pagedResponse->iteratePages() as $page) {
 *         foreach ($page as $element) {
 *             // doSomethingWith($element);
 *         }
 *     }
 *     // Alternatively:
 *     // Iterate through all elements
 *     $pagedResponse = $answerRecordsClient->listAnswerRecords($formattedParent);
 *     foreach ($pagedResponse->iterateAllElements() as $element) {
 *         // doSomethingWith($element);
 *     }
 * } finally {
 *     $answerRecordsClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\Dialogflow\V2\Client\AnswerRecordsClient} to use the new surface.
 */
class AnswerRecordsGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.dialogflow.v2.AnswerRecords';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'dialogflow.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/dialogflow',
    ];

    private static $agentNameTemplate;

    private static $answerRecordNameTemplate;

    private static $contextNameTemplate;

    private static $intentNameTemplate;

    private static $locationNameTemplate;

    private static $projectNameTemplate;

    private static $projectAgentNameTemplate;

    private static $projectAnswerRecordNameTemplate;

    private static $projectEnvironmentUserSessionNameTemplate;

    private static $projectEnvironmentUserSessionContextNameTemplate;

    private static $projectIntentNameTemplate;

    private static $projectLocationAgentNameTemplate;

    private static $projectLocationAnswerRecordNameTemplate;

    private static $projectLocationEnvironmentUserSessionNameTemplate;

    private static $projectLocationEnvironmentUserSessionContextNameTemplate;

    private static $projectLocationIntentNameTemplate;

    private static $projectLocationSessionNameTemplate;

    private static $projectLocationSessionContextNameTemplate;

    private static $projectSessionNameTemplate;

    private static $projectSessionContextNameTemplate;

    private static $sessionNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/answer_records_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/answer_records_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/answer_records_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/answer_records_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAgentNameTemplate()
    {
        if (self::$agentNameTemplate == null) {
            self::$agentNameTemplate = new PathTemplate('projects/{project}/agent');
        }

        return self::$agentNameTemplate;
    }

    private static function getAnswerRecordNameTemplate()
    {
        if (self::$answerRecordNameTemplate == null) {
            self::$answerRecordNameTemplate = new PathTemplate('projects/{project}/answerRecords/{answer_record}');
        }

        return self::$answerRecordNameTemplate;
    }

    private static function getContextNameTemplate()
    {
        if (self::$contextNameTemplate == null) {
            self::$contextNameTemplate = new PathTemplate('projects/{project}/agent/sessions/{session}/contexts/{context}');
        }

        return self::$contextNameTemplate;
    }

    private static function getIntentNameTemplate()
    {
        if (self::$intentNameTemplate == null) {
            self::$intentNameTemplate = new PathTemplate('projects/{project}/agent/intents/{intent}');
        }

        return self::$intentNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getProjectNameTemplate()
    {
        if (self::$projectNameTemplate == null) {
            self::$projectNameTemplate = new PathTemplate('projects/{project}');
        }

        return self::$projectNameTemplate;
    }

    private static function getProjectAgentNameTemplate()
    {
        if (self::$projectAgentNameTemplate == null) {
            self::$projectAgentNameTemplate = new PathTemplate('projects/{project}/agent');
        }

        return self::$projectAgentNameTemplate;
    }

    private static function getProjectAnswerRecordNameTemplate()
    {
        if (self::$projectAnswerRecordNameTemplate == null) {
            self::$projectAnswerRecordNameTemplate = new PathTemplate('projects/{project}/answerRecords/{answer_record}');
        }

        return self::$projectAnswerRecordNameTemplate;
    }

    private static function getProjectEnvironmentUserSessionNameTemplate()
    {
        if (self::$projectEnvironmentUserSessionNameTemplate == null) {
            self::$projectEnvironmentUserSessionNameTemplate = new PathTemplate('projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}');
        }

        return self::$projectEnvironmentUserSessionNameTemplate;
    }

    private static function getProjectEnvironmentUserSessionContextNameTemplate()
    {
        if (self::$projectEnvironmentUserSessionContextNameTemplate == null) {
            self::$projectEnvironmentUserSessionContextNameTemplate = new PathTemplate('projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}');
        }

        return self::$projectEnvironmentUserSessionContextNameTemplate;
    }

    private static function getProjectIntentNameTemplate()
    {
        if (self::$projectIntentNameTemplate == null) {
            self::$projectIntentNameTemplate = new PathTemplate('projects/{project}/agent/intents/{intent}');
        }

        return self::$projectIntentNameTemplate;
    }

    private static function getProjectLocationAgentNameTemplate()
    {
        if (self::$projectLocationAgentNameTemplate == null) {
            self::$projectLocationAgentNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agent');
        }

        return self::$projectLocationAgentNameTemplate;
    }

    private static function getProjectLocationAnswerRecordNameTemplate()
    {
        if (self::$projectLocationAnswerRecordNameTemplate == null) {
            self::$projectLocationAnswerRecordNameTemplate = new PathTemplate('projects/{project}/locations/{location}/answerRecords/{answer_record}');
        }

        return self::$projectLocationAnswerRecordNameTemplate;
    }

    private static function getProjectLocationEnvironmentUserSessionNameTemplate()
    {
        if (self::$projectLocationEnvironmentUserSessionNameTemplate == null) {
            self::$projectLocationEnvironmentUserSessionNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}');
        }

        return self::$projectLocationEnvironmentUserSessionNameTemplate;
    }

    private static function getProjectLocationEnvironmentUserSessionContextNameTemplate()
    {
        if (self::$projectLocationEnvironmentUserSessionContextNameTemplate == null) {
            self::$projectLocationEnvironmentUserSessionContextNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}');
        }

        return self::$projectLocationEnvironmentUserSessionContextNameTemplate;
    }

    private static function getProjectLocationIntentNameTemplate()
    {
        if (self::$projectLocationIntentNameTemplate == null) {
            self::$projectLocationIntentNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agent/intents/{intent}');
        }

        return self::$projectLocationIntentNameTemplate;
    }

    private static function getProjectLocationSessionNameTemplate()
    {
        if (self::$projectLocationSessionNameTemplate == null) {
            self::$projectLocationSessionNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agent/sessions/{session}');
        }

        return self::$projectLocationSessionNameTemplate;
    }

    private static function getProjectLocationSessionContextNameTemplate()
    {
        if (self::$projectLocationSessionContextNameTemplate == null) {
            self::$projectLocationSessionContextNameTemplate = new PathTemplate('projects/{project}/locations/{location}/agent/sessions/{session}/contexts/{context}');
        }

        return self::$projectLocationSessionContextNameTemplate;
    }

    private static function getProjectSessionNameTemplate()
    {
        if (self::$projectSessionNameTemplate == null) {
            self::$projectSessionNameTemplate = new PathTemplate('projects/{project}/agent/sessions/{session}');
        }

        return self::$projectSessionNameTemplate;
    }

    private static function getProjectSessionContextNameTemplate()
    {
        if (self::$projectSessionContextNameTemplate == null) {
            self::$projectSessionContextNameTemplate = new PathTemplate('projects/{project}/agent/sessions/{session}/contexts/{context}');
        }

        return self::$projectSessionContextNameTemplate;
    }

    private static function getSessionNameTemplate()
    {
        if (self::$sessionNameTemplate == null) {
            self::$sessionNameTemplate = new PathTemplate('projects/{project}/agent/sessions/{session}');
        }

        return self::$sessionNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'agent' => self::getAgentNameTemplate(),
                'answerRecord' => self::getAnswerRecordNameTemplate(),
                'context' => self::getContextNameTemplate(),
                'intent' => self::getIntentNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'project' => self::getProjectNameTemplate(),
                'projectAgent' => self::getProjectAgentNameTemplate(),
                'projectAnswerRecord' => self::getProjectAnswerRecordNameTemplate(),
                'projectEnvironmentUserSession' => self::getProjectEnvironmentUserSessionNameTemplate(),
                'projectEnvironmentUserSessionContext' => self::getProjectEnvironmentUserSessionContextNameTemplate(),
                'projectIntent' => self::getProjectIntentNameTemplate(),
                'projectLocationAgent' => self::getProjectLocationAgentNameTemplate(),
                'projectLocationAnswerRecord' => self::getProjectLocationAnswerRecordNameTemplate(),
                'projectLocationEnvironmentUserSession' => self::getProjectLocationEnvironmentUserSessionNameTemplate(),
                'projectLocationEnvironmentUserSessionContext' => self::getProjectLocationEnvironmentUserSessionContextNameTemplate(),
                'projectLocationIntent' => self::getProjectLocationIntentNameTemplate(),
                'projectLocationSession' => self::getProjectLocationSessionNameTemplate(),
                'projectLocationSessionContext' => self::getProjectLocationSessionContextNameTemplate(),
                'projectSession' => self::getProjectSessionNameTemplate(),
                'projectSessionContext' => self::getProjectSessionContextNameTemplate(),
                'session' => self::getSessionNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a agent
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted agent resource.
     */
    public static function agentName($project)
    {
        return self::getAgentNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * answer_record resource.
     *
     * @param string $project
     * @param string $answerRecord
     *
     * @return string The formatted answer_record resource.
     */
    public static function answerRecordName($project, $answerRecord)
    {
        return self::getAnswerRecordNameTemplate()->render([
            'project' => $project,
            'answer_record' => $answerRecord,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a context
     * resource.
     *
     * @param string $project
     * @param string $session
     * @param string $context
     *
     * @return string The formatted context resource.
     */
    public static function contextName($project, $session, $context)
    {
        return self::getContextNameTemplate()->render([
            'project' => $project,
            'session' => $session,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a intent
     * resource.
     *
     * @param string $project
     * @param string $intent
     *
     * @return string The formatted intent resource.
     */
    public static function intentName($project, $intent)
    {
        return self::getIntentNameTemplate()->render([
            'project' => $project,
            'intent' => $intent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName($project)
    {
        return self::getProjectNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_agent resource.
     *
     * @param string $project
     *
     * @return string The formatted project_agent resource.
     */
    public static function projectAgentName($project)
    {
        return self::getProjectAgentNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_answer_record resource.
     *
     * @param string $project
     * @param string $answerRecord
     *
     * @return string The formatted project_answer_record resource.
     */
    public static function projectAnswerRecordName($project, $answerRecord)
    {
        return self::getProjectAnswerRecordNameTemplate()->render([
            'project' => $project,
            'answer_record' => $answerRecord,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_environment_user_session resource.
     *
     * @param string $project
     * @param string $environment
     * @param string $user
     * @param string $session
     *
     * @return string The formatted project_environment_user_session resource.
     */
    public static function projectEnvironmentUserSessionName($project, $environment, $user, $session)
    {
        return self::getProjectEnvironmentUserSessionNameTemplate()->render([
            'project' => $project,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_environment_user_session_context resource.
     *
     * @param string $project
     * @param string $environment
     * @param string $user
     * @param string $session
     * @param string $context
     *
     * @return string The formatted project_environment_user_session_context resource.
     */
    public static function projectEnvironmentUserSessionContextName($project, $environment, $user, $session, $context)
    {
        return self::getProjectEnvironmentUserSessionContextNameTemplate()->render([
            'project' => $project,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_intent resource.
     *
     * @param string $project
     * @param string $intent
     *
     * @return string The formatted project_intent resource.
     */
    public static function projectIntentName($project, $intent)
    {
        return self::getProjectIntentNameTemplate()->render([
            'project' => $project,
            'intent' => $intent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_agent resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted project_location_agent resource.
     */
    public static function projectLocationAgentName($project, $location)
    {
        return self::getProjectLocationAgentNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_answer_record resource.
     *
     * @param string $project
     * @param string $location
     * @param string $answerRecord
     *
     * @return string The formatted project_location_answer_record resource.
     */
    public static function projectLocationAnswerRecordName($project, $location, $answerRecord)
    {
        return self::getProjectLocationAnswerRecordNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'answer_record' => $answerRecord,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_environment_user_session resource.
     *
     * @param string $project
     * @param string $location
     * @param string $environment
     * @param string $user
     * @param string $session
     *
     * @return string The formatted project_location_environment_user_session resource.
     */
    public static function projectLocationEnvironmentUserSessionName($project, $location, $environment, $user, $session)
    {
        return self::getProjectLocationEnvironmentUserSessionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_environment_user_session_context resource.
     *
     * @param string $project
     * @param string $location
     * @param string $environment
     * @param string $user
     * @param string $session
     * @param string $context
     *
     * @return string The formatted project_location_environment_user_session_context resource.
     */
    public static function projectLocationEnvironmentUserSessionContextName($project, $location, $environment, $user, $session, $context)
    {
        return self::getProjectLocationEnvironmentUserSessionContextNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'environment' => $environment,
            'user' => $user,
            'session' => $session,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_intent resource.
     *
     * @param string $project
     * @param string $location
     * @param string $intent
     *
     * @return string The formatted project_location_intent resource.
     */
    public static function projectLocationIntentName($project, $location, $intent)
    {
        return self::getProjectLocationIntentNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'intent' => $intent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_session resource.
     *
     * @param string $project
     * @param string $location
     * @param string $session
     *
     * @return string The formatted project_location_session resource.
     */
    public static function projectLocationSessionName($project, $location, $session)
    {
        return self::getProjectLocationSessionNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_session_context resource.
     *
     * @param string $project
     * @param string $location
     * @param string $session
     * @param string $context
     *
     * @return string The formatted project_location_session_context resource.
     */
    public static function projectLocationSessionContextName($project, $location, $session, $context)
    {
        return self::getProjectLocationSessionContextNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'session' => $session,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_session resource.
     *
     * @param string $project
     * @param string $session
     *
     * @return string The formatted project_session resource.
     */
    public static function projectSessionName($project, $session)
    {
        return self::getProjectSessionNameTemplate()->render([
            'project' => $project,
            'session' => $session,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_session_context resource.
     *
     * @param string $project
     * @param string $session
     * @param string $context
     *
     * @return string The formatted project_session_context resource.
     */
    public static function projectSessionContextName($project, $session, $context)
    {
        return self::getProjectSessionContextNameTemplate()->render([
            'project' => $project,
            'session' => $session,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a session
     * resource.
     *
     * @param string $project
     * @param string $session
     *
     * @return string The formatted session resource.
     */
    public static function sessionName($project, $session)
    {
        return self::getSessionNameTemplate()->render([
            'project' => $project,
            'session' => $session,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - agent: projects/{project}/agent
     * - answerRecord: projects/{project}/answerRecords/{answer_record}
     * - context: projects/{project}/agent/sessions/{session}/contexts/{context}
     * - intent: projects/{project}/agent/intents/{intent}
     * - location: projects/{project}/locations/{location}
     * - project: projects/{project}
     * - projectAgent: projects/{project}/agent
     * - projectAnswerRecord: projects/{project}/answerRecords/{answer_record}
     * - projectEnvironmentUserSession: projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}
     * - projectEnvironmentUserSessionContext: projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}
     * - projectIntent: projects/{project}/agent/intents/{intent}
     * - projectLocationAgent: projects/{project}/locations/{location}/agent
     * - projectLocationAnswerRecord: projects/{project}/locations/{location}/answerRecords/{answer_record}
     * - projectLocationEnvironmentUserSession: projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}
     * - projectLocationEnvironmentUserSessionContext: projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}
     * - projectLocationIntent: projects/{project}/locations/{location}/agent/intents/{intent}
     * - projectLocationSession: projects/{project}/locations/{location}/agent/sessions/{session}
     * - projectLocationSessionContext: projects/{project}/locations/{location}/agent/sessions/{session}/contexts/{context}
     * - projectSession: projects/{project}/agent/sessions/{session}
     * - projectSessionContext: projects/{project}/agent/sessions/{session}/contexts/{context}
     * - session: projects/{project}/agent/sessions/{session}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dialogflow.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Returns the list of all answer records in the specified project in reverse
     * chronological order.
     *
     * Sample code:
     * ```
     * $answerRecordsClient = new AnswerRecordsClient();
     * try {
     *     $formattedParent = $answerRecordsClient->projectName('[PROJECT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $answerRecordsClient->listAnswerRecords($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $answerRecordsClient->listAnswerRecords($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $answerRecordsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project to list all answer records for in reverse
     *                             chronological order. Format: `projects/<Project ID>/locations/<Location
     *                             ID>`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Optional. Filters to restrict results to specific answer records.
     *
     *           Marked deprecated as it hasn't been, and isn't currently, supported.
     *
     *           For more information about filtering, see
     *           [API Filtering](https://aip.dev/160).
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAnswerRecords($parent, array $optionalArgs = [])
    {
        $request = new ListAnswerRecordsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListAnswerRecords', $optionalArgs, ListAnswerRecordsResponse::class, $request);
    }

    /**
     * Updates the specified answer record.
     *
     * Sample code:
     * ```
     * $answerRecordsClient = new AnswerRecordsClient();
     * try {
     *     $answerRecord = new AnswerRecord();
     *     $updateMask = new FieldMask();
     *     $response = $answerRecordsClient->updateAnswerRecord($answerRecord, $updateMask);
     * } finally {
     *     $answerRecordsClient->close();
     * }
     * ```
     *
     * @param AnswerRecord $answerRecord Required. Answer record to update.
     * @param FieldMask    $updateMask   Required. The mask to control which fields get updated.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dialogflow\V2\AnswerRecord
     *
     * @throws ApiException if the remote call fails
     */
    public function updateAnswerRecord($answerRecord, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateAnswerRecordRequest();
        $requestParamHeaders = [];
        $request->setAnswerRecord($answerRecord);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['answer_record.name'] = $answerRecord->getName();
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateAnswerRecord', AnswerRecord::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $answerRecordsClient = new AnswerRecordsClient();
     * try {
     *     $response = $answerRecordsClient->getLocation();
     * } finally {
     *     $answerRecordsClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetLocation', Location::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.cloud.location.Locations')->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $answerRecordsClient = new AnswerRecordsClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $answerRecordsClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $answerRecordsClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $answerRecordsClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListLocations', $optionalArgs, ListLocationsResponse::class, $request, 'google.cloud.location.Locations');
    }
}
