<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/datastream/v1/datastream_resources.proto

namespace Google\Cloud\Datastream\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Oracle data source configuration
 *
 * Generated from protobuf message <code>google.cloud.datastream.v1.OracleSourceConfig</code>
 */
class OracleSourceConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Oracle objects to include in the stream.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.OracleRdbms include_objects = 1;</code>
     */
    private $include_objects = null;
    /**
     * Oracle objects to exclude from the stream.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.OracleRdbms exclude_objects = 2;</code>
     */
    private $exclude_objects = null;
    /**
     * Maximum number of concurrent CDC tasks. The number should be non-negative.
     * If not set (or set to 0), the system's default value is used.
     *
     * Generated from protobuf field <code>int32 max_concurrent_cdc_tasks = 3;</code>
     */
    private $max_concurrent_cdc_tasks = 0;
    /**
     * Maximum number of concurrent backfill tasks. The number should be
     * non-negative. If not set (or set to 0), the system's default value is used.
     *
     * Generated from protobuf field <code>int32 max_concurrent_backfill_tasks = 4;</code>
     */
    private $max_concurrent_backfill_tasks = 0;
    protected $large_objects_handling;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Datastream\V1\OracleRdbms $include_objects
     *           Oracle objects to include in the stream.
     *     @type \Google\Cloud\Datastream\V1\OracleRdbms $exclude_objects
     *           Oracle objects to exclude from the stream.
     *     @type int $max_concurrent_cdc_tasks
     *           Maximum number of concurrent CDC tasks. The number should be non-negative.
     *           If not set (or set to 0), the system's default value is used.
     *     @type int $max_concurrent_backfill_tasks
     *           Maximum number of concurrent backfill tasks. The number should be
     *           non-negative. If not set (or set to 0), the system's default value is used.
     *     @type \Google\Cloud\Datastream\V1\OracleSourceConfig\DropLargeObjects $drop_large_objects
     *           Drop large object values.
     *     @type \Google\Cloud\Datastream\V1\OracleSourceConfig\StreamLargeObjects $stream_large_objects
     *           Stream large object values. NOTE: This feature is currently experimental.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Datastream\V1\DatastreamResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Oracle objects to include in the stream.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.OracleRdbms include_objects = 1;</code>
     * @return \Google\Cloud\Datastream\V1\OracleRdbms|null
     */
    public function getIncludeObjects()
    {
        return $this->include_objects;
    }

    public function hasIncludeObjects()
    {
        return isset($this->include_objects);
    }

    public function clearIncludeObjects()
    {
        unset($this->include_objects);
    }

    /**
     * Oracle objects to include in the stream.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.OracleRdbms include_objects = 1;</code>
     * @param \Google\Cloud\Datastream\V1\OracleRdbms $var
     * @return $this
     */
    public function setIncludeObjects($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Datastream\V1\OracleRdbms::class);
        $this->include_objects = $var;

        return $this;
    }

    /**
     * Oracle objects to exclude from the stream.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.OracleRdbms exclude_objects = 2;</code>
     * @return \Google\Cloud\Datastream\V1\OracleRdbms|null
     */
    public function getExcludeObjects()
    {
        return $this->exclude_objects;
    }

    public function hasExcludeObjects()
    {
        return isset($this->exclude_objects);
    }

    public function clearExcludeObjects()
    {
        unset($this->exclude_objects);
    }

    /**
     * Oracle objects to exclude from the stream.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.OracleRdbms exclude_objects = 2;</code>
     * @param \Google\Cloud\Datastream\V1\OracleRdbms $var
     * @return $this
     */
    public function setExcludeObjects($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Datastream\V1\OracleRdbms::class);
        $this->exclude_objects = $var;

        return $this;
    }

    /**
     * Maximum number of concurrent CDC tasks. The number should be non-negative.
     * If not set (or set to 0), the system's default value is used.
     *
     * Generated from protobuf field <code>int32 max_concurrent_cdc_tasks = 3;</code>
     * @return int
     */
    public function getMaxConcurrentCdcTasks()
    {
        return $this->max_concurrent_cdc_tasks;
    }

    /**
     * Maximum number of concurrent CDC tasks. The number should be non-negative.
     * If not set (or set to 0), the system's default value is used.
     *
     * Generated from protobuf field <code>int32 max_concurrent_cdc_tasks = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxConcurrentCdcTasks($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_concurrent_cdc_tasks = $var;

        return $this;
    }

    /**
     * Maximum number of concurrent backfill tasks. The number should be
     * non-negative. If not set (or set to 0), the system's default value is used.
     *
     * Generated from protobuf field <code>int32 max_concurrent_backfill_tasks = 4;</code>
     * @return int
     */
    public function getMaxConcurrentBackfillTasks()
    {
        return $this->max_concurrent_backfill_tasks;
    }

    /**
     * Maximum number of concurrent backfill tasks. The number should be
     * non-negative. If not set (or set to 0), the system's default value is used.
     *
     * Generated from protobuf field <code>int32 max_concurrent_backfill_tasks = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxConcurrentBackfillTasks($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_concurrent_backfill_tasks = $var;

        return $this;
    }

    /**
     * Drop large object values.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.OracleSourceConfig.DropLargeObjects drop_large_objects = 100;</code>
     * @return \Google\Cloud\Datastream\V1\OracleSourceConfig\DropLargeObjects|null
     */
    public function getDropLargeObjects()
    {
        return $this->readOneof(100);
    }

    public function hasDropLargeObjects()
    {
        return $this->hasOneof(100);
    }

    /**
     * Drop large object values.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.OracleSourceConfig.DropLargeObjects drop_large_objects = 100;</code>
     * @param \Google\Cloud\Datastream\V1\OracleSourceConfig\DropLargeObjects $var
     * @return $this
     */
    public function setDropLargeObjects($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Datastream\V1\OracleSourceConfig\DropLargeObjects::class);
        $this->writeOneof(100, $var);

        return $this;
    }

    /**
     * Stream large object values. NOTE: This feature is currently experimental.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.OracleSourceConfig.StreamLargeObjects stream_large_objects = 102;</code>
     * @return \Google\Cloud\Datastream\V1\OracleSourceConfig\StreamLargeObjects|null
     */
    public function getStreamLargeObjects()
    {
        return $this->readOneof(102);
    }

    public function hasStreamLargeObjects()
    {
        return $this->hasOneof(102);
    }

    /**
     * Stream large object values. NOTE: This feature is currently experimental.
     *
     * Generated from protobuf field <code>.google.cloud.datastream.v1.OracleSourceConfig.StreamLargeObjects stream_large_objects = 102;</code>
     * @param \Google\Cloud\Datastream\V1\OracleSourceConfig\StreamLargeObjects $var
     * @return $this
     */
    public function setStreamLargeObjects($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Datastream\V1\OracleSourceConfig\StreamLargeObjects::class);
        $this->writeOneof(102, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getLargeObjectsHandling()
    {
        return $this->whichOneof("large_objects_handling");
    }

}

