<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/datacatalog/lineage/v1/lineage.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\DataCatalog\Lineage\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\DataCatalog\Lineage\V1\BatchSearchLinkProcessesRequest;
use Google\Cloud\DataCatalog\Lineage\V1\BatchSearchLinkProcessesResponse;
use Google\Cloud\DataCatalog\Lineage\V1\CreateLineageEventRequest;
use Google\Cloud\DataCatalog\Lineage\V1\CreateProcessRequest;
use Google\Cloud\DataCatalog\Lineage\V1\CreateRunRequest;
use Google\Cloud\DataCatalog\Lineage\V1\DeleteLineageEventRequest;
use Google\Cloud\DataCatalog\Lineage\V1\DeleteProcessRequest;
use Google\Cloud\DataCatalog\Lineage\V1\DeleteRunRequest;
use Google\Cloud\DataCatalog\Lineage\V1\EntityReference;
use Google\Cloud\DataCatalog\Lineage\V1\GetLineageEventRequest;
use Google\Cloud\DataCatalog\Lineage\V1\GetProcessRequest;
use Google\Cloud\DataCatalog\Lineage\V1\GetRunRequest;
use Google\Cloud\DataCatalog\Lineage\V1\LineageEvent;
use Google\Cloud\DataCatalog\Lineage\V1\ListLineageEventsRequest;
use Google\Cloud\DataCatalog\Lineage\V1\ListLineageEventsResponse;
use Google\Cloud\DataCatalog\Lineage\V1\ListProcessesRequest;
use Google\Cloud\DataCatalog\Lineage\V1\ListProcessesResponse;
use Google\Cloud\DataCatalog\Lineage\V1\ListRunsRequest;
use Google\Cloud\DataCatalog\Lineage\V1\ListRunsResponse;
use Google\Cloud\DataCatalog\Lineage\V1\Process;
use Google\Cloud\DataCatalog\Lineage\V1\ProcessOpenLineageRunEventRequest;
use Google\Cloud\DataCatalog\Lineage\V1\ProcessOpenLineageRunEventResponse;
use Google\Cloud\DataCatalog\Lineage\V1\Run;
use Google\Cloud\DataCatalog\Lineage\V1\SearchLinksRequest;
use Google\Cloud\DataCatalog\Lineage\V1\SearchLinksResponse;
use Google\Cloud\DataCatalog\Lineage\V1\UpdateProcessRequest;
use Google\Cloud\DataCatalog\Lineage\V1\UpdateRunRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;
use Google\Protobuf\Struct;

/**
 * Service Description: Lineage is used to track data flows between assets over time. You can
 * create [LineageEvents][google.cloud.datacatalog.lineage.v1.LineageEvent]
 * to record lineage between multiple sources and a single target, for
 * example, when table data is based on data from multiple tables.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $lineageClient = new LineageClient();
 * try {
 *     $formattedParent = $lineageClient->locationName('[PROJECT]', '[LOCATION]');
 *     $links = [];
 *     // Iterate over pages of elements
 *     $pagedResponse = $lineageClient->batchSearchLinkProcesses($formattedParent, $links);
 *     foreach ($pagedResponse->iteratePages() as $page) {
 *         foreach ($page as $element) {
 *             // doSomethingWith($element);
 *         }
 *     }
 *     // Alternatively:
 *     // Iterate through all elements
 *     $pagedResponse = $lineageClient->batchSearchLinkProcesses($formattedParent, $links);
 *     foreach ($pagedResponse->iterateAllElements() as $element) {
 *         // doSomethingWith($element);
 *     }
 * } finally {
 *     $lineageClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\DataCatalog\Lineage\V1\Client\LineageClient} to use the new
 * surface.
 */
class LineageGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.datacatalog.lineage.v1.Lineage';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'datalineage.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $lineageEventNameTemplate;

    private static $locationNameTemplate;

    private static $processNameTemplate;

    private static $runNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/lineage_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/lineage_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/lineage_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/lineage_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getLineageEventNameTemplate()
    {
        if (self::$lineageEventNameTemplate == null) {
            self::$lineageEventNameTemplate = new PathTemplate('projects/{project}/locations/{location}/processes/{process}/runs/{run}/lineageEvents/{lineage_event}');
        }

        return self::$lineageEventNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getProcessNameTemplate()
    {
        if (self::$processNameTemplate == null) {
            self::$processNameTemplate = new PathTemplate('projects/{project}/locations/{location}/processes/{process}');
        }

        return self::$processNameTemplate;
    }

    private static function getRunNameTemplate()
    {
        if (self::$runNameTemplate == null) {
            self::$runNameTemplate = new PathTemplate('projects/{project}/locations/{location}/processes/{process}/runs/{run}');
        }

        return self::$runNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'lineageEvent' => self::getLineageEventNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'process' => self::getProcessNameTemplate(),
                'run' => self::getRunNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * lineage_event resource.
     *
     * @param string $project
     * @param string $location
     * @param string $process
     * @param string $run
     * @param string $lineageEvent
     *
     * @return string The formatted lineage_event resource.
     */
    public static function lineageEventName($project, $location, $process, $run, $lineageEvent)
    {
        return self::getLineageEventNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'process' => $process,
            'run' => $run,
            'lineage_event' => $lineageEvent,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a process
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $process
     *
     * @return string The formatted process resource.
     */
    public static function processName($project, $location, $process)
    {
        return self::getProcessNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'process' => $process,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a run
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $process
     * @param string $run
     *
     * @return string The formatted run resource.
     */
    public static function runName($project, $location, $process, $run)
    {
        return self::getRunNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'process' => $process,
            'run' => $run,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - lineageEvent: projects/{project}/locations/{location}/processes/{process}/runs/{run}/lineageEvents/{lineage_event}
     * - location: projects/{project}/locations/{location}
     * - process: projects/{project}/locations/{location}/processes/{process}
     * - run: projects/{project}/locations/{location}/processes/{process}/runs/{run}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'datalineage.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Retrieve information about LineageProcesses associated with specific
     * links. LineageProcesses are transformation pipelines that result in data
     * flowing from **source** to **target** assets. Links between assets
     * represent this operation.
     *
     * If you have specific link names, you can use this method to
     * verify which LineageProcesses contribute to creating those links.
     * See the
     * [SearchLinks][google.cloud.datacatalog.lineage.v1.Lineage.SearchLinks]
     * method for more information on how to retrieve link name.
     *
     * You can retrieve the LineageProcess information in every project where you
     * have the `datalineage.events.get` permission. The project provided in the
     * URL is used for Billing and Quota.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $formattedParent = $lineageClient->locationName('[PROJECT]', '[LOCATION]');
     *     $links = [];
     *     // Iterate over pages of elements
     *     $pagedResponse = $lineageClient->batchSearchLinkProcesses($formattedParent, $links);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $lineageClient->batchSearchLinkProcesses($formattedParent, $links);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. The project and location where you want to search.
     * @param string[] $links        Required. An array of links to check for their associated LineageProcesses.
     *
     *                               The maximum number of items in this array is 100.
     *                               If the request contains more than 100 links, it returns the
     *                               `INVALID_ARGUMENT` error.
     *
     *                               Format: `projects/{project}/locations/{location}/links/{link}`.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function batchSearchLinkProcesses($parent, $links, array $optionalArgs = [])
    {
        $request = new BatchSearchLinkProcessesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setLinks($links);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('BatchSearchLinkProcesses', $optionalArgs, BatchSearchLinkProcessesResponse::class, $request);
    }

    /**
     * Creates a new lineage event.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $formattedParent = $lineageClient->runName('[PROJECT]', '[LOCATION]', '[PROCESS]', '[RUN]');
     *     $lineageEvent = new LineageEvent();
     *     $response = $lineageClient->createLineageEvent($formattedParent, $lineageEvent);
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param string       $parent       Required. The name of the run that should own the lineage event.
     * @param LineageEvent $lineageEvent Required. The lineage event to create.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A unique identifier for this request. Restricted to 36 ASCII characters.
     *           A random UUID is recommended. This request is idempotent only if a
     *           `request_id` is provided.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\Lineage\V1\LineageEvent
     *
     * @throws ApiException if the remote call fails
     */
    public function createLineageEvent($parent, $lineageEvent, array $optionalArgs = [])
    {
        $request = new CreateLineageEventRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setLineageEvent($lineageEvent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateLineageEvent', LineageEvent::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a new process.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $formattedParent = $lineageClient->locationName('[PROJECT]', '[LOCATION]');
     *     $process = new Process();
     *     $response = $lineageClient->createProcess($formattedParent, $process);
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The name of the project and its location that should own the
     *                              process.
     * @param Process $process      Required. The process to create.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A unique identifier for this request. Restricted to 36 ASCII characters.
     *           A random UUID is recommended. This request is idempotent only if a
     *           `request_id` is provided.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\Lineage\V1\Process
     *
     * @throws ApiException if the remote call fails
     */
    public function createProcess($parent, $process, array $optionalArgs = [])
    {
        $request = new CreateProcessRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setProcess($process);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateProcess', Process::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a new run.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $formattedParent = $lineageClient->processName('[PROJECT]', '[LOCATION]', '[PROCESS]');
     *     $run = new Run();
     *     $response = $lineageClient->createRun($formattedParent, $run);
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the process that should own the run.
     * @param Run    $run          Required. The run to create.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A unique identifier for this request. Restricted to 36 ASCII characters.
     *           A random UUID is recommended. This request is idempotent only if a
     *           `request_id` is provided.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\Lineage\V1\Run
     *
     * @throws ApiException if the remote call fails
     */
    public function createRun($parent, $run, array $optionalArgs = [])
    {
        $request = new CreateRunRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setRun($run);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateRun', Run::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes the lineage event with the specified name.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $formattedName = $lineageClient->lineageEventName('[PROJECT]', '[LOCATION]', '[PROCESS]', '[RUN]', '[LINEAGE_EVENT]');
     *     $lineageClient->deleteLineageEvent($formattedName);
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the lineage event to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $allowMissing
     *           If set to true and the lineage event is not found, the request
     *           succeeds but the server doesn't perform any actions.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteLineageEvent($name, array $optionalArgs = [])
    {
        $request = new DeleteLineageEventRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteLineageEvent', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes the process with the specified name.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $formattedName = $lineageClient->processName('[PROJECT]', '[LOCATION]', '[PROCESS]');
     *     $operationResponse = $lineageClient->deleteProcess($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $lineageClient->deleteProcess($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $lineageClient->resumeOperation($operationName, 'deleteProcess');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the process to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $allowMissing
     *           If set to true and the process is not found, the request
     *           succeeds but the server doesn't perform any actions.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteProcess($name, array $optionalArgs = [])
    {
        $request = new DeleteProcessRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteProcess', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes the run with the specified name.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $formattedName = $lineageClient->runName('[PROJECT]', '[LOCATION]', '[PROCESS]', '[RUN]');
     *     $operationResponse = $lineageClient->deleteRun($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $lineageClient->deleteRun($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $lineageClient->resumeOperation($operationName, 'deleteRun');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the run to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $allowMissing
     *           If set to true and the run is not found, the request
     *           succeeds but the server doesn't perform any actions.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteRun($name, array $optionalArgs = [])
    {
        $request = new DeleteRunRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteRun', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Gets details of a specified lineage event.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $formattedName = $lineageClient->lineageEventName('[PROJECT]', '[LOCATION]', '[PROCESS]', '[RUN]', '[LINEAGE_EVENT]');
     *     $response = $lineageClient->getLineageEvent($formattedName);
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the lineage event to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\Lineage\V1\LineageEvent
     *
     * @throws ApiException if the remote call fails
     */
    public function getLineageEvent($name, array $optionalArgs = [])
    {
        $request = new GetLineageEventRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetLineageEvent', LineageEvent::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the details of the specified process.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $formattedName = $lineageClient->processName('[PROJECT]', '[LOCATION]', '[PROCESS]');
     *     $response = $lineageClient->getProcess($formattedName);
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the process to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\Lineage\V1\Process
     *
     * @throws ApiException if the remote call fails
     */
    public function getProcess($name, array $optionalArgs = [])
    {
        $request = new GetProcessRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetProcess', Process::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the details of the specified run.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $formattedName = $lineageClient->runName('[PROJECT]', '[LOCATION]', '[PROCESS]', '[RUN]');
     *     $response = $lineageClient->getRun($formattedName);
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the run to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\Lineage\V1\Run
     *
     * @throws ApiException if the remote call fails
     */
    public function getRun($name, array $optionalArgs = [])
    {
        $request = new GetRunRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetRun', Run::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists lineage events in the given project and location. The list order is
     * not defined.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $formattedParent = $lineageClient->runName('[PROJECT]', '[LOCATION]', '[PROCESS]', '[RUN]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $lineageClient->listLineageEvents($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $lineageClient->listLineageEvents($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the run that owns the collection of lineage events to
     *                             get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLineageEvents($parent, array $optionalArgs = [])
    {
        $request = new ListLineageEventsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListLineageEvents', $optionalArgs, ListLineageEventsResponse::class, $request);
    }

    /**
     * List processes in the given project and location. List order is descending
     * by insertion time.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $formattedParent = $lineageClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $lineageClient->listProcesses($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $lineageClient->listProcesses($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the project and its location that owns this
     *                             collection of processes.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listProcesses($parent, array $optionalArgs = [])
    {
        $request = new ListProcessesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListProcesses', $optionalArgs, ListProcessesResponse::class, $request);
    }

    /**
     * Lists runs in the given project and location. List order is descending by
     * `start_time`.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $formattedParent = $lineageClient->processName('[PROJECT]', '[LOCATION]', '[PROCESS]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $lineageClient->listRuns($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $lineageClient->listRuns($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of process that owns this collection of runs.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listRuns($parent, array $optionalArgs = [])
    {
        $request = new ListRunsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListRuns', $optionalArgs, ListRunsResponse::class, $request);
    }

    /**
     * Creates new lineage events together with their parents: process and run.
     * Updates the process and run if they already exist.
     * Mapped from Open Lineage specification:
     * https://github.com/OpenLineage/OpenLineage/blob/main/spec/OpenLineage.json.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $parent = 'parent';
     *     $openLineage = new Struct();
     *     $response = $lineageClient->processOpenLineageRunEvent($parent, $openLineage);
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the project and its location that should own the
     *                             process, run, and lineage event.
     * @param Struct $openLineage  Required. OpenLineage message following OpenLineage format:
     *                             https://github.com/OpenLineage/OpenLineage/blob/main/spec/OpenLineage.json
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           A unique identifier for this request. Restricted to 36 ASCII characters.
     *           A random UUID is recommended. This request is idempotent only if a
     *           `request_id` is provided.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\Lineage\V1\ProcessOpenLineageRunEventResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function processOpenLineageRunEvent($parent, $openLineage, array $optionalArgs = [])
    {
        $request = new ProcessOpenLineageRunEventRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setOpenLineage($openLineage);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ProcessOpenLineageRunEvent', ProcessOpenLineageRunEventResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Retrieve a list of links connected to a specific asset.
     * Links represent the data flow between **source** (upstream)
     * and **target** (downstream) assets in transformation pipelines.
     * Links are stored in the same project as the Lineage Events that create
     * them.
     *
     * You can retrieve links in every project where you have the
     * `datalineage.events.get` permission. The project provided in the URL
     * is used for Billing and Quota.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $formattedParent = $lineageClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $lineageClient->searchLinks($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $lineageClient->searchLinks($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location you want search in.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type EntityReference $source
     *           Optional. Send asset information in the **source** field to retrieve all
     *           links that lead from the specified asset to downstream assets.
     *     @type EntityReference $target
     *           Optional. Send asset information in the **target** field to retrieve all
     *           links that lead from upstream assets to the specified asset.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function searchLinks($parent, array $optionalArgs = [])
    {
        $request = new SearchLinksRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['source'])) {
            $request->setSource($optionalArgs['source']);
        }

        if (isset($optionalArgs['target'])) {
            $request->setTarget($optionalArgs['target']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('SearchLinks', $optionalArgs, SearchLinksResponse::class, $request);
    }

    /**
     * Updates a process.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $process = new Process();
     *     $response = $lineageClient->updateProcess($process);
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param Process $process      Required. The lineage process to update.
     *
     *                              The process's `name` field is used to identify the process to update.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to update. Currently not used. The whole message is
     *           updated.
     *     @type bool $allowMissing
     *           If set to true and the process is not found, the request inserts it.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\Lineage\V1\Process
     *
     * @throws ApiException if the remote call fails
     */
    public function updateProcess($process, array $optionalArgs = [])
    {
        $request = new UpdateProcessRequest();
        $requestParamHeaders = [];
        $request->setProcess($process);
        $requestParamHeaders['process.name'] = $process->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateProcess', Process::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a run.
     *
     * Sample code:
     * ```
     * $lineageClient = new LineageClient();
     * try {
     *     $run = new Run();
     *     $response = $lineageClient->updateRun($run);
     * } finally {
     *     $lineageClient->close();
     * }
     * ```
     *
     * @param Run   $run          Required. The lineage run to update.
     *
     *                            The run's `name` field is used to identify the run to update.
     *
     *                            Format:
     *                            `projects/{project}/locations/{location}/processes/{process}/runs/{run}`.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to update. Currently not used. The whole message is
     *           updated.
     *     @type bool $allowMissing
     *           If set to true and the run is not found, the request creates it.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\Lineage\V1\Run
     *
     * @throws ApiException if the remote call fails
     */
    public function updateRun($run, array $optionalArgs = [])
    {
        $request = new UpdateRunRequest();
        $requestParamHeaders = [];
        $request->setRun($run);
        $requestParamHeaders['run.name'] = $run->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['allowMissing'])) {
            $request->setAllowMissing($optionalArgs['allowMissing']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateRun', Run::class, $optionalArgs, $request)->wait();
    }
}
