<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/contactcenterinsights/v1/contact_center_insights.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\ContactCenterInsights\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\ContactCenterInsights\V1\Analysis;
use Google\Cloud\ContactCenterInsights\V1\AnnotatorSelector;
use Google\Cloud\ContactCenterInsights\V1\BulkAnalyzeConversationsRequest;
use Google\Cloud\ContactCenterInsights\V1\BulkDeleteConversationsRequest;
use Google\Cloud\ContactCenterInsights\V1\CalculateIssueModelStatsRequest;
use Google\Cloud\ContactCenterInsights\V1\CalculateIssueModelStatsResponse;
use Google\Cloud\ContactCenterInsights\V1\CalculateStatsRequest;
use Google\Cloud\ContactCenterInsights\V1\CalculateStatsResponse;
use Google\Cloud\ContactCenterInsights\V1\Conversation;
use Google\Cloud\ContactCenterInsights\V1\CreateAnalysisRequest;
use Google\Cloud\ContactCenterInsights\V1\CreateConversationRequest;
use Google\Cloud\ContactCenterInsights\V1\CreateIssueModelRequest;
use Google\Cloud\ContactCenterInsights\V1\CreatePhraseMatcherRequest;
use Google\Cloud\ContactCenterInsights\V1\CreateViewRequest;
use Google\Cloud\ContactCenterInsights\V1\DeleteAnalysisRequest;
use Google\Cloud\ContactCenterInsights\V1\DeleteConversationRequest;
use Google\Cloud\ContactCenterInsights\V1\DeleteIssueModelRequest;
use Google\Cloud\ContactCenterInsights\V1\DeleteIssueRequest;
use Google\Cloud\ContactCenterInsights\V1\DeletePhraseMatcherRequest;
use Google\Cloud\ContactCenterInsights\V1\DeleteViewRequest;
use Google\Cloud\ContactCenterInsights\V1\DeployIssueModelRequest;
use Google\Cloud\ContactCenterInsights\V1\ExportInsightsDataRequest;
use Google\Cloud\ContactCenterInsights\V1\ExportInsightsDataRequest\BigQueryDestination;
use Google\Cloud\ContactCenterInsights\V1\GetAnalysisRequest;
use Google\Cloud\ContactCenterInsights\V1\GetConversationRequest;
use Google\Cloud\ContactCenterInsights\V1\GetIssueModelRequest;
use Google\Cloud\ContactCenterInsights\V1\GetIssueRequest;
use Google\Cloud\ContactCenterInsights\V1\GetPhraseMatcherRequest;
use Google\Cloud\ContactCenterInsights\V1\GetSettingsRequest;
use Google\Cloud\ContactCenterInsights\V1\GetViewRequest;
use Google\Cloud\ContactCenterInsights\V1\IngestConversationsRequest;
use Google\Cloud\ContactCenterInsights\V1\IngestConversationsRequest\ConversationConfig;
use Google\Cloud\ContactCenterInsights\V1\IngestConversationsRequest\GcsSource;
use Google\Cloud\ContactCenterInsights\V1\IngestConversationsRequest\TranscriptObjectConfig;
use Google\Cloud\ContactCenterInsights\V1\Issue;
use Google\Cloud\ContactCenterInsights\V1\IssueModel;
use Google\Cloud\ContactCenterInsights\V1\ListAnalysesRequest;
use Google\Cloud\ContactCenterInsights\V1\ListAnalysesResponse;
use Google\Cloud\ContactCenterInsights\V1\ListConversationsRequest;
use Google\Cloud\ContactCenterInsights\V1\ListConversationsResponse;
use Google\Cloud\ContactCenterInsights\V1\ListIssueModelsRequest;
use Google\Cloud\ContactCenterInsights\V1\ListIssueModelsResponse;
use Google\Cloud\ContactCenterInsights\V1\ListIssuesRequest;
use Google\Cloud\ContactCenterInsights\V1\ListIssuesResponse;
use Google\Cloud\ContactCenterInsights\V1\ListPhraseMatchersRequest;
use Google\Cloud\ContactCenterInsights\V1\ListPhraseMatchersResponse;
use Google\Cloud\ContactCenterInsights\V1\ListViewsRequest;
use Google\Cloud\ContactCenterInsights\V1\ListViewsResponse;
use Google\Cloud\ContactCenterInsights\V1\PhraseMatcher;
use Google\Cloud\ContactCenterInsights\V1\RedactionConfig;
use Google\Cloud\ContactCenterInsights\V1\Settings;
use Google\Cloud\ContactCenterInsights\V1\SpeechConfig;
use Google\Cloud\ContactCenterInsights\V1\UndeployIssueModelRequest;
use Google\Cloud\ContactCenterInsights\V1\UpdateConversationRequest;
use Google\Cloud\ContactCenterInsights\V1\UpdateIssueModelRequest;
use Google\Cloud\ContactCenterInsights\V1\UpdateIssueRequest;
use Google\Cloud\ContactCenterInsights\V1\UpdatePhraseMatcherRequest;
use Google\Cloud\ContactCenterInsights\V1\UpdateSettingsRequest;
use Google\Cloud\ContactCenterInsights\V1\UpdateViewRequest;
use Google\Cloud\ContactCenterInsights\V1\UploadConversationRequest;
use Google\Cloud\ContactCenterInsights\V1\View;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: An API that lets users analyze and explore their business conversation data.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $contactCenterInsightsClient = new ContactCenterInsightsClient();
 * try {
 *     $formattedParent = $contactCenterInsightsClient->locationName('[PROJECT]', '[LOCATION]');
 *     $filter = 'filter';
 *     $analysisPercentage = 0.0;
 *     $operationResponse = $contactCenterInsightsClient->bulkAnalyzeConversations($formattedParent, $filter, $analysisPercentage);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $contactCenterInsightsClient->bulkAnalyzeConversations($formattedParent, $filter, $analysisPercentage);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $contactCenterInsightsClient->resumeOperation($operationName, 'bulkAnalyzeConversations');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $contactCenterInsightsClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\ContactCenterInsights\V1\Client\ContactCenterInsightsClient} to
 * use the new surface.
 */
class ContactCenterInsightsGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.contactcenterinsights.v1.ContactCenterInsights';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'contactcenterinsights.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $analysisNameTemplate;

    private static $conversationNameTemplate;

    private static $conversationProfileNameTemplate;

    private static $issueNameTemplate;

    private static $issueModelNameTemplate;

    private static $locationNameTemplate;

    private static $participantNameTemplate;

    private static $phraseMatcherNameTemplate;

    private static $projectConversationParticipantNameTemplate;

    private static $projectLocationConversationParticipantNameTemplate;

    private static $recognizerNameTemplate;

    private static $settingsNameTemplate;

    private static $viewNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/contact_center_insights_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/contact_center_insights_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ .
                '/../resources/contact_center_insights_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/contact_center_insights_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getAnalysisNameTemplate()
    {
        if (self::$analysisNameTemplate == null) {
            self::$analysisNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}'
            );
        }

        return self::$analysisNameTemplate;
    }

    private static function getConversationNameTemplate()
    {
        if (self::$conversationNameTemplate == null) {
            self::$conversationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/conversations/{conversation}'
            );
        }

        return self::$conversationNameTemplate;
    }

    private static function getConversationProfileNameTemplate()
    {
        if (self::$conversationProfileNameTemplate == null) {
            self::$conversationProfileNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}'
            );
        }

        return self::$conversationProfileNameTemplate;
    }

    private static function getIssueNameTemplate()
    {
        if (self::$issueNameTemplate == null) {
            self::$issueNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{issue}'
            );
        }

        return self::$issueNameTemplate;
    }

    private static function getIssueModelNameTemplate()
    {
        if (self::$issueModelNameTemplate == null) {
            self::$issueModelNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/issueModels/{issue_model}'
            );
        }

        return self::$issueModelNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getParticipantNameTemplate()
    {
        if (self::$participantNameTemplate == null) {
            self::$participantNameTemplate = new PathTemplate(
                'projects/{project}/conversations/{conversation}/participants/{participant}'
            );
        }

        return self::$participantNameTemplate;
    }

    private static function getPhraseMatcherNameTemplate()
    {
        if (self::$phraseMatcherNameTemplate == null) {
            self::$phraseMatcherNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}'
            );
        }

        return self::$phraseMatcherNameTemplate;
    }

    private static function getProjectConversationParticipantNameTemplate()
    {
        if (self::$projectConversationParticipantNameTemplate == null) {
            self::$projectConversationParticipantNameTemplate = new PathTemplate(
                'projects/{project}/conversations/{conversation}/participants/{participant}'
            );
        }

        return self::$projectConversationParticipantNameTemplate;
    }

    private static function getProjectLocationConversationParticipantNameTemplate()
    {
        if (self::$projectLocationConversationParticipantNameTemplate == null) {
            self::$projectLocationConversationParticipantNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}'
            );
        }

        return self::$projectLocationConversationParticipantNameTemplate;
    }

    private static function getRecognizerNameTemplate()
    {
        if (self::$recognizerNameTemplate == null) {
            self::$recognizerNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/recognizers/{recognizer}'
            );
        }

        return self::$recognizerNameTemplate;
    }

    private static function getSettingsNameTemplate()
    {
        if (self::$settingsNameTemplate == null) {
            self::$settingsNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/settings'
            );
        }

        return self::$settingsNameTemplate;
    }

    private static function getViewNameTemplate()
    {
        if (self::$viewNameTemplate == null) {
            self::$viewNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/views/{view}'
            );
        }

        return self::$viewNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'analysis' => self::getAnalysisNameTemplate(),
                'conversation' => self::getConversationNameTemplate(),
                'conversationProfile' => self::getConversationProfileNameTemplate(),
                'issue' => self::getIssueNameTemplate(),
                'issueModel' => self::getIssueModelNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'participant' => self::getParticipantNameTemplate(),
                'phraseMatcher' => self::getPhraseMatcherNameTemplate(),
                'projectConversationParticipant' => self::getProjectConversationParticipantNameTemplate(),
                'projectLocationConversationParticipant' => self::getProjectLocationConversationParticipantNameTemplate(),
                'recognizer' => self::getRecognizerNameTemplate(),
                'settings' => self::getSettingsNameTemplate(),
                'view' => self::getViewNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a analysis
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversation
     * @param string $analysis
     *
     * @return string The formatted analysis resource.
     */
    public static function analysisName(
        $project,
        $location,
        $conversation,
        $analysis
    ) {
        return self::getAnalysisNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'conversation' => $conversation,
            'analysis' => $analysis,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a conversation
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversation
     *
     * @return string The formatted conversation resource.
     */
    public static function conversationName($project, $location, $conversation)
    {
        return self::getConversationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'conversation' => $conversation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * conversation_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversationProfile
     *
     * @return string The formatted conversation_profile resource.
     */
    public static function conversationProfileName(
        $project,
        $location,
        $conversationProfile
    ) {
        return self::getConversationProfileNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'conversation_profile' => $conversationProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a issue
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $issueModel
     * @param string $issue
     *
     * @return string The formatted issue resource.
     */
    public static function issueName($project, $location, $issueModel, $issue)
    {
        return self::getIssueNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'issue_model' => $issueModel,
            'issue' => $issue,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a issue_model
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $issueModel
     *
     * @return string The formatted issue_model resource.
     */
    public static function issueModelName($project, $location, $issueModel)
    {
        return self::getIssueModelNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'issue_model' => $issueModel,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a participant
     * resource.
     *
     * @param string $project
     * @param string $conversation
     * @param string $participant
     *
     * @return string The formatted participant resource.
     */
    public static function participantName(
        $project,
        $conversation,
        $participant
    ) {
        return self::getParticipantNameTemplate()->render([
            'project' => $project,
            'conversation' => $conversation,
            'participant' => $participant,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * phrase_matcher resource.
     *
     * @param string $project
     * @param string $location
     * @param string $phraseMatcher
     *
     * @return string The formatted phrase_matcher resource.
     */
    public static function phraseMatcherName(
        $project,
        $location,
        $phraseMatcher
    ) {
        return self::getPhraseMatcherNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'phrase_matcher' => $phraseMatcher,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_conversation_participant resource.
     *
     * @param string $project
     * @param string $conversation
     * @param string $participant
     *
     * @return string The formatted project_conversation_participant resource.
     */
    public static function projectConversationParticipantName(
        $project,
        $conversation,
        $participant
    ) {
        return self::getProjectConversationParticipantNameTemplate()->render([
            'project' => $project,
            'conversation' => $conversation,
            'participant' => $participant,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_conversation_participant resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversation
     * @param string $participant
     *
     * @return string The formatted project_location_conversation_participant resource.
     */
    public static function projectLocationConversationParticipantName(
        $project,
        $location,
        $conversation,
        $participant
    ) {
        return self::getProjectLocationConversationParticipantNameTemplate()->render(
            [
                'project' => $project,
                'location' => $location,
                'conversation' => $conversation,
                'participant' => $participant,
            ]
        );
    }

    /**
     * Formats a string containing the fully-qualified path to represent a recognizer
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $recognizer
     *
     * @return string The formatted recognizer resource.
     */
    public static function recognizerName($project, $location, $recognizer)
    {
        return self::getRecognizerNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'recognizer' => $recognizer,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a settings
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted settings resource.
     */
    public static function settingsName($project, $location)
    {
        return self::getSettingsNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a view
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $view
     *
     * @return string The formatted view resource.
     */
    public static function viewName($project, $location, $view)
    {
        return self::getViewNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'view' => $view,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - analysis: projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
     * - conversation: projects/{project}/locations/{location}/conversations/{conversation}
     * - conversationProfile: projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}
     * - issue: projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{issue}
     * - issueModel: projects/{project}/locations/{location}/issueModels/{issue_model}
     * - location: projects/{project}/locations/{location}
     * - participant: projects/{project}/conversations/{conversation}/participants/{participant}
     * - phraseMatcher: projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * - projectConversationParticipant: projects/{project}/conversations/{conversation}/participants/{participant}
     * - projectLocationConversationParticipant: projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
     * - recognizer: projects/{project}/locations/{location}/recognizers/{recognizer}
     * - settings: projects/{project}/locations/{location}/settings
     * - view: projects/{project}/locations/{location}/views/{view}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'contactcenterinsights.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Analyzes multiple conversations in a single request.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->locationName('[PROJECT]', '[LOCATION]');
     *     $filter = 'filter';
     *     $analysisPercentage = 0.0;
     *     $operationResponse = $contactCenterInsightsClient->bulkAnalyzeConversations($formattedParent, $filter, $analysisPercentage);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $contactCenterInsightsClient->bulkAnalyzeConversations($formattedParent, $filter, $analysisPercentage);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $contactCenterInsightsClient->resumeOperation($operationName, 'bulkAnalyzeConversations');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $parent             Required. The parent resource to create analyses in.
     * @param string $filter             Required. Filter used to select the subset of conversations to analyze.
     * @param float  $analysisPercentage Required. Percentage of selected conversation to analyze, between
     *                                   [0, 100].
     * @param array  $optionalArgs       {
     *     Optional.
     *
     *     @type AnnotatorSelector $annotatorSelector
     *           To select the annotators to run and the phrase matchers to use
     *           (if any). If not specified, all annotators will be run.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function bulkAnalyzeConversations(
        $parent,
        $filter,
        $analysisPercentage,
        array $optionalArgs = []
    ) {
        $request = new BulkAnalyzeConversationsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setFilter($filter);
        $request->setAnalysisPercentage($analysisPercentage);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['annotatorSelector'])) {
            $request->setAnnotatorSelector($optionalArgs['annotatorSelector']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'BulkAnalyzeConversations',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes multiple conversations in a single request.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->locationName('[PROJECT]', '[LOCATION]');
     *     $operationResponse = $contactCenterInsightsClient->bulkDeleteConversations($formattedParent);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $contactCenterInsightsClient->bulkDeleteConversations($formattedParent);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $contactCenterInsightsClient->resumeOperation($operationName, 'bulkDeleteConversations');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource to create analyses in.
     *                             Format:
     *                             projects/{project}/locations/{location}
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Filter used to select the subset of conversations to analyze.
     *     @type int $maxDeleteCount
     *           Maximum number of conversations to delete. The default is 1000. It can be
     *           changed by setting the `max_delete_count` field.
     *     @type bool $force
     *           If set to true, all of this conversation's analyses will also be deleted.
     *           Otherwise, the request will only succeed if the conversation has no
     *           analyses.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function bulkDeleteConversations($parent, array $optionalArgs = [])
    {
        $request = new BulkDeleteConversationsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['maxDeleteCount'])) {
            $request->setMaxDeleteCount($optionalArgs['maxDeleteCount']);
        }

        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'BulkDeleteConversations',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets an issue model's statistics.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedIssueModel = $contactCenterInsightsClient->issueModelName('[PROJECT]', '[LOCATION]', '[ISSUE_MODEL]');
     *     $response = $contactCenterInsightsClient->calculateIssueModelStats($formattedIssueModel);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $issueModel   Required. The resource name of the issue model to query against.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\CalculateIssueModelStatsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function calculateIssueModelStats(
        $issueModel,
        array $optionalArgs = []
    ) {
        $request = new CalculateIssueModelStatsRequest();
        $requestParamHeaders = [];
        $request->setIssueModel($issueModel);
        $requestParamHeaders['issue_model'] = $issueModel;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CalculateIssueModelStats',
            CalculateIssueModelStatsResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets conversation statistics.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedLocation = $contactCenterInsightsClient->locationName('[PROJECT]', '[LOCATION]');
     *     $response = $contactCenterInsightsClient->calculateStats($formattedLocation);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $location     Required. The location of the conversations.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           A filter to reduce results to a specific subset. This field is useful for
     *           getting statistics about conversations with specific properties.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\CalculateStatsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function calculateStats($location, array $optionalArgs = [])
    {
        $request = new CalculateStatsRequest();
        $requestParamHeaders = [];
        $request->setLocation($location);
        $requestParamHeaders['location'] = $location;
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CalculateStats',
            CalculateStatsResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates an analysis. The long running operation is done when the analysis
     * has completed.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->conversationName('[PROJECT]', '[LOCATION]', '[CONVERSATION]');
     *     $analysis = new Analysis();
     *     $operationResponse = $contactCenterInsightsClient->createAnalysis($formattedParent, $analysis);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $contactCenterInsightsClient->createAnalysis($formattedParent, $analysis);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $contactCenterInsightsClient->resumeOperation($operationName, 'createAnalysis');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string   $parent       Required. The parent resource of the analysis.
     * @param Analysis $analysis     Required. The analysis to create.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createAnalysis($parent, $analysis, array $optionalArgs = [])
    {
        $request = new CreateAnalysisRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setAnalysis($analysis);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateAnalysis',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a conversation.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->locationName('[PROJECT]', '[LOCATION]');
     *     $conversation = new Conversation();
     *     $response = $contactCenterInsightsClient->createConversation($formattedParent, $conversation);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string       $parent       Required. The parent resource of the conversation.
     * @param Conversation $conversation Required. The conversation resource to create.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type string $conversationId
     *           A unique ID for the new conversation. This ID will become the final
     *           component of the conversation's resource name. If no ID is specified, a
     *           server-generated ID will be used.
     *
     *           This value should be 4-64 characters and must match the regular
     *           expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\Conversation
     *
     * @throws ApiException if the remote call fails
     */
    public function createConversation(
        $parent,
        $conversation,
        array $optionalArgs = []
    ) {
        $request = new CreateConversationRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setConversation($conversation);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['conversationId'])) {
            $request->setConversationId($optionalArgs['conversationId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateConversation',
            Conversation::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates an issue model.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->locationName('[PROJECT]', '[LOCATION]');
     *     $issueModel = new IssueModel();
     *     $operationResponse = $contactCenterInsightsClient->createIssueModel($formattedParent, $issueModel);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $contactCenterInsightsClient->createIssueModel($formattedParent, $issueModel);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $contactCenterInsightsClient->resumeOperation($operationName, 'createIssueModel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string     $parent       Required. The parent resource of the issue model.
     * @param IssueModel $issueModel   Required. The issue model to create.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createIssueModel(
        $parent,
        $issueModel,
        array $optionalArgs = []
    ) {
        $request = new CreateIssueModelRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setIssueModel($issueModel);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateIssueModel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a phrase matcher.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->locationName('[PROJECT]', '[LOCATION]');
     *     $phraseMatcher = new PhraseMatcher();
     *     $response = $contactCenterInsightsClient->createPhraseMatcher($formattedParent, $phraseMatcher);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string        $parent        Required. The parent resource of the phrase matcher. Required. The location
     *                                     to create a phrase matcher for. Format: `projects/<Project
     *                                     ID>/locations/<Location ID>` or `projects/<Project
     *                                     Number>/locations/<Location ID>`
     * @param PhraseMatcher $phraseMatcher Required. The phrase matcher resource to create.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\PhraseMatcher
     *
     * @throws ApiException if the remote call fails
     */
    public function createPhraseMatcher(
        $parent,
        $phraseMatcher,
        array $optionalArgs = []
    ) {
        $request = new CreatePhraseMatcherRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setPhraseMatcher($phraseMatcher);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreatePhraseMatcher',
            PhraseMatcher::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Creates a view.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->locationName('[PROJECT]', '[LOCATION]');
     *     $view = new View();
     *     $response = $contactCenterInsightsClient->createView($formattedParent, $view);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource of the view. Required. The location to create
     *                             a view for.
     *                             Format: `projects/<Project ID>/locations/<Location ID>` or
     *                             `projects/<Project Number>/locations/<Location ID>`
     * @param View   $view         Required. The view resource to create.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\View
     *
     * @throws ApiException if the remote call fails
     */
    public function createView($parent, $view, array $optionalArgs = [])
    {
        $request = new CreateViewRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setView($view);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'CreateView',
            View::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes an analysis.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedName = $contactCenterInsightsClient->analysisName('[PROJECT]', '[LOCATION]', '[CONVERSATION]', '[ANALYSIS]');
     *     $contactCenterInsightsClient->deleteAnalysis($formattedName);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the analysis to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteAnalysis($name, array $optionalArgs = [])
    {
        $request = new DeleteAnalysisRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteAnalysis',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a conversation.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedName = $contactCenterInsightsClient->conversationName('[PROJECT]', '[LOCATION]', '[CONVERSATION]');
     *     $contactCenterInsightsClient->deleteConversation($formattedName);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the conversation to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           If set to true, all of this conversation's analyses will also be deleted.
     *           Otherwise, the request will only succeed if the conversation has no
     *           analyses.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteConversation($name, array $optionalArgs = [])
    {
        $request = new DeleteConversationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteConversation',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes an issue.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedName = $contactCenterInsightsClient->issueName('[PROJECT]', '[LOCATION]', '[ISSUE_MODEL]', '[ISSUE]');
     *     $contactCenterInsightsClient->deleteIssue($formattedName);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the issue to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteIssue($name, array $optionalArgs = [])
    {
        $request = new DeleteIssueRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteIssue',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes an issue model.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedName = $contactCenterInsightsClient->issueModelName('[PROJECT]', '[LOCATION]', '[ISSUE_MODEL]');
     *     $operationResponse = $contactCenterInsightsClient->deleteIssueModel($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $contactCenterInsightsClient->deleteIssueModel($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $contactCenterInsightsClient->resumeOperation($operationName, 'deleteIssueModel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the issue model to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteIssueModel($name, array $optionalArgs = [])
    {
        $request = new DeleteIssueModelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteIssueModel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a phrase matcher.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedName = $contactCenterInsightsClient->phraseMatcherName('[PROJECT]', '[LOCATION]', '[PHRASE_MATCHER]');
     *     $contactCenterInsightsClient->deletePhraseMatcher($formattedName);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the phrase matcher to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deletePhraseMatcher($name, array $optionalArgs = [])
    {
        $request = new DeletePhraseMatcherRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeletePhraseMatcher',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deletes a view.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedName = $contactCenterInsightsClient->viewName('[PROJECT]', '[LOCATION]', '[VIEW]');
     *     $contactCenterInsightsClient->deleteView($formattedName);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the view to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteView($name, array $optionalArgs = [])
    {
        $request = new DeleteViewRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'DeleteView',
            GPBEmpty::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Deploys an issue model. Returns an error if a model is already deployed.
     * An issue model can only be used in analysis after it has been deployed.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedName = $contactCenterInsightsClient->issueModelName('[PROJECT]', '[LOCATION]', '[ISSUE_MODEL]');
     *     $operationResponse = $contactCenterInsightsClient->deployIssueModel($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $contactCenterInsightsClient->deployIssueModel($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $contactCenterInsightsClient->resumeOperation($operationName, 'deployIssueModel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The issue model to deploy.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deployIssueModel($name, array $optionalArgs = [])
    {
        $request = new DeployIssueModelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeployIssueModel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Export insights data to a destination defined in the request body.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->locationName('[PROJECT]', '[LOCATION]');
     *     $operationResponse = $contactCenterInsightsClient->exportInsightsData($formattedParent);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $contactCenterInsightsClient->exportInsightsData($formattedParent);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $contactCenterInsightsClient->resumeOperation($operationName, 'exportInsightsData');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource to export data from.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type BigQueryDestination $bigQueryDestination
     *           Specified if sink is a BigQuery table.
     *     @type string $filter
     *           A filter to reduce results to a specific subset. Useful for exporting
     *           conversations with specific properties.
     *     @type string $kmsKey
     *           A fully qualified KMS key name for BigQuery tables protected by CMEK.
     *           Format:
     *           projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}
     *     @type int $writeDisposition
     *           Options for what to do if the destination table already exists.
     *           For allowed values, use constants defined on {@see \Google\Cloud\ContactCenterInsights\V1\ExportInsightsDataRequest\WriteDisposition}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function exportInsightsData($parent, array $optionalArgs = [])
    {
        $request = new ExportInsightsDataRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['bigQueryDestination'])) {
            $request->setBigQueryDestination(
                $optionalArgs['bigQueryDestination']
            );
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['kmsKey'])) {
            $request->setKmsKey($optionalArgs['kmsKey']);
        }

        if (isset($optionalArgs['writeDisposition'])) {
            $request->setWriteDisposition($optionalArgs['writeDisposition']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'ExportInsightsData',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets an analysis.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedName = $contactCenterInsightsClient->analysisName('[PROJECT]', '[LOCATION]', '[CONVERSATION]', '[ANALYSIS]');
     *     $response = $contactCenterInsightsClient->getAnalysis($formattedName);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the analysis to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\Analysis
     *
     * @throws ApiException if the remote call fails
     */
    public function getAnalysis($name, array $optionalArgs = [])
    {
        $request = new GetAnalysisRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetAnalysis',
            Analysis::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a conversation.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedName = $contactCenterInsightsClient->conversationName('[PROJECT]', '[LOCATION]', '[CONVERSATION]');
     *     $response = $contactCenterInsightsClient->getConversation($formattedName);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the conversation to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $view
     *           The level of details of the conversation. Default is `FULL`.
     *           For allowed values, use constants defined on {@see \Google\Cloud\ContactCenterInsights\V1\ConversationView}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\Conversation
     *
     * @throws ApiException if the remote call fails
     */
    public function getConversation($name, array $optionalArgs = [])
    {
        $request = new GetConversationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['view'])) {
            $request->setView($optionalArgs['view']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetConversation',
            Conversation::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets an issue.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedName = $contactCenterInsightsClient->issueName('[PROJECT]', '[LOCATION]', '[ISSUE_MODEL]', '[ISSUE]');
     *     $response = $contactCenterInsightsClient->getIssue($formattedName);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the issue to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\Issue
     *
     * @throws ApiException if the remote call fails
     */
    public function getIssue($name, array $optionalArgs = [])
    {
        $request = new GetIssueRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIssue',
            Issue::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets an issue model.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedName = $contactCenterInsightsClient->issueModelName('[PROJECT]', '[LOCATION]', '[ISSUE_MODEL]');
     *     $response = $contactCenterInsightsClient->getIssueModel($formattedName);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the issue model to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\IssueModel
     *
     * @throws ApiException if the remote call fails
     */
    public function getIssueModel($name, array $optionalArgs = [])
    {
        $request = new GetIssueModelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIssueModel',
            IssueModel::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a phrase matcher.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedName = $contactCenterInsightsClient->phraseMatcherName('[PROJECT]', '[LOCATION]', '[PHRASE_MATCHER]');
     *     $response = $contactCenterInsightsClient->getPhraseMatcher($formattedName);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the phrase matcher to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\PhraseMatcher
     *
     * @throws ApiException if the remote call fails
     */
    public function getPhraseMatcher($name, array $optionalArgs = [])
    {
        $request = new GetPhraseMatcherRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetPhraseMatcher',
            PhraseMatcher::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets project-level settings.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedName = $contactCenterInsightsClient->settingsName('[PROJECT]', '[LOCATION]');
     *     $response = $contactCenterInsightsClient->getSettings($formattedName);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the settings resource to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\Settings
     *
     * @throws ApiException if the remote call fails
     */
    public function getSettings($name, array $optionalArgs = [])
    {
        $request = new GetSettingsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetSettings',
            Settings::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets a view.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedName = $contactCenterInsightsClient->viewName('[PROJECT]', '[LOCATION]', '[VIEW]');
     *     $response = $contactCenterInsightsClient->getView($formattedName);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the view to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\View
     *
     * @throws ApiException if the remote call fails
     */
    public function getView($name, array $optionalArgs = [])
    {
        $request = new GetViewRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetView',
            View::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Imports conversations and processes them according to the user's
     * configuration.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->locationName('[PROJECT]', '[LOCATION]');
     *     $operationResponse = $contactCenterInsightsClient->ingestConversations($formattedParent);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $contactCenterInsightsClient->ingestConversations($formattedParent);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $contactCenterInsightsClient->resumeOperation($operationName, 'ingestConversations');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource for new conversations.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GcsSource $gcsSource
     *           A cloud storage bucket source. Note that any previously ingested objects
     *           from the source will be skipped to avoid duplication.
     *     @type TranscriptObjectConfig $transcriptObjectConfig
     *           Configuration for when `source` contains conversation transcripts.
     *     @type ConversationConfig $conversationConfig
     *           Configuration that applies to all conversations.
     *     @type RedactionConfig $redactionConfig
     *           Optional. DLP settings for transcript redaction. Optional, will default to
     *           the config specified in Settings.
     *     @type SpeechConfig $speechConfig
     *           Optional. Default Speech-to-Text configuration. Optional, will default to
     *           the config specified in Settings.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function ingestConversations($parent, array $optionalArgs = [])
    {
        $request = new IngestConversationsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['gcsSource'])) {
            $request->setGcsSource($optionalArgs['gcsSource']);
        }

        if (isset($optionalArgs['transcriptObjectConfig'])) {
            $request->setTranscriptObjectConfig(
                $optionalArgs['transcriptObjectConfig']
            );
        }

        if (isset($optionalArgs['conversationConfig'])) {
            $request->setConversationConfig(
                $optionalArgs['conversationConfig']
            );
        }

        if (isset($optionalArgs['redactionConfig'])) {
            $request->setRedactionConfig($optionalArgs['redactionConfig']);
        }

        if (isset($optionalArgs['speechConfig'])) {
            $request->setSpeechConfig($optionalArgs['speechConfig']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'IngestConversations',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Lists analyses.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->conversationName('[PROJECT]', '[LOCATION]', '[CONVERSATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $contactCenterInsightsClient->listAnalyses($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $contactCenterInsightsClient->listAnalyses($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource of the analyses.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter to reduce results to a specific subset. Useful for querying
     *           conversations with specific properties.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listAnalyses($parent, array $optionalArgs = [])
    {
        $request = new ListAnalysesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListAnalyses',
            $optionalArgs,
            ListAnalysesResponse::class,
            $request
        );
    }

    /**
     * Lists conversations.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $contactCenterInsightsClient->listConversations($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $contactCenterInsightsClient->listConversations($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource of the conversation.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter to reduce results to a specific subset. Useful for querying
     *           conversations with specific properties.
     *     @type int $view
     *           The level of details of the conversation. Default is `BASIC`.
     *           For allowed values, use constants defined on {@see \Google\Cloud\ContactCenterInsights\V1\ConversationView}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listConversations($parent, array $optionalArgs = [])
    {
        $request = new ListConversationsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['view'])) {
            $request->setView($optionalArgs['view']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListConversations',
            $optionalArgs,
            ListConversationsResponse::class,
            $request
        );
    }

    /**
     * Lists issue models.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->locationName('[PROJECT]', '[LOCATION]');
     *     $response = $contactCenterInsightsClient->listIssueModels($formattedParent);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource of the issue model.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\ListIssueModelsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listIssueModels($parent, array $optionalArgs = [])
    {
        $request = new ListIssueModelsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ListIssueModels',
            ListIssueModelsResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists issues.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->issueModelName('[PROJECT]', '[LOCATION]', '[ISSUE_MODEL]');
     *     $response = $contactCenterInsightsClient->listIssues($formattedParent);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource of the issue.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\ListIssuesResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listIssues($parent, array $optionalArgs = [])
    {
        $request = new ListIssuesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ListIssues',
            ListIssuesResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists phrase matchers.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $contactCenterInsightsClient->listPhraseMatchers($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $contactCenterInsightsClient->listPhraseMatchers($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource of the phrase matcher.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           A filter to reduce results to a specific subset. Useful for querying
     *           phrase matchers with specific properties.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listPhraseMatchers($parent, array $optionalArgs = [])
    {
        $request = new ListPhraseMatchersRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListPhraseMatchers',
            $optionalArgs,
            ListPhraseMatchersResponse::class,
            $request
        );
    }

    /**
     * Lists views.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $contactCenterInsightsClient->listViews($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $contactCenterInsightsClient->listViews($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource of the views.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listViews($parent, array $optionalArgs = [])
    {
        $request = new ListViewsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListViews',
            $optionalArgs,
            ListViewsResponse::class,
            $request
        );
    }

    /**
     * Undeploys an issue model.
     * An issue model can not be used in analysis after it has been undeployed.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedName = $contactCenterInsightsClient->issueModelName('[PROJECT]', '[LOCATION]', '[ISSUE_MODEL]');
     *     $operationResponse = $contactCenterInsightsClient->undeployIssueModel($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $contactCenterInsightsClient->undeployIssueModel($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $contactCenterInsightsClient->resumeOperation($operationName, 'undeployIssueModel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The issue model to undeploy.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function undeployIssueModel($name, array $optionalArgs = [])
    {
        $request = new UndeployIssueModelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UndeployIssueModel',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates a conversation.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $conversation = new Conversation();
     *     $response = $contactCenterInsightsClient->updateConversation($conversation);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param Conversation $conversation Required. The new values for the conversation.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\Conversation
     *
     * @throws ApiException if the remote call fails
     */
    public function updateConversation($conversation, array $optionalArgs = [])
    {
        $request = new UpdateConversationRequest();
        $requestParamHeaders = [];
        $request->setConversation($conversation);
        $requestParamHeaders['conversation.name'] = $conversation->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateConversation',
            Conversation::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates an issue.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $issue = new Issue();
     *     $response = $contactCenterInsightsClient->updateIssue($issue);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param Issue $issue        Required. The new values for the issue.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\Issue
     *
     * @throws ApiException if the remote call fails
     */
    public function updateIssue($issue, array $optionalArgs = [])
    {
        $request = new UpdateIssueRequest();
        $requestParamHeaders = [];
        $request->setIssue($issue);
        $requestParamHeaders['issue.name'] = $issue->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateIssue',
            Issue::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates an issue model.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $issueModel = new IssueModel();
     *     $response = $contactCenterInsightsClient->updateIssueModel($issueModel);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param IssueModel $issueModel   Required. The new values for the issue model.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\IssueModel
     *
     * @throws ApiException if the remote call fails
     */
    public function updateIssueModel($issueModel, array $optionalArgs = [])
    {
        $request = new UpdateIssueModelRequest();
        $requestParamHeaders = [];
        $request->setIssueModel($issueModel);
        $requestParamHeaders['issue_model.name'] = $issueModel->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateIssueModel',
            IssueModel::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates a phrase matcher.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $phraseMatcher = new PhraseMatcher();
     *     $response = $contactCenterInsightsClient->updatePhraseMatcher($phraseMatcher);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param PhraseMatcher $phraseMatcher Required. The new values for the phrase matcher.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\PhraseMatcher
     *
     * @throws ApiException if the remote call fails
     */
    public function updatePhraseMatcher(
        $phraseMatcher,
        array $optionalArgs = []
    ) {
        $request = new UpdatePhraseMatcherRequest();
        $requestParamHeaders = [];
        $request->setPhraseMatcher($phraseMatcher);
        $requestParamHeaders['phrase_matcher.name'] = $phraseMatcher->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdatePhraseMatcher',
            PhraseMatcher::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates project-level settings.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $settings = new Settings();
     *     $updateMask = new FieldMask();
     *     $response = $contactCenterInsightsClient->updateSettings($settings, $updateMask);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param Settings  $settings     Required. The new settings values.
     * @param FieldMask $updateMask   Required. The list of fields to be updated.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\Settings
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSettings(
        $settings,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateSettingsRequest();
        $requestParamHeaders = [];
        $request->setSettings($settings);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['settings.name'] = $settings->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateSettings',
            Settings::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Updates a view.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $view = new View();
     *     $response = $contactCenterInsightsClient->updateView($view);
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param View  $view         Required. The new view.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           The list of fields to be updated.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\ContactCenterInsights\V1\View
     *
     * @throws ApiException if the remote call fails
     */
    public function updateView($view, array $optionalArgs = [])
    {
        $request = new UpdateViewRequest();
        $requestParamHeaders = [];
        $request->setView($view);
        $requestParamHeaders['view.name'] = $view->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'UpdateView',
            View::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Create a longrunning conversation upload operation. This method differs
     * from CreateConversation by allowing audio transcription and optional DLP
     * redaction.
     *
     * Sample code:
     * ```
     * $contactCenterInsightsClient = new ContactCenterInsightsClient();
     * try {
     *     $formattedParent = $contactCenterInsightsClient->locationName('[PROJECT]', '[LOCATION]');
     *     $conversation = new Conversation();
     *     $operationResponse = $contactCenterInsightsClient->uploadConversation($formattedParent, $conversation);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $contactCenterInsightsClient->uploadConversation($formattedParent, $conversation);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $contactCenterInsightsClient->resumeOperation($operationName, 'uploadConversation');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $contactCenterInsightsClient->close();
     * }
     * ```
     *
     * @param string       $parent       Required. The parent resource of the conversation.
     * @param Conversation $conversation Required. The conversation resource to create.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type string $conversationId
     *           Optional. A unique ID for the new conversation. This ID will become the
     *           final component of the conversation's resource name. If no ID is specified,
     *           a server-generated ID will be used.
     *
     *           This value should be 4-64 characters and must match the regular
     *           expression `^[a-z0-9-]{4,64}$`. Valid characters are `[a-z][0-9]-`
     *     @type RedactionConfig $redactionConfig
     *           Optional. DLP settings for transcript redaction. Optional, will default to
     *           the config specified in Settings.
     *     @type SpeechConfig $speechConfig
     *           Optional. Default Speech-to-Text configuration. Optional, will default to
     *           the config specified in Settings.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function uploadConversation(
        $parent,
        $conversation,
        array $optionalArgs = []
    ) {
        $request = new UploadConversationRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setConversation($conversation);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['conversationId'])) {
            $request->setConversationId($optionalArgs['conversationId']);
        }

        if (isset($optionalArgs['redactionConfig'])) {
            $request->setRedactionConfig($optionalArgs['redactionConfig']);
        }

        if (isset($optionalArgs['speechConfig'])) {
            $request->setSpeechConfig($optionalArgs['speechConfig']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UploadConversation',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }
}
