<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/commerce/consumer/procurement/v1/order.proto

namespace Google\Cloud\Commerce\Consumer\Procurement\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a purchase made by a customer on Cloud Marketplace.
 * Creating an order makes sure that both the Google backend systems
 * as well as external service provider's systems (if needed) allow use of
 * purchased products and ensures the appropriate billing events occur.
 * An Order can be made against one Product with multiple add-ons (optional) or
 * one Quote which might reference multiple products.
 * Customers typically choose a price plan for each Product purchased when
 * they create an order and can change their plan later, if the product allows.
 *
 * Generated from protobuf message <code>google.cloud.commerce.consumer.procurement.v1.Order</code>
 */
class Order extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of the order.
     * Has the form
     * `billingAccounts/{billing_account}/orders/{order}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Required. The user-specified name of the order.
     *
     * Generated from protobuf field <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Output only. The items being purchased.
     *
     * Generated from protobuf field <code>repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $line_items;
    /**
     * Output only. Line items that were cancelled.
     *
     * Generated from protobuf field <code>repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $cancelled_line_items;
    /**
     * Output only. The creation timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The last update timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * The weak etag of the order.
     *
     * Generated from protobuf field <code>string etag = 11;</code>
     */
    protected $etag = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The resource name of the order.
     *           Has the form
     *           `billingAccounts/{billing_account}/orders/{order}`.
     *     @type string $display_name
     *           Required. The user-specified name of the order.
     *     @type array<\Google\Cloud\Commerce\Consumer\Procurement\V1\LineItem>|\Google\Protobuf\Internal\RepeatedField $line_items
     *           Output only. The items being purchased.
     *     @type array<\Google\Cloud\Commerce\Consumer\Procurement\V1\LineItem>|\Google\Protobuf\Internal\RepeatedField $cancelled_line_items
     *           Output only. Line items that were cancelled.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation timestamp.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The last update timestamp.
     *     @type string $etag
     *           The weak etag of the order.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Commerce\Consumer\Procurement\V1\Order::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of the order.
     * Has the form
     * `billingAccounts/{billing_account}/orders/{order}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The resource name of the order.
     * Has the form
     * `billingAccounts/{billing_account}/orders/{order}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The user-specified name of the order.
     *
     * Generated from protobuf field <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The user-specified name of the order.
     *
     * Generated from protobuf field <code>string display_name = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Output only. The items being purchased.
     *
     * Generated from protobuf field <code>repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLineItems()
    {
        return $this->line_items;
    }

    /**
     * Output only. The items being purchased.
     *
     * Generated from protobuf field <code>repeated .google.cloud.commerce.consumer.procurement.v1.LineItem line_items = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Commerce\Consumer\Procurement\V1\LineItem>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLineItems($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Commerce\Consumer\Procurement\V1\LineItem::class);
        $this->line_items = $arr;

        return $this;
    }

    /**
     * Output only. Line items that were cancelled.
     *
     * Generated from protobuf field <code>repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCancelledLineItems()
    {
        return $this->cancelled_line_items;
    }

    /**
     * Output only. Line items that were cancelled.
     *
     * Generated from protobuf field <code>repeated .google.cloud.commerce.consumer.procurement.v1.LineItem cancelled_line_items = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Commerce\Consumer\Procurement\V1\LineItem>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCancelledLineItems($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Commerce\Consumer\Procurement\V1\LineItem::class);
        $this->cancelled_line_items = $arr;

        return $this;
    }

    /**
     * Output only. The creation timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The last update timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The last update timestamp.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * The weak etag of the order.
     *
     * Generated from protobuf field <code>string etag = 11;</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * The weak etag of the order.
     *
     * Generated from protobuf field <code>string etag = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

}

