<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/certificatemanager/v1/certificate_manager.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\CertificateManager\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\CertificateManager\V1\Certificate;
use Google\Cloud\CertificateManager\V1\CertificateIssuanceConfig;
use Google\Cloud\CertificateManager\V1\CertificateMap;
use Google\Cloud\CertificateManager\V1\CertificateMapEntry;
use Google\Cloud\CertificateManager\V1\CreateCertificateIssuanceConfigRequest;
use Google\Cloud\CertificateManager\V1\CreateCertificateMapEntryRequest;
use Google\Cloud\CertificateManager\V1\CreateCertificateMapRequest;
use Google\Cloud\CertificateManager\V1\CreateCertificateRequest;
use Google\Cloud\CertificateManager\V1\CreateDnsAuthorizationRequest;
use Google\Cloud\CertificateManager\V1\DeleteCertificateIssuanceConfigRequest;
use Google\Cloud\CertificateManager\V1\DeleteCertificateMapEntryRequest;
use Google\Cloud\CertificateManager\V1\DeleteCertificateMapRequest;
use Google\Cloud\CertificateManager\V1\DeleteCertificateRequest;
use Google\Cloud\CertificateManager\V1\DeleteDnsAuthorizationRequest;
use Google\Cloud\CertificateManager\V1\DnsAuthorization;
use Google\Cloud\CertificateManager\V1\GetCertificateIssuanceConfigRequest;
use Google\Cloud\CertificateManager\V1\GetCertificateMapEntryRequest;
use Google\Cloud\CertificateManager\V1\GetCertificateMapRequest;
use Google\Cloud\CertificateManager\V1\GetCertificateRequest;
use Google\Cloud\CertificateManager\V1\GetDnsAuthorizationRequest;
use Google\Cloud\CertificateManager\V1\ListCertificateIssuanceConfigsRequest;
use Google\Cloud\CertificateManager\V1\ListCertificateIssuanceConfigsResponse;
use Google\Cloud\CertificateManager\V1\ListCertificateMapEntriesRequest;
use Google\Cloud\CertificateManager\V1\ListCertificateMapEntriesResponse;
use Google\Cloud\CertificateManager\V1\ListCertificateMapsRequest;
use Google\Cloud\CertificateManager\V1\ListCertificateMapsResponse;
use Google\Cloud\CertificateManager\V1\ListCertificatesRequest;
use Google\Cloud\CertificateManager\V1\ListCertificatesResponse;
use Google\Cloud\CertificateManager\V1\ListDnsAuthorizationsRequest;
use Google\Cloud\CertificateManager\V1\ListDnsAuthorizationsResponse;
use Google\Cloud\CertificateManager\V1\UpdateCertificateMapEntryRequest;
use Google\Cloud\CertificateManager\V1\UpdateCertificateMapRequest;
use Google\Cloud\CertificateManager\V1\UpdateCertificateRequest;
use Google\Cloud\CertificateManager\V1\UpdateDnsAuthorizationRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: API Overview
 *
 * Certificates Manager API allows customers to see and manage all their TLS
 * certificates.
 *
 * Certificates Manager API service provides methods to manage certificates,
 * group them into collections, and create serving configuration that can be
 * easily applied to other Cloud resources e.g. Target Proxies.
 *
 * Data Model
 *
 * The Certificates Manager service exposes the following resources:
 *
 * * `Certificate` that describes a single TLS certificate.
 * * `CertificateMap` that describes a collection of certificates that can be
 * attached to a target resource.
 * * `CertificateMapEntry` that describes a single configuration entry that
 * consists of a SNI and a group of certificates. It's a subresource of
 * CertificateMap.
 *
 * Certificate, CertificateMap and CertificateMapEntry IDs
 * have to fully match the regexp `[a-z0-9-]{1,63}`. In other words,
 * - only lower case letters, digits, and hyphen are allowed
 * - length of the resource ID has to be in [1,63] range.
 *
 * Provides methods to manage Cloud Certificate Manager entities.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $certificateManagerClient = new CertificateManagerClient();
 * try {
 *     $formattedParent = $certificateManagerClient->locationName('[PROJECT]', '[LOCATION]');
 *     $certificateId = 'certificate_id';
 *     $certificate = new Certificate();
 *     $operationResponse = $certificateManagerClient->createCertificate($formattedParent, $certificateId, $certificate);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $certificateManagerClient->createCertificate($formattedParent, $certificateId, $certificate);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $certificateManagerClient->resumeOperation($operationName, 'createCertificate');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $certificateManagerClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\CertificateManager\V1\Client\CertificateManagerClient} to use the
 * new surface.
 */
class CertificateManagerGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.certificatemanager.v1.CertificateManager';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'certificatemanager.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $caPoolNameTemplate;

    private static $certificateNameTemplate;

    private static $certificateIssuanceConfigNameTemplate;

    private static $certificateMapNameTemplate;

    private static $certificateMapEntryNameTemplate;

    private static $dnsAuthorizationNameTemplate;

    private static $locationNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/certificate_manager_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/certificate_manager_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/certificate_manager_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/certificate_manager_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getCaPoolNameTemplate()
    {
        if (self::$caPoolNameTemplate == null) {
            self::$caPoolNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/caPools/{ca_pool}'
            );
        }

        return self::$caPoolNameTemplate;
    }

    private static function getCertificateNameTemplate()
    {
        if (self::$certificateNameTemplate == null) {
            self::$certificateNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/certificates/{certificate}'
            );
        }

        return self::$certificateNameTemplate;
    }

    private static function getCertificateIssuanceConfigNameTemplate()
    {
        if (self::$certificateIssuanceConfigNameTemplate == null) {
            self::$certificateIssuanceConfigNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/certificateIssuanceConfigs/{certificate_issuance_config}'
            );
        }

        return self::$certificateIssuanceConfigNameTemplate;
    }

    private static function getCertificateMapNameTemplate()
    {
        if (self::$certificateMapNameTemplate == null) {
            self::$certificateMapNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/certificateMaps/{certificate_map}'
            );
        }

        return self::$certificateMapNameTemplate;
    }

    private static function getCertificateMapEntryNameTemplate()
    {
        if (self::$certificateMapEntryNameTemplate == null) {
            self::$certificateMapEntryNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/certificateMaps/{certificate_map}/certificateMapEntries/{certificate_map_entry}'
            );
        }

        return self::$certificateMapEntryNameTemplate;
    }

    private static function getDnsAuthorizationNameTemplate()
    {
        if (self::$dnsAuthorizationNameTemplate == null) {
            self::$dnsAuthorizationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/dnsAuthorizations/{dns_authorization}'
            );
        }

        return self::$dnsAuthorizationNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'caPool' => self::getCaPoolNameTemplate(),
                'certificate' => self::getCertificateNameTemplate(),
                'certificateIssuanceConfig' => self::getCertificateIssuanceConfigNameTemplate(),
                'certificateMap' => self::getCertificateMapNameTemplate(),
                'certificateMapEntry' => self::getCertificateMapEntryNameTemplate(),
                'dnsAuthorization' => self::getDnsAuthorizationNameTemplate(),
                'location' => self::getLocationNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a ca_pool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $caPool
     *
     * @return string The formatted ca_pool resource.
     */
    public static function caPoolName($project, $location, $caPool)
    {
        return self::getCaPoolNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'ca_pool' => $caPool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a certificate
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $certificate
     *
     * @return string The formatted certificate resource.
     */
    public static function certificateName($project, $location, $certificate)
    {
        return self::getCertificateNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'certificate' => $certificate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * certificate_issuance_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $certificateIssuanceConfig
     *
     * @return string The formatted certificate_issuance_config resource.
     */
    public static function certificateIssuanceConfigName(
        $project,
        $location,
        $certificateIssuanceConfig
    ) {
        return self::getCertificateIssuanceConfigNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'certificate_issuance_config' => $certificateIssuanceConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * certificate_map resource.
     *
     * @param string $project
     * @param string $location
     * @param string $certificateMap
     *
     * @return string The formatted certificate_map resource.
     */
    public static function certificateMapName(
        $project,
        $location,
        $certificateMap
    ) {
        return self::getCertificateMapNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'certificate_map' => $certificateMap,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * certificate_map_entry resource.
     *
     * @param string $project
     * @param string $location
     * @param string $certificateMap
     * @param string $certificateMapEntry
     *
     * @return string The formatted certificate_map_entry resource.
     */
    public static function certificateMapEntryName(
        $project,
        $location,
        $certificateMap,
        $certificateMapEntry
    ) {
        return self::getCertificateMapEntryNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'certificate_map' => $certificateMap,
            'certificate_map_entry' => $certificateMapEntry,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * dns_authorization resource.
     *
     * @param string $project
     * @param string $location
     * @param string $dnsAuthorization
     *
     * @return string The formatted dns_authorization resource.
     */
    public static function dnsAuthorizationName(
        $project,
        $location,
        $dnsAuthorization
    ) {
        return self::getDnsAuthorizationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'dns_authorization' => $dnsAuthorization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - caPool: projects/{project}/locations/{location}/caPools/{ca_pool}
     * - certificate: projects/{project}/locations/{location}/certificates/{certificate}
     * - certificateIssuanceConfig: projects/{project}/locations/{location}/certificateIssuanceConfigs/{certificate_issuance_config}
     * - certificateMap: projects/{project}/locations/{location}/certificateMaps/{certificate_map}
     * - certificateMapEntry: projects/{project}/locations/{location}/certificateMaps/{certificate_map}/certificateMapEntries/{certificate_map_entry}
     * - dnsAuthorization: projects/{project}/locations/{location}/dnsAuthorizations/{dns_authorization}
     * - location: projects/{project}/locations/{location}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'certificatemanager.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a new Certificate in a given project and location.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedParent = $certificateManagerClient->locationName('[PROJECT]', '[LOCATION]');
     *     $certificateId = 'certificate_id';
     *     $certificate = new Certificate();
     *     $operationResponse = $certificateManagerClient->createCertificate($formattedParent, $certificateId, $certificate);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $certificateManagerClient->createCertificate($formattedParent, $certificateId, $certificate);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $certificateManagerClient->resumeOperation($operationName, 'createCertificate');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string      $parent        Required. The parent resource of the certificate. Must be in the format
     *                                   `projects/&#42;/locations/*`.
     * @param string      $certificateId Required. A user-provided name of the certificate.
     * @param Certificate $certificate   Required. A definition of the certificate to create.
     * @param array       $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createCertificate(
        $parent,
        $certificateId,
        $certificate,
        array $optionalArgs = []
    ) {
        $request = new CreateCertificateRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setCertificateId($certificateId);
        $request->setCertificate($certificate);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateCertificate',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new CertificateIssuanceConfig in a given project and location.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedParent = $certificateManagerClient->locationName('[PROJECT]', '[LOCATION]');
     *     $certificateIssuanceConfigId = 'certificate_issuance_config_id';
     *     $certificateIssuanceConfig = new CertificateIssuanceConfig();
     *     $operationResponse = $certificateManagerClient->createCertificateIssuanceConfig($formattedParent, $certificateIssuanceConfigId, $certificateIssuanceConfig);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $certificateManagerClient->createCertificateIssuanceConfig($formattedParent, $certificateIssuanceConfigId, $certificateIssuanceConfig);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $certificateManagerClient->resumeOperation($operationName, 'createCertificateIssuanceConfig');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string                    $parent                      Required. The parent resource of the certificate issuance config. Must be
     *                                                               in the format `projects/&#42;/locations/*`.
     * @param string                    $certificateIssuanceConfigId Required. A user-provided name of the certificate config.
     * @param CertificateIssuanceConfig $certificateIssuanceConfig   Required. A definition of the certificate issuance config to create.
     * @param array                     $optionalArgs                {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createCertificateIssuanceConfig(
        $parent,
        $certificateIssuanceConfigId,
        $certificateIssuanceConfig,
        array $optionalArgs = []
    ) {
        $request = new CreateCertificateIssuanceConfigRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setCertificateIssuanceConfigId($certificateIssuanceConfigId);
        $request->setCertificateIssuanceConfig($certificateIssuanceConfig);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateCertificateIssuanceConfig',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new CertificateMap in a given project and location.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedParent = $certificateManagerClient->locationName('[PROJECT]', '[LOCATION]');
     *     $certificateMapId = 'certificate_map_id';
     *     $certificateMap = new CertificateMap();
     *     $operationResponse = $certificateManagerClient->createCertificateMap($formattedParent, $certificateMapId, $certificateMap);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $certificateManagerClient->createCertificateMap($formattedParent, $certificateMapId, $certificateMap);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $certificateManagerClient->resumeOperation($operationName, 'createCertificateMap');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string         $parent           Required. The parent resource of the certificate map. Must be in the format
     *                                         `projects/&#42;/locations/*`.
     * @param string         $certificateMapId Required. A user-provided name of the certificate map.
     * @param CertificateMap $certificateMap   Required. A definition of the certificate map to create.
     * @param array          $optionalArgs     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createCertificateMap(
        $parent,
        $certificateMapId,
        $certificateMap,
        array $optionalArgs = []
    ) {
        $request = new CreateCertificateMapRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setCertificateMapId($certificateMapId);
        $request->setCertificateMap($certificateMap);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateCertificateMap',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new CertificateMapEntry in a given project and location.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedParent = $certificateManagerClient->certificateMapName('[PROJECT]', '[LOCATION]', '[CERTIFICATE_MAP]');
     *     $certificateMapEntryId = 'certificate_map_entry_id';
     *     $certificateMapEntry = new CertificateMapEntry();
     *     $operationResponse = $certificateManagerClient->createCertificateMapEntry($formattedParent, $certificateMapEntryId, $certificateMapEntry);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $certificateManagerClient->createCertificateMapEntry($formattedParent, $certificateMapEntryId, $certificateMapEntry);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $certificateManagerClient->resumeOperation($operationName, 'createCertificateMapEntry');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string              $parent                Required. The parent resource of the certificate map entry. Must be in the
     *                                                   format `projects/&#42;/locations/&#42;/certificateMaps/*`.
     * @param string              $certificateMapEntryId Required. A user-provided name of the certificate map entry.
     * @param CertificateMapEntry $certificateMapEntry   Required. A definition of the certificate map entry to create.
     * @param array               $optionalArgs          {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createCertificateMapEntry(
        $parent,
        $certificateMapEntryId,
        $certificateMapEntry,
        array $optionalArgs = []
    ) {
        $request = new CreateCertificateMapEntryRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setCertificateMapEntryId($certificateMapEntryId);
        $request->setCertificateMapEntry($certificateMapEntry);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateCertificateMapEntry',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new DnsAuthorization in a given project and location.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedParent = $certificateManagerClient->locationName('[PROJECT]', '[LOCATION]');
     *     $dnsAuthorizationId = 'dns_authorization_id';
     *     $dnsAuthorization = new DnsAuthorization();
     *     $operationResponse = $certificateManagerClient->createDnsAuthorization($formattedParent, $dnsAuthorizationId, $dnsAuthorization);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $certificateManagerClient->createDnsAuthorization($formattedParent, $dnsAuthorizationId, $dnsAuthorization);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $certificateManagerClient->resumeOperation($operationName, 'createDnsAuthorization');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string           $parent             Required. The parent resource of the dns authorization. Must be in the
     *                                             format `projects/&#42;/locations/*`.
     * @param string           $dnsAuthorizationId Required. A user-provided name of the dns authorization.
     * @param DnsAuthorization $dnsAuthorization   Required. A definition of the dns authorization to create.
     * @param array            $optionalArgs       {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createDnsAuthorization(
        $parent,
        $dnsAuthorizationId,
        $dnsAuthorization,
        array $optionalArgs = []
    ) {
        $request = new CreateDnsAuthorizationRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setDnsAuthorizationId($dnsAuthorizationId);
        $request->setDnsAuthorization($dnsAuthorization);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateDnsAuthorization',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single Certificate.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedName = $certificateManagerClient->certificateName('[PROJECT]', '[LOCATION]', '[CERTIFICATE]');
     *     $operationResponse = $certificateManagerClient->deleteCertificate($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $certificateManagerClient->deleteCertificate($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $certificateManagerClient->resumeOperation($operationName, 'deleteCertificate');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the certificate to delete. Must be in the format
     *                             `projects/&#42;/locations/&#42;/certificates/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteCertificate($name, array $optionalArgs = [])
    {
        $request = new DeleteCertificateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteCertificate',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single CertificateIssuanceConfig.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedName = $certificateManagerClient->certificateIssuanceConfigName('[PROJECT]', '[LOCATION]', '[CERTIFICATE_ISSUANCE_CONFIG]');
     *     $operationResponse = $certificateManagerClient->deleteCertificateIssuanceConfig($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $certificateManagerClient->deleteCertificateIssuanceConfig($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $certificateManagerClient->resumeOperation($operationName, 'deleteCertificateIssuanceConfig');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the certificate issuance config to delete. Must be in
     *                             the format `projects/&#42;/locations/&#42;/certificateIssuanceConfigs/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteCertificateIssuanceConfig(
        $name,
        array $optionalArgs = []
    ) {
        $request = new DeleteCertificateIssuanceConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteCertificateIssuanceConfig',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single CertificateMap. A Certificate Map can't be deleted
     * if it contains Certificate Map Entries. Remove all the entries from
     * the map before calling this method.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedName = $certificateManagerClient->certificateMapName('[PROJECT]', '[LOCATION]', '[CERTIFICATE_MAP]');
     *     $operationResponse = $certificateManagerClient->deleteCertificateMap($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $certificateManagerClient->deleteCertificateMap($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $certificateManagerClient->resumeOperation($operationName, 'deleteCertificateMap');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the certificate map to delete. Must be in the format
     *                             `projects/&#42;/locations/&#42;/certificateMaps/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteCertificateMap($name, array $optionalArgs = [])
    {
        $request = new DeleteCertificateMapRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteCertificateMap',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single CertificateMapEntry.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedName = $certificateManagerClient->certificateMapEntryName('[PROJECT]', '[LOCATION]', '[CERTIFICATE_MAP]', '[CERTIFICATE_MAP_ENTRY]');
     *     $operationResponse = $certificateManagerClient->deleteCertificateMapEntry($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $certificateManagerClient->deleteCertificateMapEntry($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $certificateManagerClient->resumeOperation($operationName, 'deleteCertificateMapEntry');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the certificate map entry to delete. Must be in the
     *                             format `projects/&#42;/locations/&#42;/certificateMaps/&#42;/certificateMapEntries/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteCertificateMapEntry($name, array $optionalArgs = [])
    {
        $request = new DeleteCertificateMapEntryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteCertificateMapEntry',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a single DnsAuthorization.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedName = $certificateManagerClient->dnsAuthorizationName('[PROJECT]', '[LOCATION]', '[DNS_AUTHORIZATION]');
     *     $operationResponse = $certificateManagerClient->deleteDnsAuthorization($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $certificateManagerClient->deleteDnsAuthorization($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $certificateManagerClient->resumeOperation($operationName, 'deleteDnsAuthorization');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the dns authorization to delete. Must be in the format
     *                             `projects/&#42;/locations/&#42;/dnsAuthorizations/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteDnsAuthorization($name, array $optionalArgs = [])
    {
        $request = new DeleteDnsAuthorizationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteDnsAuthorization',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets details of a single Certificate.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedName = $certificateManagerClient->certificateName('[PROJECT]', '[LOCATION]', '[CERTIFICATE]');
     *     $response = $certificateManagerClient->getCertificate($formattedName);
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the certificate to describe. Must be in the format
     *                             `projects/&#42;/locations/&#42;/certificates/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\CertificateManager\V1\Certificate
     *
     * @throws ApiException if the remote call fails
     */
    public function getCertificate($name, array $optionalArgs = [])
    {
        $request = new GetCertificateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetCertificate',
            Certificate::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single CertificateIssuanceConfig.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedName = $certificateManagerClient->certificateIssuanceConfigName('[PROJECT]', '[LOCATION]', '[CERTIFICATE_ISSUANCE_CONFIG]');
     *     $response = $certificateManagerClient->getCertificateIssuanceConfig($formattedName);
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the certificate issuance config to describe. Must be in
     *                             the format `projects/&#42;/locations/&#42;/certificateIssuanceConfigs/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\CertificateManager\V1\CertificateIssuanceConfig
     *
     * @throws ApiException if the remote call fails
     */
    public function getCertificateIssuanceConfig(
        $name,
        array $optionalArgs = []
    ) {
        $request = new GetCertificateIssuanceConfigRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetCertificateIssuanceConfig',
            CertificateIssuanceConfig::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single CertificateMap.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedName = $certificateManagerClient->certificateMapName('[PROJECT]', '[LOCATION]', '[CERTIFICATE_MAP]');
     *     $response = $certificateManagerClient->getCertificateMap($formattedName);
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the certificate map to describe. Must be in the format
     *                             `projects/&#42;/locations/&#42;/certificateMaps/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\CertificateManager\V1\CertificateMap
     *
     * @throws ApiException if the remote call fails
     */
    public function getCertificateMap($name, array $optionalArgs = [])
    {
        $request = new GetCertificateMapRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetCertificateMap',
            CertificateMap::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single CertificateMapEntry.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedName = $certificateManagerClient->certificateMapEntryName('[PROJECT]', '[LOCATION]', '[CERTIFICATE_MAP]', '[CERTIFICATE_MAP_ENTRY]');
     *     $response = $certificateManagerClient->getCertificateMapEntry($formattedName);
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the certificate map entry to describe. Must be in the
     *                             format `projects/&#42;/locations/&#42;/certificateMaps/&#42;/certificateMapEntries/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\CertificateManager\V1\CertificateMapEntry
     *
     * @throws ApiException if the remote call fails
     */
    public function getCertificateMapEntry($name, array $optionalArgs = [])
    {
        $request = new GetCertificateMapEntryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetCertificateMapEntry',
            CertificateMapEntry::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details of a single DnsAuthorization.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedName = $certificateManagerClient->dnsAuthorizationName('[PROJECT]', '[LOCATION]', '[DNS_AUTHORIZATION]');
     *     $response = $certificateManagerClient->getDnsAuthorization($formattedName);
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string $name         Required. A name of the dns authorization to describe. Must be in the
     *                             format `projects/&#42;/locations/&#42;/dnsAuthorizations/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\CertificateManager\V1\DnsAuthorization
     *
     * @throws ApiException if the remote call fails
     */
    public function getDnsAuthorization($name, array $optionalArgs = [])
    {
        $request = new GetDnsAuthorizationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetDnsAuthorization',
            DnsAuthorization::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists CertificateIssuanceConfigs in a given project and location.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedParent = $certificateManagerClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $certificateManagerClient->listCertificateIssuanceConfigs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $certificateManagerClient->listCertificateIssuanceConfigs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the certificate should be
     *                             listed, specified in the format `projects/&#42;/locations/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filter expression to restrict the Certificates Configs returned.
     *     @type string $orderBy
     *           A list of Certificate Config field names used to specify the order of the
     *           returned results. The default sorting order is ascending. To specify
     *           descending order for a field, add a suffix " desc".
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listCertificateIssuanceConfigs(
        $parent,
        array $optionalArgs = []
    ) {
        $request = new ListCertificateIssuanceConfigsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListCertificateIssuanceConfigs',
            $optionalArgs,
            ListCertificateIssuanceConfigsResponse::class,
            $request
        );
    }

    /**
     * Lists CertificateMapEntries in a given project and location.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedParent = $certificateManagerClient->certificateMapName('[PROJECT]', '[LOCATION]', '[CERTIFICATE_MAP]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $certificateManagerClient->listCertificateMapEntries($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $certificateManagerClient->listCertificateMapEntries($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project, location and certificate map from which the
     *                             certificate map entries should be listed, specified in the format
     *                             `projects/&#42;/locations/&#42;/certificateMaps/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filter expression to restrict the returned Certificate Map Entries.
     *     @type string $orderBy
     *           A list of Certificate Map Entry field names used to specify
     *           the order of the returned results. The default sorting order is ascending.
     *           To specify descending order for a field, add a suffix " desc".
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listCertificateMapEntries($parent, array $optionalArgs = [])
    {
        $request = new ListCertificateMapEntriesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListCertificateMapEntries',
            $optionalArgs,
            ListCertificateMapEntriesResponse::class,
            $request
        );
    }

    /**
     * Lists CertificateMaps in a given project and location.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedParent = $certificateManagerClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $certificateManagerClient->listCertificateMaps($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $certificateManagerClient->listCertificateMaps($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the certificate maps should
     *                             be listed, specified in the format `projects/&#42;/locations/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filter expression to restrict the Certificates Maps returned.
     *     @type string $orderBy
     *           A list of Certificate Map field names used to specify the order of the
     *           returned results. The default sorting order is ascending. To specify
     *           descending order for a field, add a suffix " desc".
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listCertificateMaps($parent, array $optionalArgs = [])
    {
        $request = new ListCertificateMapsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListCertificateMaps',
            $optionalArgs,
            ListCertificateMapsResponse::class,
            $request
        );
    }

    /**
     * Lists Certificates in a given project and location.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedParent = $certificateManagerClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $certificateManagerClient->listCertificates($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $certificateManagerClient->listCertificates($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the certificate should be
     *                             listed, specified in the format `projects/&#42;/locations/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filter expression to restrict the Certificates returned.
     *     @type string $orderBy
     *           A list of Certificate field names used to specify the order of the returned
     *           results. The default sorting order is ascending. To specify descending
     *           order for a field, add a suffix " desc".
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listCertificates($parent, array $optionalArgs = [])
    {
        $request = new ListCertificatesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListCertificates',
            $optionalArgs,
            ListCertificatesResponse::class,
            $request
        );
    }

    /**
     * Lists DnsAuthorizations in a given project and location.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $formattedParent = $certificateManagerClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $certificateManagerClient->listDnsAuthorizations($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $certificateManagerClient->listDnsAuthorizations($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project and location from which the dns authorizations should
     *                             be listed, specified in the format `projects/&#42;/locations/*`.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           Filter expression to restrict the Dns Authorizations returned.
     *     @type string $orderBy
     *           A list of Dns Authorization field names used to specify the order of the
     *           returned results. The default sorting order is ascending. To specify
     *           descending order for a field, add a suffix " desc".
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listDnsAuthorizations($parent, array $optionalArgs = [])
    {
        $request = new ListDnsAuthorizationsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListDnsAuthorizations',
            $optionalArgs,
            ListDnsAuthorizationsResponse::class,
            $request
        );
    }

    /**
     * Updates a Certificate.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $certificate = new Certificate();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $certificateManagerClient->updateCertificate($certificate, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $certificateManagerClient->updateCertificate($certificate, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $certificateManagerClient->resumeOperation($operationName, 'updateCertificate');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param Certificate $certificate  Required. A definition of the certificate to update.
     * @param FieldMask   $updateMask   Required. The update mask applies to the resource. For the `FieldMask`
     *                                  definition, see
     *                                  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateCertificate(
        $certificate,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateCertificateRequest();
        $requestParamHeaders = [];
        $request->setCertificate($certificate);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['certificate.name'] = $certificate->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateCertificate',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates a CertificateMap.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $certificateMap = new CertificateMap();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $certificateManagerClient->updateCertificateMap($certificateMap, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $certificateManagerClient->updateCertificateMap($certificateMap, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $certificateManagerClient->resumeOperation($operationName, 'updateCertificateMap');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param CertificateMap $certificateMap Required. A definition of the certificate map to update.
     * @param FieldMask      $updateMask     Required. The update mask applies to the resource. For the `FieldMask`
     *                                       definition, see
     *                                       https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
     * @param array          $optionalArgs   {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateCertificateMap(
        $certificateMap,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateCertificateMapRequest();
        $requestParamHeaders = [];
        $request->setCertificateMap($certificateMap);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders[
            'certificate_map.name'
        ] = $certificateMap->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateCertificateMap',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates a CertificateMapEntry.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $certificateMapEntry = new CertificateMapEntry();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $certificateManagerClient->updateCertificateMapEntry($certificateMapEntry, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $certificateManagerClient->updateCertificateMapEntry($certificateMapEntry, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $certificateManagerClient->resumeOperation($operationName, 'updateCertificateMapEntry');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param CertificateMapEntry $certificateMapEntry Required. A definition of the certificate map entry to create map entry.
     * @param FieldMask           $updateMask          Required. The update mask applies to the resource. For the `FieldMask`
     *                                                 definition, see
     *                                                 https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
     * @param array               $optionalArgs        {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateCertificateMapEntry(
        $certificateMapEntry,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateCertificateMapEntryRequest();
        $requestParamHeaders = [];
        $request->setCertificateMapEntry($certificateMapEntry);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders[
            'certificate_map_entry.name'
        ] = $certificateMapEntry->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateCertificateMapEntry',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates a DnsAuthorization.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $dnsAuthorization = new DnsAuthorization();
     *     $updateMask = new FieldMask();
     *     $operationResponse = $certificateManagerClient->updateDnsAuthorization($dnsAuthorization, $updateMask);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $certificateManagerClient->updateDnsAuthorization($dnsAuthorization, $updateMask);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $certificateManagerClient->resumeOperation($operationName, 'updateDnsAuthorization');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param DnsAuthorization $dnsAuthorization Required. A definition of the dns authorization to update.
     * @param FieldMask        $updateMask       Required. The update mask applies to the resource. For the `FieldMask`
     *                                           definition, see
     *                                           https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask.
     * @param array            $optionalArgs     {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateDnsAuthorization(
        $dnsAuthorization,
        $updateMask,
        array $optionalArgs = []
    ) {
        $request = new UpdateDnsAuthorizationRequest();
        $requestParamHeaders = [];
        $request->setDnsAuthorization($dnsAuthorization);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders[
            'dns_authorization.name'
        ] = $dnsAuthorization->getName();
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateDnsAuthorization',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     $response = $certificateManagerClient->getLocation();
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $certificateManagerClient = new CertificateManagerClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $certificateManagerClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $certificateManagerClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $certificateManagerClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }
}
