<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/metadata_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\AddContextArtifactsAndExecutionsRequest;
use Google\Cloud\AIPlatform\V1\AddContextArtifactsAndExecutionsResponse;
use Google\Cloud\AIPlatform\V1\AddContextChildrenRequest;
use Google\Cloud\AIPlatform\V1\AddContextChildrenResponse;
use Google\Cloud\AIPlatform\V1\AddExecutionEventsRequest;
use Google\Cloud\AIPlatform\V1\AddExecutionEventsResponse;
use Google\Cloud\AIPlatform\V1\Artifact;
use Google\Cloud\AIPlatform\V1\Context;
use Google\Cloud\AIPlatform\V1\CreateArtifactRequest;
use Google\Cloud\AIPlatform\V1\CreateContextRequest;
use Google\Cloud\AIPlatform\V1\CreateExecutionRequest;
use Google\Cloud\AIPlatform\V1\CreateMetadataSchemaRequest;
use Google\Cloud\AIPlatform\V1\CreateMetadataStoreRequest;
use Google\Cloud\AIPlatform\V1\DeleteArtifactRequest;
use Google\Cloud\AIPlatform\V1\DeleteContextRequest;
use Google\Cloud\AIPlatform\V1\DeleteExecutionRequest;
use Google\Cloud\AIPlatform\V1\DeleteMetadataStoreRequest;
use Google\Cloud\AIPlatform\V1\Event;
use Google\Cloud\AIPlatform\V1\Execution;
use Google\Cloud\AIPlatform\V1\GetArtifactRequest;
use Google\Cloud\AIPlatform\V1\GetContextRequest;
use Google\Cloud\AIPlatform\V1\GetExecutionRequest;
use Google\Cloud\AIPlatform\V1\GetMetadataSchemaRequest;
use Google\Cloud\AIPlatform\V1\GetMetadataStoreRequest;
use Google\Cloud\AIPlatform\V1\LineageSubgraph;
use Google\Cloud\AIPlatform\V1\ListArtifactsRequest;
use Google\Cloud\AIPlatform\V1\ListContextsRequest;
use Google\Cloud\AIPlatform\V1\ListExecutionsRequest;
use Google\Cloud\AIPlatform\V1\ListMetadataSchemasRequest;
use Google\Cloud\AIPlatform\V1\ListMetadataStoresRequest;
use Google\Cloud\AIPlatform\V1\MetadataSchema;
use Google\Cloud\AIPlatform\V1\MetadataStore;
use Google\Cloud\AIPlatform\V1\PurgeArtifactsRequest;
use Google\Cloud\AIPlatform\V1\PurgeContextsRequest;
use Google\Cloud\AIPlatform\V1\PurgeExecutionsRequest;
use Google\Cloud\AIPlatform\V1\QueryArtifactLineageSubgraphRequest;
use Google\Cloud\AIPlatform\V1\QueryContextLineageSubgraphRequest;
use Google\Cloud\AIPlatform\V1\QueryExecutionInputsAndOutputsRequest;
use Google\Cloud\AIPlatform\V1\RemoveContextChildrenRequest;
use Google\Cloud\AIPlatform\V1\RemoveContextChildrenResponse;
use Google\Cloud\AIPlatform\V1\UpdateArtifactRequest;
use Google\Cloud\AIPlatform\V1\UpdateContextRequest;
use Google\Cloud\AIPlatform\V1\UpdateExecutionRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Service for reading and writing metadata entries.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\AIPlatform\V1\MetadataServiceClient} for the stable implementation
 *
 * @experimental
 *
 * @method PromiseInterface addContextArtifactsAndExecutionsAsync(AddContextArtifactsAndExecutionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface addContextChildrenAsync(AddContextChildrenRequest $request, array $optionalArgs = [])
 * @method PromiseInterface addExecutionEventsAsync(AddExecutionEventsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createArtifactAsync(CreateArtifactRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createContextAsync(CreateContextRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createExecutionAsync(CreateExecutionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createMetadataSchemaAsync(CreateMetadataSchemaRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createMetadataStoreAsync(CreateMetadataStoreRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteArtifactAsync(DeleteArtifactRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteContextAsync(DeleteContextRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteExecutionAsync(DeleteExecutionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteMetadataStoreAsync(DeleteMetadataStoreRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getArtifactAsync(GetArtifactRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getContextAsync(GetContextRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getExecutionAsync(GetExecutionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getMetadataSchemaAsync(GetMetadataSchemaRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getMetadataStoreAsync(GetMetadataStoreRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listArtifactsAsync(ListArtifactsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listContextsAsync(ListContextsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listExecutionsAsync(ListExecutionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listMetadataSchemasAsync(ListMetadataSchemasRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listMetadataStoresAsync(ListMetadataStoresRequest $request, array $optionalArgs = [])
 * @method PromiseInterface purgeArtifactsAsync(PurgeArtifactsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface purgeContextsAsync(PurgeContextsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface purgeExecutionsAsync(PurgeExecutionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface queryArtifactLineageSubgraphAsync(QueryArtifactLineageSubgraphRequest $request, array $optionalArgs = [])
 * @method PromiseInterface queryContextLineageSubgraphAsync(QueryContextLineageSubgraphRequest $request, array $optionalArgs = [])
 * @method PromiseInterface queryExecutionInputsAndOutputsAsync(QueryExecutionInputsAndOutputsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface removeContextChildrenAsync(RemoveContextChildrenRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateArtifactAsync(UpdateArtifactRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateContextAsync(UpdateContextRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateExecutionAsync(UpdateExecutionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class MetadataServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.aiplatform.v1.MetadataService';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/metadata_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/metadata_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/metadata_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/metadata_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a artifact
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataStore
     * @param string $artifact
     *
     * @return string The formatted artifact resource.
     */
    public static function artifactName(string $project, string $location, string $metadataStore, string $artifact): string
    {
        return self::getPathTemplate('artifact')->render([
            'project' => $project,
            'location' => $location,
            'metadata_store' => $metadataStore,
            'artifact' => $artifact,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a context
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataStore
     * @param string $context
     *
     * @return string The formatted context resource.
     */
    public static function contextName(string $project, string $location, string $metadataStore, string $context): string
    {
        return self::getPathTemplate('context')->render([
            'project' => $project,
            'location' => $location,
            'metadata_store' => $metadataStore,
            'context' => $context,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a execution
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataStore
     * @param string $execution
     *
     * @return string The formatted execution resource.
     */
    public static function executionName(string $project, string $location, string $metadataStore, string $execution): string
    {
        return self::getPathTemplate('execution')->render([
            'project' => $project,
            'location' => $location,
            'metadata_store' => $metadataStore,
            'execution' => $execution,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * metadata_schema resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataStore
     * @param string $metadataSchema
     *
     * @return string The formatted metadata_schema resource.
     */
    public static function metadataSchemaName(string $project, string $location, string $metadataStore, string $metadataSchema): string
    {
        return self::getPathTemplate('metadataSchema')->render([
            'project' => $project,
            'location' => $location,
            'metadata_store' => $metadataStore,
            'metadata_schema' => $metadataSchema,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * metadata_store resource.
     *
     * @param string $project
     * @param string $location
     * @param string $metadataStore
     *
     * @return string The formatted metadata_store resource.
     */
    public static function metadataStoreName(string $project, string $location, string $metadataStore): string
    {
        return self::getPathTemplate('metadataStore')->render([
            'project' => $project,
            'location' => $location,
            'metadata_store' => $metadataStore,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - artifact: projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}
     * - context: projects/{project}/locations/{location}/metadataStores/{metadata_store}/contexts/{context}
     * - execution: projects/{project}/locations/{location}/metadataStores/{metadata_store}/executions/{execution}
     * - location: projects/{project}/locations/{location}
     * - metadataSchema: projects/{project}/locations/{location}/metadataStores/{metadata_store}/metadataSchemas/{metadata_schema}
     * - metadataStore: projects/{project}/locations/{location}/metadataStores/{metadata_store}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Adds a set of Artifacts and Executions to a Context. If any of the
     * Artifacts or Executions have already been added to a Context, they are
     * simply skipped.
     *
     * The async variant is
     * {@see MetadataServiceClient::addContextArtifactsAndExecutionsAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/add_context_artifacts_and_executions.php
     *
     * @param AddContextArtifactsAndExecutionsRequest $request     A request to house fields associated with the call.
     * @param array                                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AddContextArtifactsAndExecutionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function addContextArtifactsAndExecutions(AddContextArtifactsAndExecutionsRequest $request, array $callOptions = []): AddContextArtifactsAndExecutionsResponse
    {
        return $this->startApiCall('AddContextArtifactsAndExecutions', $request, $callOptions)->wait();
    }

    /**
     * Adds a set of Contexts as children to a parent Context. If any of the
     * child Contexts have already been added to the parent Context, they are
     * simply skipped. If this call would create a cycle or cause any Context to
     * have more than 10 parents, the request will fail with an INVALID_ARGUMENT
     * error.
     *
     * The async variant is {@see MetadataServiceClient::addContextChildrenAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/add_context_children.php
     *
     * @param AddContextChildrenRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AddContextChildrenResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function addContextChildren(AddContextChildrenRequest $request, array $callOptions = []): AddContextChildrenResponse
    {
        return $this->startApiCall('AddContextChildren', $request, $callOptions)->wait();
    }

    /**
     * Adds Events to the specified Execution. An Event indicates whether an
     * Artifact was used as an input or output for an Execution. If an Event
     * already exists between the Execution and the Artifact, the Event is
     * skipped.
     *
     * The async variant is {@see MetadataServiceClient::addExecutionEventsAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/add_execution_events.php
     *
     * @param AddExecutionEventsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AddExecutionEventsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function addExecutionEvents(AddExecutionEventsRequest $request, array $callOptions = []): AddExecutionEventsResponse
    {
        return $this->startApiCall('AddExecutionEvents', $request, $callOptions)->wait();
    }

    /**
     * Creates an Artifact associated with a MetadataStore.
     *
     * The async variant is {@see MetadataServiceClient::createArtifactAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/create_artifact.php
     *
     * @param CreateArtifactRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Artifact
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createArtifact(CreateArtifactRequest $request, array $callOptions = []): Artifact
    {
        return $this->startApiCall('CreateArtifact', $request, $callOptions)->wait();
    }

    /**
     * Creates a Context associated with a MetadataStore.
     *
     * The async variant is {@see MetadataServiceClient::createContextAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/create_context.php
     *
     * @param CreateContextRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Context
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createContext(CreateContextRequest $request, array $callOptions = []): Context
    {
        return $this->startApiCall('CreateContext', $request, $callOptions)->wait();
    }

    /**
     * Creates an Execution associated with a MetadataStore.
     *
     * The async variant is {@see MetadataServiceClient::createExecutionAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/create_execution.php
     *
     * @param CreateExecutionRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Execution
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createExecution(CreateExecutionRequest $request, array $callOptions = []): Execution
    {
        return $this->startApiCall('CreateExecution', $request, $callOptions)->wait();
    }

    /**
     * Creates a MetadataSchema.
     *
     * The async variant is {@see MetadataServiceClient::createMetadataSchemaAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/create_metadata_schema.php
     *
     * @param CreateMetadataSchemaRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MetadataSchema
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createMetadataSchema(CreateMetadataSchemaRequest $request, array $callOptions = []): MetadataSchema
    {
        return $this->startApiCall('CreateMetadataSchema', $request, $callOptions)->wait();
    }

    /**
     * Initializes a MetadataStore, including allocation of resources.
     *
     * The async variant is {@see MetadataServiceClient::createMetadataStoreAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/create_metadata_store.php
     *
     * @param CreateMetadataStoreRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createMetadataStore(CreateMetadataStoreRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateMetadataStore', $request, $callOptions)->wait();
    }

    /**
     * Deletes an Artifact.
     *
     * The async variant is {@see MetadataServiceClient::deleteArtifactAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/delete_artifact.php
     *
     * @param DeleteArtifactRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteArtifact(DeleteArtifactRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteArtifact', $request, $callOptions)->wait();
    }

    /**
     * Deletes a stored Context.
     *
     * The async variant is {@see MetadataServiceClient::deleteContextAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/delete_context.php
     *
     * @param DeleteContextRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteContext(DeleteContextRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteContext', $request, $callOptions)->wait();
    }

    /**
     * Deletes an Execution.
     *
     * The async variant is {@see MetadataServiceClient::deleteExecutionAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/delete_execution.php
     *
     * @param DeleteExecutionRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteExecution(DeleteExecutionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteExecution', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single MetadataStore and all its child resources (Artifacts,
     * Executions, and Contexts).
     *
     * The async variant is {@see MetadataServiceClient::deleteMetadataStoreAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/delete_metadata_store.php
     *
     * @param DeleteMetadataStoreRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteMetadataStore(DeleteMetadataStoreRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteMetadataStore', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a specific Artifact.
     *
     * The async variant is {@see MetadataServiceClient::getArtifactAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/get_artifact.php
     *
     * @param GetArtifactRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Artifact
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getArtifact(GetArtifactRequest $request, array $callOptions = []): Artifact
    {
        return $this->startApiCall('GetArtifact', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a specific Context.
     *
     * The async variant is {@see MetadataServiceClient::getContextAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/get_context.php
     *
     * @param GetContextRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Context
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getContext(GetContextRequest $request, array $callOptions = []): Context
    {
        return $this->startApiCall('GetContext', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a specific Execution.
     *
     * The async variant is {@see MetadataServiceClient::getExecutionAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/get_execution.php
     *
     * @param GetExecutionRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Execution
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getExecution(GetExecutionRequest $request, array $callOptions = []): Execution
    {
        return $this->startApiCall('GetExecution', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a specific MetadataSchema.
     *
     * The async variant is {@see MetadataServiceClient::getMetadataSchemaAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/get_metadata_schema.php
     *
     * @param GetMetadataSchemaRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MetadataSchema
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMetadataSchema(GetMetadataSchemaRequest $request, array $callOptions = []): MetadataSchema
    {
        return $this->startApiCall('GetMetadataSchema', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a specific MetadataStore.
     *
     * The async variant is {@see MetadataServiceClient::getMetadataStoreAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/get_metadata_store.php
     *
     * @param GetMetadataStoreRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MetadataStore
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMetadataStore(GetMetadataStoreRequest $request, array $callOptions = []): MetadataStore
    {
        return $this->startApiCall('GetMetadataStore', $request, $callOptions)->wait();
    }

    /**
     * Lists Artifacts in the MetadataStore.
     *
     * The async variant is {@see MetadataServiceClient::listArtifactsAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/list_artifacts.php
     *
     * @param ListArtifactsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listArtifacts(ListArtifactsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListArtifacts', $request, $callOptions);
    }

    /**
     * Lists Contexts on the MetadataStore.
     *
     * The async variant is {@see MetadataServiceClient::listContextsAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/list_contexts.php
     *
     * @param ListContextsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listContexts(ListContextsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListContexts', $request, $callOptions);
    }

    /**
     * Lists Executions in the MetadataStore.
     *
     * The async variant is {@see MetadataServiceClient::listExecutionsAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/list_executions.php
     *
     * @param ListExecutionsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listExecutions(ListExecutionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListExecutions', $request, $callOptions);
    }

    /**
     * Lists MetadataSchemas.
     *
     * The async variant is {@see MetadataServiceClient::listMetadataSchemasAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/list_metadata_schemas.php
     *
     * @param ListMetadataSchemasRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMetadataSchemas(ListMetadataSchemasRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMetadataSchemas', $request, $callOptions);
    }

    /**
     * Lists MetadataStores for a Location.
     *
     * The async variant is {@see MetadataServiceClient::listMetadataStoresAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/list_metadata_stores.php
     *
     * @param ListMetadataStoresRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMetadataStores(ListMetadataStoresRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListMetadataStores', $request, $callOptions);
    }

    /**
     * Purges Artifacts.
     *
     * The async variant is {@see MetadataServiceClient::purgeArtifactsAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/purge_artifacts.php
     *
     * @param PurgeArtifactsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function purgeArtifacts(PurgeArtifactsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('PurgeArtifacts', $request, $callOptions)->wait();
    }

    /**
     * Purges Contexts.
     *
     * The async variant is {@see MetadataServiceClient::purgeContextsAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/purge_contexts.php
     *
     * @param PurgeContextsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function purgeContexts(PurgeContextsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('PurgeContexts', $request, $callOptions)->wait();
    }

    /**
     * Purges Executions.
     *
     * The async variant is {@see MetadataServiceClient::purgeExecutionsAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/purge_executions.php
     *
     * @param PurgeExecutionsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function purgeExecutions(PurgeExecutionsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('PurgeExecutions', $request, $callOptions)->wait();
    }

    /**
     * Retrieves lineage of an Artifact represented through Artifacts and
     * Executions connected by Event edges and returned as a LineageSubgraph.
     *
     * The async variant is
     * {@see MetadataServiceClient::queryArtifactLineageSubgraphAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/query_artifact_lineage_subgraph.php
     *
     * @param QueryArtifactLineageSubgraphRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LineageSubgraph
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function queryArtifactLineageSubgraph(QueryArtifactLineageSubgraphRequest $request, array $callOptions = []): LineageSubgraph
    {
        return $this->startApiCall('QueryArtifactLineageSubgraph', $request, $callOptions)->wait();
    }

    /**
     * Retrieves Artifacts and Executions within the specified Context, connected
     * by Event edges and returned as a LineageSubgraph.
     *
     * The async variant is
     * {@see MetadataServiceClient::queryContextLineageSubgraphAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/query_context_lineage_subgraph.php
     *
     * @param QueryContextLineageSubgraphRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LineageSubgraph
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function queryContextLineageSubgraph(QueryContextLineageSubgraphRequest $request, array $callOptions = []): LineageSubgraph
    {
        return $this->startApiCall('QueryContextLineageSubgraph', $request, $callOptions)->wait();
    }

    /**
     * Obtains the set of input and output Artifacts for this Execution, in the
     * form of LineageSubgraph that also contains the Execution and connecting
     * Events.
     *
     * The async variant is
     * {@see MetadataServiceClient::queryExecutionInputsAndOutputsAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/query_execution_inputs_and_outputs.php
     *
     * @param QueryExecutionInputsAndOutputsRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return LineageSubgraph
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function queryExecutionInputsAndOutputs(QueryExecutionInputsAndOutputsRequest $request, array $callOptions = []): LineageSubgraph
    {
        return $this->startApiCall('QueryExecutionInputsAndOutputs', $request, $callOptions)->wait();
    }

    /**
     * Remove a set of children contexts from a parent Context. If any of the
     * child Contexts were NOT added to the parent Context, they are
     * simply skipped.
     *
     * The async variant is {@see MetadataServiceClient::removeContextChildrenAsync()}
     * .
     *
     * @example samples/V1/MetadataServiceClient/remove_context_children.php
     *
     * @param RemoveContextChildrenRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RemoveContextChildrenResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function removeContextChildren(RemoveContextChildrenRequest $request, array $callOptions = []): RemoveContextChildrenResponse
    {
        return $this->startApiCall('RemoveContextChildren', $request, $callOptions)->wait();
    }

    /**
     * Updates a stored Artifact.
     *
     * The async variant is {@see MetadataServiceClient::updateArtifactAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/update_artifact.php
     *
     * @param UpdateArtifactRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Artifact
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateArtifact(UpdateArtifactRequest $request, array $callOptions = []): Artifact
    {
        return $this->startApiCall('UpdateArtifact', $request, $callOptions)->wait();
    }

    /**
     * Updates a stored Context.
     *
     * The async variant is {@see MetadataServiceClient::updateContextAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/update_context.php
     *
     * @param UpdateContextRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Context
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateContext(UpdateContextRequest $request, array $callOptions = []): Context
    {
        return $this->startApiCall('UpdateContext', $request, $callOptions)->wait();
    }

    /**
     * Updates a stored Execution.
     *
     * The async variant is {@see MetadataServiceClient::updateExecutionAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/update_execution.php
     *
     * @param UpdateExecutionRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Execution
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateExecution(UpdateExecutionRequest $request, array $callOptions = []): Execution
    {
        return $this->startApiCall('UpdateExecution', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see MetadataServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see MetadataServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see MetadataServiceClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see MetadataServiceClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see MetadataServiceClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/MetadataServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
