<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/advanced_settings.proto

namespace Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Define behaviors for DTMF (dual tone multi frequency).
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.AdvancedSettings.DtmfSettings</code>
 */
class DtmfSettings extends \Google\Protobuf\Internal\Message
{
    /**
     * If true, incoming audio is processed for DTMF (dual tone multi frequency)
     * events. For example, if the caller presses a button on their telephone
     * keypad and DTMF processing is enabled, Dialogflow will detect the
     * event (e.g. a "3" was pressed) in the incoming audio and pass the event
     * to the bot to drive business logic (e.g. when 3 is pressed, return the
     * account balance).
     *
     * Generated from protobuf field <code>bool enabled = 1;</code>
     */
    protected $enabled = false;
    /**
     * Max length of DTMF digits.
     *
     * Generated from protobuf field <code>int32 max_digits = 2;</code>
     */
    protected $max_digits = 0;
    /**
     * The digit that terminates a DTMF digit sequence.
     *
     * Generated from protobuf field <code>string finish_digit = 3;</code>
     */
    protected $finish_digit = '';
    /**
     * Interdigit timeout setting for matching dtmf input to regex.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
     */
    protected $interdigit_timeout_duration = null;
    /**
     * Endpoint timeout setting for matching dtmf input to regex.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
     */
    protected $endpointing_timeout_duration = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $enabled
     *           If true, incoming audio is processed for DTMF (dual tone multi frequency)
     *           events. For example, if the caller presses a button on their telephone
     *           keypad and DTMF processing is enabled, Dialogflow will detect the
     *           event (e.g. a "3" was pressed) in the incoming audio and pass the event
     *           to the bot to drive business logic (e.g. when 3 is pressed, return the
     *           account balance).
     *     @type int $max_digits
     *           Max length of DTMF digits.
     *     @type string $finish_digit
     *           The digit that terminates a DTMF digit sequence.
     *     @type \Google\Protobuf\Duration $interdigit_timeout_duration
     *           Interdigit timeout setting for matching dtmf input to regex.
     *     @type \Google\Protobuf\Duration $endpointing_timeout_duration
     *           Endpoint timeout setting for matching dtmf input to regex.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\AdvancedSettings::initOnce();
        parent::__construct($data);
    }

    /**
     * If true, incoming audio is processed for DTMF (dual tone multi frequency)
     * events. For example, if the caller presses a button on their telephone
     * keypad and DTMF processing is enabled, Dialogflow will detect the
     * event (e.g. a "3" was pressed) in the incoming audio and pass the event
     * to the bot to drive business logic (e.g. when 3 is pressed, return the
     * account balance).
     *
     * Generated from protobuf field <code>bool enabled = 1;</code>
     * @return bool
     */
    public function getEnabled()
    {
        return $this->enabled;
    }

    /**
     * If true, incoming audio is processed for DTMF (dual tone multi frequency)
     * events. For example, if the caller presses a button on their telephone
     * keypad and DTMF processing is enabled, Dialogflow will detect the
     * event (e.g. a "3" was pressed) in the incoming audio and pass the event
     * to the bot to drive business logic (e.g. when 3 is pressed, return the
     * account balance).
     *
     * Generated from protobuf field <code>bool enabled = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->enabled = $var;

        return $this;
    }

    /**
     * Max length of DTMF digits.
     *
     * Generated from protobuf field <code>int32 max_digits = 2;</code>
     * @return int
     */
    public function getMaxDigits()
    {
        return $this->max_digits;
    }

    /**
     * Max length of DTMF digits.
     *
     * Generated from protobuf field <code>int32 max_digits = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxDigits($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_digits = $var;

        return $this;
    }

    /**
     * The digit that terminates a DTMF digit sequence.
     *
     * Generated from protobuf field <code>string finish_digit = 3;</code>
     * @return string
     */
    public function getFinishDigit()
    {
        return $this->finish_digit;
    }

    /**
     * The digit that terminates a DTMF digit sequence.
     *
     * Generated from protobuf field <code>string finish_digit = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setFinishDigit($var)
    {
        GPBUtil::checkString($var, True);
        $this->finish_digit = $var;

        return $this;
    }

    /**
     * Interdigit timeout setting for matching dtmf input to regex.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getInterdigitTimeoutDuration()
    {
        return $this->interdigit_timeout_duration;
    }

    public function hasInterdigitTimeoutDuration()
    {
        return isset($this->interdigit_timeout_duration);
    }

    public function clearInterdigitTimeoutDuration()
    {
        unset($this->interdigit_timeout_duration);
    }

    /**
     * Interdigit timeout setting for matching dtmf input to regex.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration interdigit_timeout_duration = 6;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setInterdigitTimeoutDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->interdigit_timeout_duration = $var;

        return $this;
    }

    /**
     * Endpoint timeout setting for matching dtmf input to regex.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getEndpointingTimeoutDuration()
    {
        return $this->endpointing_timeout_duration;
    }

    public function hasEndpointingTimeoutDuration()
    {
        return isset($this->endpointing_timeout_duration);
    }

    public function clearEndpointingTimeoutDuration()
    {
        unset($this->endpointing_timeout_duration);
    }

    /**
     * Endpoint timeout setting for matching dtmf input to regex.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration endpointing_timeout_duration = 7;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setEndpointingTimeoutDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->endpointing_timeout_duration = $var;

        return $this;
    }

}


