<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/vertex_rag_data.proto

namespace Google\Cloud\AIPlatform\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Config for importing RagFiles.
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.ImportRagFilesConfig</code>
 */
class ImportRagFilesConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Specifies the transformation config for RagFiles.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.RagFileTransformationConfig rag_file_transformation_config = 16;</code>
     */
    protected $rag_file_transformation_config = null;
    /**
     * Optional. Specifies the parsing config for RagFiles.
     * RAG will use the default parser if this field is not set.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $rag_file_parsing_config = null;
    /**
     * Optional. The max number of queries per minute that this job is allowed to
     * make to the embedding model specified on the corpus. This value is specific
     * to this job and not shared across other import jobs. Consult the Quotas
     * page on the project to set an appropriate value here.
     * If unspecified, a default value of 1,000 QPM would be used.
     *
     * Generated from protobuf field <code>int32 max_embedding_requests_per_min = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $max_embedding_requests_per_min = 0;
    protected $import_source;
    protected $partial_failure_sink;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\AIPlatform\V1\GcsSource $gcs_source
     *           Google Cloud Storage location. Supports importing individual files as
     *           well as entire Google Cloud Storage directories. Sample formats:
     *           - `gs://bucket_name/my_directory/object_name/my_file.txt`
     *           - `gs://bucket_name/my_directory`
     *     @type \Google\Cloud\AIPlatform\V1\GoogleDriveSource $google_drive_source
     *           Google Drive location. Supports importing individual files as
     *           well as Google Drive folders.
     *     @type \Google\Cloud\AIPlatform\V1\SlackSource $slack_source
     *           Slack channels with their corresponding access tokens.
     *     @type \Google\Cloud\AIPlatform\V1\JiraSource $jira_source
     *           Jira queries with their corresponding authentication.
     *     @type \Google\Cloud\AIPlatform\V1\SharePointSources $share_point_sources
     *           SharePoint sources.
     *     @type \Google\Cloud\AIPlatform\V1\GcsDestination $partial_failure_gcs_sink
     *           The Cloud Storage path to write partial failures to.
     *           Deprecated. Prefer to use `import_result_gcs_sink`.
     *     @type \Google\Cloud\AIPlatform\V1\BigQueryDestination $partial_failure_bigquery_sink
     *           The BigQuery destination to write partial failures to. It should be a
     *           bigquery table resource name (e.g.
     *           "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     *           table does not exist, it will be created with the expected schema. If the
     *           table exists, the schema will be validated and data will be added to this
     *           existing table.
     *           Deprecated. Prefer to use `import_result_bq_sink`.
     *     @type \Google\Cloud\AIPlatform\V1\RagFileTransformationConfig $rag_file_transformation_config
     *           Specifies the transformation config for RagFiles.
     *     @type \Google\Cloud\AIPlatform\V1\RagFileParsingConfig $rag_file_parsing_config
     *           Optional. Specifies the parsing config for RagFiles.
     *           RAG will use the default parser if this field is not set.
     *     @type int $max_embedding_requests_per_min
     *           Optional. The max number of queries per minute that this job is allowed to
     *           make to the embedding model specified on the corpus. This value is specific
     *           to this job and not shared across other import jobs. Consult the Quotas
     *           page on the project to set an appropriate value here.
     *           If unspecified, a default value of 1,000 QPM would be used.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\VertexRagData::initOnce();
        parent::__construct($data);
    }

    /**
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.GcsSource gcs_source = 2;</code>
     * @return \Google\Cloud\AIPlatform\V1\GcsSource|null
     */
    public function getGcsSource()
    {
        return $this->readOneof(2);
    }

    public function hasGcsSource()
    {
        return $this->hasOneof(2);
    }

    /**
     * Google Cloud Storage location. Supports importing individual files as
     * well as entire Google Cloud Storage directories. Sample formats:
     * - `gs://bucket_name/my_directory/object_name/my_file.txt`
     * - `gs://bucket_name/my_directory`
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.GcsSource gcs_source = 2;</code>
     * @param \Google\Cloud\AIPlatform\V1\GcsSource $var
     * @return $this
     */
    public function setGcsSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\GcsSource::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.GoogleDriveSource google_drive_source = 3;</code>
     * @return \Google\Cloud\AIPlatform\V1\GoogleDriveSource|null
     */
    public function getGoogleDriveSource()
    {
        return $this->readOneof(3);
    }

    public function hasGoogleDriveSource()
    {
        return $this->hasOneof(3);
    }

    /**
     * Google Drive location. Supports importing individual files as
     * well as Google Drive folders.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.GoogleDriveSource google_drive_source = 3;</code>
     * @param \Google\Cloud\AIPlatform\V1\GoogleDriveSource $var
     * @return $this
     */
    public function setGoogleDriveSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\GoogleDriveSource::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Slack channels with their corresponding access tokens.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.SlackSource slack_source = 6;</code>
     * @return \Google\Cloud\AIPlatform\V1\SlackSource|null
     */
    public function getSlackSource()
    {
        return $this->readOneof(6);
    }

    public function hasSlackSource()
    {
        return $this->hasOneof(6);
    }

    /**
     * Slack channels with their corresponding access tokens.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.SlackSource slack_source = 6;</code>
     * @param \Google\Cloud\AIPlatform\V1\SlackSource $var
     * @return $this
     */
    public function setSlackSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\SlackSource::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Jira queries with their corresponding authentication.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.JiraSource jira_source = 7;</code>
     * @return \Google\Cloud\AIPlatform\V1\JiraSource|null
     */
    public function getJiraSource()
    {
        return $this->readOneof(7);
    }

    public function hasJiraSource()
    {
        return $this->hasOneof(7);
    }

    /**
     * Jira queries with their corresponding authentication.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.JiraSource jira_source = 7;</code>
     * @param \Google\Cloud\AIPlatform\V1\JiraSource $var
     * @return $this
     */
    public function setJiraSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\JiraSource::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * SharePoint sources.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.SharePointSources share_point_sources = 13;</code>
     * @return \Google\Cloud\AIPlatform\V1\SharePointSources|null
     */
    public function getSharePointSources()
    {
        return $this->readOneof(13);
    }

    public function hasSharePointSources()
    {
        return $this->hasOneof(13);
    }

    /**
     * SharePoint sources.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.SharePointSources share_point_sources = 13;</code>
     * @param \Google\Cloud\AIPlatform\V1\SharePointSources $var
     * @return $this
     */
    public function setSharePointSources($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\SharePointSources::class);
        $this->writeOneof(13, $var);

        return $this;
    }

    /**
     * The Cloud Storage path to write partial failures to.
     * Deprecated. Prefer to use `import_result_gcs_sink`.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];</code>
     * @return \Google\Cloud\AIPlatform\V1\GcsDestination|null
     * @deprecated
     */
    public function getPartialFailureGcsSink()
    {
        @trigger_error('partial_failure_gcs_sink is deprecated.', E_USER_DEPRECATED);
        return $this->readOneof(11);
    }

    public function hasPartialFailureGcsSink()
    {
        @trigger_error('partial_failure_gcs_sink is deprecated.', E_USER_DEPRECATED);
        return $this->hasOneof(11);
    }

    /**
     * The Cloud Storage path to write partial failures to.
     * Deprecated. Prefer to use `import_result_gcs_sink`.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.GcsDestination partial_failure_gcs_sink = 11 [deprecated = true];</code>
     * @param \Google\Cloud\AIPlatform\V1\GcsDestination $var
     * @return $this
     * @deprecated
     */
    public function setPartialFailureGcsSink($var)
    {
        @trigger_error('partial_failure_gcs_sink is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\GcsDestination::class);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * The BigQuery destination to write partial failures to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * Deprecated. Prefer to use `import_result_bq_sink`.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];</code>
     * @return \Google\Cloud\AIPlatform\V1\BigQueryDestination|null
     * @deprecated
     */
    public function getPartialFailureBigquerySink()
    {
        @trigger_error('partial_failure_bigquery_sink is deprecated.', E_USER_DEPRECATED);
        return $this->readOneof(12);
    }

    public function hasPartialFailureBigquerySink()
    {
        @trigger_error('partial_failure_bigquery_sink is deprecated.', E_USER_DEPRECATED);
        return $this->hasOneof(12);
    }

    /**
     * The BigQuery destination to write partial failures to. It should be a
     * bigquery table resource name (e.g.
     * "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
     * table does not exist, it will be created with the expected schema. If the
     * table exists, the schema will be validated and data will be added to this
     * existing table.
     * Deprecated. Prefer to use `import_result_bq_sink`.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.BigQueryDestination partial_failure_bigquery_sink = 12 [deprecated = true];</code>
     * @param \Google\Cloud\AIPlatform\V1\BigQueryDestination $var
     * @return $this
     * @deprecated
     */
    public function setPartialFailureBigquerySink($var)
    {
        @trigger_error('partial_failure_bigquery_sink is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\BigQueryDestination::class);
        $this->writeOneof(12, $var);

        return $this;
    }

    /**
     * Specifies the transformation config for RagFiles.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.RagFileTransformationConfig rag_file_transformation_config = 16;</code>
     * @return \Google\Cloud\AIPlatform\V1\RagFileTransformationConfig|null
     */
    public function getRagFileTransformationConfig()
    {
        return $this->rag_file_transformation_config;
    }

    public function hasRagFileTransformationConfig()
    {
        return isset($this->rag_file_transformation_config);
    }

    public function clearRagFileTransformationConfig()
    {
        unset($this->rag_file_transformation_config);
    }

    /**
     * Specifies the transformation config for RagFiles.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.RagFileTransformationConfig rag_file_transformation_config = 16;</code>
     * @param \Google\Cloud\AIPlatform\V1\RagFileTransformationConfig $var
     * @return $this
     */
    public function setRagFileTransformationConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\RagFileTransformationConfig::class);
        $this->rag_file_transformation_config = $var;

        return $this;
    }

    /**
     * Optional. Specifies the parsing config for RagFiles.
     * RAG will use the default parser if this field is not set.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AIPlatform\V1\RagFileParsingConfig|null
     */
    public function getRagFileParsingConfig()
    {
        return $this->rag_file_parsing_config;
    }

    public function hasRagFileParsingConfig()
    {
        return isset($this->rag_file_parsing_config);
    }

    public function clearRagFileParsingConfig()
    {
        unset($this->rag_file_parsing_config);
    }

    /**
     * Optional. Specifies the parsing config for RagFiles.
     * RAG will use the default parser if this field is not set.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.RagFileParsingConfig rag_file_parsing_config = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AIPlatform\V1\RagFileParsingConfig $var
     * @return $this
     */
    public function setRagFileParsingConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\RagFileParsingConfig::class);
        $this->rag_file_parsing_config = $var;

        return $this;
    }

    /**
     * Optional. The max number of queries per minute that this job is allowed to
     * make to the embedding model specified on the corpus. This value is specific
     * to this job and not shared across other import jobs. Consult the Quotas
     * page on the project to set an appropriate value here.
     * If unspecified, a default value of 1,000 QPM would be used.
     *
     * Generated from protobuf field <code>int32 max_embedding_requests_per_min = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getMaxEmbeddingRequestsPerMin()
    {
        return $this->max_embedding_requests_per_min;
    }

    /**
     * Optional. The max number of queries per minute that this job is allowed to
     * make to the embedding model specified on the corpus. This value is specific
     * to this job and not shared across other import jobs. Consult the Quotas
     * page on the project to set an appropriate value here.
     * If unspecified, a default value of 1,000 QPM would be used.
     *
     * Generated from protobuf field <code>int32 max_embedding_requests_per_min = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setMaxEmbeddingRequestsPerMin($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_embedding_requests_per_min = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getImportSource()
    {
        return $this->whichOneof("import_source");
    }

    /**
     * @return string
     */
    public function getPartialFailureSink()
    {
        return $this->whichOneof("partial_failure_sink");
    }

}

