<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/datacatalog/v1/tags.proto

namespace Google\Cloud\DataCatalog\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Tags are used to attach custom metadata to Data Catalog resources. Tags
 * conform to the specifications within their tag template.
 * See [Data Catalog
 * IAM](https://cloud.google.com/data-catalog/docs/concepts/iam) for information
 * on the permissions needed to create or view tags.
 *
 * Generated from protobuf message <code>google.cloud.datacatalog.v1.Tag</code>
 */
class Tag extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the tag in URL format. Example:
     * * projects/{project_id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}
     * where `tag_id` is a system-generated identifier.
     * Note that this Tag may not actually be stored in the location in this name.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Required. The resource name of the tag template that this tag uses. Example:
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     * This field cannot be modified after creation.
     *
     * Generated from protobuf field <code>string template = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $template = '';
    /**
     * Output only. The display name of the tag template.
     *
     * Generated from protobuf field <code>string template_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $template_display_name = '';
    /**
     * Required. This maps the ID of a tag field to the value of and additional information
     * about that field. Valid field IDs are defined by the tag's template. A tag
     * must have at least 1 field and at most 500 fields.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.datacatalog.v1.TagField> fields = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $fields;
    protected $scope;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the tag in URL format. Example:
     *           * projects/{project_id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}
     *           where `tag_id` is a system-generated identifier.
     *           Note that this Tag may not actually be stored in the location in this name.
     *     @type string $template
     *           Required. The resource name of the tag template that this tag uses. Example:
     *           * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     *           This field cannot be modified after creation.
     *     @type string $template_display_name
     *           Output only. The display name of the tag template.
     *     @type string $column
     *           Resources like Entry can have schemas associated with them. This scope
     *           allows users to attach tags to an individual column based on that schema.
     *           For attaching a tag to a nested column, use `.` to separate the column
     *           names. Example:
     *           * `outer_column.inner_column`
     *     @type array|\Google\Protobuf\Internal\MapField $fields
     *           Required. This maps the ID of a tag field to the value of and additional information
     *           about that field. Valid field IDs are defined by the tag's template. A tag
     *           must have at least 1 field and at most 500 fields.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Datacatalog\V1\Tags::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the tag in URL format. Example:
     * * projects/{project_id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}
     * where `tag_id` is a system-generated identifier.
     * Note that this Tag may not actually be stored in the location in this name.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the tag in URL format. Example:
     * * projects/{project_id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}
     * where `tag_id` is a system-generated identifier.
     * Note that this Tag may not actually be stored in the location in this name.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The resource name of the tag template that this tag uses. Example:
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     * This field cannot be modified after creation.
     *
     * Generated from protobuf field <code>string template = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTemplate()
    {
        return $this->template;
    }

    /**
     * Required. The resource name of the tag template that this tag uses. Example:
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     * This field cannot be modified after creation.
     *
     * Generated from protobuf field <code>string template = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTemplate($var)
    {
        GPBUtil::checkString($var, True);
        $this->template = $var;

        return $this;
    }

    /**
     * Output only. The display name of the tag template.
     *
     * Generated from protobuf field <code>string template_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getTemplateDisplayName()
    {
        return $this->template_display_name;
    }

    /**
     * Output only. The display name of the tag template.
     *
     * Generated from protobuf field <code>string template_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setTemplateDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->template_display_name = $var;

        return $this;
    }

    /**
     * Resources like Entry can have schemas associated with them. This scope
     * allows users to attach tags to an individual column based on that schema.
     * For attaching a tag to a nested column, use `.` to separate the column
     * names. Example:
     * * `outer_column.inner_column`
     *
     * Generated from protobuf field <code>string column = 4;</code>
     * @return string
     */
    public function getColumn()
    {
        return $this->readOneof(4);
    }

    /**
     * Resources like Entry can have schemas associated with them. This scope
     * allows users to attach tags to an individual column based on that schema.
     * For attaching a tag to a nested column, use `.` to separate the column
     * names. Example:
     * * `outer_column.inner_column`
     *
     * Generated from protobuf field <code>string column = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setColumn($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Required. This maps the ID of a tag field to the value of and additional information
     * about that field. Valid field IDs are defined by the tag's template. A tag
     * must have at least 1 field and at most 500 fields.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.datacatalog.v1.TagField> fields = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getFields()
    {
        return $this->fields;
    }

    /**
     * Required. This maps the ID of a tag field to the value of and additional information
     * about that field. Valid field IDs are defined by the tag's template. A tag
     * must have at least 1 field and at most 500 fields.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.datacatalog.v1.TagField> fields = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setFields($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\DataCatalog\V1\TagField::class);
        $this->fields = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getScope()
    {
        return $this->whichOneof("scope");
    }

}

