<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/redis/cluster/v1/cloud_redis_cluster.proto

namespace Google\Cloud\Redis\Cluster\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request for [CreateCluster][CloudRedis.CreateCluster].
 *
 * Generated from protobuf message <code>google.cloud.redis.cluster.v1.CreateClusterRequest</code>
 */
class CreateClusterRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the cluster location using the form:
     *     `projects/{project_id}/locations/{location_id}`
     * where `location_id` refers to a GCP region.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. The logical name of the Redis cluster in the customer project
     * with the following restrictions:
     * * Must contain only lowercase letters, numbers, and hyphens.
     * * Must start with a letter.
     * * Must be between 1-63 characters.
     * * Must end with a number or a letter.
     * * Must be unique within the customer project / location
     *
     * Generated from protobuf field <code>string cluster_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $cluster_id = '';
    /**
     * Required. The cluster that is to be created.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $cluster = null;
    /**
     * Idempotent request UUID.
     *
     * Generated from protobuf field <code>string request_id = 4;</code>
     */
    protected $request_id = '';

    /**
     * @param string                                 $parent    Required. The resource name of the cluster location using the form:
     *                                                          `projects/{project_id}/locations/{location_id}`
     *                                                          where `location_id` refers to a GCP region. Please see
     *                                                          {@see CloudRedisClusterClient::locationName()} for help formatting this field.
     * @param \Google\Cloud\Redis\Cluster\V1\Cluster $cluster   Required. The cluster that is to be created.
     * @param string                                 $clusterId Required. The logical name of the Redis cluster in the customer project
     *                                                          with the following restrictions:
     *
     *                                                          * Must contain only lowercase letters, numbers, and hyphens.
     *                                                          * Must start with a letter.
     *                                                          * Must be between 1-63 characters.
     *                                                          * Must end with a number or a letter.
     *                                                          * Must be unique within the customer project / location
     *
     * @return \Google\Cloud\Redis\Cluster\V1\CreateClusterRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\Redis\Cluster\V1\Cluster $cluster, string $clusterId): self
    {
        return (new self())
            ->setParent($parent)
            ->setCluster($cluster)
            ->setClusterId($clusterId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The resource name of the cluster location using the form:
     *               `projects/{project_id}/locations/{location_id}`
     *           where `location_id` refers to a GCP region.
     *     @type string $cluster_id
     *           Required. The logical name of the Redis cluster in the customer project
     *           with the following restrictions:
     *           * Must contain only lowercase letters, numbers, and hyphens.
     *           * Must start with a letter.
     *           * Must be between 1-63 characters.
     *           * Must end with a number or a letter.
     *           * Must be unique within the customer project / location
     *     @type \Google\Cloud\Redis\Cluster\V1\Cluster $cluster
     *           Required. The cluster that is to be created.
     *     @type string $request_id
     *           Idempotent request UUID.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Redis\Cluster\V1\CloudRedisCluster::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the cluster location using the form:
     *     `projects/{project_id}/locations/{location_id}`
     * where `location_id` refers to a GCP region.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The resource name of the cluster location using the form:
     *     `projects/{project_id}/locations/{location_id}`
     * where `location_id` refers to a GCP region.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The logical name of the Redis cluster in the customer project
     * with the following restrictions:
     * * Must contain only lowercase letters, numbers, and hyphens.
     * * Must start with a letter.
     * * Must be between 1-63 characters.
     * * Must end with a number or a letter.
     * * Must be unique within the customer project / location
     *
     * Generated from protobuf field <code>string cluster_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getClusterId()
    {
        return $this->cluster_id;
    }

    /**
     * Required. The logical name of the Redis cluster in the customer project
     * with the following restrictions:
     * * Must contain only lowercase letters, numbers, and hyphens.
     * * Must start with a letter.
     * * Must be between 1-63 characters.
     * * Must end with a number or a letter.
     * * Must be unique within the customer project / location
     *
     * Generated from protobuf field <code>string cluster_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setClusterId($var)
    {
        GPBUtil::checkString($var, True);
        $this->cluster_id = $var;

        return $this;
    }

    /**
     * Required. The cluster that is to be created.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Redis\Cluster\V1\Cluster|null
     */
    public function getCluster()
    {
        return $this->cluster;
    }

    public function hasCluster()
    {
        return isset($this->cluster);
    }

    public function clearCluster()
    {
        unset($this->cluster);
    }

    /**
     * Required. The cluster that is to be created.
     *
     * Generated from protobuf field <code>.google.cloud.redis.cluster.v1.Cluster cluster = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Redis\Cluster\V1\Cluster $var
     * @return $this
     */
    public function setCluster($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Redis\Cluster\V1\Cluster::class);
        $this->cluster = $var;

        return $this;
    }

    /**
     * Idempotent request UUID.
     *
     * Generated from protobuf field <code>string request_id = 4;</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * Idempotent request UUID.
     *
     * Generated from protobuf field <code>string request_id = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

}

